/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution.scheduler;

import com.facebook.presto.execution.RemoteTask;
import com.facebook.presto.execution.SqlStageExecution;
import com.facebook.presto.execution.scheduler.ScheduleResult;
import com.facebook.presto.execution.scheduler.StageScheduler;
import com.facebook.presto.spi.Node;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.stream.IntStream;

public class FixedCountScheduler
implements StageScheduler {
    private final TaskScheduler taskScheduler;
    private final List<Node> partitionToNode;

    public FixedCountScheduler(SqlStageExecution stage, List<Node> partitionToNode) {
        Objects.requireNonNull(stage, "stage is null");
        this.taskScheduler = stage::scheduleTask;
        this.partitionToNode = Objects.requireNonNull(partitionToNode, "partitionToNode is null");
    }

    @VisibleForTesting
    public FixedCountScheduler(TaskScheduler taskScheduler, List<Node> partitionToNode) {
        this.taskScheduler = Objects.requireNonNull(taskScheduler, "taskScheduler is null");
        this.partitionToNode = Objects.requireNonNull(partitionToNode, "partitionToNode is null");
    }

    @Override
    public ScheduleResult schedule() {
        OptionalInt totalPartitions = OptionalInt.of(this.partitionToNode.size());
        List newTasks = (List)IntStream.range(0, this.partitionToNode.size()).mapToObj(partition -> this.taskScheduler.scheduleTask(this.partitionToNode.get(partition), partition, totalPartitions)).filter(Optional::isPresent).map(Optional::get).collect(ImmutableList.toImmutableList());
        return new ScheduleResult(true, newTasks, 0);
    }

    public static interface TaskScheduler {
        public Optional<RemoteTask> scheduleTask(Node var1, int var2, OptionalInt var3);
    }
}

