/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution;

import com.facebook.presto.Session;
import com.facebook.presto.execution.BasicStageStats;
import com.facebook.presto.execution.ExecutionFailureInfo;
import com.facebook.presto.execution.StageId;
import com.facebook.presto.execution.StageInfo;
import com.facebook.presto.execution.StageState;
import com.facebook.presto.execution.StageStats;
import com.facebook.presto.execution.StateMachine;
import com.facebook.presto.execution.TaskInfo;
import com.facebook.presto.execution.TaskState;
import com.facebook.presto.execution.scheduler.SplitSchedulerStats;
import com.facebook.presto.operator.BlockedReason;
import com.facebook.presto.operator.OperatorStats;
import com.facebook.presto.operator.PipelineStats;
import com.facebook.presto.operator.TaskStats;
import com.facebook.presto.spi.eventlistener.StageGcStatistics;
import com.facebook.presto.sql.planner.PlanFragment;
import com.facebook.presto.sql.planner.plan.TableScanNode;
import com.facebook.presto.util.Failures;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.airlift.log.Logger;
import io.airlift.stats.Distribution;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import java.net.URI;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import javax.annotation.concurrent.ThreadSafe;
import org.joda.time.DateTime;

@ThreadSafe
public class StageStateMachine {
    private static final Logger log = Logger.get(StageStateMachine.class);
    private final StageId stageId;
    private final URI location;
    private final PlanFragment fragment;
    private final Session session;
    private final SplitSchedulerStats scheduledStats;
    private final StateMachine<StageState> stageState;
    private final StateMachine<Optional<StageInfo>> finalStageInfo;
    private final AtomicReference<ExecutionFailureInfo> failureCause = new AtomicReference();
    private final AtomicReference<DateTime> schedulingComplete = new AtomicReference();
    private final Distribution getSplitDistribution = new Distribution();
    private final AtomicLong peakUserMemory = new AtomicLong();
    private final AtomicLong currentUserMemory = new AtomicLong();
    private final AtomicLong currentTotalMemory = new AtomicLong();

    public StageStateMachine(StageId stageId, URI location, Session session, PlanFragment fragment, ExecutorService executor, SplitSchedulerStats schedulerStats) {
        this.stageId = Objects.requireNonNull(stageId, "stageId is null");
        this.location = Objects.requireNonNull(location, "location is null");
        this.session = Objects.requireNonNull(session, "session is null");
        this.fragment = Objects.requireNonNull(fragment, "fragment is null");
        this.scheduledStats = Objects.requireNonNull(schedulerStats, "schedulerStats is null");
        this.stageState = new StateMachine<StageState>("stage " + stageId, executor, StageState.PLANNED, StageState.TERMINAL_STAGE_STATES);
        this.stageState.addStateChangeListener((T state) -> log.debug("Stage %s is %s", new Object[]{stageId, state}));
        this.finalStageInfo = new StateMachine("final stage " + stageId, executor, Optional.empty());
    }

    public StageId getStageId() {
        return this.stageId;
    }

    public URI getLocation() {
        return this.location;
    }

    public Session getSession() {
        return this.session;
    }

    public StageState getState() {
        return this.stageState.get();
    }

    public PlanFragment getFragment() {
        return this.fragment;
    }

    public void addStateChangeListener(StateMachine.StateChangeListener<StageState> stateChangeListener) {
        this.stageState.addStateChangeListener(stateChangeListener);
    }

    public synchronized boolean transitionToScheduling() {
        return this.stageState.compareAndSet(StageState.PLANNED, StageState.SCHEDULING);
    }

    public synchronized boolean transitionToSchedulingSplits() {
        return this.stageState.setIf(StageState.SCHEDULING_SPLITS, currentState -> currentState == StageState.PLANNED || currentState == StageState.SCHEDULING);
    }

    public synchronized boolean transitionToScheduled() {
        this.schedulingComplete.compareAndSet(null, DateTime.now());
        return this.stageState.setIf(StageState.SCHEDULED, currentState -> currentState == StageState.PLANNED || currentState == StageState.SCHEDULING || currentState == StageState.SCHEDULING_SPLITS);
    }

    public boolean transitionToRunning() {
        return this.stageState.setIf(StageState.RUNNING, currentState -> currentState != StageState.RUNNING && !currentState.isDone());
    }

    public boolean transitionToFinished() {
        return this.stageState.setIf(StageState.FINISHED, currentState -> !currentState.isDone());
    }

    public boolean transitionToCanceled() {
        return this.stageState.setIf(StageState.CANCELED, currentState -> !currentState.isDone());
    }

    public boolean transitionToAborted() {
        return this.stageState.setIf(StageState.ABORTED, currentState -> !currentState.isDone());
    }

    public boolean transitionToFailed(Throwable throwable) {
        Objects.requireNonNull(throwable, "throwable is null");
        this.failureCause.compareAndSet(null, Failures.toFailure(throwable));
        boolean failed = this.stageState.setIf(StageState.FAILED, currentState -> !currentState.isDone());
        if (failed) {
            log.error(throwable, "Stage %s failed", new Object[]{this.stageId});
        } else {
            log.debug(throwable, "Failure after stage %s finished", new Object[]{this.stageId});
        }
        return failed;
    }

    public void addFinalStageInfoListener(StateMachine.StateChangeListener<StageInfo> finalStatusListener) {
        AtomicBoolean done = new AtomicBoolean();
        StateMachine.StateChangeListener<Optional> fireOnceStateChangeListener = finalStageInfo -> {
            if (finalStageInfo.isPresent() && done.compareAndSet(false, true)) {
                finalStatusListener.stateChanged((StageInfo)finalStageInfo.get());
            }
        };
        this.finalStageInfo.addStateChangeListener(fireOnceStateChangeListener);
    }

    public void setAllTasksFinal(Iterable<TaskInfo> finalTaskInfos) {
        Objects.requireNonNull(finalTaskInfos, "finalTaskInfos is null");
        Preconditions.checkState((boolean)this.stageState.get().isDone());
        StageInfo stageInfo = this.getStageInfo(() -> finalTaskInfos);
        Preconditions.checkArgument((boolean)stageInfo.isCompleteInfo(), (Object)"finalTaskInfos are not all done");
        this.finalStageInfo.compareAndSet(Optional.empty(), Optional.of(stageInfo));
    }

    public long getUserMemoryReservation() {
        return this.currentUserMemory.get();
    }

    public long getTotalMemoryReservation() {
        return this.currentTotalMemory.get();
    }

    public void updateMemoryUsage(long deltaUserMemoryInBytes, long deltaTotalMemoryInBytes) {
        this.currentTotalMemory.addAndGet(deltaTotalMemoryInBytes);
        this.currentUserMemory.addAndGet(deltaUserMemoryInBytes);
        this.peakUserMemory.updateAndGet(currentPeakValue -> Math.max(this.currentUserMemory.get(), currentPeakValue));
    }

    public BasicStageStats getBasicStageStats(Supplier<Iterable<TaskInfo>> taskInfosSupplier) {
        Optional<StageInfo> finalStageInfo = this.finalStageInfo.get();
        if (finalStageInfo.isPresent()) {
            return finalStageInfo.get().getStageStats().toBasicStageStats(finalStageInfo.get().getState());
        }
        StageState state = this.stageState.get();
        boolean isScheduled = state == StageState.RUNNING || state.isDone();
        ImmutableList taskInfos = ImmutableList.copyOf(taskInfosSupplier.get());
        int totalDrivers = 0;
        int queuedDrivers = 0;
        int runningDrivers = 0;
        int completedDrivers = 0;
        long cumulativeUserMemory = 0L;
        long userMemoryReservation = 0L;
        long totalMemoryReservation = 0L;
        long totalScheduledTime = 0L;
        long totalCpuTime = 0L;
        long rawInputDataSize = 0L;
        long rawInputPositions = 0L;
        boolean fullyBlocked = true;
        HashSet<BlockedReason> blockedReasons = new HashSet<BlockedReason>();
        for (TaskInfo taskInfo : taskInfos) {
            TaskState taskState = taskInfo.getTaskStatus().getState();
            TaskStats taskStats = taskInfo.getStats();
            totalDrivers += taskStats.getTotalDrivers();
            queuedDrivers += taskStats.getQueuedDrivers();
            runningDrivers += taskStats.getRunningDrivers();
            completedDrivers += taskStats.getCompletedDrivers();
            cumulativeUserMemory = (long)((double)cumulativeUserMemory + taskStats.getCumulativeUserMemory());
            long taskUserMemory = taskStats.getUserMemoryReservation().toBytes();
            long taskSystemMemory = taskStats.getSystemMemoryReservation().toBytes();
            userMemoryReservation += taskUserMemory;
            totalMemoryReservation += taskUserMemory + taskSystemMemory;
            totalScheduledTime += taskStats.getTotalScheduledTime().roundTo(TimeUnit.NANOSECONDS);
            totalCpuTime += taskStats.getTotalCpuTime().roundTo(TimeUnit.NANOSECONDS);
            if (!taskState.isDone()) {
                fullyBlocked &= taskStats.isFullyBlocked();
                blockedReasons.addAll(taskStats.getBlockedReasons());
            }
            if (!this.fragment.getPartitionedSourceNodes().stream().anyMatch(TableScanNode.class::isInstance)) continue;
            rawInputDataSize += taskStats.getRawInputDataSize().toBytes();
            rawInputPositions += taskStats.getRawInputPositions();
        }
        OptionalDouble progressPercentage = OptionalDouble.empty();
        if (isScheduled && totalDrivers != 0) {
            progressPercentage = OptionalDouble.of(Math.min(100.0, (double)completedDrivers * 100.0 / (double)totalDrivers));
        }
        return new BasicStageStats(isScheduled, totalDrivers, queuedDrivers, runningDrivers, completedDrivers, DataSize.succinctBytes((long)rawInputDataSize), rawInputPositions, cumulativeUserMemory, DataSize.succinctBytes((long)userMemoryReservation), DataSize.succinctBytes((long)totalMemoryReservation), new Duration((double)totalCpuTime, TimeUnit.NANOSECONDS).convertToMostSuccinctTimeUnit(), new Duration((double)totalScheduledTime, TimeUnit.NANOSECONDS).convertToMostSuccinctTimeUnit(), fullyBlocked, blockedReasons, progressPercentage);
    }

    public StageInfo getStageInfo(Supplier<Iterable<TaskInfo>> taskInfosSupplier) {
        Optional<StageInfo> finalStageInfo = this.finalStageInfo.get();
        if (finalStageInfo.isPresent()) {
            return finalStageInfo.get();
        }
        StageState state = this.stageState.get();
        ImmutableList taskInfos = ImmutableList.copyOf(taskInfosSupplier.get());
        int totalTasks = taskInfos.size();
        int runningTasks = 0;
        int completedTasks = 0;
        int totalDrivers = 0;
        int queuedDrivers = 0;
        int runningDrivers = 0;
        int blockedDrivers = 0;
        int completedDrivers = 0;
        long cumulativeUserMemory = 0L;
        long userMemoryReservation = 0L;
        long totalMemoryReservation = 0L;
        long peakUserMemoryReservation = this.peakUserMemory.get();
        long totalScheduledTime = 0L;
        long totalCpuTime = 0L;
        long totalBlockedTime = 0L;
        long rawInputDataSize = 0L;
        long rawInputPositions = 0L;
        long processedInputDataSize = 0L;
        long processedInputPositions = 0L;
        long bufferedDataSize = 0L;
        long outputDataSize = 0L;
        long outputPositions = 0L;
        long physicalWrittenDataSize = 0L;
        int fullGcCount = 0;
        int fullGcTaskCount = 0;
        int minFullGcSec = 0;
        int maxFullGcSec = 0;
        int totalFullGcSec = 0;
        boolean fullyBlocked = true;
        HashSet<BlockedReason> blockedReasons = new HashSet<BlockedReason>();
        HashMap<String, OperatorStats> operatorToStats = new HashMap<String, OperatorStats>();
        for (TaskInfo taskInfo : taskInfos) {
            TaskState taskState = taskInfo.getTaskStatus().getState();
            if (taskState.isDone()) {
                ++completedTasks;
            } else {
                ++runningTasks;
            }
            TaskStats taskStats = taskInfo.getStats();
            totalDrivers += taskStats.getTotalDrivers();
            queuedDrivers += taskStats.getQueuedDrivers();
            runningDrivers += taskStats.getRunningDrivers();
            blockedDrivers += taskStats.getBlockedDrivers();
            completedDrivers += taskStats.getCompletedDrivers();
            cumulativeUserMemory = (long)((double)cumulativeUserMemory + taskStats.getCumulativeUserMemory());
            long taskUserMemory = taskStats.getUserMemoryReservation().toBytes();
            long taskSystemMemory = taskStats.getSystemMemoryReservation().toBytes();
            userMemoryReservation += taskUserMemory;
            totalMemoryReservation += taskUserMemory + taskSystemMemory;
            totalScheduledTime += taskStats.getTotalScheduledTime().roundTo(TimeUnit.NANOSECONDS);
            totalCpuTime += taskStats.getTotalCpuTime().roundTo(TimeUnit.NANOSECONDS);
            totalBlockedTime += taskStats.getTotalBlockedTime().roundTo(TimeUnit.NANOSECONDS);
            if (!taskState.isDone()) {
                fullyBlocked &= taskStats.isFullyBlocked();
                blockedReasons.addAll(taskStats.getBlockedReasons());
            }
            rawInputDataSize += taskStats.getRawInputDataSize().toBytes();
            rawInputPositions += taskStats.getRawInputPositions();
            processedInputDataSize += taskStats.getProcessedInputDataSize().toBytes();
            processedInputPositions += taskStats.getProcessedInputPositions();
            bufferedDataSize += taskInfo.getOutputBuffers().getTotalBufferedBytes();
            outputDataSize += taskStats.getOutputDataSize().toBytes();
            outputPositions += taskStats.getOutputPositions();
            physicalWrittenDataSize += taskStats.getPhysicalWrittenDataSize().toBytes();
            fullGcCount += taskStats.getFullGcCount();
            fullGcTaskCount += taskStats.getFullGcCount() > 0 ? 1 : 0;
            int gcSec = Math.toIntExact(taskStats.getFullGcTime().roundTo(TimeUnit.SECONDS));
            totalFullGcSec += gcSec;
            minFullGcSec = Math.min(minFullGcSec, gcSec);
            maxFullGcSec = Math.max(maxFullGcSec, gcSec);
            for (PipelineStats pipeline : taskStats.getPipelines()) {
                for (OperatorStats operatorStats : pipeline.getOperatorSummaries()) {
                    String id = pipeline.getPipelineId() + "." + operatorStats.getOperatorId();
                    operatorToStats.compute(id, (k, v) -> v == null ? operatorStats : v.add(operatorStats));
                }
            }
        }
        StageStats stageStats = new StageStats(this.schedulingComplete.get(), this.getSplitDistribution.snapshot(), totalTasks, runningTasks, completedTasks, totalDrivers, queuedDrivers, runningDrivers, blockedDrivers, completedDrivers, cumulativeUserMemory, DataSize.succinctBytes((long)userMemoryReservation), DataSize.succinctBytes((long)totalMemoryReservation), DataSize.succinctBytes((long)peakUserMemoryReservation), Duration.succinctDuration((double)totalScheduledTime, (TimeUnit)TimeUnit.NANOSECONDS), Duration.succinctDuration((double)totalCpuTime, (TimeUnit)TimeUnit.NANOSECONDS), Duration.succinctDuration((double)totalBlockedTime, (TimeUnit)TimeUnit.NANOSECONDS), fullyBlocked && runningTasks > 0, blockedReasons, DataSize.succinctBytes((long)rawInputDataSize), rawInputPositions, DataSize.succinctBytes((long)processedInputDataSize), processedInputPositions, DataSize.succinctBytes((long)bufferedDataSize), DataSize.succinctBytes((long)outputDataSize), outputPositions, DataSize.succinctBytes((long)physicalWrittenDataSize), new StageGcStatistics(this.stageId.getId(), totalTasks, fullGcTaskCount, minFullGcSec, maxFullGcSec, totalFullGcSec, (int)(1.0 * (double)totalFullGcSec / (double)fullGcCount)), (List<OperatorStats>)ImmutableList.copyOf(operatorToStats.values()));
        ExecutionFailureInfo failureInfo = null;
        if (state == StageState.FAILED) {
            failureInfo = this.failureCause.get();
        }
        return new StageInfo(this.stageId, state, this.location, this.fragment, this.fragment.getTypes(), stageStats, (List<TaskInfo>)taskInfos, (List<StageInfo>)ImmutableList.of(), failureInfo);
    }

    public void recordGetSplitTime(long startNanos) {
        long elapsedNanos = System.nanoTime() - startNanos;
        this.getSplitDistribution.add(elapsedNanos);
        this.scheduledStats.getGetSplitTime().add((double)elapsedNanos, TimeUnit.NANOSECONDS);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("stageId", (Object)this.stageId).add("stageState", this.stageState).toString();
    }
}

