/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution;

import com.facebook.presto.operator.BlockedReason;
import com.facebook.presto.operator.OperatorStats;
import com.facebook.presto.operator.TableWriterOperator;
import com.facebook.presto.spi.eventlistener.StageGcStatistics;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.OptionalDouble;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.joda.time.DateTime;

public class QueryStats {
    private final DateTime createTime;
    private final DateTime executionStartTime;
    private final DateTime lastHeartbeat;
    private final DateTime endTime;
    private final Duration elapsedTime;
    private final Duration queuedTime;
    private final Duration executionTime;
    private final Duration resourceWaitingTime;
    private final Duration analysisTime;
    private final Duration distributedPlanningTime;
    private final Duration totalPlanningTime;
    private final Duration finishingTime;
    private final int totalTasks;
    private final int runningTasks;
    private final int completedTasks;
    private final int totalDrivers;
    private final int queuedDrivers;
    private final int runningDrivers;
    private final int blockedDrivers;
    private final int completedDrivers;
    private final double cumulativeUserMemory;
    private final DataSize userMemoryReservation;
    private final DataSize totalMemoryReservation;
    private final DataSize peakUserMemoryReservation;
    private final DataSize peakTotalMemoryReservation;
    private final DataSize peakTaskTotalMemory;
    private final boolean scheduled;
    private final Duration totalScheduledTime;
    private final Duration totalCpuTime;
    private final Duration totalBlockedTime;
    private final boolean fullyBlocked;
    private final Set<BlockedReason> blockedReasons;
    private final DataSize rawInputDataSize;
    private final long rawInputPositions;
    private final DataSize processedInputDataSize;
    private final long processedInputPositions;
    private final DataSize outputDataSize;
    private final long outputPositions;
    private final DataSize physicalWrittenDataSize;
    private final List<StageGcStatistics> stageGcStatistics;
    private final List<OperatorStats> operatorSummaries;

    @JsonCreator
    public QueryStats(@JsonProperty(value="createTime") DateTime createTime, @JsonProperty(value="executionStartTime") DateTime executionStartTime, @JsonProperty(value="lastHeartbeat") DateTime lastHeartbeat, @JsonProperty(value="endTime") DateTime endTime, @JsonProperty(value="elapsedTime") Duration elapsedTime, @JsonProperty(value="queuedTime") Duration queuedTime, @JsonProperty(value="resourceWaitingTime") Duration resourceWaitingTime, @JsonProperty(value="executionTime") Duration executionTime, @JsonProperty(value="analysisTime") Duration analysisTime, @JsonProperty(value="distributedPlanningTime") Duration distributedPlanningTime, @JsonProperty(value="totalPlanningTime") Duration totalPlanningTime, @JsonProperty(value="finishingTime") Duration finishingTime, @JsonProperty(value="totalTasks") int totalTasks, @JsonProperty(value="runningTasks") int runningTasks, @JsonProperty(value="completedTasks") int completedTasks, @JsonProperty(value="totalDrivers") int totalDrivers, @JsonProperty(value="queuedDrivers") int queuedDrivers, @JsonProperty(value="runningDrivers") int runningDrivers, @JsonProperty(value="blockedDrivers") int blockedDrivers, @JsonProperty(value="completedDrivers") int completedDrivers, @JsonProperty(value="cumulativeUserMemory") double cumulativeUserMemory, @JsonProperty(value="userMemoryReservation") DataSize userMemoryReservation, @JsonProperty(value="totalMemoryReservation") DataSize totalMemoryReservation, @JsonProperty(value="peakUserMemoryReservation") DataSize peakUserMemoryReservation, @JsonProperty(value="peakTotalMemoryReservation") DataSize peakTotalMemoryReservation, @JsonProperty(value="peakTaskTotalMemory") DataSize peakTaskTotalMemory, @JsonProperty(value="scheduled") boolean scheduled, @JsonProperty(value="totalScheduledTime") Duration totalScheduledTime, @JsonProperty(value="totalCpuTime") Duration totalCpuTime, @JsonProperty(value="totalBlockedTime") Duration totalBlockedTime, @JsonProperty(value="fullyBlocked") boolean fullyBlocked, @JsonProperty(value="blockedReasons") Set<BlockedReason> blockedReasons, @JsonProperty(value="rawInputDataSize") DataSize rawInputDataSize, @JsonProperty(value="rawInputPositions") long rawInputPositions, @JsonProperty(value="processedInputDataSize") DataSize processedInputDataSize, @JsonProperty(value="processedInputPositions") long processedInputPositions, @JsonProperty(value="outputDataSize") DataSize outputDataSize, @JsonProperty(value="outputPositions") long outputPositions, @JsonProperty(value="physicalWrittenDataSize") DataSize physicalWrittenDataSize, @JsonProperty(value="stageGcStatistics") List<StageGcStatistics> stageGcStatistics, @JsonProperty(value="operatorSummaries") List<OperatorStats> operatorSummaries) {
        this.createTime = Objects.requireNonNull(createTime, "createTime is null");
        this.executionStartTime = executionStartTime;
        this.lastHeartbeat = Objects.requireNonNull(lastHeartbeat, "lastHeartbeat is null");
        this.endTime = endTime;
        this.elapsedTime = Objects.requireNonNull(elapsedTime, "elapsedTime is null");
        this.queuedTime = Objects.requireNonNull(queuedTime, "queuedTime is null");
        this.resourceWaitingTime = Objects.requireNonNull(resourceWaitingTime, "resourceWaitingTime is null");
        this.executionTime = Objects.requireNonNull(executionTime, "executionTime is null");
        this.analysisTime = Objects.requireNonNull(analysisTime, "analysisTime is null");
        this.distributedPlanningTime = Objects.requireNonNull(distributedPlanningTime, "distributedPlanningTime is null");
        this.totalPlanningTime = Objects.requireNonNull(totalPlanningTime, "totalPlanningTime is null");
        this.finishingTime = Objects.requireNonNull(finishingTime, "finishingTime is null");
        Preconditions.checkArgument((totalTasks >= 0 ? 1 : 0) != 0, (Object)"totalTasks is negative");
        this.totalTasks = totalTasks;
        Preconditions.checkArgument((runningTasks >= 0 ? 1 : 0) != 0, (Object)"runningTasks is negative");
        this.runningTasks = runningTasks;
        Preconditions.checkArgument((completedTasks >= 0 ? 1 : 0) != 0, (Object)"completedTasks is negative");
        this.completedTasks = completedTasks;
        Preconditions.checkArgument((totalDrivers >= 0 ? 1 : 0) != 0, (Object)"totalDrivers is negative");
        this.totalDrivers = totalDrivers;
        Preconditions.checkArgument((queuedDrivers >= 0 ? 1 : 0) != 0, (Object)"queuedDrivers is negative");
        this.queuedDrivers = queuedDrivers;
        Preconditions.checkArgument((runningDrivers >= 0 ? 1 : 0) != 0, (Object)"runningDrivers is negative");
        this.runningDrivers = runningDrivers;
        Preconditions.checkArgument((blockedDrivers >= 0 ? 1 : 0) != 0, (Object)"blockedDrivers is negative");
        this.blockedDrivers = blockedDrivers;
        Preconditions.checkArgument((completedDrivers >= 0 ? 1 : 0) != 0, (Object)"completedDrivers is negative");
        this.completedDrivers = completedDrivers;
        Preconditions.checkArgument((cumulativeUserMemory >= 0.0 ? 1 : 0) != 0, (Object)"cumulativeUserMemory is negative");
        this.cumulativeUserMemory = cumulativeUserMemory;
        this.userMemoryReservation = Objects.requireNonNull(userMemoryReservation, "userMemoryReservation is null");
        this.totalMemoryReservation = Objects.requireNonNull(totalMemoryReservation, "totalMemoryReservation is null");
        this.peakUserMemoryReservation = Objects.requireNonNull(peakUserMemoryReservation, "peakUserMemoryReservation is null");
        this.peakTotalMemoryReservation = Objects.requireNonNull(peakTotalMemoryReservation, "peakTotalMemoryReservation is null");
        this.peakTaskTotalMemory = Objects.requireNonNull(peakTaskTotalMemory, "peakTaskTotalMemory is null");
        this.scheduled = scheduled;
        this.totalScheduledTime = Objects.requireNonNull(totalScheduledTime, "totalScheduledTime is null");
        this.totalCpuTime = Objects.requireNonNull(totalCpuTime, "totalCpuTime is null");
        this.totalBlockedTime = Objects.requireNonNull(totalBlockedTime, "totalBlockedTime is null");
        this.fullyBlocked = fullyBlocked;
        this.blockedReasons = ImmutableSet.copyOf((Collection)Objects.requireNonNull(blockedReasons, "blockedReasons is null"));
        this.rawInputDataSize = Objects.requireNonNull(rawInputDataSize, "rawInputDataSize is null");
        Preconditions.checkArgument((rawInputPositions >= 0L ? 1 : 0) != 0, (Object)"rawInputPositions is negative");
        this.rawInputPositions = rawInputPositions;
        this.processedInputDataSize = Objects.requireNonNull(processedInputDataSize, "processedInputDataSize is null");
        Preconditions.checkArgument((processedInputPositions >= 0L ? 1 : 0) != 0, (Object)"processedInputPositions is negative");
        this.processedInputPositions = processedInputPositions;
        this.outputDataSize = Objects.requireNonNull(outputDataSize, "outputDataSize is null");
        Preconditions.checkArgument((outputPositions >= 0L ? 1 : 0) != 0, (Object)"outputPositions is negative");
        this.outputPositions = outputPositions;
        this.physicalWrittenDataSize = Objects.requireNonNull(physicalWrittenDataSize, "physicalWrittenDataSize is null");
        this.stageGcStatistics = ImmutableList.copyOf((Collection)Objects.requireNonNull(stageGcStatistics, "stageGcStatistics is null"));
        this.operatorSummaries = ImmutableList.copyOf((Collection)Objects.requireNonNull(operatorSummaries, "operatorSummaries is null"));
    }

    public static QueryStats immediateFailureQueryStats() {
        DateTime now = DateTime.now();
        return new QueryStats(now, now, now, now, new Duration(0.0, TimeUnit.MILLISECONDS), new Duration(0.0, TimeUnit.MILLISECONDS), new Duration(0.0, TimeUnit.MILLISECONDS), new Duration(0.0, TimeUnit.MILLISECONDS), new Duration(0.0, TimeUnit.MILLISECONDS), new Duration(0.0, TimeUnit.MILLISECONDS), new Duration(0.0, TimeUnit.MILLISECONDS), new Duration(0.0, TimeUnit.MILLISECONDS), 0, 0, 0, 0, 0, 0, 0, 0, 0.0, new DataSize(0.0, DataSize.Unit.BYTE), new DataSize(0.0, DataSize.Unit.BYTE), new DataSize(0.0, DataSize.Unit.BYTE), new DataSize(0.0, DataSize.Unit.BYTE), new DataSize(0.0, DataSize.Unit.BYTE), false, new Duration(0.0, TimeUnit.MILLISECONDS), new Duration(0.0, TimeUnit.MILLISECONDS), new Duration(0.0, TimeUnit.MILLISECONDS), false, (Set<BlockedReason>)ImmutableSet.of(), new DataSize(0.0, DataSize.Unit.BYTE), 0L, new DataSize(0.0, DataSize.Unit.BYTE), 0L, new DataSize(0.0, DataSize.Unit.BYTE), 0L, new DataSize(0.0, DataSize.Unit.BYTE), (List<StageGcStatistics>)ImmutableList.of(), (List<OperatorStats>)ImmutableList.of());
    }

    @JsonProperty
    public DateTime getCreateTime() {
        return this.createTime;
    }

    @JsonProperty
    public DateTime getExecutionStartTime() {
        return this.executionStartTime;
    }

    @JsonProperty
    public DateTime getLastHeartbeat() {
        return this.lastHeartbeat;
    }

    @Nullable
    @JsonProperty
    public DateTime getEndTime() {
        return this.endTime;
    }

    @JsonProperty
    public Duration getElapsedTime() {
        return this.elapsedTime;
    }

    @JsonProperty
    public Duration getResourceWaitingTime() {
        return this.resourceWaitingTime;
    }

    @JsonProperty
    public Duration getQueuedTime() {
        return this.queuedTime;
    }

    @JsonProperty
    public Duration getExecutionTime() {
        return this.executionTime;
    }

    @JsonProperty
    public Duration getAnalysisTime() {
        return this.analysisTime;
    }

    @JsonProperty
    public Duration getDistributedPlanningTime() {
        return this.distributedPlanningTime;
    }

    @JsonProperty
    public Duration getTotalPlanningTime() {
        return this.totalPlanningTime;
    }

    @JsonProperty
    public Duration getFinishingTime() {
        return this.finishingTime;
    }

    @JsonProperty
    public int getTotalTasks() {
        return this.totalTasks;
    }

    @JsonProperty
    public int getRunningTasks() {
        return this.runningTasks;
    }

    @JsonProperty
    public int getCompletedTasks() {
        return this.completedTasks;
    }

    @JsonProperty
    public int getTotalDrivers() {
        return this.totalDrivers;
    }

    @JsonProperty
    public int getQueuedDrivers() {
        return this.queuedDrivers;
    }

    @JsonProperty
    public int getRunningDrivers() {
        return this.runningDrivers;
    }

    @JsonProperty
    public int getBlockedDrivers() {
        return this.blockedDrivers;
    }

    @JsonProperty
    public int getCompletedDrivers() {
        return this.completedDrivers;
    }

    @JsonProperty
    public double getCumulativeUserMemory() {
        return this.cumulativeUserMemory;
    }

    @JsonProperty
    public DataSize getUserMemoryReservation() {
        return this.userMemoryReservation;
    }

    @JsonProperty
    public DataSize getTotalMemoryReservation() {
        return this.totalMemoryReservation;
    }

    @JsonProperty
    public DataSize getPeakUserMemoryReservation() {
        return this.peakUserMemoryReservation;
    }

    @JsonProperty
    public DataSize getPeakTotalMemoryReservation() {
        return this.peakTotalMemoryReservation;
    }

    @JsonProperty
    public DataSize getPeakTaskTotalMemory() {
        return this.peakTaskTotalMemory;
    }

    @JsonProperty
    public boolean isScheduled() {
        return this.scheduled;
    }

    @JsonProperty
    public Duration getTotalScheduledTime() {
        return this.totalScheduledTime;
    }

    @JsonProperty
    public Duration getTotalCpuTime() {
        return this.totalCpuTime;
    }

    @JsonProperty
    public Duration getTotalBlockedTime() {
        return this.totalBlockedTime;
    }

    @JsonProperty
    public boolean isFullyBlocked() {
        return this.fullyBlocked;
    }

    @JsonProperty
    public Set<BlockedReason> getBlockedReasons() {
        return this.blockedReasons;
    }

    @JsonProperty
    public DataSize getRawInputDataSize() {
        return this.rawInputDataSize;
    }

    @JsonProperty
    public long getRawInputPositions() {
        return this.rawInputPositions;
    }

    @JsonProperty
    public DataSize getProcessedInputDataSize() {
        return this.processedInputDataSize;
    }

    @JsonProperty
    public long getProcessedInputPositions() {
        return this.processedInputPositions;
    }

    @JsonProperty
    public DataSize getOutputDataSize() {
        return this.outputDataSize;
    }

    @JsonProperty
    public long getOutputPositions() {
        return this.outputPositions;
    }

    @JsonProperty
    public DataSize getPhysicalWrittenDataSize() {
        return this.physicalWrittenDataSize;
    }

    @JsonProperty
    public long getWrittenPositions() {
        return this.operatorSummaries.stream().filter(stats -> stats.getOperatorType().equals(TableWriterOperator.class.getSimpleName())).mapToLong(OperatorStats::getInputPositions).sum();
    }

    @JsonProperty
    public DataSize getLogicalWrittenDataSize() {
        return DataSize.succinctBytes((long)this.operatorSummaries.stream().filter(stats -> stats.getOperatorType().equals(TableWriterOperator.class.getSimpleName())).mapToLong(stats -> stats.getInputDataSize().toBytes()).sum());
    }

    @JsonProperty
    public List<StageGcStatistics> getStageGcStatistics() {
        return this.stageGcStatistics;
    }

    @JsonProperty
    public List<OperatorStats> getOperatorSummaries() {
        return this.operatorSummaries;
    }

    @JsonProperty
    public OptionalDouble getProgressPercentage() {
        if (!this.scheduled || this.totalDrivers == 0) {
            return OptionalDouble.empty();
        }
        return OptionalDouble.of(Math.min(100.0, (double)this.completedDrivers * 100.0 / (double)this.totalDrivers));
    }
}

