/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution;

import com.facebook.presto.Session;
import com.facebook.presto.connector.ConnectorId;
import com.facebook.presto.execution.DataDefinitionTask;
import com.facebook.presto.execution.QueryStateMachine;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.MetadataUtil;
import com.facebook.presto.metadata.QualifiedObjectName;
import com.facebook.presto.metadata.TableHandle;
import com.facebook.presto.metadata.TableMetadata;
import com.facebook.presto.security.AccessControl;
import com.facebook.presto.spi.ColumnMetadata;
import com.facebook.presto.spi.ConnectorTableMetadata;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeSignature;
import com.facebook.presto.sql.NodeUtils;
import com.facebook.presto.sql.analyzer.SemanticErrorCode;
import com.facebook.presto.sql.analyzer.SemanticException;
import com.facebook.presto.sql.tree.ColumnDefinition;
import com.facebook.presto.sql.tree.CreateTable;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.LikeClause;
import com.facebook.presto.sql.tree.Node;
import com.facebook.presto.sql.tree.TableElement;
import com.facebook.presto.transaction.TransactionManager;
import com.facebook.presto.type.UnknownType;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public class CreateTableTask
implements DataDefinitionTask<CreateTable> {
    @Override
    public String getName() {
        return "CREATE TABLE";
    }

    @Override
    public String explain(CreateTable statement, List<Expression> parameters) {
        return "CREATE TABLE " + statement.getName();
    }

    @Override
    public ListenableFuture<?> execute(CreateTable statement, TransactionManager transactionManager, Metadata metadata, AccessControl accessControl, QueryStateMachine stateMachine, List<Expression> parameters) {
        return this.internalExecute(statement, metadata, accessControl, stateMachine.getSession(), parameters);
    }

    @VisibleForTesting
    public ListenableFuture<?> internalExecute(CreateTable statement, Metadata metadata, AccessControl accessControl, Session session, List<Expression> parameters) {
        block15: {
            Preconditions.checkArgument((!statement.getElements().isEmpty() ? 1 : 0) != 0, (Object)"no columns for table");
            QualifiedObjectName tableName = MetadataUtil.createQualifiedObjectName(session, (Node)statement, statement.getName());
            Optional<TableHandle> tableHandle = metadata.getTableHandle(session, tableName);
            if (tableHandle.isPresent()) {
                if (!statement.isNotExists()) {
                    throw new SemanticException(SemanticErrorCode.TABLE_ALREADY_EXISTS, (Node)statement, "Table '%s' already exists", tableName);
                }
                return Futures.immediateFuture(null);
            }
            ConnectorId connectorId = metadata.getCatalogHandle(session, tableName.getCatalogName()).orElseThrow(() -> new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_FOUND, "Catalog does not exist: " + tableName.getCatalogName()));
            LinkedHashMap<String, ColumnMetadata> columns = new LinkedHashMap<String, ColumnMetadata>();
            Object inheritedProperties = ImmutableMap.of();
            boolean includingProperties = false;
            for (TableElement element : statement.getElements()) {
                if (element instanceof ColumnDefinition) {
                    Type type;
                    ColumnDefinition column2 = (ColumnDefinition)element;
                    String name = column2.getName().getValue().toLowerCase(Locale.ENGLISH);
                    try {
                        type = metadata.getType(TypeSignature.parseTypeSignature((String)column2.getType()));
                    }
                    catch (IllegalArgumentException e) {
                        throw new SemanticException(SemanticErrorCode.TYPE_MISMATCH, (Node)element, "Unknown type '%s' for column '%s'", column2.getType(), column2.getName());
                    }
                    if (type.equals((Object)UnknownType.UNKNOWN)) {
                        throw new SemanticException(SemanticErrorCode.TYPE_MISMATCH, (Node)element, "Unknown type '%s' for column '%s'", column2.getType(), column2.getName());
                    }
                    if (columns.containsKey(name)) {
                        throw new SemanticException(SemanticErrorCode.DUPLICATE_COLUMN_NAME, (Node)column2, "Column name '%s' specified more than once", column2.getName());
                    }
                    Map<String, Expression> sqlProperties = NodeUtils.mapFromProperties(column2.getProperties());
                    Map<String, Object> columnProperties = metadata.getColumnPropertyManager().getProperties(connectorId, tableName.getCatalogName(), sqlProperties, session, metadata, parameters);
                    columns.put(name, new ColumnMetadata(name, type, (String)column2.getComment().orElse(null), null, false, columnProperties));
                    continue;
                }
                if (element instanceof LikeClause) {
                    LikeClause likeClause = (LikeClause)element;
                    QualifiedObjectName likeTableName = MetadataUtil.createQualifiedObjectName(session, (Node)statement, likeClause.getTableName());
                    if (!metadata.getCatalogHandle(session, likeTableName.getCatalogName()).isPresent()) {
                        throw new SemanticException(SemanticErrorCode.MISSING_CATALOG, (Node)statement, "LIKE table catalog '%s' does not exist", likeTableName.getCatalogName());
                    }
                    if (!tableName.getCatalogName().equals(likeTableName.getCatalogName())) {
                        throw new SemanticException(SemanticErrorCode.NOT_SUPPORTED, (Node)statement, "LIKE table across catalogs is not supported", new Object[0]);
                    }
                    TableHandle likeTable = metadata.getTableHandle(session, likeTableName).orElseThrow(() -> new SemanticException(SemanticErrorCode.MISSING_TABLE, (Node)statement, "LIKE table '%s' does not exist", likeTableName));
                    TableMetadata likeTableMetadata = metadata.getTableMetadata(session, likeTable);
                    Optional propertiesOption = likeClause.getPropertiesOption();
                    if (propertiesOption.isPresent() && ((LikeClause.PropertiesOption)propertiesOption.get()).equals((Object)LikeClause.PropertiesOption.INCLUDING)) {
                        if (includingProperties) {
                            throw new SemanticException(SemanticErrorCode.NOT_SUPPORTED, (Node)statement, "Only one LIKE clause can specify INCLUDING PROPERTIES", new Object[0]);
                        }
                        includingProperties = true;
                        inheritedProperties = likeTableMetadata.getMetadata().getProperties();
                    }
                    likeTableMetadata.getColumns().stream().filter(column -> !column.isHidden()).forEach(column -> {
                        if (columns.containsKey(column.getName().toLowerCase(Locale.ENGLISH))) {
                            throw new SemanticException(SemanticErrorCode.DUPLICATE_COLUMN_NAME, (Node)element, "Column name '%s' specified more than once", column.getName());
                        }
                        columns.put(column.getName().toLowerCase(Locale.ENGLISH), (ColumnMetadata)column);
                    });
                    continue;
                }
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, "Invalid TableElement: " + element.getClass().getName());
            }
            accessControl.checkCanCreateTable(session.getRequiredTransactionId(), session.getIdentity(), tableName);
            Map<String, Expression> sqlProperties = NodeUtils.mapFromProperties(statement.getProperties());
            Map<String, Object> properties = metadata.getTablePropertyManager().getProperties(connectorId, tableName.getCatalogName(), sqlProperties, session, metadata, parameters);
            Map<String, Object> finalProperties = CreateTableTask.combineProperties(sqlProperties.keySet(), properties, (Map<String, Object>)inheritedProperties);
            ConnectorTableMetadata tableMetadata = new ConnectorTableMetadata(tableName.asSchemaTableName(), (List)ImmutableList.copyOf(columns.values()), finalProperties, statement.getComment());
            try {
                metadata.createTable(session, tableName.getCatalogName(), tableMetadata, statement.isNotExists());
            }
            catch (PrestoException e) {
                if (e.getErrorCode().equals((Object)StandardErrorCode.ALREADY_EXISTS.toErrorCode()) && statement.isNotExists()) break block15;
                throw e;
            }
        }
        return Futures.immediateFuture(null);
    }

    private static Map<String, Object> combineProperties(Set<String> specifiedPropertyKeys, Map<String, Object> defaultProperties, Map<String, Object> inheritedProperties) {
        HashMap<String, Object> finalProperties = new HashMap<String, Object>(inheritedProperties);
        for (Map.Entry<String, Object> entry : defaultProperties.entrySet()) {
            if (!specifiedPropertyKeys.contains(entry.getKey()) && finalProperties.containsKey(entry.getKey())) continue;
            finalProperties.put(entry.getKey(), entry.getValue());
        }
        return finalProperties;
    }
}

