/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution;

import com.facebook.presto.operator.BlockedReason;
import com.google.common.collect.ImmutableSet;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.OptionalDouble;
import java.util.Set;
import java.util.concurrent.TimeUnit;

public class BasicStageStats {
    public static final BasicStageStats EMPTY_STAGE_STATS = new BasicStageStats(false, 0, 0, 0, 0, new DataSize(0.0, DataSize.Unit.BYTE), 0L, 0L, new DataSize(0.0, DataSize.Unit.BYTE), new DataSize(0.0, DataSize.Unit.BYTE), new Duration(0.0, TimeUnit.MILLISECONDS), new Duration(0.0, TimeUnit.MILLISECONDS), false, (Set<BlockedReason>)ImmutableSet.of(), OptionalDouble.empty());
    private final boolean isScheduled;
    private final int totalDrivers;
    private final int queuedDrivers;
    private final int runningDrivers;
    private final int completedDrivers;
    private final DataSize rawInputDataSize;
    private final long rawInputPositions;
    private final long cumulativeUserMemory;
    private final DataSize userMemoryReservation;
    private final DataSize totalMemoryReservation;
    private final Duration totalCpuTime;
    private final Duration totalScheduledTime;
    private final boolean fullyBlocked;
    private final Set<BlockedReason> blockedReasons;
    private final OptionalDouble progressPercentage;

    public BasicStageStats(boolean isScheduled, int totalDrivers, int queuedDrivers, int runningDrivers, int completedDrivers, DataSize rawInputDataSize, long rawInputPositions, long cumulativeUserMemory, DataSize userMemoryReservation, DataSize totalMemoryReservation, Duration totalCpuTime, Duration totalScheduledTime, boolean fullyBlocked, Set<BlockedReason> blockedReasons, OptionalDouble progressPercentage) {
        this.isScheduled = isScheduled;
        this.totalDrivers = totalDrivers;
        this.queuedDrivers = queuedDrivers;
        this.runningDrivers = runningDrivers;
        this.completedDrivers = completedDrivers;
        this.rawInputDataSize = Objects.requireNonNull(rawInputDataSize, "rawInputDataSize is null");
        this.rawInputPositions = rawInputPositions;
        this.cumulativeUserMemory = cumulativeUserMemory;
        this.userMemoryReservation = Objects.requireNonNull(userMemoryReservation, "userMemoryReservation is null");
        this.totalMemoryReservation = Objects.requireNonNull(totalMemoryReservation, "totalMemoryReservation is null");
        this.totalCpuTime = Objects.requireNonNull(totalCpuTime, "totalCpuTime is null");
        this.totalScheduledTime = Objects.requireNonNull(totalScheduledTime, "totalScheduledTime is null");
        this.fullyBlocked = fullyBlocked;
        this.blockedReasons = ImmutableSet.copyOf((Collection)Objects.requireNonNull(blockedReasons, "blockedReasons is null"));
        this.progressPercentage = Objects.requireNonNull(progressPercentage, "progressPercentage is null");
    }

    public boolean isScheduled() {
        return this.isScheduled;
    }

    public int getTotalDrivers() {
        return this.totalDrivers;
    }

    public int getQueuedDrivers() {
        return this.queuedDrivers;
    }

    public int getRunningDrivers() {
        return this.runningDrivers;
    }

    public int getCompletedDrivers() {
        return this.completedDrivers;
    }

    public DataSize getRawInputDataSize() {
        return this.rawInputDataSize;
    }

    public long getRawInputPositions() {
        return this.rawInputPositions;
    }

    public long getCumulativeUserMemory() {
        return this.cumulativeUserMemory;
    }

    public DataSize getUserMemoryReservation() {
        return this.userMemoryReservation;
    }

    public DataSize getTotalMemoryReservation() {
        return this.totalMemoryReservation;
    }

    public Duration getTotalCpuTime() {
        return this.totalCpuTime;
    }

    public Duration getTotalScheduledTime() {
        return this.totalScheduledTime;
    }

    public boolean isFullyBlocked() {
        return this.fullyBlocked;
    }

    public Set<BlockedReason> getBlockedReasons() {
        return this.blockedReasons;
    }

    public OptionalDouble getProgressPercentage() {
        return this.progressPercentage;
    }

    public static BasicStageStats aggregateBasicStageStats(Iterable<BasicStageStats> stages) {
        int totalDrivers = 0;
        int queuedDrivers = 0;
        int runningDrivers = 0;
        int completedDrivers = 0;
        long cumulativeUserMemory = 0L;
        long userMemoryReservation = 0L;
        long totalMemoryReservation = 0L;
        long totalScheduledTimeMillis = 0L;
        long totalCpuTime = 0L;
        long rawInputDataSize = 0L;
        long rawInputPositions = 0L;
        boolean isScheduled = true;
        boolean fullyBlocked = true;
        HashSet<BlockedReason> blockedReasons = new HashSet<BlockedReason>();
        for (BasicStageStats stageStats : stages) {
            totalDrivers += stageStats.getTotalDrivers();
            queuedDrivers += stageStats.getQueuedDrivers();
            runningDrivers += stageStats.getRunningDrivers();
            completedDrivers += stageStats.getCompletedDrivers();
            cumulativeUserMemory += stageStats.getCumulativeUserMemory();
            userMemoryReservation += stageStats.getUserMemoryReservation().toBytes();
            totalMemoryReservation += stageStats.getTotalMemoryReservation().toBytes();
            totalScheduledTimeMillis += stageStats.getTotalScheduledTime().roundTo(TimeUnit.MILLISECONDS);
            totalCpuTime += stageStats.getTotalCpuTime().roundTo(TimeUnit.MILLISECONDS);
            isScheduled &= stageStats.isScheduled();
            fullyBlocked &= stageStats.isFullyBlocked();
            blockedReasons.addAll(stageStats.getBlockedReasons());
            rawInputDataSize += stageStats.getRawInputDataSize().toBytes();
            rawInputPositions += stageStats.getRawInputPositions();
        }
        OptionalDouble progressPercentage = OptionalDouble.empty();
        if (isScheduled && totalDrivers != 0) {
            progressPercentage = OptionalDouble.of(Math.min(100.0, (double)completedDrivers * 100.0 / (double)totalDrivers));
        }
        return new BasicStageStats(isScheduled, totalDrivers, queuedDrivers, runningDrivers, completedDrivers, DataSize.succinctBytes((long)rawInputDataSize), rawInputPositions, cumulativeUserMemory, DataSize.succinctBytes((long)userMemoryReservation), DataSize.succinctBytes((long)totalMemoryReservation), new Duration((double)totalCpuTime, TimeUnit.MILLISECONDS).convertToMostSuccinctTimeUnit(), new Duration((double)totalScheduledTimeMillis, TimeUnit.MILLISECONDS).convertToMostSuccinctTimeUnit(), fullyBlocked, blockedReasons, progressPercentage);
    }
}

