/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.cost;

import com.facebook.presto.Session;
import com.facebook.presto.SystemSessionProperties;
import com.facebook.presto.cost.CostCalculator;
import com.facebook.presto.cost.CostProvider;
import com.facebook.presto.cost.PlanNodeCostEstimate;
import com.facebook.presto.cost.StatsProvider;
import com.facebook.presto.sql.planner.TypeProvider;
import com.facebook.presto.sql.planner.iterative.GroupReference;
import com.facebook.presto.sql.planner.iterative.Memo;
import com.facebook.presto.sql.planner.plan.PlanNode;
import com.google.common.base.Verify;
import io.airlift.log.Logger;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class CachingCostProvider
implements CostProvider {
    private static final Logger log = Logger.get(CachingCostProvider.class);
    private final CostCalculator costCalculator;
    private final StatsProvider statsProvider;
    private final Optional<Memo> memo;
    private final Session session;
    private final TypeProvider types;
    private final Map<PlanNode, PlanNodeCostEstimate> cache = new IdentityHashMap<PlanNode, PlanNodeCostEstimate>();

    public CachingCostProvider(CostCalculator costCalculator, StatsProvider statsProvider, Session session, TypeProvider types) {
        this(costCalculator, statsProvider, Optional.empty(), session, types);
    }

    public CachingCostProvider(CostCalculator costCalculator, StatsProvider statsProvider, Optional<Memo> memo, Session session, TypeProvider types) {
        this.costCalculator = Objects.requireNonNull(costCalculator, "costCalculator is null");
        this.statsProvider = Objects.requireNonNull(statsProvider, "statsProvider is null");
        this.memo = Objects.requireNonNull(memo, "memo is null");
        this.session = Objects.requireNonNull(session, "session is null");
        this.types = Objects.requireNonNull(types, "types is null");
    }

    @Override
    public PlanNodeCostEstimate getCumulativeCost(PlanNode node) {
        if (!SystemSessionProperties.isEnableStatsCalculator(this.session)) {
            return PlanNodeCostEstimate.unknown();
        }
        Objects.requireNonNull(node, "node is null");
        try {
            if (node instanceof GroupReference) {
                return this.getGroupCost((GroupReference)node);
            }
            PlanNodeCostEstimate cumulativeCost = this.cache.get(node);
            if (cumulativeCost != null) {
                return cumulativeCost;
            }
            cumulativeCost = this.calculateCumulativeCost(node);
            Verify.verify((this.cache.put(node, cumulativeCost) == null ? 1 : 0) != 0, (String)"Cost already set", (Object[])new Object[0]);
            return cumulativeCost;
        }
        catch (RuntimeException e) {
            if (SystemSessionProperties.isIgnoreStatsCalculatorFailures(this.session)) {
                log.error((Throwable)e, "Error occurred when computing cost for query %s", new Object[]{this.session.getQueryId()});
                return PlanNodeCostEstimate.unknown();
            }
            throw e;
        }
    }

    private PlanNodeCostEstimate getGroupCost(GroupReference groupReference) {
        int group = groupReference.getGroupId();
        Memo memo = this.memo.orElseThrow(() -> new IllegalStateException("CachingCostProvider without memo cannot handle GroupReferences"));
        Optional<PlanNodeCostEstimate> cost = memo.getCumulativeCost(group);
        if (cost.isPresent()) {
            return cost.get();
        }
        PlanNodeCostEstimate cumulativeCost = this.calculateCumulativeCost(memo.getNode(group));
        Verify.verify((!memo.getCumulativeCost(group).isPresent() ? 1 : 0) != 0, (String)"Group cost already set", (Object[])new Object[0]);
        memo.storeCumulativeCost(group, cumulativeCost);
        return cumulativeCost;
    }

    private PlanNodeCostEstimate calculateCumulativeCost(PlanNode node) {
        PlanNodeCostEstimate localCosts = this.costCalculator.calculateCost(node, this.statsProvider, this.session, this.types);
        PlanNodeCostEstimate sourcesCost = node.getSources().stream().map(this::getCumulativeCost).reduce(PlanNodeCostEstimate.zero(), PlanNodeCostEstimate::add);
        PlanNodeCostEstimate cumulativeCost = localCosts.add(sourcesCost);
        return cumulativeCost;
    }
}

