/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto;

import com.facebook.presto.Session;
import com.facebook.presto.SystemSessionProperties;
import com.facebook.presto.connector.ConnectorId;
import com.facebook.presto.metadata.SessionPropertyManager;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.security.Identity;
import com.facebook.presto.spi.type.TimeZoneKey;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class FullConnectorSession
implements ConnectorSession {
    private final Session session;
    private final Map<String, String> properties;
    private final ConnectorId connectorId;
    private final String catalog;
    private final SessionPropertyManager sessionPropertyManager;
    private final boolean isLegacyTimestamp;

    public FullConnectorSession(Session session) {
        this.session = Objects.requireNonNull(session, "session is null");
        this.properties = null;
        this.connectorId = null;
        this.catalog = null;
        this.sessionPropertyManager = null;
        this.isLegacyTimestamp = SystemSessionProperties.isLegacyTimestamp(session);
    }

    public FullConnectorSession(Session session, Map<String, String> properties, ConnectorId connectorId, String catalog, SessionPropertyManager sessionPropertyManager) {
        this.session = Objects.requireNonNull(session, "session is null");
        this.properties = ImmutableMap.copyOf(Objects.requireNonNull(properties, "properties is null"));
        this.connectorId = Objects.requireNonNull(connectorId, "connectorId is null");
        this.catalog = Objects.requireNonNull(catalog, "catalog is null");
        this.sessionPropertyManager = Objects.requireNonNull(sessionPropertyManager, "sessionPropertyManager is null");
        this.isLegacyTimestamp = SystemSessionProperties.isLegacyTimestamp(session);
    }

    public Session getSession() {
        return this.session;
    }

    public String getQueryId() {
        return this.session.getQueryId().toString();
    }

    public Optional<String> getSource() {
        return this.session.getSource();
    }

    public Identity getIdentity() {
        return this.session.getIdentity();
    }

    public TimeZoneKey getTimeZoneKey() {
        return this.session.getTimeZoneKey();
    }

    public Locale getLocale() {
        return this.session.getLocale();
    }

    public long getStartTime() {
        return this.session.getStartTime();
    }

    public Optional<String> getTraceToken() {
        return this.session.getTraceToken();
    }

    public boolean isLegacyTimestamp() {
        return this.isLegacyTimestamp;
    }

    public <T> T getProperty(String propertyName, Class<T> type) {
        if (this.properties == null) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_SESSION_PROPERTY, String.format("Unknown session property: %s.%s", this.catalog, propertyName));
        }
        return this.sessionPropertyManager.decodeCatalogPropertyValue(this.connectorId, this.catalog, propertyName, this.properties.get(propertyName), type);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("queryId", (Object)this.getQueryId()).add("user", (Object)this.getUser()).add("source", this.getSource().orElse(null)).add("traceToken", this.getTraceToken().orElse(null)).add("timeZoneKey", (Object)this.getTimeZoneKey()).add("locale", (Object)this.getLocale()).add("startTime", this.getStartTime()).add("properties", this.properties).omitNullValues().toString();
    }
}

