/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.util;

import com.google.common.collect.AbstractIterator;
import java.util.Iterator;
import java.util.Objects;

public class PrestoIterators {
    private PrestoIterators() {
    }

    public static <T> Iterator<T> closeWhenExhausted(final Iterator<T> iterator, final AutoCloseable resource) {
        Objects.requireNonNull(iterator, "iterator is null");
        Objects.requireNonNull(resource, "resource is null");
        return new AbstractIterator<T>(){

            protected T computeNext() {
                if (iterator.hasNext()) {
                    return iterator.next();
                }
                try {
                    resource.close();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                return this.endOfData();
            }
        };
    }
}

