/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.util;

import com.facebook.presto.memory.context.AggregatedMemoryContext;
import com.facebook.presto.memory.context.LocalMemoryContext;
import com.facebook.presto.operator.DriverYieldSignal;
import com.facebook.presto.operator.PageWithPositionComparator;
import com.facebook.presto.operator.WorkProcessor;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.PageBuilder;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.type.Type;
import com.google.common.collect.ImmutableList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.function.BiPredicate;
import java.util.stream.IntStream;

public final class MergeSortedPages {
    private MergeSortedPages() {
    }

    public static WorkProcessor<Page> mergeSortedPages(List<WorkProcessor<Page>> pageProducers, PageWithPositionComparator comparator, List<Type> outputTypes, AggregatedMemoryContext aggregatedMemoryContext, DriverYieldSignal yieldSignal) {
        return MergeSortedPages.mergeSortedPages(pageProducers, comparator, (List)IntStream.range(0, outputTypes.size()).boxed().collect(ImmutableList.toImmutableList()), outputTypes, (pageBuilder, pageWithPosition) -> pageBuilder.isFull(), false, aggregatedMemoryContext, yieldSignal);
    }

    public static WorkProcessor<Page> mergeSortedPages(List<WorkProcessor<Page>> pageProducers, PageWithPositionComparator comparator, List<Integer> outputChannels, List<Type> outputTypes, BiPredicate<PageBuilder, PageWithPosition> pageBreakPredicate, boolean updateMemoryAfterEveryPosition, AggregatedMemoryContext aggregatedMemoryContext, DriverYieldSignal yieldSignal) {
        List pageWithPositionProducers = (List)pageProducers.stream().map(pageProducer -> MergeSortedPages.pageWithPositions(pageProducer, aggregatedMemoryContext.newLocalMemoryContext())).collect(ImmutableList.toImmutableList());
        Comparator pageWithPositionComparator = (firstPageWithPosition, secondPageWithPosition) -> comparator.compareTo(firstPageWithPosition.getPage(), firstPageWithPosition.getPosition(), secondPageWithPosition.getPage(), secondPageWithPosition.getPosition());
        return MergeSortedPages.buildPage(WorkProcessor.mergeSorted(pageWithPositionProducers, pageWithPositionComparator), outputChannels, outputTypes, pageBreakPredicate, updateMemoryAfterEveryPosition, aggregatedMemoryContext.newLocalMemoryContext(), yieldSignal);
    }

    private static WorkProcessor<Page> buildPage(WorkProcessor<PageWithPosition> pageWithPositions, List<Integer> outputChannels, List<Type> outputTypes, BiPredicate<PageBuilder, PageWithPosition> pageBreakPredicate, boolean updateMemoryAfterEveryPosition, LocalMemoryContext memoryContext, DriverYieldSignal yieldSignal) {
        PageBuilder pageBuilder = new PageBuilder(outputTypes);
        return pageWithPositions.transform(pageWithPositionOptional -> {
            boolean finished;
            if (yieldSignal.isSet()) {
                return WorkProcessor.ProcessorState.yield();
            }
            boolean bl = finished = !pageWithPositionOptional.isPresent();
            if (finished && pageBuilder.isEmpty()) {
                return WorkProcessor.ProcessorState.finished();
            }
            if (finished || pageBreakPredicate.test(pageBuilder, (PageWithPosition)pageWithPositionOptional.get())) {
                if (!updateMemoryAfterEveryPosition) {
                    memoryContext.setBytes(pageBuilder.getRetainedSizeInBytes());
                }
                Page page = pageBuilder.build();
                pageBuilder.reset();
                if (!finished) {
                    ((PageWithPosition)pageWithPositionOptional.get()).appendTo(pageBuilder, outputChannels, outputTypes);
                }
                if (updateMemoryAfterEveryPosition) {
                    memoryContext.setBytes(pageBuilder.getRetainedSizeInBytes());
                }
                return WorkProcessor.ProcessorState.ofResult(page, !finished);
            }
            ((PageWithPosition)pageWithPositionOptional.get()).appendTo(pageBuilder, outputChannels, outputTypes);
            if (updateMemoryAfterEveryPosition) {
                memoryContext.setBytes(pageBuilder.getRetainedSizeInBytes());
            }
            return WorkProcessor.ProcessorState.needsMoreData();
        });
    }

    private static WorkProcessor<PageWithPosition> pageWithPositions(WorkProcessor<Page> pages, final LocalMemoryContext memoryContext) {
        return pages.flatMap(page -> {
            memoryContext.setBytes(page.getRetainedSizeInBytes());
            return WorkProcessor.create(new WorkProcessor.Process<PageWithPosition>(){
                int position;

                @Override
                public WorkProcessor.ProcessorState<PageWithPosition> process() {
                    if (this.position >= page.getPositionCount()) {
                        memoryContext.setBytes(0L);
                        return WorkProcessor.ProcessorState.finished();
                    }
                    return WorkProcessor.ProcessorState.ofResult(new PageWithPosition(page, this.position++));
                }
            });
        });
    }

    public static class PageWithPosition {
        private final Page page;
        private final int position;

        private PageWithPosition(Page page, int position) {
            this.page = Objects.requireNonNull(page, "page is null");
            this.position = position;
        }

        public Page getPage() {
            return this.page;
        }

        public int getPosition() {
            return this.position;
        }

        public void appendTo(PageBuilder pageBuilder, List<Integer> outputChannels, List<Type> outputTypes) {
            pageBuilder.declarePosition();
            for (int i = 0; i < outputChannels.size(); ++i) {
                Type type = outputTypes.get(i);
                Block block = this.page.getBlock(outputChannels.get(i).intValue());
                type.appendTo(block, this.position, pageBuilder.getBlockBuilder(i));
            }
        }
    }
}

