/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.type;

import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.function.IsNull;
import com.facebook.presto.spi.function.LiteralParameters;
import com.facebook.presto.spi.function.OperatorType;
import com.facebook.presto.spi.function.ScalarOperator;
import com.facebook.presto.spi.function.SqlType;
import com.facebook.presto.spi.type.AbstractLongType;
import com.facebook.presto.spi.type.DateTimeEncoding;
import com.facebook.presto.spi.type.TimeZoneKey;
import com.facebook.presto.util.DateTimeUtils;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;

public final class TimeOperators {
    private TimeOperators() {
    }

    @ScalarOperator(value=OperatorType.SUBTRACT)
    @SqlType(value="interval day to second")
    public static long subtract(@SqlType(value="time") long left, @SqlType(value="time") long right) {
        return left - right;
    }

    @ScalarOperator(value=OperatorType.EQUAL)
    @SqlType(value="boolean")
    public static boolean equal(@SqlType(value="time") long left, @SqlType(value="time") long right) {
        return left == right;
    }

    @ScalarOperator(value=OperatorType.NOT_EQUAL)
    @SqlType(value="boolean")
    public static boolean notEqual(@SqlType(value="time") long left, @SqlType(value="time") long right) {
        return left != right;
    }

    @ScalarOperator(value=OperatorType.LESS_THAN)
    @SqlType(value="boolean")
    public static boolean lessThan(@SqlType(value="time") long left, @SqlType(value="time") long right) {
        return left < right;
    }

    @ScalarOperator(value=OperatorType.LESS_THAN_OR_EQUAL)
    @SqlType(value="boolean")
    public static boolean lessThanOrEqual(@SqlType(value="time") long left, @SqlType(value="time") long right) {
        return left <= right;
    }

    @ScalarOperator(value=OperatorType.GREATER_THAN)
    @SqlType(value="boolean")
    public static boolean greaterThan(@SqlType(value="time") long left, @SqlType(value="time") long right) {
        return left > right;
    }

    @ScalarOperator(value=OperatorType.GREATER_THAN_OR_EQUAL)
    @SqlType(value="boolean")
    public static boolean greaterThanOrEqual(@SqlType(value="time") long left, @SqlType(value="time") long right) {
        return left >= right;
    }

    @ScalarOperator(value=OperatorType.BETWEEN)
    @SqlType(value="boolean")
    public static boolean between(@SqlType(value="time") long value, @SqlType(value="time") long min, @SqlType(value="time") long max) {
        return min <= value && value <= max;
    }

    @ScalarOperator(value=OperatorType.CAST)
    @SqlType(value="time with time zone")
    public static long castToTimeWithTimeZone(ConnectorSession session, @SqlType(value="time") long value) {
        return DateTimeEncoding.packDateTimeWithZone((long)value, (TimeZoneKey)session.getTimeZoneKey());
    }

    @ScalarOperator(value=OperatorType.CAST)
    @SqlType(value="timestamp")
    public static long castToTimestamp(@SqlType(value="time") long value) {
        return value;
    }

    @ScalarOperator(value=OperatorType.CAST)
    @SqlType(value="timestamp with time zone")
    public static long castToTimestampWithTimeZone(ConnectorSession session, @SqlType(value="time") long value) {
        return DateTimeEncoding.packDateTimeWithZone((long)value, (TimeZoneKey)session.getTimeZoneKey());
    }

    @ScalarOperator(value=OperatorType.CAST)
    @LiteralParameters(value={"x"})
    @SqlType(value="varchar(x)")
    public static Slice castToSlice(ConnectorSession session, @SqlType(value="time") long value) {
        return Slices.utf8Slice((String)DateTimeUtils.printTimeWithoutTimeZone(session.getTimeZoneKey(), value));
    }

    @ScalarOperator(value=OperatorType.CAST)
    @LiteralParameters(value={"x"})
    @SqlType(value="time")
    public static long castFromSlice(ConnectorSession session, @SqlType(value="varchar(x)") Slice value) {
        try {
            return DateTimeUtils.parseTimeWithoutTimeZone(session.getTimeZoneKey(), value.toStringUtf8());
        }
        catch (IllegalArgumentException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, "Value cannot be cast to time: " + value.toStringUtf8(), (Throwable)e);
        }
    }

    @ScalarOperator(value=OperatorType.HASH_CODE)
    @SqlType(value="bigint")
    public static long hashCode(@SqlType(value="time") long value) {
        return AbstractLongType.hash((long)value);
    }

    @ScalarOperator(value=OperatorType.IS_DISTINCT_FROM)
    @SqlType(value="boolean")
    public static boolean isDistinctFrom(@SqlType(value="time") long left, @IsNull boolean leftNull, @SqlType(value="time") long right, @IsNull boolean rightNull) {
        if (leftNull != rightNull) {
            return true;
        }
        if (leftNull) {
            return false;
        }
        return TimeOperators.notEqual(left, right);
    }
}

