/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.type;

import com.facebook.presto.spi.type.ParameterKind;
import com.facebook.presto.spi.type.ParametricType;
import com.facebook.presto.spi.type.RowType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeManager;
import com.facebook.presto.spi.type.TypeParameter;
import com.google.common.base.Preconditions;
import java.util.List;
import java.util.stream.Collectors;

public final class RowParametricType
implements ParametricType {
    public static final RowParametricType ROW = new RowParametricType();

    private RowParametricType() {
    }

    public String getName() {
        return "row";
    }

    public Type createType(TypeManager typeManager, List<TypeParameter> parameters) {
        Preconditions.checkArgument((!parameters.isEmpty() ? 1 : 0) != 0, (Object)"Row type must have at least one parameter");
        Preconditions.checkArgument((boolean)parameters.stream().allMatch(parameter -> parameter.getKind() == ParameterKind.NAMED_TYPE), (String)"Expected only named types as a parameters, got %s", parameters);
        List fields = parameters.stream().map(TypeParameter::getNamedType).map(parameter -> new RowType.Field(parameter.getName(), parameter.getType())).collect(Collectors.toList());
        return RowType.from(fields);
    }
}

