/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.type;

import com.facebook.presto.operator.scalar.MathFunctions;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.function.IsNull;
import com.facebook.presto.spi.function.LiteralParameters;
import com.facebook.presto.spi.function.OperatorType;
import com.facebook.presto.spi.function.ScalarOperator;
import com.facebook.presto.spi.function.SqlType;
import com.facebook.presto.spi.type.AbstractIntType;
import com.google.common.math.DoubleMath;
import com.google.common.primitives.Shorts;
import com.google.common.primitives.SignedBytes;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import java.math.RoundingMode;

public final class RealOperators {
    private static final float MIN_LONG_AS_FLOAT = -9.223372E18f;
    private static final float MAX_LONG_PLUS_ONE_AS_FLOAT = 9.223372E18f;
    private static final float MIN_INTEGER_AS_FLOAT = -2.1474836E9f;
    private static final float MAX_INTEGER_PLUS_ONE_AS_FLOAT = 2.1474836E9f;
    private static final float MIN_SHORT_AS_FLOAT = -32768.0f;
    private static final float MAX_SHORT_PLUS_ONE_AS_FLOAT = 32768.0f;
    private static final float MIN_BYTE_AS_FLOAT = -128.0f;
    private static final float MAX_BYTE_PLUS_ONE_AS_FLOAT = 128.0f;

    private RealOperators() {
    }

    @ScalarOperator(value=OperatorType.ADD)
    @SqlType(value="real")
    public static long add(@SqlType(value="real") long left, @SqlType(value="real") long right) {
        return Float.floatToRawIntBits(Float.intBitsToFloat((int)left) + Float.intBitsToFloat((int)right));
    }

    @ScalarOperator(value=OperatorType.SUBTRACT)
    @SqlType(value="real")
    public static long subtract(@SqlType(value="real") long left, @SqlType(value="real") long right) {
        return Float.floatToRawIntBits(Float.intBitsToFloat((int)left) - Float.intBitsToFloat((int)right));
    }

    @ScalarOperator(value=OperatorType.MULTIPLY)
    @SqlType(value="real")
    public static long multiply(@SqlType(value="real") long left, @SqlType(value="real") long right) {
        return Float.floatToRawIntBits(Float.intBitsToFloat((int)left) * Float.intBitsToFloat((int)right));
    }

    @ScalarOperator(value=OperatorType.DIVIDE)
    @SqlType(value="real")
    public static long divide(@SqlType(value="real") long left, @SqlType(value="real") long right) {
        return Float.floatToRawIntBits(Float.intBitsToFloat((int)left) / Float.intBitsToFloat((int)right));
    }

    @ScalarOperator(value=OperatorType.MODULUS)
    @SqlType(value="real")
    public static long modulus(@SqlType(value="real") long left, @SqlType(value="real") long right) {
        return Float.floatToRawIntBits(Float.intBitsToFloat((int)left) % Float.intBitsToFloat((int)right));
    }

    @ScalarOperator(value=OperatorType.NEGATION)
    @SqlType(value="real")
    public static long negate(@SqlType(value="real") long value) {
        return Float.floatToRawIntBits(-Float.intBitsToFloat((int)value));
    }

    @ScalarOperator(value=OperatorType.EQUAL)
    @SqlType(value="boolean")
    public static boolean equal(@SqlType(value="real") long left, @SqlType(value="real") long right) {
        return Float.intBitsToFloat((int)left) == Float.intBitsToFloat((int)right);
    }

    @ScalarOperator(value=OperatorType.NOT_EQUAL)
    @SqlType(value="boolean")
    public static boolean notEqual(@SqlType(value="real") long left, @SqlType(value="real") long right) {
        return Float.intBitsToFloat((int)left) != Float.intBitsToFloat((int)right);
    }

    @ScalarOperator(value=OperatorType.LESS_THAN)
    @SqlType(value="boolean")
    public static boolean lessThan(@SqlType(value="real") long left, @SqlType(value="real") long right) {
        return Float.intBitsToFloat((int)left) < Float.intBitsToFloat((int)right);
    }

    @ScalarOperator(value=OperatorType.LESS_THAN_OR_EQUAL)
    @SqlType(value="boolean")
    public static boolean lessThanOrEqual(@SqlType(value="real") long left, @SqlType(value="real") long right) {
        return Float.intBitsToFloat((int)left) <= Float.intBitsToFloat((int)right);
    }

    @ScalarOperator(value=OperatorType.GREATER_THAN)
    @SqlType(value="boolean")
    public static boolean greaterThan(@SqlType(value="real") long left, @SqlType(value="real") long right) {
        return Float.intBitsToFloat((int)left) > Float.intBitsToFloat((int)right);
    }

    @ScalarOperator(value=OperatorType.GREATER_THAN_OR_EQUAL)
    @SqlType(value="boolean")
    public static boolean greaterThanOrEqual(@SqlType(value="real") long left, @SqlType(value="real") long right) {
        return Float.intBitsToFloat((int)left) >= Float.intBitsToFloat((int)right);
    }

    @ScalarOperator(value=OperatorType.BETWEEN)
    @SqlType(value="boolean")
    public static boolean between(@SqlType(value="real") long value, @SqlType(value="real") long min, @SqlType(value="real") long max) {
        return Float.intBitsToFloat((int)min) <= Float.intBitsToFloat((int)value) && Float.intBitsToFloat((int)value) <= Float.intBitsToFloat((int)max);
    }

    @ScalarOperator(value=OperatorType.HASH_CODE)
    @SqlType(value="bigint")
    public static long hashCode(@SqlType(value="real") long value) {
        return AbstractIntType.hash((int)((int)value));
    }

    @ScalarOperator(value=OperatorType.CAST)
    @LiteralParameters(value={"x"})
    @SqlType(value="varchar(x)")
    public static Slice castToVarchar(@SqlType(value="real") long value) {
        return Slices.utf8Slice((String)String.valueOf(Float.intBitsToFloat((int)value)));
    }

    @ScalarOperator(value=OperatorType.CAST)
    @SqlType(value="bigint")
    public static long castToLong(@SqlType(value="real") long value) {
        return (long)MathFunctions.round(Float.intBitsToFloat((int)value));
    }

    @ScalarOperator(value=OperatorType.CAST)
    @SqlType(value="integer")
    public static long castToInteger(@SqlType(value="real") long value) {
        try {
            return Math.toIntExact((long)MathFunctions.round(Float.intBitsToFloat((int)value)));
        }
        catch (ArithmeticException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NUMERIC_VALUE_OUT_OF_RANGE, "Out of range for integer: " + value, (Throwable)e);
        }
    }

    @ScalarOperator(value=OperatorType.CAST)
    @SqlType(value="smallint")
    public static long castToSmallint(@SqlType(value="real") long value) {
        try {
            return Shorts.checkedCast((long)((long)MathFunctions.round(Float.intBitsToFloat((int)value))));
        }
        catch (IllegalArgumentException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NUMERIC_VALUE_OUT_OF_RANGE, "Out of range for smallint: " + value, (Throwable)e);
        }
    }

    @ScalarOperator(value=OperatorType.CAST)
    @SqlType(value="tinyint")
    public static long castToTinyint(@SqlType(value="real") long value) {
        try {
            return SignedBytes.checkedCast((long)((long)MathFunctions.round(Float.intBitsToFloat((int)value))));
        }
        catch (IllegalArgumentException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NUMERIC_VALUE_OUT_OF_RANGE, "Out of range for tinyint: " + value, (Throwable)e);
        }
    }

    @ScalarOperator(value=OperatorType.CAST)
    @SqlType(value="double")
    public static double castToDouble(@SqlType(value="real") long value) {
        return Float.intBitsToFloat((int)value);
    }

    @ScalarOperator(value=OperatorType.CAST)
    @SqlType(value="boolean")
    public static boolean castToBoolean(@SqlType(value="real") long value) {
        return Float.intBitsToFloat((int)value) != 0.0f;
    }

    @ScalarOperator(value=OperatorType.IS_DISTINCT_FROM)
    @SqlType(value="boolean")
    public static boolean isDistinctFrom(@SqlType(value="real") long left, @IsNull boolean leftNull, @SqlType(value="real") long right, @IsNull boolean rightNull) {
        if (leftNull != rightNull) {
            return true;
        }
        if (leftNull) {
            return false;
        }
        float leftFloat = Float.intBitsToFloat((int)left);
        float rightFloat = Float.intBitsToFloat((int)right);
        if (Float.isNaN(leftFloat) && Float.isNaN(rightFloat)) {
            return false;
        }
        return RealOperators.notEqual(left, right);
    }

    @ScalarOperator(value=OperatorType.SATURATED_FLOOR_CAST)
    @SqlType(value="smallint")
    public static long saturatedFloorCastToSmallint(@SqlType(value="real") long value) {
        return RealOperators.saturatedFloorCastToLong(value, -32768L, -32768.0f, 32767L, 32768.0f);
    }

    @ScalarOperator(value=OperatorType.SATURATED_FLOOR_CAST)
    @SqlType(value="tinyint")
    public static long saturatedFloorCastToTinyint(@SqlType(value="real") long value) {
        return RealOperators.saturatedFloorCastToLong(value, -128L, -128.0f, 127L, 128.0f);
    }

    private static long saturatedFloorCastToLong(long valueBits, long minValue, float minValueAsDouble, long maxValue, float maxValuePlusOneAsDouble) {
        float value = Float.intBitsToFloat((int)valueBits);
        if (value <= minValueAsDouble) {
            return minValue;
        }
        if (value + 1.0f >= maxValuePlusOneAsDouble) {
            return maxValue;
        }
        return DoubleMath.roundToLong((double)value, (RoundingMode)RoundingMode.FLOOR);
    }
}

