/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.type;

import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.type.AbstractFixedWidthType;
import com.facebook.presto.spi.type.TypeSignature;
import com.google.common.net.InetAddresses;
import io.airlift.slice.Slice;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class IpAddressType
extends AbstractFixedWidthType {
    public static final IpAddressType IPADDRESS = new IpAddressType();

    private IpAddressType() {
        super(TypeSignature.parseTypeSignature((String)"ipaddress"), Slice.class, 16);
    }

    public boolean isComparable() {
        return true;
    }

    public boolean isOrderable() {
        return true;
    }

    public boolean equalTo(Block leftBlock, int leftPosition, Block rightBlock, int rightPosition) {
        return this.compareTo(leftBlock, leftPosition, rightBlock, rightPosition) == 0;
    }

    public int compareTo(Block leftBlock, int leftPosition, Block rightBlock, int rightPosition) {
        return leftBlock.compareTo(leftPosition, 0, this.getFixedSize(), rightBlock, rightPosition, 0, this.getFixedSize());
    }

    public long hash(Block block, int position) {
        return block.hash(position, 0, this.getFixedSize());
    }

    public Object getObjectValue(ConnectorSession session, Block block, int position) {
        if (block.isNull(position)) {
            return null;
        }
        try {
            return InetAddresses.toAddrString((InetAddress)InetAddress.getByAddress(block.getSlice(position, 0, this.getFixedSize()).getBytes()));
        }
        catch (UnknownHostException e) {
            throw new IllegalArgumentException();
        }
    }

    public void appendTo(Block block, int position, BlockBuilder blockBuilder) {
        if (block.isNull(position)) {
            blockBuilder.appendNull();
        } else {
            block.writeBytesTo(position, 0, this.getFixedSize(), blockBuilder);
            blockBuilder.closeEntry();
        }
    }

    public void writeSlice(BlockBuilder blockBuilder, Slice value) {
        this.writeSlice(blockBuilder, value, 0, value.length());
    }

    public void writeSlice(BlockBuilder blockBuilder, Slice value, int offset, int length) {
        blockBuilder.writeBytes(value, offset, length).closeEntry();
    }
}

