/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.type;

import com.facebook.presto.annotation.UsedByGeneratedCode;
import com.facebook.presto.metadata.FunctionKind;
import com.facebook.presto.metadata.Signature;
import com.facebook.presto.metadata.SqlScalarFunction;
import com.facebook.presto.spi.function.OperatorType;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.Decimals;
import com.facebook.presto.spi.type.IntegerType;
import com.facebook.presto.spi.type.SmallintType;
import com.facebook.presto.spi.type.TinyintType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeSignature;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import io.airlift.slice.Slice;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.util.Set;

public final class DecimalSaturatedFloorCasts {
    public static final SqlScalarFunction DECIMAL_TO_DECIMAL_SATURATED_FLOOR_CAST = SqlScalarFunction.builder(DecimalSaturatedFloorCasts.class).signature(Signature.builder().kind(FunctionKind.SCALAR).operatorType(OperatorType.SATURATED_FLOOR_CAST).argumentTypes(TypeSignature.parseTypeSignature((String)"decimal(source_precision,source_scale)", (Set)ImmutableSet.of((Object)"source_precision", (Object)"source_scale"))).returnType(TypeSignature.parseTypeSignature((String)"decimal(result_precision,result_scale)", (Set)ImmutableSet.of((Object)"result_precision", (Object)"result_scale"))).build()).deterministic(true).implementation(b -> b.methods("shortDecimalToShortDecimal", "shortDecimalToLongDecimal", "longDecimalToShortDecimal", "longDecimalToLongDecimal").withExtraParameters(context -> {
        int sourcePrecision = Math.toIntExact(context.getLiteral("source_precision"));
        int sourceScale = Math.toIntExact(context.getLiteral("source_scale"));
        int resultPrecision = Math.toIntExact(context.getLiteral("result_precision"));
        int resultScale = Math.toIntExact(context.getLiteral("result_scale"));
        return ImmutableList.of((Object)sourcePrecision, (Object)sourceScale, (Object)resultPrecision, (Object)resultScale);
    })).build();
    public static final SqlScalarFunction DECIMAL_TO_BIGINT_SATURATED_FLOOR_CAST = DecimalSaturatedFloorCasts.decimalToGenericIntegerTypeSaturatedFloorCast((Type)BigintType.BIGINT, Long.MIN_VALUE, Long.MAX_VALUE);
    public static final SqlScalarFunction DECIMAL_TO_INTEGER_SATURATED_FLOOR_CAST = DecimalSaturatedFloorCasts.decimalToGenericIntegerTypeSaturatedFloorCast((Type)IntegerType.INTEGER, Integer.MIN_VALUE, Integer.MAX_VALUE);
    public static final SqlScalarFunction DECIMAL_TO_SMALLINT_SATURATED_FLOOR_CAST = DecimalSaturatedFloorCasts.decimalToGenericIntegerTypeSaturatedFloorCast((Type)SmallintType.SMALLINT, -32768L, 32767L);
    public static final SqlScalarFunction DECIMAL_TO_TINYINT_SATURATED_FLOOR_CAST = DecimalSaturatedFloorCasts.decimalToGenericIntegerTypeSaturatedFloorCast((Type)TinyintType.TINYINT, -128L, 127L);
    public static final SqlScalarFunction BIGINT_TO_DECIMAL_SATURATED_FLOOR_CAST = DecimalSaturatedFloorCasts.genericIntegerTypeToDecimalSaturatedFloorCast((Type)BigintType.BIGINT);
    public static final SqlScalarFunction INTEGER_TO_DECIMAL_SATURATED_FLOOR_CAST = DecimalSaturatedFloorCasts.genericIntegerTypeToDecimalSaturatedFloorCast((Type)IntegerType.INTEGER);
    public static final SqlScalarFunction SMALLINT_TO_DECIMAL_SATURATED_FLOOR_CAST = DecimalSaturatedFloorCasts.genericIntegerTypeToDecimalSaturatedFloorCast((Type)SmallintType.SMALLINT);
    public static final SqlScalarFunction TINYINT_TO_DECIMAL_SATURATED_FLOOR_CAST = DecimalSaturatedFloorCasts.genericIntegerTypeToDecimalSaturatedFloorCast((Type)TinyintType.TINYINT);

    private DecimalSaturatedFloorCasts() {
    }

    @UsedByGeneratedCode
    public static long shortDecimalToShortDecimal(long value, int sourcePrecision, int sourceScale, int resultPrecision, int resultScale) {
        return DecimalSaturatedFloorCasts.bigintToBigintFloorSaturatedCast(BigInteger.valueOf(value), sourceScale, resultPrecision, resultScale).longValueExact();
    }

    @UsedByGeneratedCode
    public static Slice shortDecimalToLongDecimal(long value, int sourcePrecision, int sourceScale, int resultPrecision, int resultScale) {
        return Decimals.encodeUnscaledValue((BigInteger)DecimalSaturatedFloorCasts.bigintToBigintFloorSaturatedCast(BigInteger.valueOf(value), sourceScale, resultPrecision, resultScale));
    }

    @UsedByGeneratedCode
    public static long longDecimalToShortDecimal(Slice value, int sourcePrecision, int sourceScale, int resultPrecision, int resultScale) {
        return DecimalSaturatedFloorCasts.bigintToBigintFloorSaturatedCast(Decimals.decodeUnscaledValue((Slice)value), sourceScale, resultPrecision, resultScale).longValueExact();
    }

    @UsedByGeneratedCode
    public static Slice longDecimalToLongDecimal(Slice value, int sourcePrecision, int sourceScale, int resultPrecision, int resultScale) {
        return Decimals.encodeUnscaledValue((BigInteger)DecimalSaturatedFloorCasts.bigintToBigintFloorSaturatedCast(Decimals.decodeUnscaledValue((Slice)value), sourceScale, resultPrecision, resultScale));
    }

    private static BigInteger bigintToBigintFloorSaturatedCast(BigInteger value, int sourceScale, int resultPrecision, int resultScale) {
        return DecimalSaturatedFloorCasts.bigDecimalToBigintFloorSaturatedCast(new BigDecimal(value, sourceScale), resultPrecision, resultScale);
    }

    private static BigInteger bigDecimalToBigintFloorSaturatedCast(BigDecimal bigDecimal, int resultPrecision, int resultScale) {
        BigInteger maxUnscaledValue;
        BigDecimal rescaledValue = bigDecimal.setScale(resultScale, RoundingMode.FLOOR);
        BigInteger unscaledValue = rescaledValue.unscaledValue();
        if (unscaledValue.compareTo(maxUnscaledValue = Decimals.bigIntegerTenToNth((int)resultPrecision).subtract(BigInteger.ONE)) > 0) {
            return maxUnscaledValue;
        }
        BigInteger minUnscaledValue = maxUnscaledValue.negate();
        if (unscaledValue.compareTo(minUnscaledValue) < 0) {
            return minUnscaledValue;
        }
        return unscaledValue;
    }

    private static SqlScalarFunction decimalToGenericIntegerTypeSaturatedFloorCast(Type type, long minValue, long maxValue) {
        return SqlScalarFunction.builder(DecimalSaturatedFloorCasts.class).signature(Signature.builder().kind(FunctionKind.SCALAR).operatorType(OperatorType.SATURATED_FLOOR_CAST).argumentTypes(TypeSignature.parseTypeSignature((String)"decimal(source_precision,source_scale)", (Set)ImmutableSet.of((Object)"source_precision", (Object)"source_scale"))).returnType(type.getTypeSignature()).build()).deterministic(true).implementation(b -> b.methods("shortDecimalToGenericIntegerType", "longDecimalToGenericIntegerType").withExtraParameters(context -> {
            int sourceScale = Math.toIntExact(context.getLiteral("source_scale"));
            return ImmutableList.of((Object)sourceScale, (Object)minValue, (Object)maxValue);
        })).build();
    }

    @UsedByGeneratedCode
    public static long shortDecimalToGenericIntegerType(long value, int sourceScale, long minValue, long maxValue) {
        return DecimalSaturatedFloorCasts.bigIntegerDecimalToGenericIntegerType(BigInteger.valueOf(value), sourceScale, minValue, maxValue);
    }

    @UsedByGeneratedCode
    public static long longDecimalToGenericIntegerType(Slice value, int sourceScale, long minValue, long maxValue) {
        return DecimalSaturatedFloorCasts.bigIntegerDecimalToGenericIntegerType(Decimals.decodeUnscaledValue((Slice)value), sourceScale, minValue, maxValue);
    }

    private static long bigIntegerDecimalToGenericIntegerType(BigInteger bigInteger, int sourceScale, long minValue, long maxValue) {
        BigDecimal bigDecimal = new BigDecimal(bigInteger, sourceScale);
        BigInteger unscaledValue = bigDecimal.setScale(0, RoundingMode.FLOOR).unscaledValue();
        if (unscaledValue.compareTo(BigInteger.valueOf(maxValue)) > 0) {
            return maxValue;
        }
        if (unscaledValue.compareTo(BigInteger.valueOf(minValue)) < 0) {
            return minValue;
        }
        return unscaledValue.longValueExact();
    }

    private static SqlScalarFunction genericIntegerTypeToDecimalSaturatedFloorCast(Type integerType) {
        return SqlScalarFunction.builder(DecimalSaturatedFloorCasts.class).signature(Signature.builder().kind(FunctionKind.SCALAR).operatorType(OperatorType.SATURATED_FLOOR_CAST).argumentTypes(integerType.getTypeSignature()).returnType(TypeSignature.parseTypeSignature((String)"decimal(result_precision,result_scale)", (Set)ImmutableSet.of((Object)"result_precision", (Object)"result_scale"))).build()).deterministic(true).implementation(b -> b.methods("genericIntegerTypeToShortDecimal", "genericIntegerTypeToLongDecimal").withExtraParameters(context -> {
            int resultPrecision = Math.toIntExact(context.getLiteral("result_precision"));
            int resultScale = Math.toIntExact(context.getLiteral("result_scale"));
            return ImmutableList.of((Object)resultPrecision, (Object)resultScale);
        })).build();
    }

    @UsedByGeneratedCode
    public static long genericIntegerTypeToShortDecimal(long value, int resultPrecision, int resultScale) {
        return DecimalSaturatedFloorCasts.bigDecimalToBigintFloorSaturatedCast(BigDecimal.valueOf(value), resultPrecision, resultScale).longValueExact();
    }

    @UsedByGeneratedCode
    public static Slice genericIntegerTypeToLongDecimal(long value, int resultPrecision, int resultScale) {
        return Decimals.encodeUnscaledValue((BigInteger)DecimalSaturatedFloorCasts.bigDecimalToBigintFloorSaturatedCast(BigDecimal.valueOf(value), resultPrecision, resultScale));
    }
}

