/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.testing;

import com.facebook.presto.execution.QueryIdGenerator;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.security.Identity;
import com.facebook.presto.spi.session.PropertyMetadata;
import com.facebook.presto.spi.type.TimeZoneKey;
import com.facebook.presto.sql.analyzer.FeaturesConfig;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class TestingConnectorSession
implements ConnectorSession {
    private static final QueryIdGenerator queryIdGenerator = new QueryIdGenerator();
    public static final ConnectorSession SESSION = new TestingConnectorSession((List<PropertyMetadata<?>>)ImmutableList.of());
    private final String queryId = queryIdGenerator.createNextQueryId().toString();
    private final Identity identity;
    private final Optional<String> source;
    private final TimeZoneKey timeZoneKey;
    private final Locale locale;
    private final Optional<String> traceToken;
    private final long startTime;
    private final Map<String, PropertyMetadata<?>> properties;
    private final Map<String, Object> propertyValues;
    private final boolean isLegacyTimestamp;

    public TestingConnectorSession(List<PropertyMetadata<?>> properties) {
        this("user", Optional.of("test"), Optional.empty(), TimeZoneKey.UTC_KEY, Locale.ENGLISH, System.currentTimeMillis(), properties, (Map<String, Object>)ImmutableMap.of(), new FeaturesConfig().isLegacyTimestamp());
    }

    public TestingConnectorSession(String user, Optional<String> source, Optional<String> traceToken, TimeZoneKey timeZoneKey, Locale locale, long startTime, List<PropertyMetadata<?>> propertyMetadatas, Map<String, Object> propertyValues, boolean isLegacyTimestamp) {
        this.identity = new Identity(Objects.requireNonNull(user, "user is null"), Optional.empty());
        this.source = Objects.requireNonNull(source, "source is null");
        this.traceToken = Objects.requireNonNull(traceToken, "traceToken is null");
        this.timeZoneKey = Objects.requireNonNull(timeZoneKey, "timeZoneKey is null");
        this.locale = Objects.requireNonNull(locale, "locale is null");
        this.startTime = startTime;
        this.properties = Maps.uniqueIndex(propertyMetadatas, PropertyMetadata::getName);
        this.propertyValues = ImmutableMap.copyOf(propertyValues);
        this.isLegacyTimestamp = isLegacyTimestamp;
    }

    public String getQueryId() {
        return this.queryId;
    }

    public Optional<String> getSource() {
        return this.source;
    }

    public Identity getIdentity() {
        return this.identity;
    }

    public TimeZoneKey getTimeZoneKey() {
        return this.timeZoneKey;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public Optional<String> getTraceToken() {
        return this.traceToken;
    }

    public boolean isLegacyTimestamp() {
        return this.isLegacyTimestamp;
    }

    public boolean isLegacyRoundNBigint() {
        return false;
    }

    public <T> T getProperty(String name, Class<T> type) {
        PropertyMetadata<?> metadata = this.properties.get(name);
        if (metadata == null) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_SESSION_PROPERTY, "Unknown session property " + name);
        }
        Object value = this.propertyValues.get(name);
        if (value == null) {
            return type.cast(metadata.getDefaultValue());
        }
        return type.cast(metadata.decode(value));
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("user", (Object)this.getUser()).add("source", this.source.orElse(null)).add("traceToken", this.traceToken.orElse(null)).add("timeZoneKey", (Object)this.timeZoneKey).add("locale", (Object)this.locale).add("startTime", this.startTime).add("properties", this.propertyValues).omitNullValues().toString();
    }
}

