/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.rewrite;

import com.facebook.presto.Session;
import com.facebook.presto.metadata.FunctionRegistry;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.MetadataUtil;
import com.facebook.presto.metadata.QualifiedObjectName;
import com.facebook.presto.metadata.Signature;
import com.facebook.presto.metadata.TableHandle;
import com.facebook.presto.security.AccessControl;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.Constraint;
import com.facebook.presto.spi.predicate.TupleDomain;
import com.facebook.presto.spi.statistics.ColumnStatistics;
import com.facebook.presto.spi.statistics.Estimate;
import com.facebook.presto.spi.statistics.RangeColumnStatistics;
import com.facebook.presto.spi.statistics.TableStatistics;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.VarcharType;
import com.facebook.presto.sql.FunctionInvoker;
import com.facebook.presto.sql.QueryUtil;
import com.facebook.presto.sql.analyzer.QueryExplainer;
import com.facebook.presto.sql.analyzer.SemanticErrorCode;
import com.facebook.presto.sql.analyzer.SemanticException;
import com.facebook.presto.sql.parser.SqlParser;
import com.facebook.presto.sql.planner.Plan;
import com.facebook.presto.sql.planner.optimizations.PlanNodeSearcher;
import com.facebook.presto.sql.planner.plan.TableScanNode;
import com.facebook.presto.sql.rewrite.StatementRewrite;
import com.facebook.presto.sql.tree.AllColumns;
import com.facebook.presto.sql.tree.AstVisitor;
import com.facebook.presto.sql.tree.Cast;
import com.facebook.presto.sql.tree.ComparisonExpression;
import com.facebook.presto.sql.tree.DoubleLiteral;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.Identifier;
import com.facebook.presto.sql.tree.IsNotNullPredicate;
import com.facebook.presto.sql.tree.IsNullPredicate;
import com.facebook.presto.sql.tree.Literal;
import com.facebook.presto.sql.tree.LogicalBinaryExpression;
import com.facebook.presto.sql.tree.Node;
import com.facebook.presto.sql.tree.NotExpression;
import com.facebook.presto.sql.tree.NullLiteral;
import com.facebook.presto.sql.tree.QualifiedName;
import com.facebook.presto.sql.tree.Query;
import com.facebook.presto.sql.tree.QueryBody;
import com.facebook.presto.sql.tree.QuerySpecification;
import com.facebook.presto.sql.tree.Relation;
import com.facebook.presto.sql.tree.Row;
import com.facebook.presto.sql.tree.Select;
import com.facebook.presto.sql.tree.SelectItem;
import com.facebook.presto.sql.tree.ShowStats;
import com.facebook.presto.sql.tree.SingleColumn;
import com.facebook.presto.sql.tree.Statement;
import com.facebook.presto.sql.tree.StringLiteral;
import com.facebook.presto.sql.tree.Table;
import com.facebook.presto.sql.tree.TableSubquery;
import com.facebook.presto.sql.tree.Values;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slice;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;

public class ShowStatsRewrite
implements StatementRewrite.Rewrite {
    private static final List<Class<? extends Expression>> ALLOWED_SHOW_STATS_WHERE_EXPRESSION_TYPES = ImmutableList.of(Literal.class, Identifier.class, ComparisonExpression.class, LogicalBinaryExpression.class, NotExpression.class, IsNullPredicate.class, IsNotNullPredicate.class);
    private static final Expression NULL_DOUBLE = new Cast((Expression)new NullLiteral(), "double");
    private static final Expression NULL_VARCHAR = new Cast((Expression)new NullLiteral(), "varchar");
    private static final int MAX_LOW_HIGH_LENGTH = 32;

    @Override
    public Statement rewrite(Session session, Metadata metadata, SqlParser parser, Optional<QueryExplainer> queryExplainer, Statement node, List<Expression> parameters, AccessControl accessControl) {
        return (Statement)new Visitor(metadata, session, parameters, queryExplainer).process((Node)node, null);
    }

    private static class Visitor
    extends AstVisitor<Node, Void> {
        private final Metadata metadata;
        private final Session session;
        private final List<Expression> parameters;
        private final Optional<QueryExplainer> queryExplainer;

        public Visitor(Metadata metadata, Session session, List<Expression> parameters, Optional<QueryExplainer> queryExplainer) {
            this.metadata = Objects.requireNonNull(metadata, "metadata is null");
            this.session = Objects.requireNonNull(session, "session is null");
            this.parameters = Objects.requireNonNull(parameters, "parameters is null");
            this.queryExplainer = Objects.requireNonNull(queryExplainer, "queryExplainer is null");
        }

        protected Node visitShowStats(ShowStats node, Void context) {
            this.validateShowStats(node);
            Preconditions.checkState((boolean)this.queryExplainer.isPresent(), (Object)"Query explainer must be provided for SHOW STATS SELECT");
            if (node.getRelation() instanceof TableSubquery) {
                QuerySpecification specification = (QuerySpecification)((TableSubquery)node.getRelation()).getQuery().getQueryBody();
                Table table = (Table)specification.getFrom().get();
                Constraint<ColumnHandle> constraint = this.getConstraint(specification);
                return this.rewriteShowStats(node, table, constraint);
            }
            if (node.getRelation() instanceof Table) {
                Table table = (Table)node.getRelation();
                return this.rewriteShowStats(node, table, (Constraint<ColumnHandle>)Constraint.alwaysTrue());
            }
            throw new IllegalArgumentException("Expected either TableSubquery or Table as relation");
        }

        private void validateShowStats(ShowStats node) {
            if (!(node.getRelation() instanceof Table) && !(node.getRelation() instanceof TableSubquery)) {
                throw new SemanticException(SemanticErrorCode.NOT_SUPPORTED, (Node)node, "Only table and simple table subquery can be passed as argument to SHOW STATS clause", new Object[0]);
            }
            if (node.getRelation() instanceof TableSubquery) {
                Query query = ((TableSubquery)node.getRelation()).getQuery();
                Visitor.check(query.getQueryBody() instanceof QuerySpecification, node, "Only table and simple table subquery can be passed as argument to SHOW STATS clause");
                QuerySpecification querySpecification = (QuerySpecification)query.getQueryBody();
                Visitor.check(querySpecification.getFrom().isPresent(), node, "There must be exactly one table in query passed to SHOW STATS SELECT clause");
                Visitor.check(querySpecification.getFrom().get() instanceof Table, node, "There must be exactly one table in query passed to SHOW STATS SELECT clause");
                Visitor.check(!query.getWith().isPresent(), node, "WITH is not supported by SHOW STATS SELECT clause");
                Visitor.check(!querySpecification.getOrderBy().isPresent(), node, "ORDER BY is not supported in SHOW STATS SELECT clause");
                Visitor.check(!querySpecification.getLimit().isPresent(), node, "LIMIT is not supported by SHOW STATS SELECT clause");
                Visitor.check(!querySpecification.getHaving().isPresent(), node, "HAVING is not supported in SHOW STATS SELECT clause");
                Visitor.check(!querySpecification.getGroupBy().isPresent(), node, "GROUP BY is not supported in SHOW STATS SELECT clause");
                Visitor.check(!querySpecification.getSelect().isDistinct(), node, "DISTINCT is not supported by SHOW STATS SELECT clause");
                for (SelectItem selectItem : querySpecification.getSelect().getSelectItems()) {
                    if (selectItem instanceof AllColumns) continue;
                    Visitor.check(selectItem instanceof SingleColumn, node, "Only * and column references are supported by SHOW STATS SELECT clause");
                    SingleColumn columnSelect = (SingleColumn)selectItem;
                    Visitor.check(columnSelect.getExpression() instanceof Identifier, node, "Only * and column references are supported by SHOW STATS SELECT clause");
                }
                querySpecification.getWhere().ifPresent(expression -> this.validateShowStatsWhereExpression((Expression)expression, node));
            }
        }

        private void validateShowStatsWhereExpression(Expression expression, ShowStats node) {
            Visitor.check(ALLOWED_SHOW_STATS_WHERE_EXPRESSION_TYPES.stream().anyMatch(clazz -> clazz.isInstance(expression)), node, "Only literals, column references, comparators, is (not) null and logical operators are allowed in WHERE of SHOW STATS SELECT clause");
            if (expression instanceof NotExpression) {
                this.validateShowStatsWhereExpression(((NotExpression)expression).getValue(), node);
            } else if (expression instanceof LogicalBinaryExpression) {
                this.validateShowStatsWhereExpression(((LogicalBinaryExpression)expression).getLeft(), node);
                this.validateShowStatsWhereExpression(((LogicalBinaryExpression)expression).getRight(), node);
            } else if (expression instanceof ComparisonExpression) {
                this.validateShowStatsWhereExpression(((ComparisonExpression)expression).getLeft(), node);
                this.validateShowStatsWhereExpression(((ComparisonExpression)expression).getRight(), node);
            } else if (expression instanceof IsNullPredicate) {
                this.validateShowStatsWhereExpression(((IsNullPredicate)expression).getValue(), node);
            } else if (expression instanceof IsNotNullPredicate) {
                this.validateShowStatsWhereExpression(((IsNotNullPredicate)expression).getValue(), node);
            }
        }

        private Node rewriteShowStats(ShowStats node, Table table, Constraint<ColumnHandle> constraint) {
            TableHandle tableHandle = this.getTableHandle(node, table.getName());
            TableStatistics tableStatistics = this.metadata.getTableStatistics(this.session, tableHandle, constraint);
            List<String> statsColumnNames = Visitor.buildColumnsNames();
            List<SelectItem> selectItems = Visitor.buildSelectItems(statsColumnNames);
            Map<ColumnHandle, String> tableColumnNames = this.getStatisticsColumnNames(tableStatistics, tableHandle);
            Map<ColumnHandle, Type> tableColumnTypes = this.getStatisticsColumnTypes(tableStatistics, tableHandle);
            List<Expression> resultRows = this.buildStatisticsRows(tableStatistics, tableColumnNames, tableColumnTypes);
            return QueryUtil.simpleQuery((Select)QueryUtil.selectAll(selectItems), (Relation)QueryUtil.aliased((Relation)new Values(resultRows), (String)("table_stats_for_" + table.getName()), statsColumnNames));
        }

        private static void check(boolean condition, ShowStats node, String message) {
            if (!condition) {
                throw new SemanticException(SemanticErrorCode.NOT_SUPPORTED, (Node)node, message, new Object[0]);
            }
        }

        protected Node visitNode(Node node, Void context) {
            return node;
        }

        private Constraint<ColumnHandle> getConstraint(QuerySpecification specification) {
            if (!specification.getWhere().isPresent()) {
                return Constraint.alwaysTrue();
            }
            Plan plan = this.queryExplainer.get().getLogicalPlan(this.session, (Statement)new Query(Optional.empty(), (QueryBody)specification, Optional.empty(), Optional.empty()), this.parameters);
            Optional scanNode = PlanNodeSearcher.searchFrom(plan.getRoot()).where(TableScanNode.class::isInstance).findSingle();
            if (!scanNode.isPresent()) {
                return new Constraint(TupleDomain.none(), bindings -> true);
            }
            return new Constraint(((TableScanNode)scanNode.get()).getCurrentConstraint(), bindings -> true);
        }

        private Map<ColumnHandle, String> getStatisticsColumnNames(TableStatistics statistics, TableHandle tableHandle) {
            return statistics.getColumnStatistics().keySet().stream().collect(Collectors.toMap(Function.identity(), column -> this.metadata.getColumnMetadata(this.session, tableHandle, (ColumnHandle)column).getName()));
        }

        private Map<ColumnHandle, Type> getStatisticsColumnTypes(TableStatistics statistics, TableHandle tableHandle) {
            return statistics.getColumnStatistics().keySet().stream().collect(Collectors.toMap(Function.identity(), column -> this.metadata.getColumnMetadata(this.session, tableHandle, (ColumnHandle)column).getType()));
        }

        private TableHandle getTableHandle(ShowStats node, QualifiedName table) {
            QualifiedObjectName qualifiedTableName = MetadataUtil.createQualifiedObjectName(this.session, (Node)node, table);
            return this.metadata.getTableHandle(this.session, qualifiedTableName).orElseThrow(() -> new SemanticException(SemanticErrorCode.MISSING_TABLE, (Node)node, "Table %s not found", table));
        }

        private static List<String> buildColumnsNames() {
            return ImmutableList.builder().add((Object)"column_name").add((Object)"data_size").add((Object)"distinct_values_count").add((Object)"nulls_fraction").add((Object)"row_count").add((Object)"low_value").add((Object)"high_value").build();
        }

        private static List<SelectItem> buildSelectItems(List<String> columnNames) {
            return (List)columnNames.stream().map(QueryUtil::unaliasedName).collect(ImmutableList.toImmutableList());
        }

        private List<Expression> buildStatisticsRows(TableStatistics tableStatistics, Map<ColumnHandle, String> columnNames, Map<ColumnHandle, Type> columnTypes) {
            ImmutableList.Builder rowsBuilder = ImmutableList.builder();
            for (Map.Entry columnStats : tableStatistics.getColumnStatistics().entrySet()) {
                ColumnHandle columnHandle = (ColumnHandle)columnStats.getKey();
                rowsBuilder.add((Object)this.createColumnStatsRow(columnNames.get(columnHandle), columnTypes.get(columnHandle), (ColumnStatistics)columnStats.getValue()));
            }
            rowsBuilder.add((Object)Visitor.createTableStatsRow(tableStatistics));
            return rowsBuilder.build();
        }

        private Row createColumnStatsRow(String columnName, Type type, ColumnStatistics columnStatistics) {
            RangeColumnStatistics onlyRangeColumnStatistics = columnStatistics.getOnlyRangeColumnStatistics();
            ImmutableList.Builder rowValues = ImmutableList.builder();
            rowValues.add((Object)new StringLiteral(columnName));
            rowValues.add((Object)Visitor.createStatisticValueOrNull(onlyRangeColumnStatistics.getDataSize()));
            rowValues.add((Object)Visitor.createStatisticValueOrNull(onlyRangeColumnStatistics.getDistinctValuesCount()));
            rowValues.add((Object)Visitor.createStatisticValueOrNull(columnStatistics.getNullsFraction()));
            rowValues.add((Object)NULL_DOUBLE);
            rowValues.add((Object)this.lowHighAsLiteral(type, onlyRangeColumnStatistics.getLowValue()));
            rowValues.add((Object)this.lowHighAsLiteral(type, onlyRangeColumnStatistics.getHighValue()));
            return new Row((List)rowValues.build());
        }

        private static Row createTableStatsRow(TableStatistics tableStatistics) {
            ImmutableList.Builder rowValues = ImmutableList.builder();
            rowValues.add((Object)NULL_VARCHAR);
            rowValues.add((Object)NULL_DOUBLE);
            rowValues.add((Object)NULL_DOUBLE);
            rowValues.add((Object)NULL_DOUBLE);
            rowValues.add((Object)Visitor.createStatisticValueOrNull(tableStatistics.getRowCount()));
            rowValues.add((Object)NULL_VARCHAR);
            rowValues.add((Object)NULL_VARCHAR);
            return new Row((List)rowValues.build());
        }

        private Expression lowHighAsLiteral(Type valueType, Optional<Object> value) {
            Signature castSignature;
            if (!value.isPresent()) {
                return new Cast((Expression)new NullLiteral(), "varchar");
            }
            FunctionRegistry functionRegistry = this.metadata.getFunctionRegistry();
            FunctionInvoker functionInvoker = new FunctionInvoker(functionRegistry);
            Slice varcharValue = (Slice)functionInvoker.invoke(castSignature = functionRegistry.getCoercion(valueType, (Type)VarcharType.createUnboundedVarcharType()), this.session.toConnectorSession(), Collections.singletonList(value.get()));
            String stringValue = varcharValue.toStringUtf8();
            if (stringValue.length() > 32) {
                stringValue = stringValue.substring(0, 32) + "...";
            }
            return new StringLiteral(stringValue);
        }

        private static Expression createStatisticValueOrNull(Estimate estimate) {
            if (estimate.isValueUnknown()) {
                return NULL_DOUBLE;
            }
            return new DoubleLiteral(Double.toString(estimate.getValue()));
        }
    }
}

