/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.relational;

import com.facebook.presto.Session;
import com.facebook.presto.SystemSessionProperties;
import com.facebook.presto.metadata.FunctionKind;
import com.facebook.presto.metadata.FunctionRegistry;
import com.facebook.presto.metadata.Signature;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.BooleanType;
import com.facebook.presto.spi.type.CharType;
import com.facebook.presto.spi.type.DecimalParseResult;
import com.facebook.presto.spi.type.Decimals;
import com.facebook.presto.spi.type.DoubleType;
import com.facebook.presto.spi.type.IntegerType;
import com.facebook.presto.spi.type.RowType;
import com.facebook.presto.spi.type.TimeWithTimeZoneType;
import com.facebook.presto.spi.type.TimeZoneKey;
import com.facebook.presto.spi.type.TimestampWithTimeZoneType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeManager;
import com.facebook.presto.spi.type.TypeSignature;
import com.facebook.presto.spi.type.VarbinaryType;
import com.facebook.presto.spi.type.VarcharType;
import com.facebook.presto.sql.relational.CallExpression;
import com.facebook.presto.sql.relational.ConstantExpression;
import com.facebook.presto.sql.relational.Expressions;
import com.facebook.presto.sql.relational.InputReferenceExpression;
import com.facebook.presto.sql.relational.LambdaDefinitionExpression;
import com.facebook.presto.sql.relational.RowExpression;
import com.facebook.presto.sql.relational.RowExpressionVisitor;
import com.facebook.presto.sql.relational.Signatures;
import com.facebook.presto.sql.relational.VariableReferenceExpression;
import com.facebook.presto.sql.relational.optimizer.ExpressionOptimizer;
import com.facebook.presto.sql.tree.ArithmeticBinaryExpression;
import com.facebook.presto.sql.tree.ArithmeticUnaryExpression;
import com.facebook.presto.sql.tree.ArrayConstructor;
import com.facebook.presto.sql.tree.AstVisitor;
import com.facebook.presto.sql.tree.BetweenPredicate;
import com.facebook.presto.sql.tree.BinaryLiteral;
import com.facebook.presto.sql.tree.BindExpression;
import com.facebook.presto.sql.tree.BooleanLiteral;
import com.facebook.presto.sql.tree.Cast;
import com.facebook.presto.sql.tree.CharLiteral;
import com.facebook.presto.sql.tree.CoalesceExpression;
import com.facebook.presto.sql.tree.ComparisonExpression;
import com.facebook.presto.sql.tree.DecimalLiteral;
import com.facebook.presto.sql.tree.DereferenceExpression;
import com.facebook.presto.sql.tree.DoubleLiteral;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.FieldReference;
import com.facebook.presto.sql.tree.FunctionCall;
import com.facebook.presto.sql.tree.GenericLiteral;
import com.facebook.presto.sql.tree.Identifier;
import com.facebook.presto.sql.tree.IfExpression;
import com.facebook.presto.sql.tree.InListExpression;
import com.facebook.presto.sql.tree.InPredicate;
import com.facebook.presto.sql.tree.IntervalLiteral;
import com.facebook.presto.sql.tree.IsNotNullPredicate;
import com.facebook.presto.sql.tree.IsNullPredicate;
import com.facebook.presto.sql.tree.LambdaArgumentDeclaration;
import com.facebook.presto.sql.tree.LambdaExpression;
import com.facebook.presto.sql.tree.LikePredicate;
import com.facebook.presto.sql.tree.LogicalBinaryExpression;
import com.facebook.presto.sql.tree.LongLiteral;
import com.facebook.presto.sql.tree.Node;
import com.facebook.presto.sql.tree.NodeRef;
import com.facebook.presto.sql.tree.NotExpression;
import com.facebook.presto.sql.tree.NullIfExpression;
import com.facebook.presto.sql.tree.NullLiteral;
import com.facebook.presto.sql.tree.Row;
import com.facebook.presto.sql.tree.SearchedCaseExpression;
import com.facebook.presto.sql.tree.SimpleCaseExpression;
import com.facebook.presto.sql.tree.StringLiteral;
import com.facebook.presto.sql.tree.SubscriptExpression;
import com.facebook.presto.sql.tree.SymbolReference;
import com.facebook.presto.sql.tree.TimeLiteral;
import com.facebook.presto.sql.tree.TimestampLiteral;
import com.facebook.presto.sql.tree.TryExpression;
import com.facebook.presto.sql.tree.WhenClause;
import com.facebook.presto.type.JsonType;
import com.facebook.presto.type.LikePatternType;
import com.facebook.presto.type.UnknownType;
import com.facebook.presto.util.DateTimeUtils;
import com.facebook.presto.util.LegacyRowFieldOrdinalAccessUtil;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import io.airlift.slice.Slice;
import io.airlift.slice.SliceUtf8;
import io.airlift.slice.Slices;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.OptionalInt;

public final class SqlToRowExpressionTranslator {
    private SqlToRowExpressionTranslator() {
    }

    public static RowExpression translate(Expression expression, FunctionKind functionKind, Map<NodeRef<Expression>, Type> types, FunctionRegistry functionRegistry, TypeManager typeManager, Session session, boolean optimize) {
        RowExpression result = (RowExpression)new Visitor(functionKind, types, typeManager, session.getTimeZoneKey(), SystemSessionProperties.isLegacyRowFieldOrdinalAccessEnabled(session)).process((Node)expression, null);
        Objects.requireNonNull(result, "translated expression is null");
        if (optimize) {
            ExpressionOptimizer optimizer = new ExpressionOptimizer(functionRegistry, typeManager, session);
            return optimizer.optimize(result);
        }
        return result;
    }

    private static class Visitor
    extends AstVisitor<RowExpression, Void> {
        private final FunctionKind functionKind;
        private final Map<NodeRef<Expression>, Type> types;
        private final TypeManager typeManager;
        private final TimeZoneKey timeZoneKey;
        private final boolean legacyRowFieldOrdinalAccess;

        private Visitor(FunctionKind functionKind, Map<NodeRef<Expression>, Type> types, TypeManager typeManager, TimeZoneKey timeZoneKey, boolean legacyRowFieldOrdinalAccess) {
            this.functionKind = functionKind;
            this.types = ImmutableMap.copyOf(Objects.requireNonNull(types, "types is null"));
            this.typeManager = typeManager;
            this.timeZoneKey = timeZoneKey;
            this.legacyRowFieldOrdinalAccess = legacyRowFieldOrdinalAccess;
        }

        private Type getType(Expression node) {
            return this.types.get(NodeRef.of((Node)node));
        }

        protected RowExpression visitExpression(Expression node, Void context) {
            throw new UnsupportedOperationException("not yet implemented: expression translator for " + node.getClass().getName());
        }

        protected RowExpression visitFieldReference(FieldReference node, Void context) {
            return Expressions.field(node.getFieldIndex(), this.getType((Expression)node));
        }

        protected RowExpression visitNullLiteral(NullLiteral node, Void context) {
            return Expressions.constantNull((Type)UnknownType.UNKNOWN);
        }

        protected RowExpression visitBooleanLiteral(BooleanLiteral node, Void context) {
            return Expressions.constant(node.getValue(), (Type)BooleanType.BOOLEAN);
        }

        protected RowExpression visitLongLiteral(LongLiteral node, Void context) {
            if (node.getValue() >= Integer.MIN_VALUE && node.getValue() <= Integer.MAX_VALUE) {
                return Expressions.constant(node.getValue(), (Type)IntegerType.INTEGER);
            }
            return Expressions.constant(node.getValue(), (Type)BigintType.BIGINT);
        }

        protected RowExpression visitDoubleLiteral(DoubleLiteral node, Void context) {
            return Expressions.constant(node.getValue(), (Type)DoubleType.DOUBLE);
        }

        protected RowExpression visitDecimalLiteral(DecimalLiteral node, Void context) {
            DecimalParseResult parseResult = Decimals.parse((String)node.getValue());
            return Expressions.constant(parseResult.getObject(), (Type)parseResult.getType());
        }

        protected RowExpression visitStringLiteral(StringLiteral node, Void context) {
            return Expressions.constant(node.getSlice(), (Type)VarcharType.createVarcharType((int)SliceUtf8.countCodePoints((Slice)node.getSlice())));
        }

        protected RowExpression visitCharLiteral(CharLiteral node, Void context) {
            return Expressions.constant(node.getSlice(), (Type)CharType.createCharType((long)node.getValue().length()));
        }

        protected RowExpression visitBinaryLiteral(BinaryLiteral node, Void context) {
            return Expressions.constant(node.getValue(), (Type)VarbinaryType.VARBINARY);
        }

        protected RowExpression visitGenericLiteral(GenericLiteral node, Void context) {
            Type type;
            try {
                type = this.typeManager.getType(TypeSignature.parseTypeSignature((String)node.getType()));
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("Unsupported type: " + node.getType());
            }
            if (JsonType.JSON.equals(type)) {
                return Expressions.call(new Signature("json_parse", FunctionKind.SCALAR, this.getType((Expression)node).getTypeSignature(), VarcharType.VARCHAR.getTypeSignature()), this.getType((Expression)node), Expressions.constant(Slices.utf8Slice((String)node.getValue()), (Type)VarcharType.VARCHAR));
            }
            return Expressions.call(Signatures.castSignature(this.getType((Expression)node), (Type)VarcharType.VARCHAR), this.getType((Expression)node), Expressions.constant(Slices.utf8Slice((String)node.getValue()), (Type)VarcharType.VARCHAR));
        }

        protected RowExpression visitTimeLiteral(TimeLiteral node, Void context) {
            long value = this.getType((Expression)node).equals(TimeWithTimeZoneType.TIME_WITH_TIME_ZONE) ? DateTimeUtils.parseTimeWithTimeZone(node.getValue()) : DateTimeUtils.parseTimeWithoutTimeZone(this.timeZoneKey, node.getValue());
            return Expressions.constant(value, this.getType((Expression)node));
        }

        protected RowExpression visitTimestampLiteral(TimestampLiteral node, Void context) {
            long value = this.getType((Expression)node).equals(TimestampWithTimeZoneType.TIMESTAMP_WITH_TIME_ZONE) ? DateTimeUtils.parseTimestampWithTimeZone(this.timeZoneKey, node.getValue()) : DateTimeUtils.parseTimestampWithoutTimeZone(this.timeZoneKey, node.getValue());
            return Expressions.constant(value, this.getType((Expression)node));
        }

        protected RowExpression visitIntervalLiteral(IntervalLiteral node, Void context) {
            long value = node.isYearToMonth() ? (long)node.getSign().multiplier() * DateTimeUtils.parseYearMonthInterval(node.getValue(), node.getStartField(), node.getEndField()) : (long)node.getSign().multiplier() * DateTimeUtils.parseDayTimeInterval(node.getValue(), node.getStartField(), node.getEndField());
            return Expressions.constant(value, this.getType((Expression)node));
        }

        protected RowExpression visitComparisonExpression(ComparisonExpression node, Void context) {
            RowExpression left = (RowExpression)this.process((Node)node.getLeft(), context);
            RowExpression right = (RowExpression)this.process((Node)node.getRight(), context);
            return Expressions.call(Signatures.comparisonExpressionSignature(node.getType(), left.getType(), right.getType()), (Type)BooleanType.BOOLEAN, left, right);
        }

        protected RowExpression visitFunctionCall(FunctionCall node, Void context) {
            List arguments = (List)node.getArguments().stream().map(value -> (RowExpression)this.process((Node)value, context)).collect(ImmutableList.toImmutableList());
            List argumentTypes = (List)arguments.stream().map(RowExpression::getType).map(Type::getTypeSignature).collect(ImmutableList.toImmutableList());
            Signature signature = new Signature(node.getName().getSuffix(), this.functionKind, this.getType((Expression)node).getTypeSignature(), argumentTypes);
            return Expressions.call(signature, this.getType((Expression)node), arguments);
        }

        protected RowExpression visitSymbolReference(SymbolReference node, Void context) {
            return new VariableReferenceExpression(node.getName(), this.getType((Expression)node));
        }

        protected RowExpression visitLambdaExpression(LambdaExpression node, Void context) {
            RowExpression body = (RowExpression)this.process((Node)node.getBody(), context);
            Type type = this.getType((Expression)node);
            List typeParameters = type.getTypeParameters();
            List<Type> argumentTypes = typeParameters.subList(0, typeParameters.size() - 1);
            List argumentNames = (List)node.getArguments().stream().map(LambdaArgumentDeclaration::getName).map(Identifier::getValue).collect(ImmutableList.toImmutableList());
            return new LambdaDefinitionExpression(argumentTypes, argumentNames, body);
        }

        protected RowExpression visitBindExpression(BindExpression node, Void context) {
            ImmutableList.Builder valueTypesBuilder = ImmutableList.builder();
            ImmutableList.Builder argumentsBuilder = ImmutableList.builder();
            for (Expression value : node.getValues()) {
                RowExpression valueRowExpression = (RowExpression)this.process((Node)value, context);
                valueTypesBuilder.add((Object)valueRowExpression.getType());
                argumentsBuilder.add((Object)valueRowExpression);
            }
            RowExpression function = (RowExpression)this.process((Node)node.getFunction(), context);
            argumentsBuilder.add((Object)function);
            return Expressions.call(Signatures.bindSignature(this.getType((Expression)node), (List<Type>)valueTypesBuilder.build(), function.getType()), this.getType((Expression)node), (List<RowExpression>)argumentsBuilder.build());
        }

        protected RowExpression visitArithmeticBinary(ArithmeticBinaryExpression node, Void context) {
            RowExpression left = (RowExpression)this.process((Node)node.getLeft(), context);
            RowExpression right = (RowExpression)this.process((Node)node.getRight(), context);
            return Expressions.call(Signatures.arithmeticExpressionSignature(node.getType(), this.getType((Expression)node), left.getType(), right.getType()), this.getType((Expression)node), left, right);
        }

        protected RowExpression visitArithmeticUnary(ArithmeticUnaryExpression node, Void context) {
            RowExpression expression = (RowExpression)this.process((Node)node.getValue(), context);
            switch (node.getSign()) {
                case PLUS: {
                    return expression;
                }
                case MINUS: {
                    return Expressions.call(Signatures.arithmeticNegationSignature(this.getType((Expression)node), expression.getType()), this.getType((Expression)node), expression);
                }
            }
            throw new UnsupportedOperationException("Unsupported unary operator: " + node.getSign());
        }

        protected RowExpression visitLogicalBinaryExpression(LogicalBinaryExpression node, Void context) {
            return Expressions.call(Signatures.logicalExpressionSignature(node.getType()), (Type)BooleanType.BOOLEAN, (RowExpression)this.process((Node)node.getLeft(), context), (RowExpression)this.process((Node)node.getRight(), context));
        }

        protected RowExpression visitCast(Cast node, Void context) {
            RowExpression value = (RowExpression)this.process((Node)node.getExpression(), context);
            if (node.isTypeOnly()) {
                return Visitor.changeType(value, this.getType((Expression)node));
            }
            if (node.isSafe()) {
                return Expressions.call(Signatures.tryCastSignature(this.getType((Expression)node), value.getType()), this.getType((Expression)node), value);
            }
            return Expressions.call(Signatures.castSignature(this.getType((Expression)node), value.getType()), this.getType((Expression)node), value);
        }

        private static RowExpression changeType(RowExpression value, Type targetType) {
            ChangeTypeVisitor visitor = new ChangeTypeVisitor(targetType);
            return value.accept(visitor, null);
        }

        protected RowExpression visitCoalesceExpression(CoalesceExpression node, Void context) {
            List arguments = (List)node.getOperands().stream().map(value -> (RowExpression)this.process((Node)value, context)).collect(ImmutableList.toImmutableList());
            List argumentTypes = (List)arguments.stream().map(RowExpression::getType).collect(ImmutableList.toImmutableList());
            return Expressions.call(Signatures.coalesceSignature(this.getType((Expression)node), argumentTypes), this.getType((Expression)node), arguments);
        }

        protected RowExpression visitSimpleCaseExpression(SimpleCaseExpression node, Void context) {
            ImmutableList.Builder arguments = ImmutableList.builder();
            arguments.add(this.process((Node)node.getOperand(), context));
            for (WhenClause clause : node.getWhenClauses()) {
                arguments.add((Object)Expressions.call(Signatures.whenSignature(this.getType((Expression)clause)), this.getType((Expression)clause), (RowExpression)this.process((Node)clause.getOperand(), context), (RowExpression)this.process((Node)clause.getResult(), context)));
            }
            Type returnType = this.getType((Expression)node);
            arguments.add((Object)node.getDefaultValue().map(value -> (RowExpression)this.process((Node)value, context)).orElse(Expressions.constantNull(returnType)));
            return Expressions.call(Signatures.switchSignature(returnType), returnType, (List<RowExpression>)arguments.build());
        }

        protected RowExpression visitSearchedCaseExpression(SearchedCaseExpression node, Void context) {
            RowExpression expression = node.getDefaultValue().map(value -> (RowExpression)this.process((Node)value, context)).orElse(Expressions.constantNull(this.getType((Expression)node)));
            for (WhenClause clause : Lists.reverse((List)node.getWhenClauses())) {
                expression = Expressions.call(Signatures.ifSignature(this.getType((Expression)node)), this.getType((Expression)node), (RowExpression)this.process((Node)clause.getOperand(), context), (RowExpression)this.process((Node)clause.getResult(), context), expression);
            }
            return expression;
        }

        protected RowExpression visitDereferenceExpression(DereferenceExpression node, Void context) {
            OptionalInt rowIndex;
            RowType rowType = (RowType)this.getType(node.getBase());
            String fieldName = node.getField().getValue();
            List fields = rowType.getFields();
            int index = -1;
            for (int i = 0; i < fields.size(); ++i) {
                RowType.Field field = (RowType.Field)fields.get(i);
                if (!field.getName().isPresent() || !((String)field.getName().get()).equalsIgnoreCase(fieldName)) continue;
                Preconditions.checkArgument((index < 0 ? 1 : 0) != 0, (String)"Ambiguous field %s in type %s", (Object)field, (Object)rowType.getDisplayName());
                index = i;
            }
            if (this.legacyRowFieldOrdinalAccess && index < 0 && (rowIndex = LegacyRowFieldOrdinalAccessUtil.parseAnonymousRowFieldOrdinalAccess(fieldName, fields)).isPresent()) {
                index = rowIndex.getAsInt();
            }
            Preconditions.checkState((index >= 0 ? 1 : 0) != 0, (String)"could not find field name: %s", (Object)node.getField());
            Type returnType = this.getType((Expression)node);
            return Expressions.call(Signatures.dereferenceSignature(returnType, rowType), returnType, (RowExpression)this.process((Node)node.getBase(), context), Expressions.constant(index, (Type)IntegerType.INTEGER));
        }

        protected RowExpression visitIfExpression(IfExpression node, Void context) {
            ImmutableList.Builder arguments = ImmutableList.builder();
            arguments.add(this.process((Node)node.getCondition(), context)).add(this.process((Node)node.getTrueValue(), context));
            if (node.getFalseValue().isPresent()) {
                arguments.add(this.process((Node)node.getFalseValue().get(), context));
            } else {
                arguments.add((Object)Expressions.constantNull(this.getType((Expression)node)));
            }
            return Expressions.call(Signatures.ifSignature(this.getType((Expression)node)), this.getType((Expression)node), (List<RowExpression>)arguments.build());
        }

        protected RowExpression visitTryExpression(TryExpression node, Void context) {
            return Expressions.call(Signatures.trySignature(this.getType((Expression)node)), this.getType((Expression)node), (RowExpression)this.process((Node)node.getInnerExpression(), context));
        }

        protected RowExpression visitInPredicate(InPredicate node, Void context) {
            ImmutableList.Builder arguments = ImmutableList.builder();
            arguments.add(this.process((Node)node.getValue(), context));
            InListExpression values = (InListExpression)node.getValueList();
            for (Expression value : values.getValues()) {
                arguments.add(this.process((Node)value, context));
            }
            return Expressions.call(Signatures.inSignature(), (Type)BooleanType.BOOLEAN, (List<RowExpression>)arguments.build());
        }

        protected RowExpression visitIsNotNullPredicate(IsNotNullPredicate node, Void context) {
            RowExpression expression = (RowExpression)this.process((Node)node.getValue(), context);
            return Expressions.call(Signatures.notSignature(), (Type)BooleanType.BOOLEAN, Expressions.call(Signatures.isNullSignature(expression.getType()), (Type)BooleanType.BOOLEAN, (List<RowExpression>)ImmutableList.of((Object)expression)));
        }

        protected RowExpression visitIsNullPredicate(IsNullPredicate node, Void context) {
            RowExpression expression = (RowExpression)this.process((Node)node.getValue(), context);
            return Expressions.call(Signatures.isNullSignature(expression.getType()), (Type)BooleanType.BOOLEAN, expression);
        }

        protected RowExpression visitNotExpression(NotExpression node, Void context) {
            return Expressions.call(Signatures.notSignature(), (Type)BooleanType.BOOLEAN, (RowExpression)this.process((Node)node.getValue(), context));
        }

        protected RowExpression visitNullIfExpression(NullIfExpression node, Void context) {
            RowExpression first = (RowExpression)this.process((Node)node.getFirst(), context);
            RowExpression second = (RowExpression)this.process((Node)node.getSecond(), context);
            return Expressions.call(Signatures.nullIfSignature(this.getType((Expression)node), first.getType(), second.getType()), this.getType((Expression)node), first, second);
        }

        protected RowExpression visitBetweenPredicate(BetweenPredicate node, Void context) {
            RowExpression value = (RowExpression)this.process((Node)node.getValue(), context);
            RowExpression min = (RowExpression)this.process((Node)node.getMin(), context);
            RowExpression max = (RowExpression)this.process((Node)node.getMax(), context);
            return Expressions.call(Signatures.betweenSignature(value.getType(), min.getType(), max.getType()), (Type)BooleanType.BOOLEAN, value, min, max);
        }

        protected RowExpression visitLikePredicate(LikePredicate node, Void context) {
            RowExpression value = (RowExpression)this.process((Node)node.getValue(), context);
            RowExpression pattern = (RowExpression)this.process((Node)node.getPattern(), context);
            if (node.getEscape() != null) {
                RowExpression escape = (RowExpression)this.process((Node)node.getEscape(), context);
                return Expressions.call(Signatures.likeSignature(), (Type)BooleanType.BOOLEAN, value, Expressions.call(Signatures.likePatternSignature(), (Type)LikePatternType.LIKE_PATTERN, pattern, escape));
            }
            return Expressions.call(Signatures.likeSignature(), (Type)BooleanType.BOOLEAN, value, Expressions.call(Signatures.castSignature((Type)LikePatternType.LIKE_PATTERN, (Type)VarcharType.VARCHAR), (Type)LikePatternType.LIKE_PATTERN, pattern));
        }

        protected RowExpression visitSubscriptExpression(SubscriptExpression node, Void context) {
            RowExpression base = (RowExpression)this.process((Node)node.getBase(), context);
            RowExpression index = (RowExpression)this.process((Node)node.getIndex(), context);
            return Expressions.call(Signatures.subscriptSignature(this.getType((Expression)node), base.getType(), index.getType()), this.getType((Expression)node), base, index);
        }

        protected RowExpression visitArrayConstructor(ArrayConstructor node, Void context) {
            List arguments = (List)node.getValues().stream().map(value -> (RowExpression)this.process((Node)value, context)).collect(ImmutableList.toImmutableList());
            List argumentTypes = (List)arguments.stream().map(RowExpression::getType).collect(ImmutableList.toImmutableList());
            return Expressions.call(Signatures.arrayConstructorSignature(this.getType((Expression)node), argumentTypes), this.getType((Expression)node), arguments);
        }

        protected RowExpression visitRow(Row node, Void context) {
            List arguments = (List)node.getItems().stream().map(value -> (RowExpression)this.process((Node)value, context)).collect(ImmutableList.toImmutableList());
            Type returnType = this.getType((Expression)node);
            List argumentTypes = (List)node.getItems().stream().map(this::getType).collect(ImmutableList.toImmutableList());
            return Expressions.call(Signatures.rowConstructorSignature(returnType, argumentTypes), returnType, arguments);
        }

        private static class ChangeTypeVisitor
        implements RowExpressionVisitor<RowExpression, Void> {
            private final Type targetType;

            private ChangeTypeVisitor(Type targetType) {
                this.targetType = targetType;
            }

            @Override
            public RowExpression visitCall(CallExpression call, Void context) {
                return new CallExpression(call.getSignature(), this.targetType, call.getArguments());
            }

            @Override
            public RowExpression visitInputReference(InputReferenceExpression reference, Void context) {
                return Expressions.field(reference.getField(), this.targetType);
            }

            @Override
            public RowExpression visitConstant(ConstantExpression literal, Void context) {
                return Expressions.constant(literal.getValue(), this.targetType);
            }

            @Override
            public RowExpression visitLambda(LambdaDefinitionExpression lambda, Void context) {
                throw new UnsupportedOperationException();
            }

            @Override
            public RowExpression visitVariableReference(VariableReferenceExpression reference, Void context) {
                return new VariableReferenceExpression(reference.getName(), this.targetType);
            }
        }
    }
}

