/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.relational;

import com.facebook.presto.spi.type.Type;
import com.facebook.presto.sql.relational.RowExpression;
import com.facebook.presto.sql.relational.RowExpressionVisitor;
import com.facebook.presto.type.FunctionType;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

public final class LambdaDefinitionExpression
extends RowExpression {
    private final List<Type> argumentTypes;
    private final List<String> arguments;
    private final RowExpression body;

    public LambdaDefinitionExpression(List<Type> argumentTypes, List<String> arguments, RowExpression body) {
        this.argumentTypes = ImmutableList.copyOf((Collection)Objects.requireNonNull(argumentTypes, "argumentTypes is null"));
        this.arguments = ImmutableList.copyOf((Collection)Objects.requireNonNull(arguments, "arguments is null"));
        Preconditions.checkArgument((argumentTypes.size() == arguments.size() ? 1 : 0) != 0, (Object)"Number of argument types does not match number of arguments");
        this.body = Objects.requireNonNull(body, "body is null");
    }

    public List<Type> getArgumentTypes() {
        return this.argumentTypes;
    }

    public List<String> getArguments() {
        return this.arguments;
    }

    public RowExpression getBody() {
        return this.body;
    }

    @Override
    public Type getType() {
        return new FunctionType(this.argumentTypes, this.body.getType());
    }

    @Override
    public String toString() {
        return "(" + Joiner.on((String)",").join(this.arguments) + ") -> " + this.body;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LambdaDefinitionExpression that = (LambdaDefinitionExpression)o;
        return Objects.equals(this.argumentTypes, that.argumentTypes) && Objects.equals(this.arguments, that.arguments) && Objects.equals(this.body, that.body);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.argumentTypes, this.arguments, this.body);
    }

    @Override
    public <R, C> R accept(RowExpressionVisitor<R, C> visitor, C context) {
        return visitor.visitLambda(this, context);
    }
}

