/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.optimizations;

import com.facebook.presto.Session;
import com.facebook.presto.metadata.FunctionKind;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.Signature;
import com.facebook.presto.spi.predicate.Domain;
import com.facebook.presto.spi.predicate.Marker;
import com.facebook.presto.spi.predicate.Range;
import com.facebook.presto.spi.predicate.TupleDomain;
import com.facebook.presto.spi.predicate.ValueSet;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeSignature;
import com.facebook.presto.sql.ExpressionUtils;
import com.facebook.presto.sql.planner.DomainTranslator;
import com.facebook.presto.sql.planner.LiteralEncoder;
import com.facebook.presto.sql.planner.PlanNodeIdAllocator;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.SymbolAllocator;
import com.facebook.presto.sql.planner.optimizations.PlanOptimizer;
import com.facebook.presto.sql.planner.plan.ChildReplacer;
import com.facebook.presto.sql.planner.plan.FilterNode;
import com.facebook.presto.sql.planner.plan.LimitNode;
import com.facebook.presto.sql.planner.plan.PlanNode;
import com.facebook.presto.sql.planner.plan.RowNumberNode;
import com.facebook.presto.sql.planner.plan.SimplePlanRewriter;
import com.facebook.presto.sql.planner.plan.TopNRowNumberNode;
import com.facebook.presto.sql.planner.plan.WindowNode;
import com.facebook.presto.sql.tree.BooleanLiteral;
import com.facebook.presto.sql.tree.Expression;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.stream.Collectors;

public class WindowFilterPushDown
implements PlanOptimizer {
    private static final Signature ROW_NUMBER_SIGNATURE = new Signature("row_number", FunctionKind.WINDOW, TypeSignature.parseTypeSignature((String)"bigint"), (List<TypeSignature>)ImmutableList.of());
    private final Metadata metadata;
    private final DomainTranslator domainTranslator;

    public WindowFilterPushDown(Metadata metadata) {
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
        this.domainTranslator = new DomainTranslator(new LiteralEncoder(metadata.getBlockEncodingSerde()));
    }

    @Override
    public PlanNode optimize(PlanNode plan, Session session, Map<Symbol, Type> types, SymbolAllocator symbolAllocator, PlanNodeIdAllocator idAllocator) {
        Objects.requireNonNull(plan, "plan is null");
        Objects.requireNonNull(session, "session is null");
        Objects.requireNonNull(types, "types is null");
        Objects.requireNonNull(symbolAllocator, "symbolAllocator is null");
        Objects.requireNonNull(idAllocator, "idAllocator is null");
        return SimplePlanRewriter.rewriteWith(new Rewriter(idAllocator, this.metadata, this.domainTranslator, session, types), plan, null);
    }

    private static class Rewriter
    extends SimplePlanRewriter<Void> {
        private final PlanNodeIdAllocator idAllocator;
        private final Metadata metadata;
        private final DomainTranslator domainTranslator;
        private final Session session;
        private final Map<Symbol, Type> types;

        private Rewriter(PlanNodeIdAllocator idAllocator, Metadata metadata, DomainTranslator domainTranslator, Session session, Map<Symbol, Type> types) {
            this.idAllocator = Objects.requireNonNull(idAllocator, "idAllocator is null");
            this.metadata = Objects.requireNonNull(metadata, "metadata is null");
            this.domainTranslator = Objects.requireNonNull(domainTranslator, "domainTranslator is null");
            this.session = Objects.requireNonNull(session, "session is null");
            this.types = ImmutableMap.copyOf(Objects.requireNonNull(types, "types is null"));
        }

        @Override
        public PlanNode visitWindow(WindowNode node, SimplePlanRewriter.RewriteContext<Void> context) {
            Preconditions.checkState((node.getWindowFunctions().size() == 1 ? 1 : 0) != 0, (Object)"WindowFilterPushdown requires that WindowNodes contain exactly one window function");
            PlanNode rewrittenSource = context.rewrite(node.getSource());
            if (Rewriter.canReplaceWithRowNumber(node)) {
                return new RowNumberNode(this.idAllocator.getNextId(), rewrittenSource, node.getPartitionBy(), (Symbol)Iterables.getOnlyElement(node.getWindowFunctions().keySet()), Optional.empty(), Optional.empty());
            }
            return ChildReplacer.replaceChildren(node, (List<PlanNode>)ImmutableList.of((Object)rewrittenSource));
        }

        @Override
        public PlanNode visitLimit(LimitNode node, SimplePlanRewriter.RewriteContext<Void> context) {
            if (node.getCount() > Integer.MAX_VALUE) {
                return context.defaultRewrite(node);
            }
            PlanNode source = context.rewrite(node.getSource());
            int limit = Math.toIntExact(node.getCount());
            if (source instanceof RowNumberNode) {
                RowNumberNode rowNumberNode = Rewriter.mergeLimit((RowNumberNode)source, limit);
                if (rowNumberNode.getPartitionBy().isEmpty()) {
                    return rowNumberNode;
                }
                source = rowNumberNode;
            } else if (source instanceof WindowNode && Rewriter.canOptimizeWindowFunction((WindowNode)source)) {
                WindowNode windowNode = (WindowNode)source;
                Verify.verify((boolean)windowNode.getOrderingScheme().isPresent());
                TopNRowNumberNode topNRowNumberNode = this.convertToTopNRowNumber(windowNode, limit);
                if (windowNode.getPartitionBy().isEmpty()) {
                    return topNRowNumberNode;
                }
                source = topNRowNumberNode;
            }
            return ChildReplacer.replaceChildren(node, (List<PlanNode>)ImmutableList.of((Object)source));
        }

        @Override
        public PlanNode visitFilter(FilterNode node, SimplePlanRewriter.RewriteContext<Void> context) {
            WindowNode windowNode;
            Symbol rowNumberSymbol;
            OptionalInt upperBound;
            PlanNode source = context.rewrite(node.getSource());
            TupleDomain<Symbol> tupleDomain = DomainTranslator.fromPredicate(this.metadata, this.session, node.getPredicate(), this.types).getTupleDomain();
            if (source instanceof RowNumberNode) {
                Symbol rowNumberSymbol2 = ((RowNumberNode)source).getRowNumberSymbol();
                OptionalInt upperBound2 = Rewriter.extractUpperBound(tupleDomain, rowNumberSymbol2);
                if (upperBound2.isPresent()) {
                    source = Rewriter.mergeLimit((RowNumberNode)source, upperBound2.getAsInt());
                    return this.rewriteFilterSource(node, source, rowNumberSymbol2, upperBound2.getAsInt());
                }
            } else if (source instanceof WindowNode && Rewriter.canOptimizeWindowFunction((WindowNode)source) && (upperBound = Rewriter.extractUpperBound(tupleDomain, rowNumberSymbol = (Symbol)((Map.Entry)Iterables.getOnlyElement((windowNode = (WindowNode)source).getWindowFunctions().entrySet())).getKey())).isPresent()) {
                source = this.convertToTopNRowNumber(windowNode, upperBound.getAsInt());
                return this.rewriteFilterSource(node, source, rowNumberSymbol, upperBound.getAsInt());
            }
            return ChildReplacer.replaceChildren(node, (List<PlanNode>)ImmutableList.of((Object)source));
        }

        private PlanNode rewriteFilterSource(FilterNode filterNode, PlanNode source, Symbol rowNumberSymbol, int upperBound) {
            DomainTranslator.ExtractionResult extractionResult = DomainTranslator.fromPredicate(this.metadata, this.session, filterNode.getPredicate(), this.types);
            TupleDomain<Symbol> tupleDomain = extractionResult.getTupleDomain();
            if (!Rewriter.isEqualRange(tupleDomain, rowNumberSymbol, upperBound)) {
                return new FilterNode(filterNode.getId(), source, filterNode.getPredicate());
            }
            Map<Symbol, Domain> newDomains = ((Map)tupleDomain.getDomains().get()).entrySet().stream().filter(entry -> !((Symbol)entry.getKey()).equals(rowNumberSymbol)).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            TupleDomain newTupleDomain = TupleDomain.withColumnDomains(newDomains);
            Expression newPredicate = ExpressionUtils.combineConjuncts(extractionResult.getRemainingExpression(), this.domainTranslator.toPredicate((TupleDomain<Symbol>)newTupleDomain));
            if (newPredicate.equals((Object)BooleanLiteral.TRUE_LITERAL)) {
                return source;
            }
            return new FilterNode(filterNode.getId(), source, newPredicate);
        }

        private static boolean isEqualRange(TupleDomain<Symbol> tupleDomain, Symbol symbol, long upperBound) {
            if (tupleDomain.isNone()) {
                return false;
            }
            Domain domain = (Domain)((Map)tupleDomain.getDomains().get()).get(symbol);
            return domain.getValues().equals(ValueSet.ofRanges((Range)Range.lessThanOrEqual((Type)domain.getType(), (Object)upperBound), (Range[])new Range[0]));
        }

        private static OptionalInt extractUpperBound(TupleDomain<Symbol> tupleDomain, Symbol symbol) {
            if (tupleDomain.isNone()) {
                return OptionalInt.empty();
            }
            Domain rowNumberDomain = (Domain)((Map)tupleDomain.getDomains().get()).get(symbol);
            if (rowNumberDomain == null) {
                return OptionalInt.empty();
            }
            ValueSet values = rowNumberDomain.getValues();
            if (values.isAll() || values.isNone() || values.getRanges().getRangeCount() <= 0) {
                return OptionalInt.empty();
            }
            Range span = values.getRanges().getSpan();
            if (span.getHigh().isUpperUnbounded()) {
                return OptionalInt.empty();
            }
            Verify.verify((boolean)rowNumberDomain.getType().equals(BigintType.BIGINT));
            long upperBound = (Long)span.getHigh().getValue();
            if (span.getHigh().getBound() == Marker.Bound.BELOW) {
                --upperBound;
            }
            if (upperBound > 0L && upperBound <= Integer.MAX_VALUE) {
                return OptionalInt.of(Math.toIntExact(upperBound));
            }
            return OptionalInt.empty();
        }

        private static RowNumberNode mergeLimit(RowNumberNode node, int newRowCountPerPartition) {
            if (node.getMaxRowCountPerPartition().isPresent()) {
                newRowCountPerPartition = Math.min(node.getMaxRowCountPerPartition().get(), newRowCountPerPartition);
            }
            return new RowNumberNode(node.getId(), node.getSource(), node.getPartitionBy(), node.getRowNumberSymbol(), Optional.of(newRowCountPerPartition), node.getHashSymbol());
        }

        private TopNRowNumberNode convertToTopNRowNumber(WindowNode windowNode, int limit) {
            return new TopNRowNumberNode(this.idAllocator.getNextId(), windowNode.getSource(), windowNode.getSpecification(), (Symbol)Iterables.getOnlyElement(windowNode.getWindowFunctions().keySet()), limit, false, Optional.empty());
        }

        private static boolean canReplaceWithRowNumber(WindowNode node) {
            return Rewriter.canOptimizeWindowFunction(node) && !node.getOrderingScheme().isPresent();
        }

        private static boolean canOptimizeWindowFunction(WindowNode node) {
            if (node.getWindowFunctions().size() != 1) {
                return false;
            }
            Symbol rowNumberSymbol = (Symbol)((Map.Entry)Iterables.getOnlyElement(node.getWindowFunctions().entrySet())).getKey();
            return Rewriter.isRowNumberSignature(node.getWindowFunctions().get(rowNumberSymbol).getSignature());
        }

        private static boolean isRowNumberSignature(Signature signature) {
            return signature.equals(ROW_NUMBER_SIGNATURE);
        }
    }
}

