/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.optimizations;

import com.facebook.presto.Session;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.sql.planner.PlanNodeIdAllocator;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.SymbolAllocator;
import com.facebook.presto.sql.planner.optimizations.PlanOptimizer;
import com.facebook.presto.sql.planner.plan.AggregationNode;
import com.facebook.presto.sql.planner.plan.ExceptNode;
import com.facebook.presto.sql.planner.plan.IntersectNode;
import com.facebook.presto.sql.planner.plan.PlanNode;
import com.facebook.presto.sql.planner.plan.SetOperationNode;
import com.facebook.presto.sql.planner.plan.SimplePlanRewriter;
import com.facebook.presto.sql.planner.plan.UnionNode;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.ListMultimap;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class SetFlatteningOptimizer
implements PlanOptimizer {
    @Override
    public PlanNode optimize(PlanNode plan, Session session, Map<Symbol, Type> types, SymbolAllocator symbolAllocator, PlanNodeIdAllocator idAllocator) {
        Objects.requireNonNull(plan, "plan is null");
        Objects.requireNonNull(session, "session is null");
        Objects.requireNonNull(types, "types is null");
        Objects.requireNonNull(symbolAllocator, "symbolAllocator is null");
        Objects.requireNonNull(idAllocator, "idAllocator is null");
        return SimplePlanRewriter.rewriteWith(new Rewriter(), plan, false);
    }

    private static class Rewriter
    extends SimplePlanRewriter<Boolean> {
        private Rewriter() {
        }

        @Override
        public PlanNode visitPlan(PlanNode node, SimplePlanRewriter.RewriteContext<Boolean> context) {
            return context.defaultRewrite(node, false);
        }

        @Override
        public PlanNode visitUnion(UnionNode node, SimplePlanRewriter.RewriteContext<Boolean> context) {
            ImmutableList.Builder flattenedSources = ImmutableList.builder();
            ImmutableListMultimap.Builder flattenedSymbolMap = ImmutableListMultimap.builder();
            Rewriter.flattenSetOperation(node, context, (ImmutableList.Builder<PlanNode>)flattenedSources, (ImmutableListMultimap.Builder<Symbol, Symbol>)flattenedSymbolMap);
            return new UnionNode(node.getId(), (List<PlanNode>)flattenedSources.build(), (ListMultimap<Symbol, Symbol>)flattenedSymbolMap.build(), (List<Symbol>)ImmutableList.copyOf((Collection)flattenedSymbolMap.build().keySet()));
        }

        @Override
        public PlanNode visitIntersect(IntersectNode node, SimplePlanRewriter.RewriteContext<Boolean> context) {
            ImmutableList.Builder flattenedSources = ImmutableList.builder();
            ImmutableListMultimap.Builder flattenedSymbolMap = ImmutableListMultimap.builder();
            Rewriter.flattenSetOperation(node, context, (ImmutableList.Builder<PlanNode>)flattenedSources, (ImmutableListMultimap.Builder<Symbol, Symbol>)flattenedSymbolMap);
            return new IntersectNode(node.getId(), (List<PlanNode>)flattenedSources.build(), (ListMultimap<Symbol, Symbol>)flattenedSymbolMap.build(), (List<Symbol>)ImmutableList.copyOf((Collection)flattenedSymbolMap.build().keySet()));
        }

        @Override
        public PlanNode visitExcept(ExceptNode node, SimplePlanRewriter.RewriteContext<Boolean> context) {
            ImmutableList.Builder flattenedSources = ImmutableList.builder();
            ImmutableListMultimap.Builder flattenedSymbolMap = ImmutableListMultimap.builder();
            Rewriter.flattenSetOperation(node, context, (ImmutableList.Builder<PlanNode>)flattenedSources, (ImmutableListMultimap.Builder<Symbol, Symbol>)flattenedSymbolMap);
            return new ExceptNode(node.getId(), (List<PlanNode>)flattenedSources.build(), (ListMultimap<Symbol, Symbol>)flattenedSymbolMap.build(), (List<Symbol>)ImmutableList.copyOf((Collection)flattenedSymbolMap.build().keySet()));
        }

        private static void flattenSetOperation(SetOperationNode node, SimplePlanRewriter.RewriteContext<Boolean> context, ImmutableList.Builder<PlanNode> flattenedSources, ImmutableListMultimap.Builder<Symbol, Symbol> flattenedSymbolMap) {
            for (int i = 0; i < node.getSources().size(); ++i) {
                PlanNode subplan = node.getSources().get(i);
                PlanNode rewrittenSource = context.rewrite(subplan, context.get());
                Class<?> setOperationClass = node.getClass();
                if (setOperationClass.isInstance(rewrittenSource) && (!setOperationClass.equals(ExceptNode.class) || i == 0)) {
                    SetOperationNode rewrittenSetOperation = (SetOperationNode)rewrittenSource;
                    flattenedSources.addAll(rewrittenSetOperation.getSources());
                    for (Map.Entry entry : node.getSymbolMapping().asMap().entrySet()) {
                        Symbol inputSymbol = (Symbol)Iterables.get((Iterable)((Iterable)entry.getValue()), (int)i);
                        flattenedSymbolMap.putAll(entry.getKey(), (Iterable)rewrittenSetOperation.getSymbolMapping().get((Object)inputSymbol));
                    }
                    continue;
                }
                flattenedSources.add((Object)rewrittenSource);
                for (Map.Entry entry : node.getSymbolMapping().asMap().entrySet()) {
                    flattenedSymbolMap.put(entry.getKey(), Iterables.get((Iterable)((Iterable)entry.getValue()), (int)i));
                }
            }
        }

        @Override
        public PlanNode visitAggregation(AggregationNode node, SimplePlanRewriter.RewriteContext<Boolean> context) {
            boolean distinct = Rewriter.isDistinctOperator(node);
            PlanNode rewrittenNode = context.rewrite(node.getSource(), distinct);
            if (context.get().booleanValue() && distinct) {
                return rewrittenNode;
            }
            return new AggregationNode(node.getId(), rewrittenNode, node.getAggregations(), node.getGroupingSets(), node.getStep(), node.getHashSymbol(), node.getGroupIdSymbol());
        }

        private static boolean isDistinctOperator(AggregationNode node) {
            return node.getAggregations().isEmpty();
        }
    }
}

