/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.iterative.rule;

import com.facebook.presto.SystemSessionProperties;
import com.facebook.presto.matching.Captures;
import com.facebook.presto.matching.Pattern;
import com.facebook.presto.sql.planner.iterative.Rule;
import com.facebook.presto.sql.planner.optimizations.QueryCardinalityUtil;
import com.facebook.presto.sql.planner.plan.JoinNode;
import com.facebook.presto.sql.planner.plan.Patterns;

public class DetermineJoinDistributionType
implements Rule<JoinNode> {
    private static final Pattern<JoinNode> PATTERN = Patterns.join().matching(joinNode -> !joinNode.getDistributionType().isPresent());

    @Override
    public Pattern<JoinNode> getPattern() {
        return PATTERN;
    }

    @Override
    public Rule.Result apply(JoinNode node, Captures captures, Rule.Context context) {
        JoinNode.DistributionType distributionType = DetermineJoinDistributionType.determineDistributionType(node, context);
        return Rule.Result.ofPlanNode(node.withDistributionType(distributionType));
    }

    private static JoinNode.DistributionType determineDistributionType(JoinNode node, Rule.Context context) {
        JoinNode.Type type = node.getType();
        if (type == JoinNode.Type.RIGHT || type == JoinNode.Type.FULL) {
            return JoinNode.DistributionType.PARTITIONED;
        }
        if (node.getCriteria().isEmpty() && (type == JoinNode.Type.INNER || type == JoinNode.Type.LEFT)) {
            return JoinNode.DistributionType.REPLICATED;
        }
        if (QueryCardinalityUtil.isAtMostScalar(node.getRight(), context.getLookup())) {
            return JoinNode.DistributionType.REPLICATED;
        }
        if (SystemSessionProperties.isDistributedJoinEnabled(context.getSession())) {
            return JoinNode.DistributionType.PARTITIONED;
        }
        return JoinNode.DistributionType.REPLICATED;
    }
}

