/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.iterative.rule;

import com.facebook.presto.sql.tree.CurrentTime;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.ExpressionRewriter;
import com.facebook.presto.sql.tree.ExpressionTreeRewriter;
import com.facebook.presto.sql.tree.Extract;
import com.facebook.presto.sql.tree.FunctionCall;
import com.facebook.presto.sql.tree.IfExpression;
import com.facebook.presto.sql.tree.IsNotNullPredicate;
import com.facebook.presto.sql.tree.IsNullPredicate;
import com.facebook.presto.sql.tree.NotExpression;
import com.facebook.presto.sql.tree.QualifiedName;
import com.facebook.presto.sql.tree.SearchedCaseExpression;
import com.facebook.presto.sql.tree.WhenClause;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Optional;

public class CanonicalizeExpressionRewriter {
    private CanonicalizeExpressionRewriter() {
    }

    public static Expression canonicalizeExpression(Expression expression) {
        return ExpressionTreeRewriter.rewriteWith((ExpressionRewriter)new Visitor(), (Expression)expression);
    }

    private static class Visitor
    extends ExpressionRewriter<Void> {
        private Visitor() {
        }

        public Expression rewriteIsNotNullPredicate(IsNotNullPredicate node, Void context, ExpressionTreeRewriter<Void> treeRewriter) {
            Expression value = treeRewriter.rewrite(node.getValue(), (Object)context);
            return new NotExpression((Expression)new IsNullPredicate(value));
        }

        public Expression rewriteIfExpression(IfExpression node, Void context, ExpressionTreeRewriter<Void> treeRewriter) {
            Expression condition = treeRewriter.rewrite(node.getCondition(), (Object)context);
            Expression trueValue = treeRewriter.rewrite(node.getTrueValue(), (Object)context);
            Optional<Expression> falseValue = node.getFalseValue().map(value -> treeRewriter.rewrite(value, (Object)context));
            return new SearchedCaseExpression((List)ImmutableList.of((Object)new WhenClause(condition, trueValue)), falseValue);
        }

        public Expression rewriteCurrentTime(CurrentTime node, Void context, ExpressionTreeRewriter<Void> treeRewriter) {
            if (node.getPrecision() != null) {
                throw new UnsupportedOperationException("not yet implemented: non-default precision");
            }
            switch (node.getType()) {
                case DATE: {
                    return new FunctionCall(QualifiedName.of((String)"current_date"), (List)ImmutableList.of());
                }
                case TIME: {
                    return new FunctionCall(QualifiedName.of((String)"current_time"), (List)ImmutableList.of());
                }
                case LOCALTIME: {
                    return new FunctionCall(QualifiedName.of((String)"localtime"), (List)ImmutableList.of());
                }
                case TIMESTAMP: {
                    return new FunctionCall(QualifiedName.of((String)"current_timestamp"), (List)ImmutableList.of());
                }
                case LOCALTIMESTAMP: {
                    return new FunctionCall(QualifiedName.of((String)"localtimestamp"), (List)ImmutableList.of());
                }
            }
            throw new UnsupportedOperationException("not yet implemented: " + node.getType());
        }

        public Expression rewriteExtract(Extract node, Void context, ExpressionTreeRewriter<Void> treeRewriter) {
            Expression value = treeRewriter.rewrite(node.getExpression(), (Object)context);
            switch (node.getField()) {
                case YEAR: {
                    return new FunctionCall(QualifiedName.of((String)"year"), (List)ImmutableList.of((Object)value));
                }
                case QUARTER: {
                    return new FunctionCall(QualifiedName.of((String)"quarter"), (List)ImmutableList.of((Object)value));
                }
                case MONTH: {
                    return new FunctionCall(QualifiedName.of((String)"month"), (List)ImmutableList.of((Object)value));
                }
                case WEEK: {
                    return new FunctionCall(QualifiedName.of((String)"week"), (List)ImmutableList.of((Object)value));
                }
                case DAY: 
                case DAY_OF_MONTH: {
                    return new FunctionCall(QualifiedName.of((String)"day"), (List)ImmutableList.of((Object)value));
                }
                case DAY_OF_WEEK: 
                case DOW: {
                    return new FunctionCall(QualifiedName.of((String)"day_of_week"), (List)ImmutableList.of((Object)value));
                }
                case DAY_OF_YEAR: 
                case DOY: {
                    return new FunctionCall(QualifiedName.of((String)"day_of_year"), (List)ImmutableList.of((Object)value));
                }
                case YEAR_OF_WEEK: 
                case YOW: {
                    return new FunctionCall(QualifiedName.of((String)"year_of_week"), (List)ImmutableList.of((Object)value));
                }
                case HOUR: {
                    return new FunctionCall(QualifiedName.of((String)"hour"), (List)ImmutableList.of((Object)value));
                }
                case MINUTE: {
                    return new FunctionCall(QualifiedName.of((String)"minute"), (List)ImmutableList.of((Object)value));
                }
                case SECOND: {
                    return new FunctionCall(QualifiedName.of((String)"second"), (List)ImmutableList.of((Object)value));
                }
                case TIMEZONE_MINUTE: {
                    return new FunctionCall(QualifiedName.of((String)"timezone_minute"), (List)ImmutableList.of((Object)value));
                }
                case TIMEZONE_HOUR: {
                    return new FunctionCall(QualifiedName.of((String)"timezone_hour"), (List)ImmutableList.of((Object)value));
                }
            }
            throw new UnsupportedOperationException("not yet implemented: " + node.getField());
        }
    }
}

