/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner;

import com.facebook.presto.spi.type.Type;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.ExpressionRewriter;
import com.facebook.presto.sql.tree.ExpressionTreeRewriter;
import com.facebook.presto.sql.tree.FieldReference;
import com.facebook.presto.sql.tree.LambdaExpression;
import com.facebook.presto.sql.tree.SymbolReference;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class SymbolToInputParameterRewriter {
    private final Map<Symbol, Integer> symbolToChannelMapping;
    private final Map<Symbol, Type> symbolToTypeMapping;
    private final Map<Integer, Integer> fieldToParameter = new HashMap<Integer, Integer>();
    private final List<Integer> inputChannels = new ArrayList<Integer>();
    private final List<Type> inputTypes = new ArrayList<Type>();
    private int nextParameter;

    public List<Integer> getInputChannels() {
        return ImmutableList.copyOf(this.inputChannels);
    }

    public List<Type> getInputTypes() {
        return ImmutableList.copyOf(this.inputTypes);
    }

    public SymbolToInputParameterRewriter(Map<Symbol, Type> symbolToTypes, Map<Symbol, Integer> symbolToChannelMapping) {
        Objects.requireNonNull(symbolToChannelMapping, "symbolToChannelMapping is null");
        Objects.requireNonNull(symbolToTypes, "symbolToTypeMapping is null");
        this.symbolToChannelMapping = ImmutableMap.copyOf(symbolToChannelMapping);
        this.symbolToTypeMapping = ImmutableMap.copyOf(symbolToTypes);
    }

    public Expression rewrite(Expression expression) {
        return ExpressionTreeRewriter.rewriteWith((ExpressionRewriter)new ExpressionRewriter<Context>(){

            public Expression rewriteSymbolReference(SymbolReference node, Context context, ExpressionTreeRewriter<Context> treeRewriter) {
                Symbol symbol = Symbol.from((Expression)node);
                Integer channel = (Integer)SymbolToInputParameterRewriter.this.symbolToChannelMapping.get(symbol);
                if (channel == null) {
                    Preconditions.checkArgument((boolean)context.isInLambda(), (String)"Cannot resolve symbol %s", (Object)node.getName());
                    return node;
                }
                Type type = (Type)SymbolToInputParameterRewriter.this.symbolToTypeMapping.get(symbol);
                Preconditions.checkArgument((type != null ? 1 : 0) != 0, (String)"Cannot resolve symbol %s", (Object)node.getName());
                int parameter = SymbolToInputParameterRewriter.this.fieldToParameter.computeIfAbsent(channel, field -> {
                    SymbolToInputParameterRewriter.this.inputChannels.add(field);
                    SymbolToInputParameterRewriter.this.inputTypes.add(type);
                    return SymbolToInputParameterRewriter.this.nextParameter++;
                });
                return new FieldReference(parameter);
            }

            public Expression rewriteLambdaExpression(LambdaExpression node, Context context, ExpressionTreeRewriter<Context> treeRewriter) {
                return treeRewriter.defaultRewrite((Expression)node, (Object)new Context(true));
            }
        }, (Expression)expression, (Object)new Context(false));
    }

    private static class Context {
        private final boolean inLambda;

        public Context(boolean inLambda) {
            this.inLambda = inLambda;
        }

        public boolean isInLambda() {
            return this.inLambda;
        }
    }
}

