/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner;

import com.facebook.presto.Session;
import com.facebook.presto.SystemSessionProperties;
import com.facebook.presto.cost.CostCalculator;
import com.facebook.presto.cost.StatsCalculator;
import com.facebook.presto.execution.Lifespan;
import com.facebook.presto.execution.QueryPerformanceFetcher;
import com.facebook.presto.execution.StageId;
import com.facebook.presto.execution.TaskManagerConfig;
import com.facebook.presto.execution.buffer.OutputBuffer;
import com.facebook.presto.execution.buffer.PagesSerdeFactory;
import com.facebook.presto.index.IndexManager;
import com.facebook.presto.metadata.FunctionKind;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.Signature;
import com.facebook.presto.operator.AggregationOperator;
import com.facebook.presto.operator.AssignUniqueIdOperator;
import com.facebook.presto.operator.DeleteOperator;
import com.facebook.presto.operator.DistinctLimitOperator;
import com.facebook.presto.operator.DriverFactory;
import com.facebook.presto.operator.EnforceSingleRowOperator;
import com.facebook.presto.operator.ExchangeClientSupplier;
import com.facebook.presto.operator.ExchangeOperator;
import com.facebook.presto.operator.ExplainAnalyzeOperator;
import com.facebook.presto.operator.FilterAndProjectOperator;
import com.facebook.presto.operator.GroupIdOperator;
import com.facebook.presto.operator.HashAggregationOperator;
import com.facebook.presto.operator.HashBuilderOperator;
import com.facebook.presto.operator.HashSemiJoinOperator;
import com.facebook.presto.operator.JoinBridgeDataManager;
import com.facebook.presto.operator.JoinOperatorFactory;
import com.facebook.presto.operator.LimitOperator;
import com.facebook.presto.operator.LocalPlannerAware;
import com.facebook.presto.operator.LookupJoinOperators;
import com.facebook.presto.operator.LookupOuterOperator;
import com.facebook.presto.operator.LookupSourceFactory;
import com.facebook.presto.operator.MarkDistinctOperator;
import com.facebook.presto.operator.MetadataDeleteOperator;
import com.facebook.presto.operator.NestedLoopBuildOperator;
import com.facebook.presto.operator.NestedLoopJoinOperator;
import com.facebook.presto.operator.NestedLoopJoinPagesBridge;
import com.facebook.presto.operator.NestedLoopJoinPagesSupplier;
import com.facebook.presto.operator.OperatorFactory;
import com.facebook.presto.operator.OrderByOperator;
import com.facebook.presto.operator.OutputFactory;
import com.facebook.presto.operator.PagesIndex;
import com.facebook.presto.operator.PagesSpatialIndexFactory;
import com.facebook.presto.operator.PartitionFunction;
import com.facebook.presto.operator.PartitionedLookupSourceFactory;
import com.facebook.presto.operator.PartitionedOutputOperator;
import com.facebook.presto.operator.PipelineExecutionStrategy;
import com.facebook.presto.operator.RowNumberOperator;
import com.facebook.presto.operator.ScanFilterAndProjectOperator;
import com.facebook.presto.operator.SetBuilderOperator;
import com.facebook.presto.operator.SpatialIndexBuilderOperator;
import com.facebook.presto.operator.SpatialJoinOperator;
import com.facebook.presto.operator.TableFinishOperator;
import com.facebook.presto.operator.TableScanOperator;
import com.facebook.presto.operator.TableWriterOperator;
import com.facebook.presto.operator.TaskContext;
import com.facebook.presto.operator.TaskOutputOperator;
import com.facebook.presto.operator.TopNOperator;
import com.facebook.presto.operator.TopNRowNumberOperator;
import com.facebook.presto.operator.UnnestOperator;
import com.facebook.presto.operator.ValuesOperator;
import com.facebook.presto.operator.WindowFunctionDefinition;
import com.facebook.presto.operator.WindowOperator;
import com.facebook.presto.operator.aggregation.AccumulatorFactory;
import com.facebook.presto.operator.exchange.LocalExchange;
import com.facebook.presto.operator.exchange.LocalExchangeSinkOperator;
import com.facebook.presto.operator.exchange.LocalExchangeSourceOperator;
import com.facebook.presto.operator.exchange.PageChannelSelector;
import com.facebook.presto.operator.index.DynamicTupleFilterFactory;
import com.facebook.presto.operator.index.FieldSetFilteringRecordSet;
import com.facebook.presto.operator.index.IndexBuildDriverFactoryProvider;
import com.facebook.presto.operator.index.IndexJoinLookupStats;
import com.facebook.presto.operator.index.IndexLookupSourceFactory;
import com.facebook.presto.operator.index.IndexSourceOperator;
import com.facebook.presto.operator.project.CursorProcessor;
import com.facebook.presto.operator.project.PageProcessor;
import com.facebook.presto.operator.window.FrameInfo;
import com.facebook.presto.operator.window.WindowFunctionSupplier;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ConnectorIndex;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.PageBuilder;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.RecordSet;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.block.BlockEncodingSerde;
import com.facebook.presto.spi.block.SortOrder;
import com.facebook.presto.spi.predicate.NullableValue;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeUtils;
import com.facebook.presto.spiller.PartitioningSpillerFactory;
import com.facebook.presto.spiller.SingleStreamSpillerFactory;
import com.facebook.presto.spiller.SpillerFactory;
import com.facebook.presto.split.MappedRecordSet;
import com.facebook.presto.split.PageSinkManager;
import com.facebook.presto.split.PageSourceProvider;
import com.facebook.presto.sql.analyzer.ExpressionAnalyzer;
import com.facebook.presto.sql.gen.ExpressionCompiler;
import com.facebook.presto.sql.gen.JoinCompiler;
import com.facebook.presto.sql.gen.JoinFilterFunctionCompiler;
import com.facebook.presto.sql.gen.PageFunctionCompiler;
import com.facebook.presto.sql.parser.SqlParser;
import com.facebook.presto.sql.planner.ExpressionInterpreter;
import com.facebook.presto.sql.planner.ExpressionNodeInliner;
import com.facebook.presto.sql.planner.NodePartitioningManager;
import com.facebook.presto.sql.planner.OrderingScheme;
import com.facebook.presto.sql.planner.Partitioning;
import com.facebook.presto.sql.planner.PartitioningScheme;
import com.facebook.presto.sql.planner.QueryPlanner;
import com.facebook.presto.sql.planner.SortExpressionContext;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.SymbolToInputRewriter;
import com.facebook.presto.sql.planner.SystemPartitioningHandle;
import com.facebook.presto.sql.planner.optimizations.IndexJoinOptimizer;
import com.facebook.presto.sql.planner.plan.AggregationNode;
import com.facebook.presto.sql.planner.plan.AssignUniqueId;
import com.facebook.presto.sql.planner.plan.Assignments;
import com.facebook.presto.sql.planner.plan.DeleteNode;
import com.facebook.presto.sql.planner.plan.DistinctLimitNode;
import com.facebook.presto.sql.planner.plan.EnforceSingleRowNode;
import com.facebook.presto.sql.planner.plan.ExchangeNode;
import com.facebook.presto.sql.planner.plan.ExplainAnalyzeNode;
import com.facebook.presto.sql.planner.plan.FilterNode;
import com.facebook.presto.sql.planner.plan.GroupIdNode;
import com.facebook.presto.sql.planner.plan.IndexJoinNode;
import com.facebook.presto.sql.planner.plan.IndexSourceNode;
import com.facebook.presto.sql.planner.plan.JoinNode;
import com.facebook.presto.sql.planner.plan.LimitNode;
import com.facebook.presto.sql.planner.plan.MarkDistinctNode;
import com.facebook.presto.sql.planner.plan.MetadataDeleteNode;
import com.facebook.presto.sql.planner.plan.OutputNode;
import com.facebook.presto.sql.planner.plan.PlanNode;
import com.facebook.presto.sql.planner.plan.PlanNodeId;
import com.facebook.presto.sql.planner.plan.PlanVisitor;
import com.facebook.presto.sql.planner.plan.ProjectNode;
import com.facebook.presto.sql.planner.plan.RemoteSourceNode;
import com.facebook.presto.sql.planner.plan.RowNumberNode;
import com.facebook.presto.sql.planner.plan.SampleNode;
import com.facebook.presto.sql.planner.plan.SemiJoinNode;
import com.facebook.presto.sql.planner.plan.SortNode;
import com.facebook.presto.sql.planner.plan.TableFinishNode;
import com.facebook.presto.sql.planner.plan.TableScanNode;
import com.facebook.presto.sql.planner.plan.TableWriterNode;
import com.facebook.presto.sql.planner.plan.TopNNode;
import com.facebook.presto.sql.planner.plan.TopNRowNumberNode;
import com.facebook.presto.sql.planner.plan.UnionNode;
import com.facebook.presto.sql.planner.plan.UnnestNode;
import com.facebook.presto.sql.planner.plan.ValuesNode;
import com.facebook.presto.sql.planner.plan.WindowNode;
import com.facebook.presto.sql.relational.RowExpression;
import com.facebook.presto.sql.relational.SqlToRowExpressionTranslator;
import com.facebook.presto.sql.tree.BooleanLiteral;
import com.facebook.presto.sql.tree.ComparisonExpression;
import com.facebook.presto.sql.tree.ComparisonExpressionType;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.FieldReference;
import com.facebook.presto.sql.tree.FunctionCall;
import com.facebook.presto.sql.tree.NodeRef;
import com.facebook.presto.sql.tree.OrderBy;
import com.facebook.presto.sql.tree.SortItem;
import com.facebook.presto.sql.tree.SymbolReference;
import com.facebook.presto.util.SpatialJoinUtils;
import com.google.common.base.Functions;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.base.VerifyException;
import com.google.common.collect.ContiguousSet;
import com.google.common.collect.DiscreteDomain;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.Range;
import com.google.common.collect.SetMultimap;
import com.google.common.primitives.Ints;
import io.airlift.log.Logger;
import io.airlift.units.DataSize;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.inject.Inject;

public class LocalExecutionPlanner {
    private static final Logger log = Logger.get(LocalExecutionPlanner.class);
    private final Metadata metadata;
    private final SqlParser sqlParser;
    private final StatsCalculator statsCalculator;
    private final CostCalculator costCalculator;
    private final Optional<QueryPerformanceFetcher> queryPerformanceFetcher;
    private final PageSourceProvider pageSourceProvider;
    private final IndexManager indexManager;
    private final NodePartitioningManager nodePartitioningManager;
    private final PageSinkManager pageSinkManager;
    private final ExchangeClientSupplier exchangeClientSupplier;
    private final ExpressionCompiler expressionCompiler;
    private final PageFunctionCompiler pageFunctionCompiler;
    private final JoinFilterFunctionCompiler joinFilterFunctionCompiler;
    private final DataSize maxIndexMemorySize;
    private final IndexJoinLookupStats indexJoinLookupStats;
    private final DataSize maxPartialAggregationMemorySize;
    private final DataSize maxPagePartitioningBufferSize;
    private final DataSize maxLocalExchangeBufferSize;
    private final SpillerFactory spillerFactory;
    private final SingleStreamSpillerFactory singleStreamSpillerFactory;
    private final PartitioningSpillerFactory partitioningSpillerFactory;
    private final BlockEncodingSerde blockEncodingSerde;
    private final PagesIndex.Factory pagesIndexFactory;
    private final JoinCompiler joinCompiler;
    private final LookupJoinOperators lookupJoinOperators;

    @Inject
    public LocalExecutionPlanner(Metadata metadata, SqlParser sqlParser, StatsCalculator statsCalculator, CostCalculator costCalculator, Optional<QueryPerformanceFetcher> queryPerformanceFetcher, PageSourceProvider pageSourceProvider, IndexManager indexManager, NodePartitioningManager nodePartitioningManager, PageSinkManager pageSinkManager, ExchangeClientSupplier exchangeClientSupplier, ExpressionCompiler expressionCompiler, PageFunctionCompiler pageFunctionCompiler, JoinFilterFunctionCompiler joinFilterFunctionCompiler, IndexJoinLookupStats indexJoinLookupStats, TaskManagerConfig taskManagerConfig, SpillerFactory spillerFactory, SingleStreamSpillerFactory singleStreamSpillerFactory, PartitioningSpillerFactory partitioningSpillerFactory, BlockEncodingSerde blockEncodingSerde, PagesIndex.Factory pagesIndexFactory, JoinCompiler joinCompiler, LookupJoinOperators lookupJoinOperators) {
        this.queryPerformanceFetcher = Objects.requireNonNull(queryPerformanceFetcher, "queryPerformanceFetcher is null");
        this.pageSourceProvider = Objects.requireNonNull(pageSourceProvider, "pageSourceProvider is null");
        this.indexManager = Objects.requireNonNull(indexManager, "indexManager is null");
        this.nodePartitioningManager = Objects.requireNonNull(nodePartitioningManager, "nodePartitioningManager is null");
        this.exchangeClientSupplier = exchangeClientSupplier;
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
        this.sqlParser = Objects.requireNonNull(sqlParser, "sqlParser is null");
        this.statsCalculator = Objects.requireNonNull(statsCalculator, "statsCalculator is null");
        this.costCalculator = Objects.requireNonNull(costCalculator, "costCalculator is null");
        this.pageSinkManager = Objects.requireNonNull(pageSinkManager, "pageSinkManager is null");
        this.expressionCompiler = Objects.requireNonNull(expressionCompiler, "compiler is null");
        this.pageFunctionCompiler = Objects.requireNonNull(pageFunctionCompiler, "pageFunctionCompiler is null");
        this.joinFilterFunctionCompiler = Objects.requireNonNull(joinFilterFunctionCompiler, "compiler is null");
        this.indexJoinLookupStats = Objects.requireNonNull(indexJoinLookupStats, "indexJoinLookupStats is null");
        this.maxIndexMemorySize = Objects.requireNonNull(taskManagerConfig, "taskManagerConfig is null").getMaxIndexMemoryUsage();
        this.spillerFactory = Objects.requireNonNull(spillerFactory, "spillerFactory is null");
        this.singleStreamSpillerFactory = Objects.requireNonNull(singleStreamSpillerFactory, "singleStreamSpillerFactory is null");
        this.partitioningSpillerFactory = Objects.requireNonNull(partitioningSpillerFactory, "partitioningSpillerFactory is null");
        this.blockEncodingSerde = Objects.requireNonNull(blockEncodingSerde, "blockEncodingSerde is null");
        this.maxPartialAggregationMemorySize = taskManagerConfig.getMaxPartialAggregationMemoryUsage();
        this.maxPagePartitioningBufferSize = taskManagerConfig.getMaxPagePartitioningBufferSize();
        this.maxLocalExchangeBufferSize = taskManagerConfig.getMaxLocalExchangeBufferSize();
        this.pagesIndexFactory = Objects.requireNonNull(pagesIndexFactory, "pagesIndexFactory is null");
        this.joinCompiler = Objects.requireNonNull(joinCompiler, "joinCompiler is null");
        this.lookupJoinOperators = Objects.requireNonNull(lookupJoinOperators, "lookupJoinOperators is null");
    }

    public LocalExecutionPlan plan(TaskContext taskContext, PlanNode plan, Map<Symbol, Type> types, PartitioningScheme partitioningScheme, boolean planGrouped, List<PlanNodeId> partitionedSourceOrder, OutputBuffer outputBuffer) {
        Object partitionChannelTypes;
        Object partitionConstants;
        Object partitionChannels;
        List<Symbol> outputLayout = partitioningScheme.getOutputLayout();
        if (partitioningScheme.getPartitioning().getHandle().equals(SystemPartitioningHandle.FIXED_BROADCAST_DISTRIBUTION) || partitioningScheme.getPartitioning().getHandle().equals(SystemPartitioningHandle.FIXED_ARBITRARY_DISTRIBUTION) || partitioningScheme.getPartitioning().getHandle().equals(SystemPartitioningHandle.SCALED_WRITER_DISTRIBUTION) || partitioningScheme.getPartitioning().getHandle().equals(SystemPartitioningHandle.SINGLE_DISTRIBUTION) || partitioningScheme.getPartitioning().getHandle().equals(SystemPartitioningHandle.COORDINATOR_DISTRIBUTION)) {
            return this.plan(taskContext, planGrouped, plan, outputLayout, types, partitionedSourceOrder, new TaskOutputOperator.TaskOutputFactory(outputBuffer));
        }
        if (partitioningScheme.getHashColumn().isPresent()) {
            partitionChannels = ImmutableList.of((Object)outputLayout.indexOf(partitioningScheme.getHashColumn().get()));
            partitionConstants = ImmutableList.of(Optional.empty());
            partitionChannelTypes = ImmutableList.of((Object)BigintType.BIGINT);
        } else {
            partitionChannels = (List)partitioningScheme.getPartitioning().getArguments().stream().map(Partitioning.ArgumentBinding::getColumn).map(outputLayout::indexOf).collect(ImmutableList.toImmutableList());
            partitionConstants = (List)partitioningScheme.getPartitioning().getArguments().stream().map(argument -> {
                if (argument.isConstant()) {
                    return Optional.of(argument.getConstant());
                }
                return Optional.empty();
            }).collect(ImmutableList.toImmutableList());
            partitionChannelTypes = (List)partitioningScheme.getPartitioning().getArguments().stream().map(argument -> {
                if (argument.isConstant()) {
                    return argument.getConstant().getType();
                }
                return (Type)types.get(argument.getColumn());
            }).collect(ImmutableList.toImmutableList());
        }
        PartitionFunction partitionFunction = this.nodePartitioningManager.getPartitionFunction(taskContext.getSession(), partitioningScheme, (List<Type>)partitionChannelTypes);
        OptionalInt nullChannel = OptionalInt.empty();
        Set<Symbol> partitioningColumns = partitioningScheme.getPartitioning().getColumns();
        Preconditions.checkArgument((!partitioningScheme.isReplicateNullsAndAny() || partitioningColumns.size() <= 1 ? 1 : 0) != 0);
        if (partitioningScheme.isReplicateNullsAndAny() && partitioningColumns.size() == 1) {
            nullChannel = OptionalInt.of(outputLayout.indexOf(Iterables.getOnlyElement(partitioningColumns)));
        }
        return this.plan(taskContext, planGrouped, plan, outputLayout, types, partitionedSourceOrder, new PartitionedOutputOperator.PartitionedOutputFactory(partitionFunction, (List<Integer>)partitionChannels, (List<Optional<NullableValue>>)partitionConstants, partitioningScheme.isReplicateNullsAndAny(), nullChannel, outputBuffer, this.maxPagePartitioningBufferSize));
    }

    public LocalExecutionPlan plan(TaskContext taskContext, boolean planGrouped, PlanNode plan, List<Symbol> outputLayout, Map<Symbol, Type> types, List<PlanNodeId> partitionedSourceOrder, OutputFactory outputOperatorFactory) {
        Session session = taskContext.getSession();
        LocalExecutionPlanContext context = new LocalExecutionPlanContext(taskContext, types);
        PhysicalOperation physicalOperation = plan.accept(new Visitor(session, planGrouped), context);
        Function<Page, Page> pagePreprocessor = LocalExecutionPlanner.enforceLayoutProcessor(outputLayout, physicalOperation.getLayout());
        List outputTypes = (List)outputLayout.stream().map(types::get).collect(ImmutableList.toImmutableList());
        context.addDriverFactory(context.isInputDriver(), true, (List<OperatorFactory>)ImmutableList.builder().addAll((Iterable)physicalOperation.getOperatorFactories()).add((Object)outputOperatorFactory.createOutputOperator(context.getNextOperatorId(), plan.getId(), outputTypes, pagePreprocessor, new PagesSerdeFactory(this.blockEncodingSerde, SystemSessionProperties.isExchangeCompressionEnabled(session)))).build(), context.getDriverInstanceCount(), physicalOperation.getPipelineExecutionStrategy());
        LocalExecutionPlanner.addLookupOuterDrivers(context);
        context.getDriverFactories().stream().map(DriverFactory::getOperatorFactories).flatMap(Collection::stream).filter(LocalPlannerAware.class::isInstance).map(LocalPlannerAware.class::cast).forEach(LocalPlannerAware::localPlannerComplete);
        return new LocalExecutionPlan(context.getDriverFactories(), partitionedSourceOrder);
    }

    private static void addLookupOuterDrivers(LocalExecutionPlanContext context) {
        for (DriverFactory factory : context.getDriverFactories()) {
            List<OperatorFactory> operatorFactories = factory.getOperatorFactories();
            for (int i = 0; i < operatorFactories.size(); ++i) {
                JoinOperatorFactory lookupJoin;
                Optional<OperatorFactory> outerOperatorFactory;
                OperatorFactory operatorFactory = operatorFactories.get(i);
                if (!(operatorFactory instanceof JoinOperatorFactory) || !(outerOperatorFactory = (lookupJoin = (JoinOperatorFactory)operatorFactory).createOuterOperatorFactory()).isPresent()) continue;
                ImmutableList.Builder newOperators = ImmutableList.builder();
                newOperators.add((Object)outerOperatorFactory.get());
                operatorFactories.subList(i + 1, operatorFactories.size()).stream().map(OperatorFactory::duplicate).forEach(arg_0 -> ((ImmutableList.Builder)newOperators).add(arg_0));
                context.addDriverFactory(false, factory.isOutputDriver(), (List<OperatorFactory>)newOperators.build(), OptionalInt.of(1), factory.getPipelineExecutionStrategy());
            }
        }
    }

    private static List<Type> getTypes(List<Expression> expressions, Map<NodeRef<Expression>, Type> expressionTypes) {
        return (List)expressions.stream().map(NodeRef::of).map(expressionTypes::get).collect(ImmutableList.toImmutableList());
    }

    private static TableFinishOperator.TableFinisher createTableFinisher(Session session, TableFinishNode node, Metadata metadata) {
        TableWriterNode.WriterTarget target = node.getTarget();
        return fragments -> {
            if (target instanceof TableWriterNode.CreateHandle) {
                return metadata.finishCreateTable(session, ((TableWriterNode.CreateHandle)target).getHandle(), fragments);
            }
            if (target instanceof TableWriterNode.InsertHandle) {
                return metadata.finishInsert(session, ((TableWriterNode.InsertHandle)target).getHandle(), fragments);
            }
            if (target instanceof TableWriterNode.DeleteHandle) {
                metadata.finishDelete(session, ((TableWriterNode.DeleteHandle)target).getHandle(), fragments);
                return Optional.empty();
            }
            throw new AssertionError((Object)("Unhandled target type: " + target.getClass().getName()));
        };
    }

    private static Function<Page, Page> enforceLayoutProcessor(List<Symbol> expectedLayout, Map<Symbol, Integer> inputLayout) {
        int[] channels = expectedLayout.stream().peek(symbol -> Preconditions.checkArgument((boolean)inputLayout.containsKey(symbol), (String)"channel not found for symbol: %s", (Object)symbol)).mapToInt(inputLayout::get).toArray();
        if (Arrays.equals(channels, IntStream.range(0, inputLayout.size()).toArray())) {
            return Function.identity();
        }
        return new PageChannelSelector(channels);
    }

    private static List<Integer> getChannelsForSymbols(List<Symbol> symbols, Map<Symbol, Integer> layout) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Symbol symbol : symbols) {
            builder.add((Object)layout.get(symbol));
        }
        return builder.build();
    }

    private static Function<Symbol, Integer> channelGetter(PhysicalOperation source) {
        return input -> {
            Preconditions.checkArgument((boolean)source.getLayout().containsKey(input));
            return source.getLayout().get(input);
        };
    }

    private static class DriverFactoryParameters {
        private final LocalExecutionPlanContext subContext;
        private final PhysicalOperation source;

        public DriverFactoryParameters(LocalExecutionPlanContext subContext, PhysicalOperation source) {
            this.subContext = subContext;
            this.source = source;
        }

        public LocalExecutionPlanContext getSubContext() {
            return this.subContext;
        }

        public PhysicalOperation getSource() {
            return this.source;
        }
    }

    private static class PhysicalOperation {
        private final List<OperatorFactory> operatorFactories;
        private final Map<Symbol, Integer> layout;
        private final List<Type> types;
        private final PipelineExecutionStrategy pipelineExecutionStrategy;

        public PhysicalOperation(OperatorFactory operatorFactory, Map<Symbol, Integer> layout, LocalExecutionPlanContext context, PipelineExecutionStrategy pipelineExecutionStrategy) {
            this(operatorFactory, layout, context, Optional.empty(), pipelineExecutionStrategy);
        }

        public PhysicalOperation(OperatorFactory operatorFactory, Map<Symbol, Integer> layout, LocalExecutionPlanContext context, PhysicalOperation source) {
            this(operatorFactory, layout, context, Optional.of(Objects.requireNonNull(source, "source is null")), source.getPipelineExecutionStrategy());
        }

        private PhysicalOperation(OperatorFactory operatorFactory, Map<Symbol, Integer> layout, LocalExecutionPlanContext context, Optional<PhysicalOperation> source, PipelineExecutionStrategy pipelineExecutionStrategy) {
            Objects.requireNonNull(operatorFactory, "operatorFactory is null");
            Objects.requireNonNull(layout, "layout is null");
            Objects.requireNonNull(context, "context is null");
            Objects.requireNonNull(source, "source is null");
            Objects.requireNonNull(pipelineExecutionStrategy, "pipelineExecutionStrategy is null");
            this.operatorFactories = ImmutableList.builder().addAll((Iterable)source.map(PhysicalOperation::getOperatorFactories).orElse((List)ImmutableList.of())).add((Object)operatorFactory).build();
            this.layout = ImmutableMap.copyOf(layout);
            this.types = PhysicalOperation.toTypes(layout, context);
            this.pipelineExecutionStrategy = pipelineExecutionStrategy;
        }

        private static List<Type> toTypes(Map<Symbol, Integer> layout, LocalExecutionPlanContext context) {
            int channelCount = layout.values().stream().mapToInt(Integer::intValue).max().orElse(-1) + 1;
            Preconditions.checkArgument((layout.size() == channelCount && ImmutableSet.copyOf(layout.values()).containsAll((Collection)ContiguousSet.create((Range)Range.closedOpen((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(channelCount)), (DiscreteDomain)DiscreteDomain.integers())) ? 1 : 0) != 0, (String)"Layout does not have a symbol for every output channel: %s", layout);
            ImmutableBiMap channelLayout = ImmutableBiMap.copyOf(layout).inverse();
            return (List)IntStream.range(0, channelCount).mapToObj(((Map)channelLayout)::get).map(context.getTypes()::get).collect(ImmutableList.toImmutableList());
        }

        public int symbolToChannel(Symbol input) {
            Preconditions.checkArgument((boolean)this.layout.containsKey(input));
            return this.layout.get(input);
        }

        public List<Type> getTypes() {
            return this.types;
        }

        public Map<Symbol, Integer> getLayout() {
            return this.layout;
        }

        private List<OperatorFactory> getOperatorFactories() {
            return this.operatorFactories;
        }

        public PipelineExecutionStrategy getPipelineExecutionStrategy() {
            return this.pipelineExecutionStrategy;
        }
    }

    private class Visitor
    extends PlanVisitor<PhysicalOperation, LocalExecutionPlanContext> {
        private final Session session;
        private final boolean groupEnumerable;

        private Visitor(Session session, boolean groupEnumerable) {
            this.session = session;
            this.groupEnumerable = groupEnumerable;
        }

        @Override
        public PhysicalOperation visitRemoteSource(RemoteSourceNode node, LocalExecutionPlanContext context) {
            if (!context.getDriverInstanceCount().isPresent()) {
                context.setDriverInstanceCount(SystemSessionProperties.getTaskConcurrency(this.session));
            }
            ExchangeOperator.ExchangeOperatorFactory operatorFactory = new ExchangeOperator.ExchangeOperatorFactory(context.getNextOperatorId(), node.getId(), LocalExecutionPlanner.this.exchangeClientSupplier, new PagesSerdeFactory(LocalExecutionPlanner.this.blockEncodingSerde, SystemSessionProperties.isExchangeCompressionEnabled(this.session)));
            return new PhysicalOperation((OperatorFactory)operatorFactory, (Map<Symbol, Integer>)this.makeLayout(node), context, PipelineExecutionStrategy.UNGROUPED_EXECUTION);
        }

        @Override
        public PhysicalOperation visitExplainAnalyze(ExplainAnalyzeNode node, LocalExecutionPlanContext context) {
            Preconditions.checkState((boolean)LocalExecutionPlanner.this.queryPerformanceFetcher.isPresent(), (Object)"ExplainAnalyze can only run on coordinator");
            PhysicalOperation source = node.getSource().accept(this, context);
            ExplainAnalyzeOperator.ExplainAnalyzeOperatorFactory operatorFactory = new ExplainAnalyzeOperator.ExplainAnalyzeOperatorFactory(context.getNextOperatorId(), node.getId(), (QueryPerformanceFetcher)LocalExecutionPlanner.this.queryPerformanceFetcher.get(), LocalExecutionPlanner.this.metadata.getFunctionRegistry(), LocalExecutionPlanner.this.statsCalculator, LocalExecutionPlanner.this.costCalculator, node.isVerbose());
            return new PhysicalOperation((OperatorFactory)operatorFactory, (Map<Symbol, Integer>)this.makeLayout(node), context, source);
        }

        @Override
        public PhysicalOperation visitOutput(OutputNode node, LocalExecutionPlanContext context) {
            return node.getSource().accept(this, context);
        }

        @Override
        public PhysicalOperation visitRowNumber(RowNumberNode node, LocalExecutionPlanContext context) {
            PhysicalOperation source = node.getSource().accept(this, context);
            List<Symbol> partitionBySymbols = node.getPartitionBy();
            List partitionChannels = LocalExecutionPlanner.getChannelsForSymbols(partitionBySymbols, source.getLayout());
            List partitionTypes = (List)partitionChannels.stream().map(channel -> source.getTypes().get((int)channel)).collect(ImmutableList.toImmutableList());
            ImmutableList.Builder outputChannels = ImmutableList.builder();
            for (int i = 0; i < source.getTypes().size(); ++i) {
                outputChannels.add((Object)i);
            }
            ImmutableMap.Builder outputMappings = ImmutableMap.builder();
            outputMappings.putAll(source.getLayout());
            int channel2 = source.getTypes().size();
            outputMappings.put((Object)node.getRowNumberSymbol(), (Object)channel2);
            Optional<Integer> hashChannel = node.getHashSymbol().map(LocalExecutionPlanner.channelGetter(source));
            RowNumberOperator.RowNumberOperatorFactory operatorFactory = new RowNumberOperator.RowNumberOperatorFactory(context.getNextOperatorId(), node.getId(), source.getTypes(), (List<Integer>)outputChannels.build(), partitionChannels, partitionTypes, node.getMaxRowCountPerPartition(), hashChannel, 10000, LocalExecutionPlanner.this.joinCompiler);
            return new PhysicalOperation((OperatorFactory)operatorFactory, (Map<Symbol, Integer>)outputMappings.build(), context, source);
        }

        @Override
        public PhysicalOperation visitTopNRowNumber(TopNRowNumberNode node, LocalExecutionPlanContext context) {
            PhysicalOperation source = node.getSource().accept(this, context);
            List<Symbol> partitionBySymbols = node.getPartitionBy();
            List partitionChannels = LocalExecutionPlanner.getChannelsForSymbols(partitionBySymbols, source.getLayout());
            List partitionTypes = (List)partitionChannels.stream().map(channel -> source.getTypes().get((int)channel)).collect(ImmutableList.toImmutableList());
            List<Symbol> orderBySymbols = node.getOrderingScheme().getOrderBy();
            List sortChannels = LocalExecutionPlanner.getChannelsForSymbols(orderBySymbols, source.getLayout());
            List sortOrder = (List)orderBySymbols.stream().map(symbol -> node.getOrderingScheme().getOrdering((Symbol)symbol)).collect(ImmutableList.toImmutableList());
            ImmutableList.Builder outputChannels = ImmutableList.builder();
            for (int i = 0; i < source.getTypes().size(); ++i) {
                outputChannels.add((Object)i);
            }
            ImmutableMap.Builder outputMappings = ImmutableMap.builder();
            outputMappings.putAll(source.getLayout());
            if (!node.isPartial() || !partitionChannels.isEmpty()) {
                int channel2 = source.getTypes().size();
                outputMappings.put((Object)node.getRowNumberSymbol(), (Object)channel2);
            }
            Optional<Integer> hashChannel = node.getHashSymbol().map(LocalExecutionPlanner.channelGetter(source));
            TopNRowNumberOperator.TopNRowNumberOperatorFactory operatorFactory = new TopNRowNumberOperator.TopNRowNumberOperatorFactory(context.getNextOperatorId(), node.getId(), source.getTypes(), (List<Integer>)outputChannels.build(), partitionChannels, partitionTypes, sortChannels, sortOrder, node.getMaxRowCountPerPartition(), node.isPartial(), hashChannel, 1000, LocalExecutionPlanner.this.joinCompiler);
            return new PhysicalOperation((OperatorFactory)operatorFactory, (Map<Symbol, Integer>)this.makeLayout(node), context, source);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public PhysicalOperation visitWindow(WindowNode node, LocalExecutionPlanContext context) {
            PhysicalOperation source = node.getSource().accept(this, context);
            List<Symbol> partitionBySymbols = node.getPartitionBy();
            ImmutableList partitionChannels = ImmutableList.copyOf((Collection)LocalExecutionPlanner.getChannelsForSymbols(partitionBySymbols, source.getLayout()));
            ImmutableList preGroupedChannels = ImmutableList.copyOf((Collection)LocalExecutionPlanner.getChannelsForSymbols((List)ImmutableList.copyOf(node.getPrePartitionedInputs()), source.getLayout()));
            Object sortChannels = ImmutableList.of();
            Object sortOrder = ImmutableList.of();
            if (node.getOrderingScheme().isPresent()) {
                OrderingScheme orderingScheme = node.getOrderingScheme().get();
                sortChannels = LocalExecutionPlanner.getChannelsForSymbols(orderingScheme.getOrderBy(), source.getLayout());
                sortOrder = orderingScheme.getOrderingList();
            }
            ImmutableList.Builder outputChannels = ImmutableList.builder();
            for (int i = 0; i < source.getTypes().size(); ++i) {
                outputChannels.add((Object)i);
            }
            ImmutableList.Builder windowFunctionsBuilder = ImmutableList.builder();
            ImmutableList.Builder windowFunctionOutputSymbolsBuilder = ImmutableList.builder();
            for (Map.Entry<Symbol, WindowNode.Function> entry : node.getWindowFunctions().entrySet()) {
                void var15_17;
                Optional<Integer> frameStartChannel = Optional.empty();
                Optional optional = Optional.empty();
                WindowNode.Frame frame = entry.getValue().getFrame();
                if (frame.getStartValue().isPresent()) {
                    frameStartChannel = Optional.of(source.getLayout().get(frame.getStartValue().get()));
                }
                if (frame.getEndValue().isPresent()) {
                    Optional<Integer> optional2 = Optional.of(source.getLayout().get(frame.getEndValue().get()));
                }
                FrameInfo frameInfo = new FrameInfo(frame.getType(), frame.getStartType(), frameStartChannel, frame.getEndType(), (Optional<Integer>)var15_17);
                FunctionCall functionCall = entry.getValue().getFunctionCall();
                Signature signature = entry.getValue().getSignature();
                ImmutableList.Builder arguments = ImmutableList.builder();
                for (Expression argument : functionCall.getArguments()) {
                    Symbol argumentSymbol = Symbol.from(argument);
                    arguments.add((Object)source.getLayout().get(argumentSymbol));
                }
                Symbol symbol = entry.getKey();
                WindowFunctionSupplier windowFunctionSupplier = LocalExecutionPlanner.this.metadata.getFunctionRegistry().getWindowFunctionImplementation(signature);
                Type type = LocalExecutionPlanner.this.metadata.getType(signature.getReturnType());
                windowFunctionsBuilder.add((Object)WindowFunctionDefinition.window(windowFunctionSupplier, type, frameInfo, (List<Integer>)arguments.build()));
                windowFunctionOutputSymbolsBuilder.add((Object)symbol);
            }
            ImmutableList windowFunctionOutputSymbols = windowFunctionOutputSymbolsBuilder.build();
            ImmutableMap.Builder outputMappings = ImmutableMap.builder();
            for (Symbol symbol : node.getSource().getOutputSymbols()) {
                outputMappings.put((Object)symbol, (Object)source.getLayout().get(symbol));
            }
            int channel = source.getTypes().size();
            for (Symbol symbol : windowFunctionOutputSymbols) {
                outputMappings.put((Object)symbol, (Object)channel);
                ++channel;
            }
            WindowOperator.WindowOperatorFactory windowOperatorFactory = new WindowOperator.WindowOperatorFactory(context.getNextOperatorId(), node.getId(), source.getTypes(), (List<Integer>)outputChannels.build(), (List<WindowFunctionDefinition>)windowFunctionsBuilder.build(), (List<Integer>)partitionChannels, (List<Integer>)preGroupedChannels, (List<Integer>)sortChannels, (List<SortOrder>)sortOrder, node.getPreSortedOrderPrefix(), 10000, LocalExecutionPlanner.this.pagesIndexFactory);
            return new PhysicalOperation((OperatorFactory)windowOperatorFactory, (Map<Symbol, Integer>)outputMappings.build(), context, source);
        }

        @Override
        public PhysicalOperation visitTopN(TopNNode node, LocalExecutionPlanContext context) {
            PhysicalOperation source = node.getSource().accept(this, context);
            List<Symbol> orderBySymbols = node.getOrderingScheme().getOrderBy();
            ArrayList<Integer> sortChannels = new ArrayList<Integer>();
            ArrayList<SortOrder> sortOrders = new ArrayList<SortOrder>();
            for (Symbol symbol : orderBySymbols) {
                sortChannels.add(source.getLayout().get(symbol));
                sortOrders.add(node.getOrderingScheme().getOrdering(symbol));
            }
            TopNOperator.TopNOperatorFactory operator = new TopNOperator.TopNOperatorFactory(context.getNextOperatorId(), node.getId(), source.getTypes(), (int)node.getCount(), sortChannels, sortOrders);
            return new PhysicalOperation((OperatorFactory)operator, source.getLayout(), context, source);
        }

        @Override
        public PhysicalOperation visitSort(SortNode node, LocalExecutionPlanContext context) {
            PhysicalOperation source = node.getSource().accept(this, context);
            List<Symbol> orderBySymbols = node.getOrderingScheme().getOrderBy();
            List orderByChannels = LocalExecutionPlanner.getChannelsForSymbols(orderBySymbols, source.getLayout());
            ImmutableList.Builder sortOrder = ImmutableList.builder();
            for (Symbol symbol : orderBySymbols) {
                sortOrder.add((Object)node.getOrderingScheme().getOrdering(symbol));
            }
            ImmutableList.Builder outputChannels = ImmutableList.builder();
            for (int i = 0; i < source.getTypes().size(); ++i) {
                outputChannels.add((Object)i);
            }
            OrderByOperator.OrderByOperatorFactory operator = new OrderByOperator.OrderByOperatorFactory(context.getNextOperatorId(), node.getId(), source.getTypes(), (List<Integer>)outputChannels.build(), 10000, orderByChannels, (List<SortOrder>)sortOrder.build(), LocalExecutionPlanner.this.pagesIndexFactory);
            return new PhysicalOperation((OperatorFactory)operator, source.getLayout(), context, source);
        }

        @Override
        public PhysicalOperation visitLimit(LimitNode node, LocalExecutionPlanContext context) {
            PhysicalOperation source = node.getSource().accept(this, context);
            LimitOperator.LimitOperatorFactory operatorFactory = new LimitOperator.LimitOperatorFactory(context.getNextOperatorId(), node.getId(), node.getCount());
            return new PhysicalOperation((OperatorFactory)operatorFactory, source.getLayout(), context, source);
        }

        @Override
        public PhysicalOperation visitDistinctLimit(DistinctLimitNode node, LocalExecutionPlanContext context) {
            PhysicalOperation source = node.getSource().accept(this, context);
            Optional<Integer> hashChannel = node.getHashSymbol().map(LocalExecutionPlanner.channelGetter(source));
            List distinctChannels = LocalExecutionPlanner.getChannelsForSymbols(node.getDistinctSymbols(), source.getLayout());
            DistinctLimitOperator.DistinctLimitOperatorFactory operatorFactory = new DistinctLimitOperator.DistinctLimitOperatorFactory(context.getNextOperatorId(), node.getId(), source.getTypes(), distinctChannels, node.getLimit(), hashChannel, LocalExecutionPlanner.this.joinCompiler);
            return new PhysicalOperation((OperatorFactory)operatorFactory, (Map<Symbol, Integer>)this.makeLayout(node), context, source);
        }

        @Override
        public PhysicalOperation visitGroupId(GroupIdNode node, LocalExecutionPlanContext context) {
            PhysicalOperation source = node.getSource().accept(this, context);
            HashMap<Symbol, Integer> newLayout = new HashMap<Symbol, Integer>();
            ImmutableList.Builder outputTypes = ImmutableList.builder();
            int outputChannel = 0;
            for (Object output : node.getGroupingSets().stream().flatMap(Collection::stream).collect(Collectors.toSet())) {
                newLayout.put((Symbol)output, outputChannel++);
                outputTypes.add((Object)source.getTypes().get(source.getLayout().get(node.getGroupingSetMappings().get(output))));
            }
            HashMap<Symbol, Integer> argumentMappings = new HashMap<Symbol, Integer>();
            for (Symbol symbol : node.getArgumentMappings().keySet()) {
                int n = source.getLayout().get(node.getArgumentMappings().get(symbol));
                newLayout.put(symbol, outputChannel++);
                outputTypes.add((Object)source.getTypes().get(n));
                argumentMappings.put(symbol, n);
            }
            ImmutableList.Builder mappings = ImmutableList.builder();
            for (List<Symbol> list : node.getGroupingSets()) {
                ImmutableMap.Builder setMapping = ImmutableMap.builder();
                for (Symbol output : list) {
                    setMapping.put(newLayout.get(output), (Object)source.getLayout().get(node.getGroupingSetMappings().get(output)));
                }
                for (Symbol output : argumentMappings.keySet()) {
                    setMapping.put(newLayout.get(output), argumentMappings.get(output));
                }
                mappings.add((Object)setMapping.build());
            }
            newLayout.put(node.getGroupIdSymbol(), outputChannel);
            outputTypes.add((Object)BigintType.BIGINT);
            GroupIdOperator.GroupIdOperatorFactory groupIdOperatorFactory = new GroupIdOperator.GroupIdOperatorFactory(context.getNextOperatorId(), node.getId(), (List<? extends Type>)outputTypes.build(), (List<Map<Integer, Integer>>)mappings.build());
            return new PhysicalOperation((OperatorFactory)groupIdOperatorFactory, newLayout, context, source);
        }

        @Override
        public PhysicalOperation visitAggregation(AggregationNode node, LocalExecutionPlanContext context) {
            PhysicalOperation source = node.getSource().accept(this, context);
            if (node.getGroupingKeys().isEmpty()) {
                return this.planGlobalAggregation(node, source, context);
            }
            boolean spillEnabled = SystemSessionProperties.isSpillEnabled(context.getSession());
            DataSize unspillMemoryLimit = SystemSessionProperties.getAggregationOperatorUnspillMemoryLimit(context.getSession());
            return this.planGroupByAggregation(node, source, spillEnabled, unspillMemoryLimit, context);
        }

        @Override
        public PhysicalOperation visitMarkDistinct(MarkDistinctNode node, LocalExecutionPlanContext context) {
            PhysicalOperation source = node.getSource().accept(this, context);
            List channels = LocalExecutionPlanner.getChannelsForSymbols(node.getDistinctSymbols(), source.getLayout());
            Optional<Integer> hashChannel = node.getHashSymbol().map(LocalExecutionPlanner.channelGetter(source));
            MarkDistinctOperator.MarkDistinctOperatorFactory operator = new MarkDistinctOperator.MarkDistinctOperatorFactory(context.getNextOperatorId(), node.getId(), source.getTypes(), channels, hashChannel, LocalExecutionPlanner.this.joinCompiler);
            return new PhysicalOperation((OperatorFactory)operator, (Map<Symbol, Integer>)this.makeLayout(node), context, source);
        }

        @Override
        public PhysicalOperation visitSample(SampleNode node, LocalExecutionPlanContext context) {
            if (node.getSampleType() == SampleNode.Type.SYSTEM) {
                return node.getSource().accept(this, context);
            }
            throw new UnsupportedOperationException("not yet implemented: " + node);
        }

        @Override
        public PhysicalOperation visitFilter(FilterNode node, LocalExecutionPlanContext context) {
            PlanNode sourceNode = node.getSource();
            Expression filterExpression = node.getPredicate();
            List<Symbol> outputSymbols = node.getOutputSymbols();
            return this.visitScanFilterAndProject(context, node.getId(), sourceNode, Optional.of(filterExpression), Assignments.identity(outputSymbols), outputSymbols);
        }

        @Override
        public PhysicalOperation visitProject(ProjectNode node, LocalExecutionPlanContext context) {
            PlanNode sourceNode;
            Optional<Expression> filterExpression = Optional.empty();
            if (node.getSource() instanceof FilterNode) {
                FilterNode filterNode = (FilterNode)node.getSource();
                sourceNode = filterNode.getSource();
                filterExpression = Optional.of(filterNode.getPredicate());
            } else {
                sourceNode = node.getSource();
            }
            List<Symbol> outputSymbols = node.getOutputSymbols();
            return this.visitScanFilterAndProject(context, node.getId(), sourceNode, filterExpression, node.getAssignments(), outputSymbols);
        }

        private PhysicalOperation visitScanFilterAndProject(LocalExecutionPlanContext context, PlanNodeId planNodeId, PlanNode sourceNode, Optional<Expression> filterExpression, Assignments assignments, List<Symbol> outputSymbols) {
            Map<Object, Object> sourceTypes;
            LinkedHashMap<Symbol, Integer> sourceLayout;
            ArrayList<ColumnHandle> columns = null;
            PhysicalOperation source = null;
            if (sourceNode instanceof TableScanNode) {
                TableScanNode tableScanNode = (TableScanNode)sourceNode;
                sourceLayout = new LinkedHashMap();
                sourceTypes = new LinkedHashMap();
                columns = new ArrayList<ColumnHandle>();
                int channel = 0;
                for (Symbol symbol : tableScanNode.getOutputSymbols()) {
                    columns.add(tableScanNode.getAssignments().get(symbol));
                    Integer input = channel;
                    sourceLayout.put(symbol, input);
                    Type type = Objects.requireNonNull(context.getTypes().get(symbol), String.format("No type for symbol %s", symbol));
                    sourceTypes.put(input, type);
                    ++channel;
                }
            } else {
                source = sourceNode.accept(this, context);
                sourceLayout = source.getLayout();
                sourceTypes = this.getInputTypes(source.getLayout(), source.getTypes());
            }
            ImmutableMap.Builder outputMappingsBuilder = ImmutableMap.builder();
            for (int i = 0; i < outputSymbols.size(); ++i) {
                Symbol symbol = outputSymbols.get(i);
                outputMappingsBuilder.put((Object)symbol, (Object)i);
            }
            ImmutableMap outputMappings = outputMappingsBuilder.build();
            SymbolToInputRewriter symbolToInputRewriter = new SymbolToInputRewriter(sourceLayout);
            Optional<Expression> rewrittenFilter = filterExpression.map(symbolToInputRewriter::rewrite);
            ArrayList<Expression> rewrittenProjections = new ArrayList<Expression>();
            for (Symbol symbol : outputSymbols) {
                rewrittenProjections.add(symbolToInputRewriter.rewrite(assignments.get(symbol)));
            }
            Map<NodeRef<Expression>, Type> expressionTypes = ExpressionAnalyzer.getExpressionTypesFromInput(context.getSession(), LocalExecutionPlanner.this.metadata, LocalExecutionPlanner.this.sqlParser, sourceTypes, Iterables.concat((Iterable)((Iterable)rewrittenFilter.map(ImmutableList::of).orElse(ImmutableList.of())), rewrittenProjections), Collections.emptyList());
            Optional<RowExpression> translatedFilter = rewrittenFilter.map(filter -> this.toRowExpression((Expression)filter, expressionTypes));
            List translatedProjections = (List)rewrittenProjections.stream().map(expression -> this.toRowExpression((Expression)expression, expressionTypes)).collect(ImmutableList.toImmutableList());
            try {
                if (columns != null) {
                    Supplier<CursorProcessor> cursorProcessor = LocalExecutionPlanner.this.expressionCompiler.compileCursorProcessor(translatedFilter, translatedProjections, sourceNode.getId());
                    Supplier<PageProcessor> pageProcessor = LocalExecutionPlanner.this.expressionCompiler.compilePageProcessor(translatedFilter, translatedProjections, Optional.of(context.getStageId() + "_" + planNodeId));
                    ScanFilterAndProjectOperator.ScanFilterAndProjectOperatorFactory operatorFactory = new ScanFilterAndProjectOperator.ScanFilterAndProjectOperatorFactory(context.getNextOperatorId(), planNodeId, sourceNode.getId(), LocalExecutionPlanner.this.pageSourceProvider, cursorProcessor, pageProcessor, columns, LocalExecutionPlanner.getTypes(rewrittenProjections, expressionTypes), SystemSessionProperties.getFilterAndProjectMinOutputPageSize(this.session), SystemSessionProperties.getFilterAndProjectMinOutputPageRowCount(this.session));
                    return new PhysicalOperation((OperatorFactory)operatorFactory, (Map<Symbol, Integer>)outputMappings, context, this.groupEnumerable ? PipelineExecutionStrategy.GROUPED_EXECUTION : PipelineExecutionStrategy.UNGROUPED_EXECUTION);
                }
                Supplier<PageProcessor> pageProcessor = LocalExecutionPlanner.this.expressionCompiler.compilePageProcessor(translatedFilter, translatedProjections, Optional.of(context.getStageId() + "_" + planNodeId));
                FilterAndProjectOperator.FilterAndProjectOperatorFactory operatorFactory = new FilterAndProjectOperator.FilterAndProjectOperatorFactory(context.getNextOperatorId(), planNodeId, pageProcessor, LocalExecutionPlanner.getTypes(rewrittenProjections, expressionTypes), SystemSessionProperties.getFilterAndProjectMinOutputPageSize(this.session), SystemSessionProperties.getFilterAndProjectMinOutputPageRowCount(this.session));
                return new PhysicalOperation((OperatorFactory)operatorFactory, (Map<Symbol, Integer>)outputMappings, context, source);
            }
            catch (RuntimeException e) {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.COMPILER_ERROR, "Compiler failed", (Throwable)e);
            }
        }

        private RowExpression toRowExpression(Expression expression, Map<NodeRef<Expression>, Type> types) {
            return SqlToRowExpressionTranslator.translate(expression, FunctionKind.SCALAR, types, LocalExecutionPlanner.this.metadata.getFunctionRegistry(), LocalExecutionPlanner.this.metadata.getTypeManager(), this.session, true);
        }

        private Map<Integer, Type> getInputTypes(Map<Symbol, Integer> layout, List<Type> types) {
            ImmutableMap.Builder inputTypes = ImmutableMap.builder();
            for (Integer input : ImmutableSet.copyOf(layout.values())) {
                Type type = types.get(input);
                inputTypes.put((Object)input, (Object)type);
            }
            return inputTypes.build();
        }

        @Override
        public PhysicalOperation visitTableScan(TableScanNode node, LocalExecutionPlanContext context) {
            ArrayList<ColumnHandle> columns = new ArrayList<ColumnHandle>();
            for (Symbol symbol : node.getOutputSymbols()) {
                columns.add(node.getAssignments().get(symbol));
            }
            TableScanOperator.TableScanOperatorFactory operatorFactory = new TableScanOperator.TableScanOperatorFactory(context.getNextOperatorId(), node.getId(), LocalExecutionPlanner.this.pageSourceProvider, columns);
            return new PhysicalOperation((OperatorFactory)operatorFactory, (Map<Symbol, Integer>)this.makeLayout(node), context, this.groupEnumerable ? PipelineExecutionStrategy.GROUPED_EXECUTION : PipelineExecutionStrategy.UNGROUPED_EXECUTION);
        }

        @Override
        public PhysicalOperation visitValues(ValuesNode node, LocalExecutionPlanContext context) {
            context.setDriverInstanceCount(1);
            if (node.getRows().isEmpty()) {
                ValuesOperator.ValuesOperatorFactory operatorFactory = new ValuesOperator.ValuesOperatorFactory(context.getNextOperatorId(), node.getId(), (List<Page>)ImmutableList.of());
                return new PhysicalOperation((OperatorFactory)operatorFactory, (Map<Symbol, Integer>)this.makeLayout(node), context, PipelineExecutionStrategy.UNGROUPED_EXECUTION);
            }
            List<Type> outputTypes = this.getSymbolTypes(node.getOutputSymbols(), context.getTypes());
            PageBuilder pageBuilder = new PageBuilder(node.getRows().size(), outputTypes);
            for (List<Expression> row : node.getRows()) {
                pageBuilder.declarePosition();
                Map<NodeRef<Expression>, Type> expressionTypes = ExpressionAnalyzer.getExpressionTypes(context.getSession(), LocalExecutionPlanner.this.metadata, LocalExecutionPlanner.this.sqlParser, (Map<Symbol, Type>)ImmutableMap.of(), (Iterable<Expression>)ImmutableList.copyOf(row), Collections.emptyList(), false);
                for (int i = 0; i < row.size(); ++i) {
                    Object result = ExpressionInterpreter.expressionInterpreter(row.get(i), LocalExecutionPlanner.this.metadata, context.getSession(), expressionTypes).evaluate();
                    TypeUtils.writeNativeValue((Type)outputTypes.get(i), (BlockBuilder)pageBuilder.getBlockBuilder(i), (Object)result);
                }
            }
            ValuesOperator.ValuesOperatorFactory operatorFactory = new ValuesOperator.ValuesOperatorFactory(context.getNextOperatorId(), node.getId(), (List<Page>)ImmutableList.of((Object)pageBuilder.build()));
            return new PhysicalOperation((OperatorFactory)operatorFactory, (Map<Symbol, Integer>)this.makeLayout(node), context, PipelineExecutionStrategy.UNGROUPED_EXECUTION);
        }

        @Override
        public PhysicalOperation visitUnnest(UnnestNode node, LocalExecutionPlanContext context) {
            PhysicalOperation source = node.getSource().accept(this, context);
            ImmutableList.Builder replicateTypes = ImmutableList.builder();
            for (Symbol symbol : node.getReplicateSymbols()) {
                replicateTypes.add((Object)context.getTypes().get(symbol));
            }
            ImmutableList unnestSymbols = ImmutableList.copyOf(node.getUnnestSymbols().keySet());
            ImmutableList.Builder unnestTypes = ImmutableList.builder();
            for (Symbol symbol : unnestSymbols) {
                unnestTypes.add((Object)context.getTypes().get(symbol));
            }
            Optional<Symbol> ordinalitySymbol = node.getOrdinalitySymbol();
            Optional<Type> ordinalityType = ordinalitySymbol.map(context.getTypes()::get);
            ordinalityType.ifPresent(type -> Preconditions.checkState((boolean)type.equals(BigintType.BIGINT), (Object)"Type of ordinalitySymbol must always be BIGINT."));
            List replicateChannels = LocalExecutionPlanner.getChannelsForSymbols(node.getReplicateSymbols(), source.getLayout());
            List unnestChannels = LocalExecutionPlanner.getChannelsForSymbols((List)unnestSymbols, source.getLayout());
            ImmutableMap.Builder outputMappings = ImmutableMap.builder();
            int channel = 0;
            for (Symbol symbol : node.getReplicateSymbols()) {
                outputMappings.put((Object)symbol, (Object)channel);
                ++channel;
            }
            for (Symbol symbol : unnestSymbols) {
                for (Symbol unnestedSymbol : node.getUnnestSymbols().get(symbol)) {
                    outputMappings.put((Object)unnestedSymbol, (Object)channel);
                    ++channel;
                }
            }
            if (ordinalitySymbol.isPresent()) {
                outputMappings.put((Object)ordinalitySymbol.get(), (Object)channel);
                ++channel;
            }
            UnnestOperator.UnnestOperatorFactory operatorFactory = new UnnestOperator.UnnestOperatorFactory(context.getNextOperatorId(), node.getId(), replicateChannels, (List<Type>)replicateTypes.build(), unnestChannels, (List<Type>)unnestTypes.build(), ordinalityType.isPresent());
            return new PhysicalOperation((OperatorFactory)operatorFactory, (Map<Symbol, Integer>)outputMappings.build(), context, source);
        }

        private ImmutableMap<Symbol, Integer> makeLayout(PlanNode node) {
            ImmutableMap.Builder outputMappings = ImmutableMap.builder();
            int channel = 0;
            for (Symbol symbol : node.getOutputSymbols()) {
                outputMappings.put((Object)symbol, (Object)channel);
                ++channel;
            }
            return outputMappings.build();
        }

        @Override
        public PhysicalOperation visitIndexSource(IndexSourceNode node, LocalExecutionPlanContext context) {
            Preconditions.checkState((boolean)context.getIndexSourceContext().isPresent(), (Object)"Must be in an index source context");
            IndexSourceContext indexSourceContext = context.getIndexSourceContext().get();
            SetMultimap indexLookupToProbeInput = indexSourceContext.getIndexLookupToProbeInput();
            Preconditions.checkState((boolean)indexLookupToProbeInput.keySet().equals(node.getLookupSymbols()));
            ImmutableList lookupSymbolSchema = ImmutableList.copyOf(node.getLookupSymbols());
            ImmutableList.Builder remappedProbeKeyChannelsBuilder = ImmutableList.builder();
            ImmutableList.Builder overlappingFieldSetsBuilder = ImmutableList.builder();
            for (Symbol lookupSymbol : lookupSymbolSchema) {
                Set potentialProbeInputs = indexLookupToProbeInput.get((Object)lookupSymbol);
                Preconditions.checkState((!potentialProbeInputs.isEmpty() ? 1 : 0) != 0, (Object)"Must have at least one source from the probe input");
                if (potentialProbeInputs.size() > 1) {
                    overlappingFieldSetsBuilder.add(potentialProbeInputs.stream().collect(ImmutableSet.toImmutableSet()));
                }
                remappedProbeKeyChannelsBuilder.add(Iterables.getFirst((Iterable)potentialProbeInputs, null));
            }
            ImmutableList overlappingFieldSets = overlappingFieldSetsBuilder.build();
            ImmutableList remappedProbeKeyChannels = remappedProbeKeyChannelsBuilder.build();
            Function<RecordSet, RecordSet> probeKeyNormalizer = arg_0 -> this.lambda$visitIndexSource$6((List)overlappingFieldSets, (List)remappedProbeKeyChannels, arg_0);
            List lookupSchema = Lists.transform((List)lookupSymbolSchema, (com.google.common.base.Function)Functions.forMap(node.getAssignments()));
            List outputSchema = Lists.transform(node.getOutputSymbols(), (com.google.common.base.Function)Functions.forMap(node.getAssignments()));
            ConnectorIndex index = LocalExecutionPlanner.this.indexManager.getIndex(this.session, node.getIndexHandle(), lookupSchema, outputSchema);
            IndexSourceOperator.IndexSourceOperatorFactory operatorFactory = new IndexSourceOperator.IndexSourceOperatorFactory(context.getNextOperatorId(), node.getId(), index, probeKeyNormalizer);
            return new PhysicalOperation((OperatorFactory)operatorFactory, (Map<Symbol, Integer>)this.makeLayout(node), context, PipelineExecutionStrategy.UNGROUPED_EXECUTION);
        }

        private SetMultimap<Symbol, Integer> mapIndexSourceLookupSymbolToProbeKeyInput(IndexJoinNode node, Map<Symbol, Integer> probeKeyLayout) {
            Set indexJoinSymbols = (Set)node.getCriteria().stream().map(IndexJoinNode.EquiJoinClause::getIndex).collect(ImmutableSet.toImmutableSet());
            Map<Symbol, Symbol> indexKeyTrace = IndexJoinOptimizer.IndexKeyTracer.trace(node.getIndexSource(), indexJoinSymbols);
            HashMultimap indexToProbeKeyInput = HashMultimap.create();
            for (IndexJoinNode.EquiJoinClause clause : node.getCriteria()) {
                indexToProbeKeyInput.put((Object)clause.getIndex(), (Object)probeKeyLayout.get(clause.getProbe()));
            }
            ImmutableSetMultimap.Builder builder = ImmutableSetMultimap.builder();
            for (Map.Entry<Symbol, Symbol> entry : indexKeyTrace.entrySet()) {
                Symbol indexJoinSymbol = entry.getKey();
                Symbol indexLookupSymbol = entry.getValue();
                builder.putAll((Object)indexLookupSymbol, (Iterable)indexToProbeKeyInput.get((Object)indexJoinSymbol));
            }
            return builder.build();
        }

        @Override
        public PhysicalOperation visitIndexJoin(IndexJoinNode node, LocalExecutionPlanContext context) {
            OperatorFactory lookupJoinOperatorFactory;
            List<IndexJoinNode.EquiJoinClause> clauses = node.getCriteria();
            List probeSymbols = Lists.transform(clauses, IndexJoinNode.EquiJoinClause::getProbe);
            List indexSymbols = Lists.transform(clauses, IndexJoinNode.EquiJoinClause::getIndex);
            PhysicalOperation probeSource = node.getProbeSource().accept(this, context);
            List probeChannels = LocalExecutionPlanner.getChannelsForSymbols(probeSymbols, probeSource.getLayout());
            OptionalInt probeHashChannel = node.getProbeHashSymbol().map(LocalExecutionPlanner.channelGetter(probeSource)).map(OptionalInt::of).orElse(OptionalInt.empty());
            HashMap<Symbol, Integer> probeKeyLayout = new HashMap<Symbol, Integer>();
            for (int i = 0; i < probeSymbols.size(); ++i) {
                probeKeyLayout.put((Symbol)probeSymbols.get(i), i);
            }
            SetMultimap<Symbol, Integer> indexLookupToProbeInput = this.mapIndexSourceLookupSymbolToProbeKeyInput(node, probeKeyLayout);
            LocalExecutionPlanContext indexContext = context.createIndexSourceSubContext(new IndexSourceContext(indexLookupToProbeInput));
            PhysicalOperation indexSource = node.getIndexSource().accept(this, indexContext);
            List indexOutputChannels = LocalExecutionPlanner.getChannelsForSymbols(indexSymbols, indexSource.getLayout());
            OptionalInt indexHashChannel = node.getIndexHashSymbol().map(LocalExecutionPlanner.channelGetter(indexSource)).map(OptionalInt::of).orElse(OptionalInt.empty());
            Set<Symbol> indexSymbolsNeededBySource = IndexJoinOptimizer.IndexKeyTracer.trace(node.getIndexSource(), (Set<Symbol>)ImmutableSet.copyOf((Collection)indexSymbols)).keySet();
            Set lookupSourceInputChannels = (Set)node.getCriteria().stream().filter(equiJoinClause -> indexSymbolsNeededBySource.contains(equiJoinClause.getIndex())).map(IndexJoinNode.EquiJoinClause::getProbe).map(probeKeyLayout::get).collect(ImmutableSet.toImmutableSet());
            Optional<DynamicTupleFilterFactory> dynamicTupleFilterFactory = Optional.empty();
            if (lookupSourceInputChannels.size() < probeKeyLayout.values().size()) {
                int[] nonLookupInputChannels = Ints.toArray((Collection)((Collection)node.getCriteria().stream().filter(equiJoinClause -> !indexSymbolsNeededBySource.contains(equiJoinClause.getIndex())).map(IndexJoinNode.EquiJoinClause::getProbe).map(probeKeyLayout::get).collect(ImmutableList.toImmutableList())));
                int[] nonLookupOutputChannels = Ints.toArray((Collection)((Collection)node.getCriteria().stream().filter(equiJoinClause -> !indexSymbolsNeededBySource.contains(equiJoinClause.getIndex())).map(IndexJoinNode.EquiJoinClause::getIndex).map(indexSource.getLayout()::get).collect(ImmutableList.toImmutableList())));
                int filterOperatorId = indexContext.getNextOperatorId();
                dynamicTupleFilterFactory = Optional.of(new DynamicTupleFilterFactory(filterOperatorId, node.getId(), nonLookupInputChannels, nonLookupOutputChannels, indexSource.getTypes(), LocalExecutionPlanner.this.pageFunctionCompiler));
            }
            IndexBuildDriverFactoryProvider indexBuildDriverFactoryProvider = new IndexBuildDriverFactoryProvider(indexContext.getNextPipelineId(), indexContext.getNextOperatorId(), node.getId(), indexContext.isInputDriver(), indexSource.getTypes(), indexSource.getOperatorFactories(), dynamicTupleFilterFactory);
            IndexLookupSourceFactory indexLookupSourceFactory = new IndexLookupSourceFactory(lookupSourceInputChannels, indexOutputChannels, indexHashChannel, indexSource.getTypes(), indexSource.getLayout(), indexBuildDriverFactoryProvider, LocalExecutionPlanner.this.maxIndexMemorySize, LocalExecutionPlanner.this.indexJoinLookupStats, SystemSessionProperties.isShareIndexLoading(this.session), LocalExecutionPlanner.this.pagesIndexFactory, LocalExecutionPlanner.this.joinCompiler);
            Verify.verify((probeSource.getPipelineExecutionStrategy() == PipelineExecutionStrategy.UNGROUPED_EXECUTION ? 1 : 0) != 0);
            Verify.verify((indexSource.getPipelineExecutionStrategy() == PipelineExecutionStrategy.UNGROUPED_EXECUTION ? 1 : 0) != 0);
            JoinBridgeDataManager<LookupSourceFactory> lookupSourceFactoryManager = JoinBridgeDataManager.lookup(PipelineExecutionStrategy.UNGROUPED_EXECUTION, PipelineExecutionStrategy.UNGROUPED_EXECUTION, lifespan -> indexLookupSourceFactory, indexLookupSourceFactory.getOutputTypes());
            ImmutableMap.Builder outputMappings = ImmutableMap.builder();
            outputMappings.putAll(probeSource.getLayout());
            int offset = probeSource.getTypes().size();
            for (Map.Entry<Symbol, Integer> entry : indexSource.getLayout().entrySet()) {
                Integer input = entry.getValue();
                outputMappings.put((Object)entry.getKey(), (Object)(offset + input));
            }
            OptionalInt totalOperatorsCount = this.getJoinOperatorsCountForSpill(context, this.session);
            switch (node.getType()) {
                case INNER: {
                    lookupJoinOperatorFactory = LocalExecutionPlanner.this.lookupJoinOperators.innerJoin(context.getNextOperatorId(), node.getId(), lookupSourceFactoryManager, probeSource.getTypes(), probeChannels, probeHashChannel, Optional.empty(), totalOperatorsCount, LocalExecutionPlanner.this.partitioningSpillerFactory);
                    break;
                }
                case SOURCE_OUTER: {
                    lookupJoinOperatorFactory = LocalExecutionPlanner.this.lookupJoinOperators.probeOuterJoin(context.getNextOperatorId(), node.getId(), lookupSourceFactoryManager, probeSource.getTypes(), probeChannels, probeHashChannel, Optional.empty(), totalOperatorsCount, LocalExecutionPlanner.this.partitioningSpillerFactory);
                    break;
                }
                default: {
                    throw new AssertionError((Object)("Unknown type: " + (Object)((Object)node.getType())));
                }
            }
            return new PhysicalOperation(lookupJoinOperatorFactory, (Map<Symbol, Integer>)outputMappings.build(), context, probeSource);
        }

        @Override
        public PhysicalOperation visitJoin(JoinNode node, LocalExecutionPlanContext context) {
            if (node.isSpatialJoin()) {
                return this.createSpatialJoin(node, context);
            }
            if (node.isCrossJoin()) {
                return this.createNestedLoopJoin(node, context);
            }
            List<JoinNode.EquiJoinClause> clauses = node.getCriteria();
            List leftSymbols = Lists.transform(clauses, JoinNode.EquiJoinClause::getLeft);
            List rightSymbols = Lists.transform(clauses, JoinNode.EquiJoinClause::getRight);
            switch (node.getType()) {
                case INNER: 
                case LEFT: 
                case RIGHT: 
                case FULL: {
                    return this.createLookupJoin(node, node.getLeft(), leftSymbols, node.getLeftHashSymbol(), node.getRight(), rightSymbols, node.getRightHashSymbol(), context);
                }
            }
            throw new UnsupportedOperationException("Unsupported join type: " + (Object)((Object)node.getType()));
        }

        private PhysicalOperation createSpatialJoin(JoinNode node, LocalExecutionPlanContext context) {
            Verify.verify((node.getFilter().isPresent() && node.getCriteria().isEmpty() ? 1 : 0) != 0);
            Expression filterExpression = node.getFilter().get();
            List<FunctionCall> spatialFunctions = SpatialJoinUtils.extractSupportedSpatialFunctions(filterExpression);
            for (FunctionCall spatialFunction : spatialFunctions) {
                Optional<PhysicalOperation> operation = this.tryCreateSpatialJoin(context, node, this.removeExpressionFromFilter(filterExpression, (Expression)spatialFunction), spatialFunction, Optional.empty(), Optional.empty());
                if (!operation.isPresent()) continue;
                return operation.get();
            }
            List<ComparisonExpression> spatialComparisons = SpatialJoinUtils.extractSupportedSpatialComparisons(filterExpression);
            for (ComparisonExpression spatialComparison : spatialComparisons) {
                Expression radius;
                if (spatialComparison.getType() != ComparisonExpressionType.LESS_THAN && spatialComparison.getType() != ComparisonExpressionType.LESS_THAN_OR_EQUAL || !((radius = spatialComparison.getRight()) instanceof SymbolReference) || !this.getSymbolReferences(node.getRight().getOutputSymbols()).contains(radius)) continue;
                FunctionCall spatialFunction = (FunctionCall)spatialComparison.getLeft();
                Optional<PhysicalOperation> operation = this.tryCreateSpatialJoin(context, node, this.removeExpressionFromFilter(filterExpression, (Expression)spatialComparison), spatialFunction, Optional.of(radius), Optional.of(spatialComparison.getType()));
                if (!operation.isPresent()) continue;
                return operation.get();
            }
            throw new VerifyException("No valid spatial relationship found for spatial join");
        }

        private Optional<PhysicalOperation> tryCreateSpatialJoin(LocalExecutionPlanContext context, JoinNode node, Optional<Expression> filterExpression, FunctionCall spatialFunction, Optional<Expression> radius, Optional<ComparisonExpressionType> comparisonType) {
            List arguments = spatialFunction.getArguments();
            Verify.verify((arguments.size() == 2 ? 1 : 0) != 0);
            if (!(arguments.get(0) instanceof SymbolReference) || !(arguments.get(1) instanceof SymbolReference)) {
                return Optional.empty();
            }
            SymbolReference firstSymbol = (SymbolReference)arguments.get(0);
            SymbolReference secondSymbol = (SymbolReference)arguments.get(1);
            PlanNode probeNode = node.getLeft();
            Set<SymbolReference> probeSymbols = this.getSymbolReferences(probeNode.getOutputSymbols());
            PlanNode buildNode = node.getRight();
            Set<SymbolReference> buildSymbols = this.getSymbolReferences(buildNode.getOutputSymbols());
            if (probeSymbols.contains(firstSymbol) && buildSymbols.contains(secondSymbol)) {
                return Optional.of(this.createSpatialLookupJoin(node, probeNode, Symbol.from((Expression)firstSymbol), buildNode, Symbol.from((Expression)secondSymbol), radius.map(Symbol::from), this.spatialTest(spatialFunction, true, comparisonType), filterExpression, context));
            }
            if (probeSymbols.contains(secondSymbol) && buildSymbols.contains(firstSymbol)) {
                return Optional.of(this.createSpatialLookupJoin(node, probeNode, Symbol.from((Expression)secondSymbol), buildNode, Symbol.from((Expression)firstSymbol), radius.map(Symbol::from), this.spatialTest(spatialFunction, false, comparisonType), filterExpression, context));
            }
            return Optional.empty();
        }

        private Optional<Expression> removeExpressionFromFilter(Expression filter, Expression expression) {
            Expression updatedJoinFilter = ExpressionNodeInliner.replaceExpression(filter, (Map<? extends Expression, ? extends Expression>)ImmutableMap.of((Object)expression, (Object)BooleanLiteral.TRUE_LITERAL));
            return updatedJoinFilter == BooleanLiteral.TRUE_LITERAL ? Optional.empty() : Optional.of(updatedJoinFilter);
        }

        private SpatialIndexBuilderOperator.SpatialPredicate spatialTest(FunctionCall functionCall, boolean probeFirst, Optional<ComparisonExpressionType> comparisonType) {
            switch (functionCall.getName().toString().toLowerCase()) {
                case "st_contains": {
                    if (probeFirst) {
                        return (buildGeometry, probeGeometry, radius) -> probeGeometry.contains(buildGeometry);
                    }
                    return (buildGeometry, probeGeometry, radius) -> buildGeometry.contains(probeGeometry);
                }
                case "st_intersects": {
                    return (buildGeometry, probeGeometry, radius) -> buildGeometry.intersects(probeGeometry);
                }
                case "st_distance": {
                    if (comparisonType.get() == ComparisonExpressionType.LESS_THAN) {
                        return (buildGeometry, probeGeometry, radius) -> buildGeometry.distance(probeGeometry) < radius.getAsDouble();
                    }
                    if (comparisonType.get() == ComparisonExpressionType.LESS_THAN_OR_EQUAL) {
                        return (buildGeometry, probeGeometry, radius) -> buildGeometry.distance(probeGeometry) <= radius.getAsDouble();
                    }
                    throw new UnsupportedOperationException("Unsupported comparison type: " + comparisonType.get());
                }
            }
            throw new UnsupportedOperationException("Unsupported spatial function: " + functionCall.getName());
        }

        private Set<SymbolReference> getSymbolReferences(Collection<Symbol> symbols) {
            return (Set)symbols.stream().map(Symbol::toSymbolReference).collect(ImmutableSet.toImmutableSet());
        }

        private PhysicalOperation createNestedLoopJoin(JoinNode node, LocalExecutionPlanContext context) {
            PhysicalOperation probeSource = node.getLeft().accept(this, context);
            LocalExecutionPlanContext buildContext = context.createSubContext();
            PhysicalOperation buildSource = node.getRight().accept(this, buildContext);
            Preconditions.checkState((buildSource.getPipelineExecutionStrategy() == PipelineExecutionStrategy.UNGROUPED_EXECUTION ? 1 : 0) != 0, (Object)"Build source of a nested loop join is expected to be GROUPED_EXECUTION.");
            JoinBridgeDataManager<NestedLoopJoinPagesBridge> nestedLoopJoinPagesSupplierManager = JoinBridgeDataManager.nestedLoop(probeSource.getPipelineExecutionStrategy(), buildSource.getPipelineExecutionStrategy(), lifespan -> new NestedLoopJoinPagesSupplier(), buildSource.getTypes());
            NestedLoopBuildOperator.NestedLoopBuildOperatorFactory nestedLoopBuildOperatorFactory = new NestedLoopBuildOperator.NestedLoopBuildOperatorFactory(buildContext.getNextOperatorId(), node.getId(), nestedLoopJoinPagesSupplierManager);
            Preconditions.checkArgument((buildContext.getDriverInstanceCount().orElse(1) == 1 ? 1 : 0) != 0, (Object)"Expected local execution to not be parallel");
            context.addDriverFactory(buildContext.isInputDriver(), false, (List<OperatorFactory>)ImmutableList.builder().addAll((Iterable)buildSource.getOperatorFactories()).add((Object)nestedLoopBuildOperatorFactory).build(), buildContext.getDriverInstanceCount(), buildSource.getPipelineExecutionStrategy());
            ImmutableMap.Builder outputMappings = ImmutableMap.builder();
            outputMappings.putAll(probeSource.getLayout());
            int offset = probeSource.getTypes().size();
            for (Map.Entry<Symbol, Integer> entry : buildSource.getLayout().entrySet()) {
                outputMappings.put((Object)entry.getKey(), (Object)(offset + entry.getValue()));
            }
            NestedLoopJoinOperator.NestedLoopJoinOperatorFactory operatorFactory = new NestedLoopJoinOperator.NestedLoopJoinOperatorFactory(context.getNextOperatorId(), node.getId(), nestedLoopJoinPagesSupplierManager);
            return new PhysicalOperation((OperatorFactory)operatorFactory, (Map<Symbol, Integer>)outputMappings.build(), context, probeSource);
        }

        private PhysicalOperation createSpatialLookupJoin(JoinNode node, PlanNode probeNode, Symbol probeSymbol, PlanNode buildNode, Symbol buildSymbol, Optional<Symbol> radiusSymbol, SpatialIndexBuilderOperator.SpatialPredicate spatialRelationshipTest, Optional<Expression> joinFilter, LocalExecutionPlanContext context) {
            PhysicalOperation probeSource = probeNode.accept(this, context);
            PagesSpatialIndexFactory pagesSpatialIndexFactory = this.createPagesSpatialIndexFactory(node, buildNode, buildSymbol, radiusSymbol, probeSource.getLayout(), spatialRelationshipTest, joinFilter, context);
            OperatorFactory operator = this.createSpatialLookupJoin(node, probeNode, probeSource, probeSymbol, pagesSpatialIndexFactory, context);
            ImmutableMap.Builder outputMappings = ImmutableMap.builder();
            List<Symbol> outputSymbols = node.getOutputSymbols();
            for (int i = 0; i < outputSymbols.size(); ++i) {
                Symbol symbol = outputSymbols.get(i);
                outputMappings.put((Object)symbol, (Object)i);
            }
            return new PhysicalOperation(operator, (Map<Symbol, Integer>)outputMappings.build(), context, probeSource);
        }

        private OperatorFactory createSpatialLookupJoin(JoinNode node, PlanNode probeNode, PhysicalOperation probeSource, Symbol probeSymbol, PagesSpatialIndexFactory pagesSpatialIndexFactory, LocalExecutionPlanContext context) {
            List<Type> probeTypes = probeSource.getTypes();
            List probeOutputSymbols = (List)node.getOutputSymbols().stream().filter(symbol -> probeNode.getOutputSymbols().contains(symbol)).collect(ImmutableList.toImmutableList());
            ImmutableList probeOutputChannels = ImmutableList.copyOf((Collection)LocalExecutionPlanner.getChannelsForSymbols(probeOutputSymbols, probeSource.getLayout()));
            Integer probeChannel = (Integer)LocalExecutionPlanner.channelGetter(probeSource).apply(probeSymbol);
            return new SpatialJoinOperator.SpatialJoinOperatorFactory(context.getNextOperatorId(), node.getId(), node.getType(), probeTypes, (List<Integer>)probeOutputChannels, probeChannel, pagesSpatialIndexFactory);
        }

        private PagesSpatialIndexFactory createPagesSpatialIndexFactory(JoinNode node, PlanNode buildNode, Symbol buildSymbol, Optional<Symbol> radiusSymbol, Map<Symbol, Integer> probeLayout, SpatialIndexBuilderOperator.SpatialPredicate spatialRelationshipTest, Optional<Expression> joinFilter, LocalExecutionPlanContext context) {
            LocalExecutionPlanContext buildContext = context.createSubContext();
            PhysicalOperation buildSource = buildNode.accept(this, buildContext);
            List buildOutputSymbols = (List)node.getOutputSymbols().stream().filter(symbol -> buildNode.getOutputSymbols().contains(symbol)).collect(ImmutableList.toImmutableList());
            Map<Symbol, Integer> buildLayout = buildSource.getLayout();
            ImmutableList buildOutputChannels = ImmutableList.copyOf((Collection)LocalExecutionPlanner.getChannelsForSymbols(buildOutputSymbols, buildLayout));
            Function buildChannelGetter = LocalExecutionPlanner.channelGetter(buildSource);
            Integer buildChannel = (Integer)buildChannelGetter.apply(buildSymbol);
            Optional<Integer> radiusChannel = radiusSymbol.map(buildChannelGetter::apply);
            Optional<JoinFilterFunctionCompiler.JoinFilterFunctionFactory> filterFunctionFactory = joinFilter.map(filterExpression -> this.compileJoinFilterFunction((Expression)filterExpression, probeLayout, buildLayout, context.getTypes(), context.getSession()));
            SpatialIndexBuilderOperator.SpatialIndexBuilderOperatorFactory builderOperatorFactory = new SpatialIndexBuilderOperator.SpatialIndexBuilderOperatorFactory(buildContext.getNextOperatorId(), node.getId(), buildSource.getTypes(), (List<Integer>)buildOutputChannels, buildChannel, radiusChannel, spatialRelationshipTest, filterFunctionFactory, 10000, LocalExecutionPlanner.this.pagesIndexFactory);
            context.addDriverFactory(buildContext.isInputDriver(), false, (List<OperatorFactory>)ImmutableList.builder().addAll((Iterable)buildSource.getOperatorFactories()).add((Object)builderOperatorFactory).build(), buildContext.getDriverInstanceCount(), buildSource.getPipelineExecutionStrategy());
            return builderOperatorFactory.getPagesSpatialIndexFactory();
        }

        private PhysicalOperation createLookupJoin(JoinNode node, PlanNode probeNode, List<Symbol> probeSymbols, Optional<Symbol> probeHashSymbol, PlanNode buildNode, List<Symbol> buildSymbols, Optional<Symbol> buildHashSymbol, LocalExecutionPlanContext context) {
            PhysicalOperation probeSource = probeNode.accept(this, context);
            JoinBridgeDataManager<LookupSourceFactory> lookupSourceFactory = this.createLookupSourceFactory(node, buildNode, buildSymbols, buildHashSymbol, probeSource, context);
            OperatorFactory operator = this.createLookupJoin(node, probeSource, probeSymbols, probeHashSymbol, lookupSourceFactory, context);
            ImmutableMap.Builder outputMappings = ImmutableMap.builder();
            List<Symbol> outputSymbols = node.getOutputSymbols();
            for (int i = 0; i < outputSymbols.size(); ++i) {
                Symbol symbol = outputSymbols.get(i);
                outputMappings.put((Object)symbol, (Object)i);
            }
            return new PhysicalOperation(operator, (Map<Symbol, Integer>)outputMappings.build(), context, probeSource);
        }

        private JoinBridgeDataManager<LookupSourceFactory> createLookupSourceFactory(JoinNode node, PlanNode buildNode, List<Symbol> buildSymbols, Optional<Symbol> buildHashSymbol, PhysicalOperation probeSource, LocalExecutionPlanContext context) {
            LocalExecutionPlanContext buildContext = context.createSubContext();
            PhysicalOperation buildSource = buildNode.accept(this, buildContext);
            if (buildSource.getPipelineExecutionStrategy() == PipelineExecutionStrategy.GROUPED_EXECUTION) {
                Preconditions.checkState((probeSource.getPipelineExecutionStrategy() == PipelineExecutionStrategy.GROUPED_EXECUTION ? 1 : 0) != 0, (Object)"Build execution is GROUPED_EXECUTION. Probe execution is expected be GROUPED_EXECUTION, but is UNGROUPED_EXECUTION.");
            }
            List buildOutputSymbols = (List)node.getOutputSymbols().stream().filter(symbol -> node.getRight().getOutputSymbols().contains(symbol)).collect(ImmutableList.toImmutableList());
            ImmutableList buildOutputChannels = ImmutableList.copyOf((Collection)LocalExecutionPlanner.getChannelsForSymbols(buildOutputSymbols, buildSource.getLayout()));
            ImmutableList buildChannels = ImmutableList.copyOf((Collection)LocalExecutionPlanner.getChannelsForSymbols(buildSymbols, buildSource.getLayout()));
            OptionalInt buildHashChannel = buildHashSymbol.map(LocalExecutionPlanner.channelGetter(buildSource)).map(OptionalInt::of).orElse(OptionalInt.empty());
            boolean spillEnabled = SystemSessionProperties.isSpillEnabled(context.getSession());
            boolean buildOuter = node.getType() == JoinNode.Type.RIGHT || node.getType() == JoinNode.Type.FULL;
            int partitionCount = buildContext.getDriverInstanceCount().orElse(1);
            Optional<JoinFilterFunctionCompiler.JoinFilterFunctionFactory> filterFunctionFactory = node.getFilter().map(filterExpression -> this.compileJoinFilterFunction((Expression)filterExpression, probeSource.getLayout(), buildSource.getLayout(), context.getTypes(), context.getSession()));
            Optional<SortExpressionContext> sortExpressionContext = node.getSortExpressionContext();
            Optional<Integer> sortChannel = sortExpressionContext.map(SortExpressionContext::getSortExpression).map(sortExpression -> this.sortExpressionAsSortChannel((Expression)sortExpression, probeSource.getLayout(), buildSource.getLayout()));
            List searchFunctionFactories = (List)sortExpressionContext.map(SortExpressionContext::getSearchExpressions).map(searchExpressions -> (ImmutableList)searchExpressions.stream().map(searchExpression -> this.compileJoinFilterFunction((Expression)searchExpression, probeSource.getLayout(), buildSource.getLayout(), context.getTypes(), context.getSession())).collect(ImmutableList.toImmutableList())).orElse(ImmutableList.of());
            ImmutableList buildOutputTypes = (ImmutableList)buildOutputChannels.stream().map(buildSource.getTypes()::get).collect(ImmutableList.toImmutableList());
            JoinBridgeDataManager<LookupSourceFactory> lookupSourceFactoryManager = JoinBridgeDataManager.lookup(probeSource.getPipelineExecutionStrategy(), buildSource.getPipelineExecutionStrategy(), arg_0 -> Visitor.lambda$createLookupSourceFactory$25(buildSource, buildOutputTypes, (List)buildChannels, buildContext, node, arg_0), (List<Type>)buildOutputTypes);
            HashBuilderOperator.HashBuilderOperatorFactory hashBuilderOperatorFactory = new HashBuilderOperator.HashBuilderOperatorFactory(buildContext.getNextOperatorId(), node.getId(), lookupSourceFactoryManager, (List<Integer>)buildOutputChannels, (List<Integer>)buildChannels, buildHashChannel, filterFunctionFactory, sortChannel, searchFunctionFactories, 10000, LocalExecutionPlanner.this.pagesIndexFactory, spillEnabled && !buildOuter && partitionCount > 1, LocalExecutionPlanner.this.singleStreamSpillerFactory);
            context.addDriverFactory(buildContext.isInputDriver(), false, (List<OperatorFactory>)ImmutableList.builder().addAll((Iterable)buildSource.getOperatorFactories()).add((Object)hashBuilderOperatorFactory).build(), buildContext.getDriverInstanceCount(), buildSource.getPipelineExecutionStrategy());
            return lookupSourceFactoryManager;
        }

        private JoinFilterFunctionCompiler.JoinFilterFunctionFactory compileJoinFilterFunction(Expression filterExpression, Map<Symbol, Integer> probeLayout, Map<Symbol, Integer> buildLayout, Map<Symbol, Type> types, Session session) {
            Map<Symbol, Integer> joinSourcesLayout = this.createJoinSourcesLayout(buildLayout, probeLayout);
            Map sourceTypes = (Map)joinSourcesLayout.entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getValue, entry -> (Type)types.get(entry.getKey())));
            Expression rewrittenFilter = new SymbolToInputRewriter(joinSourcesLayout).rewrite(filterExpression);
            Map<NodeRef<Expression>, Type> expressionTypes = ExpressionAnalyzer.getExpressionTypesFromInput(session, LocalExecutionPlanner.this.metadata, LocalExecutionPlanner.this.sqlParser, (Map<Integer, Type>)sourceTypes, rewrittenFilter, Collections.emptyList());
            RowExpression translatedFilter = this.toRowExpression(rewrittenFilter, expressionTypes);
            return LocalExecutionPlanner.this.joinFilterFunctionCompiler.compileJoinFilterFunction(translatedFilter, buildLayout.size());
        }

        private int sortExpressionAsSortChannel(Expression sortExpression, Map<Symbol, Integer> probeLayout, Map<Symbol, Integer> buildLayout) {
            Map<Symbol, Integer> joinSourcesLayout = this.createJoinSourcesLayout(buildLayout, probeLayout);
            Expression rewrittenSortExpression = new SymbolToInputRewriter(joinSourcesLayout).rewrite(sortExpression);
            Preconditions.checkArgument((boolean)(rewrittenSortExpression instanceof FieldReference), (String)"Unsupported expression type [%s]", (Object)rewrittenSortExpression);
            return ((FieldReference)rewrittenSortExpression).getFieldIndex();
        }

        private OperatorFactory createLookupJoin(JoinNode node, PhysicalOperation probeSource, List<Symbol> probeSymbols, Optional<Symbol> probeHashSymbol, JoinBridgeDataManager<LookupSourceFactory> lookupSourceFactory, LocalExecutionPlanContext context) {
            List<Type> probeTypes = probeSource.getTypes();
            List probeOutputSymbols = (List)node.getOutputSymbols().stream().filter(symbol -> node.getLeft().getOutputSymbols().contains(symbol)).collect(ImmutableList.toImmutableList());
            ImmutableList probeOutputChannels = ImmutableList.copyOf((Collection)LocalExecutionPlanner.getChannelsForSymbols(probeOutputSymbols, probeSource.getLayout()));
            ImmutableList probeJoinChannels = ImmutableList.copyOf((Collection)LocalExecutionPlanner.getChannelsForSymbols(probeSymbols, probeSource.getLayout()));
            OptionalInt probeHashChannel = probeHashSymbol.map(LocalExecutionPlanner.channelGetter(probeSource)).map(OptionalInt::of).orElse(OptionalInt.empty());
            OptionalInt totalOperatorsCount = this.getJoinOperatorsCountForSpill(context, this.session);
            switch (node.getType()) {
                case INNER: {
                    return LocalExecutionPlanner.this.lookupJoinOperators.innerJoin(context.getNextOperatorId(), node.getId(), lookupSourceFactory, probeTypes, (List<Integer>)probeJoinChannels, probeHashChannel, Optional.of(probeOutputChannels), totalOperatorsCount, LocalExecutionPlanner.this.partitioningSpillerFactory);
                }
                case LEFT: {
                    return LocalExecutionPlanner.this.lookupJoinOperators.probeOuterJoin(context.getNextOperatorId(), node.getId(), lookupSourceFactory, probeTypes, (List<Integer>)probeJoinChannels, probeHashChannel, Optional.of(probeOutputChannels), totalOperatorsCount, LocalExecutionPlanner.this.partitioningSpillerFactory);
                }
                case RIGHT: {
                    return LocalExecutionPlanner.this.lookupJoinOperators.lookupOuterJoin(context.getNextOperatorId(), node.getId(), lookupSourceFactory, probeTypes, (List<Integer>)probeJoinChannels, probeHashChannel, Optional.of(probeOutputChannels), totalOperatorsCount, LocalExecutionPlanner.this.partitioningSpillerFactory);
                }
                case FULL: {
                    return LocalExecutionPlanner.this.lookupJoinOperators.fullOuterJoin(context.getNextOperatorId(), node.getId(), lookupSourceFactory, probeTypes, (List<Integer>)probeJoinChannels, probeHashChannel, Optional.of(probeOutputChannels), totalOperatorsCount, LocalExecutionPlanner.this.partitioningSpillerFactory);
                }
            }
            throw new UnsupportedOperationException("Unsupported join type: " + (Object)((Object)node.getType()));
        }

        private OptionalInt getJoinOperatorsCountForSpill(LocalExecutionPlanContext context, Session session) {
            OptionalInt driverInstanceCount = context.getDriverInstanceCount();
            if (SystemSessionProperties.isSpillEnabled(session)) {
                Preconditions.checkState((boolean)driverInstanceCount.isPresent(), (Object)"A fixed distribution is required for JOIN when spilling is enabled");
            }
            return driverInstanceCount;
        }

        private Map<Symbol, Integer> createJoinSourcesLayout(Map<Symbol, Integer> lookupSourceLayout, Map<Symbol, Integer> probeSourceLayout) {
            ImmutableMap.Builder joinSourcesLayout = ImmutableMap.builder();
            joinSourcesLayout.putAll(lookupSourceLayout);
            for (Map.Entry<Symbol, Integer> probeLayoutEntry : probeSourceLayout.entrySet()) {
                joinSourcesLayout.put((Object)probeLayoutEntry.getKey(), (Object)(probeLayoutEntry.getValue() + lookupSourceLayout.size()));
            }
            return joinSourcesLayout.build();
        }

        @Override
        public PhysicalOperation visitSemiJoin(SemiJoinNode node, LocalExecutionPlanContext context) {
            PhysicalOperation probeSource = node.getSource().accept(this, context);
            LocalExecutionPlanContext buildContext = context.createSubContext();
            PhysicalOperation buildSource = node.getFilteringSource().accept(this, buildContext);
            Preconditions.checkState((buildSource.getPipelineExecutionStrategy() == probeSource.getPipelineExecutionStrategy() ? 1 : 0) != 0, (Object)"build and probe have different pipelineExecutionStrategy");
            Preconditions.checkArgument((buildContext.getDriverInstanceCount().orElse(1) == 1 ? 1 : 0) != 0, (Object)"Expected local execution to not be parallel");
            int probeChannel = probeSource.getLayout().get(node.getSourceJoinSymbol());
            int buildChannel = buildSource.getLayout().get(node.getFilteringSourceJoinSymbol());
            Optional<Integer> buildHashChannel = node.getFilteringSourceHashSymbol().map(LocalExecutionPlanner.channelGetter(buildSource));
            SetBuilderOperator.SetBuilderOperatorFactory setBuilderOperatorFactory = new SetBuilderOperator.SetBuilderOperatorFactory(buildContext.getNextOperatorId(), node.getId(), buildSource.getTypes().get(buildChannel), buildChannel, buildHashChannel, 10000, LocalExecutionPlanner.this.joinCompiler);
            SetBuilderOperator.SetSupplier setProvider = setBuilderOperatorFactory.getSetProvider();
            context.addDriverFactory(buildContext.isInputDriver(), false, (List<OperatorFactory>)ImmutableList.builder().addAll((Iterable)buildSource.getOperatorFactories()).add((Object)setBuilderOperatorFactory).build(), buildContext.getDriverInstanceCount(), buildSource.getPipelineExecutionStrategy());
            ImmutableMap outputMappings = ImmutableMap.builder().putAll(probeSource.getLayout()).put((Object)node.getSemiJoinOutput(), (Object)probeSource.getLayout().size()).build();
            HashSemiJoinOperator.HashSemiJoinOperatorFactory operator = new HashSemiJoinOperator.HashSemiJoinOperatorFactory(context.getNextOperatorId(), node.getId(), setProvider, probeSource.getTypes(), probeChannel);
            return new PhysicalOperation((OperatorFactory)operator, (Map<Symbol, Integer>)outputMappings, context, probeSource);
        }

        @Override
        public PhysicalOperation visitTableWriter(TableWriterNode node, LocalExecutionPlanContext context) {
            if (node.getPartitioningScheme().isPresent()) {
                context.setDriverInstanceCount(1);
            } else {
                context.setDriverInstanceCount(SystemSessionProperties.getTaskWriterCount(this.session));
            }
            PhysicalOperation source = node.getSource().accept(this, context);
            List inputChannels = (List)node.getColumns().stream().map(source::symbolToChannel).collect(ImmutableList.toImmutableList());
            TableWriterOperator.TableWriterOperatorFactory operatorFactory = new TableWriterOperator.TableWriterOperatorFactory(context.getNextOperatorId(), node.getId(), LocalExecutionPlanner.this.pageSinkManager, node.getTarget(), inputChannels, this.session);
            ImmutableMap layout = ImmutableMap.builder().put((Object)node.getOutputSymbols().get(0), (Object)0).put((Object)node.getOutputSymbols().get(1), (Object)1).build();
            return new PhysicalOperation((OperatorFactory)operatorFactory, (Map<Symbol, Integer>)layout, context, source);
        }

        @Override
        public PhysicalOperation visitTableFinish(TableFinishNode node, LocalExecutionPlanContext context) {
            PhysicalOperation source = node.getSource().accept(this, context);
            TableFinishOperator.TableFinishOperatorFactory operatorFactory = new TableFinishOperator.TableFinishOperatorFactory(context.getNextOperatorId(), node.getId(), LocalExecutionPlanner.createTableFinisher(this.session, node, LocalExecutionPlanner.this.metadata));
            ImmutableMap layout = ImmutableMap.of((Object)node.getOutputSymbols().get(0), (Object)0);
            return new PhysicalOperation((OperatorFactory)operatorFactory, (Map<Symbol, Integer>)layout, context, source);
        }

        @Override
        public PhysicalOperation visitDelete(DeleteNode node, LocalExecutionPlanContext context) {
            PhysicalOperation source = node.getSource().accept(this, context);
            DeleteOperator.DeleteOperatorFactory operatorFactory = new DeleteOperator.DeleteOperatorFactory(context.getNextOperatorId(), node.getId(), source.getLayout().get(node.getRowId()));
            ImmutableMap layout = ImmutableMap.builder().put((Object)node.getOutputSymbols().get(0), (Object)0).put((Object)node.getOutputSymbols().get(1), (Object)1).build();
            return new PhysicalOperation((OperatorFactory)operatorFactory, (Map<Symbol, Integer>)layout, context, source);
        }

        @Override
        public PhysicalOperation visitMetadataDelete(MetadataDeleteNode node, LocalExecutionPlanContext context) {
            MetadataDeleteOperator.MetadataDeleteOperatorFactory operatorFactory = new MetadataDeleteOperator.MetadataDeleteOperatorFactory(context.getNextOperatorId(), node.getId(), node.getTableLayout(), LocalExecutionPlanner.this.metadata, this.session, node.getTarget().getHandle());
            return new PhysicalOperation((OperatorFactory)operatorFactory, (Map<Symbol, Integer>)this.makeLayout(node), context, PipelineExecutionStrategy.UNGROUPED_EXECUTION);
        }

        @Override
        public PhysicalOperation visitUnion(UnionNode node, LocalExecutionPlanContext context) {
            throw new UnsupportedOperationException("Union node should not be present in a local execution plan");
        }

        @Override
        public PhysicalOperation visitEnforceSingleRow(EnforceSingleRowNode node, LocalExecutionPlanContext context) {
            PhysicalOperation source = node.getSource().accept(this, context);
            EnforceSingleRowOperator.EnforceSingleRowOperatorFactory operatorFactory = new EnforceSingleRowOperator.EnforceSingleRowOperatorFactory(context.getNextOperatorId(), node.getId());
            return new PhysicalOperation((OperatorFactory)operatorFactory, (Map<Symbol, Integer>)this.makeLayout(node), context, source);
        }

        @Override
        public PhysicalOperation visitAssignUniqueId(AssignUniqueId node, LocalExecutionPlanContext context) {
            PhysicalOperation source = node.getSource().accept(this, context);
            AssignUniqueIdOperator.AssignUniqueIdOperatorFactory operatorFactory = new AssignUniqueIdOperator.AssignUniqueIdOperatorFactory(context.getNextOperatorId(), node.getId());
            return new PhysicalOperation((OperatorFactory)operatorFactory, (Map<Symbol, Integer>)this.makeLayout(node), context, source);
        }

        @Override
        public PhysicalOperation visitExchange(ExchangeNode node, LocalExecutionPlanContext context) {
            PhysicalOperation source;
            int driverInstanceCount;
            Preconditions.checkArgument((node.getScope() == ExchangeNode.Scope.LOCAL ? 1 : 0) != 0, (Object)"Only local exchanges are supported in the local planner");
            if (node.getType() == ExchangeNode.Type.GATHER) {
                driverInstanceCount = 1;
                context.setDriverInstanceCount(1);
            } else if (context.getDriverInstanceCount().isPresent()) {
                driverInstanceCount = context.getDriverInstanceCount().getAsInt();
            } else {
                driverInstanceCount = SystemSessionProperties.getTaskConcurrency(this.session);
                context.setDriverInstanceCount(driverInstanceCount);
            }
            List<Type> types = this.getSourceOperatorTypes(node, context.getTypes());
            List channels = (List)node.getPartitioningScheme().getPartitioning().getArguments().stream().map(argument -> node.getOutputSymbols().indexOf(argument.getColumn())).collect(ImmutableList.toImmutableList());
            Optional<Integer> hashChannel = node.getPartitioningScheme().getHashColumn().map(symbol -> node.getOutputSymbols().indexOf(symbol));
            PipelineExecutionStrategy exchangeSourcePipelineExecutionStrategy = PipelineExecutionStrategy.GROUPED_EXECUTION;
            ArrayList<DriverFactoryParameters> driverFactoryParametersList = new ArrayList<DriverFactoryParameters>();
            for (int i = 0; i < node.getSources().size(); ++i) {
                PlanNode sourceNode = node.getSources().get(i);
                LocalExecutionPlanContext subContext = context.createSubContext();
                source = sourceNode.accept(this, subContext);
                driverFactoryParametersList.add(new DriverFactoryParameters(subContext, source));
                if (source.getPipelineExecutionStrategy() != PipelineExecutionStrategy.UNGROUPED_EXECUTION) continue;
                exchangeSourcePipelineExecutionStrategy = PipelineExecutionStrategy.UNGROUPED_EXECUTION;
            }
            LocalExchange.LocalExchangeFactory localExchangeFactory = new LocalExchange.LocalExchangeFactory(node.getPartitioningScheme().getPartitioning().getHandle(), driverInstanceCount, types, channels, hashChannel, exchangeSourcePipelineExecutionStrategy, LocalExecutionPlanner.this.maxLocalExchangeBufferSize);
            for (int i = 0; i < node.getSources().size(); ++i) {
                DriverFactoryParameters driverFactoryParameters = (DriverFactoryParameters)driverFactoryParametersList.get(i);
                source = driverFactoryParameters.getSource();
                LocalExecutionPlanContext subContext = driverFactoryParameters.getSubContext();
                List<Symbol> expectedLayout = node.getInputs().get(i);
                Function pagePreprocessor = LocalExecutionPlanner.enforceLayoutProcessor(expectedLayout, source.getLayout());
                ArrayList<OperatorFactory> operatorFactories = new ArrayList<OperatorFactory>(source.getOperatorFactories());
                operatorFactories.add(new LocalExchangeSinkOperator.LocalExchangeSinkOperatorFactory(localExchangeFactory, subContext.getNextOperatorId(), node.getId(), localExchangeFactory.newSinkFactoryId(), pagePreprocessor));
                context.addDriverFactory(subContext.isInputDriver(), false, operatorFactories, subContext.getDriverInstanceCount(), exchangeSourcePipelineExecutionStrategy);
            }
            context.setInputDriver(false);
            Verify.verify((context.getDriverInstanceCount().getAsInt() == localExchangeFactory.getBufferCount() ? 1 : 0) != 0, (String)"driver instance count must match the number of exchange partitions", (Object[])new Object[0]);
            return new PhysicalOperation((OperatorFactory)new LocalExchangeSourceOperator.LocalExchangeSourceOperatorFactory(context.getNextOperatorId(), node.getId(), localExchangeFactory), (Map<Symbol, Integer>)this.makeLayout(node), context, exchangeSourcePipelineExecutionStrategy);
        }

        @Override
        protected PhysicalOperation visitPlan(PlanNode node, LocalExecutionPlanContext context) {
            throw new UnsupportedOperationException("not yet implemented");
        }

        private List<Type> getSourceOperatorTypes(PlanNode node, Map<Symbol, Type> types) {
            return this.getSymbolTypes(node.getOutputSymbols(), types);
        }

        private List<Type> getSymbolTypes(List<Symbol> symbols, Map<Symbol, Type> types) {
            return (List)symbols.stream().map(types::get).collect(ImmutableList.toImmutableList());
        }

        private AccumulatorFactory buildAccumulatorFactory(PhysicalOperation source, AggregationNode.Aggregation aggregation) {
            ArrayList<Integer> arguments = new ArrayList<Integer>();
            for (Expression argument : aggregation.getCall().getArguments()) {
                Symbol argumentSymbol = Symbol.from(argument);
                arguments.add(source.getLayout().get(argumentSymbol));
            }
            Optional<Integer> maskChannel = Optional.empty();
            if (aggregation.getMask() != null) {
                maskChannel = aggregation.getMask().map(value -> source.getLayout().get(value));
            }
            Object sortOrders = ImmutableList.of();
            Object sortKeys = ImmutableList.of();
            if (aggregation.getCall().getOrderBy().isPresent()) {
                OrderBy orderBy = (OrderBy)aggregation.getCall().getOrderBy().get();
                sortKeys = (List)orderBy.getSortItems().stream().map(SortItem::getSortKey).map(Symbol::from).collect(ImmutableList.toImmutableList());
                sortOrders = (List)orderBy.getSortItems().stream().map(QueryPlanner::toSortOrder).collect(ImmutableList.toImmutableList());
            }
            return LocalExecutionPlanner.this.metadata.getFunctionRegistry().getAggregateFunctionImplementation(aggregation.getSignature()).bind(arguments, maskChannel, source.getTypes(), LocalExecutionPlanner.getChannelsForSymbols((List)sortKeys, source.getLayout()), (List<SortOrder>)sortOrders, LocalExecutionPlanner.this.pagesIndexFactory, aggregation.getCall().isDistinct(), LocalExecutionPlanner.this.joinCompiler, this.session);
        }

        private PhysicalOperation planGlobalAggregation(AggregationNode node, PhysicalOperation source, LocalExecutionPlanContext context) {
            int outputChannel = 0;
            ImmutableMap.Builder outputMappings = ImmutableMap.builder();
            ArrayList<AccumulatorFactory> accumulatorFactories = new ArrayList<AccumulatorFactory>();
            for (Map.Entry<Symbol, AggregationNode.Aggregation> entry : node.getAggregations().entrySet()) {
                Symbol symbol = entry.getKey();
                AggregationNode.Aggregation aggregation = entry.getValue();
                accumulatorFactories.add(this.buildAccumulatorFactory(source, aggregation));
                outputMappings.put((Object)symbol, (Object)outputChannel);
                ++outputChannel;
            }
            AggregationOperator.AggregationOperatorFactory operatorFactory = new AggregationOperator.AggregationOperatorFactory(context.getNextOperatorId(), node.getId(), node.getStep(), accumulatorFactories);
            return new PhysicalOperation((OperatorFactory)operatorFactory, (Map<Symbol, Integer>)outputMappings.build(), context, source);
        }

        private PhysicalOperation planGroupByAggregation(AggregationNode node, PhysicalOperation source, boolean spillEnabled, DataSize unspillMemoryLimit, LocalExecutionPlanContext context) {
            List<Symbol> groupBySymbols = node.getGroupingKeys();
            ArrayList<Symbol> aggregationOutputSymbols = new ArrayList<Symbol>();
            ArrayList<AccumulatorFactory> accumulatorFactories = new ArrayList<AccumulatorFactory>();
            for (Map.Entry<Symbol, AggregationNode.Aggregation> entry2 : node.getAggregations().entrySet()) {
                Symbol symbol = entry2.getKey();
                Iterator aggregation = entry2.getValue();
                accumulatorFactories.add(this.buildAccumulatorFactory(source, (AggregationNode.Aggregation)((Object)aggregation)));
                aggregationOutputSymbols.add(symbol);
            }
            ImmutableList.Builder globalAggregationGroupIds = ImmutableList.builder();
            for (int i = 0; i < node.getGroupingSets().size(); ++i) {
                if (!node.getGroupingSets().get(i).isEmpty()) continue;
                globalAggregationGroupIds.add((Object)i);
            }
            ImmutableMap.Builder outputMappings = ImmutableMap.builder();
            int channel = 0;
            for (Symbol symbol : groupBySymbols) {
                outputMappings.put((Object)symbol, (Object)channel);
                ++channel;
            }
            if (node.getHashSymbol().isPresent()) {
                outputMappings.put((Object)node.getHashSymbol().get(), (Object)channel++);
            }
            for (Symbol symbol : aggregationOutputSymbols) {
                outputMappings.put((Object)symbol, (Object)channel);
                ++channel;
            }
            List groupByChannels = LocalExecutionPlanner.getChannelsForSymbols(groupBySymbols, source.getLayout());
            List groupByTypes = (List)groupByChannels.stream().map(entry -> source.getTypes().get((int)entry)).collect(ImmutableList.toImmutableList());
            Optional<Integer> hashChannel = node.getHashSymbol().map(LocalExecutionPlanner.channelGetter(source));
            ImmutableMap mappings = outputMappings.build();
            HashAggregationOperator.HashAggregationOperatorFactory operatorFactory = new HashAggregationOperator.HashAggregationOperatorFactory(context.getNextOperatorId(), node.getId(), groupByTypes, groupByChannels, (List<Integer>)globalAggregationGroupIds.build(), node.getStep(), node.hasDefaultOutput(), accumulatorFactories, hashChannel, node.getGroupIdSymbol().map(((Map)mappings)::get), 10000, LocalExecutionPlanner.this.maxPartialAggregationMemorySize, spillEnabled, unspillMemoryLimit, LocalExecutionPlanner.this.spillerFactory, LocalExecutionPlanner.this.joinCompiler);
            return new PhysicalOperation((OperatorFactory)operatorFactory, (Map<Symbol, Integer>)mappings, context, source);
        }

        private static /* synthetic */ LookupSourceFactory lambda$createLookupSourceFactory$25(PhysicalOperation buildSource, ImmutableList buildOutputTypes, List buildChannels, LocalExecutionPlanContext buildContext, JoinNode node, Lifespan lifespan) {
            return new PartitionedLookupSourceFactory(buildSource.getTypes(), (List<Type>)buildOutputTypes, (List)buildChannels.stream().map(buildSource.getTypes()::get).collect(ImmutableList.toImmutableList()), buildContext.getDriverInstanceCount().orElse(1), buildSource.getLayout(), node.getType() == JoinNode.Type.RIGHT || node.getType() == JoinNode.Type.FULL);
        }

        private /* synthetic */ RecordSet lambda$visitIndexSource$6(List overlappingFieldSets, List remappedProbeKeyChannels, RecordSet recordSet) {
            if (!overlappingFieldSets.isEmpty()) {
                recordSet = new FieldSetFilteringRecordSet(LocalExecutionPlanner.this.metadata.getFunctionRegistry(), recordSet, overlappingFieldSets);
            }
            return new MappedRecordSet(recordSet, remappedProbeKeyChannels);
        }
    }

    public static class LocalExecutionPlan {
        private final List<DriverFactory> driverFactories;
        private final List<PlanNodeId> partitionedSourceOrder;

        public LocalExecutionPlan(List<DriverFactory> driverFactories, List<PlanNodeId> partitionedSourceOrder) {
            this.driverFactories = ImmutableList.copyOf((Collection)Objects.requireNonNull(driverFactories, "driverFactories is null"));
            this.partitionedSourceOrder = ImmutableList.copyOf((Collection)Objects.requireNonNull(partitionedSourceOrder, "partitionedSourceOrder is null"));
        }

        public List<DriverFactory> getDriverFactories() {
            return this.driverFactories;
        }

        public List<PlanNodeId> getPartitionedSourceOrder() {
            return this.partitionedSourceOrder;
        }
    }

    private static class IndexSourceContext {
        private final SetMultimap<Symbol, Integer> indexLookupToProbeInput;

        public IndexSourceContext(SetMultimap<Symbol, Integer> indexLookupToProbeInput) {
            this.indexLookupToProbeInput = ImmutableSetMultimap.copyOf((Multimap)((Multimap)Objects.requireNonNull(indexLookupToProbeInput, "indexLookupToProbeInput is null")));
        }

        private SetMultimap<Symbol, Integer> getIndexLookupToProbeInput() {
            return this.indexLookupToProbeInput;
        }
    }

    private static class LocalExecutionPlanContext {
        private final TaskContext taskContext;
        private final Map<Symbol, Type> types;
        private final List<DriverFactory> driverFactories;
        private final Optional<IndexSourceContext> indexSourceContext;
        private AtomicInteger nextPipelineId;
        private int nextOperatorId;
        private boolean inputDriver = true;
        private OptionalInt driverInstanceCount = OptionalInt.empty();

        public LocalExecutionPlanContext(TaskContext taskContext, Map<Symbol, Type> types) {
            this(taskContext, types, new ArrayList<DriverFactory>(), Optional.empty(), new AtomicInteger(0));
        }

        private LocalExecutionPlanContext(TaskContext taskContext, Map<Symbol, Type> types, List<DriverFactory> driverFactories, Optional<IndexSourceContext> indexSourceContext, AtomicInteger nextPipelineId) {
            this.taskContext = taskContext;
            this.types = types;
            this.driverFactories = driverFactories;
            this.indexSourceContext = indexSourceContext;
            this.nextPipelineId = nextPipelineId;
        }

        public void addDriverFactory(boolean inputDriver, boolean outputDriver, List<OperatorFactory> operatorFactories, OptionalInt driverInstances, PipelineExecutionStrategy pipelineExecutionStrategy) {
            if (pipelineExecutionStrategy == PipelineExecutionStrategy.GROUPED_EXECUTION) {
                OperatorFactory firstOperatorFactory = operatorFactories.get(0);
                if (inputDriver) {
                    Preconditions.checkArgument((firstOperatorFactory instanceof ScanFilterAndProjectOperator.ScanFilterAndProjectOperatorFactory || firstOperatorFactory instanceof TableScanOperator.TableScanOperatorFactory ? 1 : 0) != 0);
                } else {
                    Preconditions.checkArgument((firstOperatorFactory instanceof LocalExchangeSourceOperator.LocalExchangeSourceOperatorFactory || firstOperatorFactory instanceof LookupOuterOperator.LookupOuterOperatorFactory ? 1 : 0) != 0);
                }
            }
            this.driverFactories.add(new DriverFactory(this.getNextPipelineId(), inputDriver, outputDriver, operatorFactories, driverInstances, pipelineExecutionStrategy));
        }

        private List<DriverFactory> getDriverFactories() {
            return ImmutableList.copyOf(this.driverFactories);
        }

        public Session getSession() {
            return this.taskContext.getSession();
        }

        public StageId getStageId() {
            return this.taskContext.getTaskId().getStageId();
        }

        public Map<Symbol, Type> getTypes() {
            return this.types;
        }

        public Optional<IndexSourceContext> getIndexSourceContext() {
            return this.indexSourceContext;
        }

        private int getNextPipelineId() {
            return this.nextPipelineId.getAndIncrement();
        }

        private int getNextOperatorId() {
            return this.nextOperatorId++;
        }

        private boolean isInputDriver() {
            return this.inputDriver;
        }

        private void setInputDriver(boolean inputDriver) {
            this.inputDriver = inputDriver;
        }

        public LocalExecutionPlanContext createSubContext() {
            Preconditions.checkState((!this.indexSourceContext.isPresent() ? 1 : 0) != 0, (Object)"index build plan can not have sub-contexts");
            return new LocalExecutionPlanContext(this.taskContext, this.types, this.driverFactories, this.indexSourceContext, this.nextPipelineId);
        }

        public LocalExecutionPlanContext createIndexSourceSubContext(IndexSourceContext indexSourceContext) {
            return new LocalExecutionPlanContext(this.taskContext, this.types, this.driverFactories, Optional.of(indexSourceContext), this.nextPipelineId);
        }

        public OptionalInt getDriverInstanceCount() {
            return this.driverInstanceCount;
        }

        public void setDriverInstanceCount(int driverInstanceCount) {
            Preconditions.checkArgument((driverInstanceCount > 0 ? 1 : 0) != 0, (Object)"driverInstanceCount must be > 0");
            if (this.driverInstanceCount.isPresent()) {
                Preconditions.checkState((this.driverInstanceCount.getAsInt() == driverInstanceCount ? 1 : 0) != 0, (Object)("driverInstance count already set to " + this.driverInstanceCount.getAsInt()));
            }
            this.driverInstanceCount = OptionalInt.of(driverInstanceCount);
        }
    }
}

