/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner;

import com.facebook.presto.sql.analyzer.Analysis;
import com.facebook.presto.sql.analyzer.FieldId;
import com.facebook.presto.sql.analyzer.RelationId;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.tree.ArithmeticBinaryExpression;
import com.facebook.presto.sql.tree.ArrayConstructor;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.GenericLiteral;
import com.facebook.presto.sql.tree.GroupingOperation;
import com.facebook.presto.sql.tree.LongLiteral;
import com.facebook.presto.sql.tree.Node;
import com.facebook.presto.sql.tree.NodeRef;
import com.facebook.presto.sql.tree.QuerySpecification;
import com.facebook.presto.sql.tree.SubscriptExpression;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public final class GroupingOperationRewriter {
    private GroupingOperationRewriter() {
    }

    public static Expression rewriteGroupingOperation(GroupingOperation expression, QuerySpecification queryNode, Analysis analysis, Optional<Symbol> groupIdSymbol) {
        Objects.requireNonNull(queryNode, "node is null");
        Objects.requireNonNull(analysis, "analysis is null");
        Objects.requireNonNull(groupIdSymbol, "groupIdSymbol is null");
        Preconditions.checkState((boolean)queryNode.getGroupBy().isPresent(), (Object)"GroupBy node must be present");
        if (analysis.getGroupingSets(queryNode).size() == 1) {
            return new LongLiteral("0");
        }
        Preconditions.checkState((boolean)groupIdSymbol.isPresent(), (Object)"groupId symbol is missing");
        Map<NodeRef<Expression>, FieldId> columnReferenceFields = analysis.getColumnReferenceFields();
        RelationId relationId = columnReferenceFields.get(NodeRef.of((Node)((Node)expression.getGroupingColumns().get(0)))).getRelationId();
        List columns = (List)expression.getGroupingColumns().stream().map(NodeRef::of).peek(groupingColumn -> Preconditions.checkState((boolean)columnReferenceFields.containsKey(groupingColumn), (Object)"the grouping column is not in the columnReferencesField map")).map(columnReferenceFields::get).map(fieldId -> GroupingOperationRewriter.translateFieldToInteger(fieldId, relationId)).collect(ImmutableList.toImmutableList());
        List groupingSetDescriptors = (List)analysis.getGroupingSets(queryNode).stream().map(groupingSet -> (ImmutableList)groupingSet.stream().map(NodeRef::of).filter(columnReferenceFields::containsKey).map(columnReferenceFields::get).map(fieldId -> GroupingOperationRewriter.translateFieldToInteger(fieldId, relationId)).collect(ImmutableList.toImmutableList())).collect(ImmutableList.toImmutableList());
        List groupingResults = (List)groupingSetDescriptors.stream().map(groupingSetDescriptors::indexOf).map(groupId -> String.valueOf(GroupingOperationRewriter.calculateGrouping(groupId.intValue(), columns, groupingSetDescriptors))).map(LongLiteral::new).collect(ImmutableList.toImmutableList());
        return new SubscriptExpression((Expression)new ArrayConstructor(groupingResults), (Expression)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Type.ADD, (Expression)groupIdSymbol.get().toSymbolReference(), (Expression)new GenericLiteral("BIGINT", "1")));
    }

    private static int translateFieldToInteger(FieldId fieldId, RelationId requiredOriginRelationId) {
        Preconditions.checkState((boolean)fieldId.getRelationId().equals(requiredOriginRelationId), (Object)"grouping arguments must all come from the same relation");
        return fieldId.getFieldIndex();
    }

    static long calculateGrouping(long groupId, List<Integer> columns, List<List<Integer>> groupingSetDescriptors) {
        long grouping = (1L << columns.size()) - 1L;
        List<Integer> groupingSet = groupingSetDescriptors.get(Math.toIntExact(groupId));
        for (Integer groupingColumn : groupingSet) {
            int index = columns.indexOf(groupingColumn);
            if (index == -1) continue;
            grouping &= 1L << columns.size() - 1 - index ^ 0xFFFFFFFFFFFFFFFFL;
        }
        return grouping;
    }
}

