/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.gen;

import com.facebook.presto.sql.relational.CallExpression;
import com.facebook.presto.sql.relational.ConstantExpression;
import com.facebook.presto.sql.relational.InputReferenceExpression;
import com.facebook.presto.sql.relational.LambdaDefinitionExpression;
import com.facebook.presto.sql.relational.RowExpression;
import com.facebook.presto.sql.relational.RowExpressionVisitor;
import com.facebook.presto.sql.relational.VariableReferenceExpression;
import com.google.common.collect.ImmutableList;
import java.util.List;

public class LambdaAndTryExpressionExtractor {
    private LambdaAndTryExpressionExtractor() {
    }

    public static List<RowExpression> extractLambdaAndTryExpressions(RowExpression expression) {
        Visitor visitor = new Visitor();
        expression.accept(visitor, new Context(false));
        return visitor.getLambdaAndTryExpressionsPostOrder();
    }

    private static class Context {
        private final boolean inLambda;

        public Context(boolean inLambda) {
            this.inLambda = inLambda;
        }

        public boolean isInLambda() {
            return this.inLambda;
        }
    }

    private static class Visitor
    implements RowExpressionVisitor<Void, Context> {
        private final ImmutableList.Builder<RowExpression> lambdaAndTryExpressions = ImmutableList.builder();

        private Visitor() {
        }

        @Override
        public Void visitInputReference(InputReferenceExpression node, Context context) {
            return null;
        }

        @Override
        public Void visitCall(CallExpression call, Context context) {
            for (RowExpression rowExpression : call.getArguments()) {
                rowExpression.accept(this, context);
            }
            return null;
        }

        @Override
        public Void visitConstant(ConstantExpression literal, Context context) {
            return null;
        }

        @Override
        public Void visitLambda(LambdaDefinitionExpression lambda, Context context) {
            lambda.getBody().accept(this, new Context(true));
            this.lambdaAndTryExpressions.add((Object)lambda);
            return null;
        }

        @Override
        public Void visitVariableReference(VariableReferenceExpression reference, Context context) {
            return null;
        }

        private List<RowExpression> getLambdaAndTryExpressionsPostOrder() {
            return this.lambdaAndTryExpressions.build();
        }
    }
}

