/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.gen;

import com.facebook.presto.Session;
import com.facebook.presto.metadata.FunctionRegistry;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.operator.JoinHash;
import com.facebook.presto.operator.JoinHashSupplier;
import com.facebook.presto.operator.LookupSourceSupplier;
import com.facebook.presto.operator.PagesHash;
import com.facebook.presto.operator.PagesHashStrategy;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.PageBuilder;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.function.OperatorType;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.sql.analyzer.FeaturesConfig;
import com.facebook.presto.sql.gen.BytecodeUtils;
import com.facebook.presto.sql.gen.CacheStatsMBean;
import com.facebook.presto.sql.gen.CallSiteBinder;
import com.facebook.presto.sql.gen.CompilerOperations;
import com.facebook.presto.sql.gen.InputReferenceCompiler;
import com.facebook.presto.sql.gen.IsolatedClass;
import com.facebook.presto.sql.gen.JoinFilterFunctionCompiler;
import com.facebook.presto.sql.gen.SqlTypeBytecodeExpression;
import com.facebook.presto.util.CompilerUtils;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import io.airlift.bytecode.Access;
import io.airlift.bytecode.BytecodeBlock;
import io.airlift.bytecode.BytecodeNode;
import io.airlift.bytecode.ClassDefinition;
import io.airlift.bytecode.DynamicClassLoader;
import io.airlift.bytecode.FieldDefinition;
import io.airlift.bytecode.MethodDefinition;
import io.airlift.bytecode.OpCode;
import io.airlift.bytecode.Parameter;
import io.airlift.bytecode.ParameterizedType;
import io.airlift.bytecode.Variable;
import io.airlift.bytecode.control.ForLoop;
import io.airlift.bytecode.control.IfStatement;
import io.airlift.bytecode.expression.BytecodeExpression;
import io.airlift.bytecode.expression.BytecodeExpressions;
import io.airlift.bytecode.instruction.LabelNode;
import io.airlift.slice.Slice;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.stream.IntStream;
import javax.inject.Inject;
import org.openjdk.jol.info.ClassLayout;
import org.weakref.jmx.Managed;
import org.weakref.jmx.Nested;

public class JoinCompiler {
    private final FunctionRegistry registry;
    private final boolean groupByUsesEqualTo;
    private final LoadingCache<CacheKey, LookupSourceSupplierFactory> lookupSourceFactories = CacheBuilder.newBuilder().recordStats().maximumSize(1000L).build(CacheLoader.from(key -> this.internalCompileLookupSourceFactory(((CacheKey)key).getTypes(), ((CacheKey)key).getOutputChannels(), ((CacheKey)key).getJoinChannels(), ((CacheKey)key).getSortChannel())));
    private final LoadingCache<CacheKey, Class<? extends PagesHashStrategy>> hashStrategies = CacheBuilder.newBuilder().recordStats().maximumSize(1000L).build(CacheLoader.from(key -> this.internalCompileHashStrategy(((CacheKey)key).getTypes(), ((CacheKey)key).getOutputChannels(), ((CacheKey)key).getJoinChannels(), ((CacheKey)key).getSortChannel())));

    public LookupSourceSupplierFactory compileLookupSourceFactory(List<? extends Type> types, List<Integer> joinChannels, Optional<Integer> sortChannel) {
        return this.compileLookupSourceFactory(types, joinChannels, sortChannel, Optional.empty());
    }

    @Inject
    public JoinCompiler(Metadata metadata, FeaturesConfig config) {
        this.registry = Objects.requireNonNull(metadata, "metadata is null").getFunctionRegistry();
        this.groupByUsesEqualTo = Objects.requireNonNull(config, "config is null").isGroupByUsesEqualTo();
    }

    @Managed
    @Nested
    public CacheStatsMBean getLookupSourceStats() {
        return new CacheStatsMBean(this.lookupSourceFactories);
    }

    @Managed
    @Nested
    public CacheStatsMBean getHashStrategiesStats() {
        return new CacheStatsMBean(this.hashStrategies);
    }

    public LookupSourceSupplierFactory compileLookupSourceFactory(List<? extends Type> types, List<Integer> joinChannels, Optional<Integer> sortChannel, Optional<List<Integer>> outputChannels) {
        return (LookupSourceSupplierFactory)this.lookupSourceFactories.getUnchecked((Object)new CacheKey(types, outputChannels.orElse(this.rangeList(types.size())), joinChannels, sortChannel));
    }

    public PagesHashStrategyFactory compilePagesHashStrategyFactory(List<Type> types, List<Integer> joinChannels) {
        return this.compilePagesHashStrategyFactory(types, joinChannels, Optional.empty());
    }

    public PagesHashStrategyFactory compilePagesHashStrategyFactory(List<Type> types, List<Integer> joinChannels, Optional<List<Integer>> outputChannels) {
        Objects.requireNonNull(types, "types is null");
        Objects.requireNonNull(joinChannels, "joinChannels is null");
        Objects.requireNonNull(outputChannels, "outputChannels is null");
        return new PagesHashStrategyFactory((Class)this.hashStrategies.getUnchecked((Object)new CacheKey(types, outputChannels.orElse(this.rangeList(types.size())), joinChannels, Optional.empty())));
    }

    private List<Integer> rangeList(int endExclusive) {
        return (List)IntStream.range(0, endExclusive).boxed().collect(ImmutableList.toImmutableList());
    }

    private LookupSourceSupplierFactory internalCompileLookupSourceFactory(List<Type> types, List<Integer> outputChannels, List<Integer> joinChannels, Optional<Integer> sortChannel) {
        Class<? extends PagesHashStrategy> pagesHashStrategyClass = this.internalCompileHashStrategy(types, outputChannels, joinChannels, sortChannel);
        Class<JoinHashSupplier> joinHashSupplierClass = IsolatedClass.isolateClass(new DynamicClassLoader(this.getClass().getClassLoader()), LookupSourceSupplier.class, JoinHashSupplier.class, JoinHash.class, PagesHash.class);
        return new LookupSourceSupplierFactory(joinHashSupplierClass, new PagesHashStrategyFactory(pagesHashStrategyClass));
    }

    private static FieldDefinition generateInstanceSize(ClassDefinition definition) {
        FieldDefinition instanceSize = definition.declareField(Access.a((Access[])new Access[]{Access.PRIVATE, Access.STATIC, Access.FINAL}), "INSTANCE_SIZE", Long.TYPE);
        definition.getClassInitializer().getBody().comment("INSTANCE_SIZE = ClassLayout.parseClass(%s.class).instanceSize()", new Object[]{definition.getName()}).push(definition.getType()).invokeStatic(ClassLayout.class, "parseClass", ClassLayout.class, new Class[]{Class.class}).invokeVirtual(ClassLayout.class, "instanceSize", Integer.TYPE, new Class[0]).intToLong().putStaticField(instanceSize);
        return instanceSize;
    }

    private Class<? extends PagesHashStrategy> internalCompileHashStrategy(List<Type> types, List<Integer> outputChannels, List<Integer> joinChannels, Optional<Integer> sortChannel) {
        CallSiteBinder callSiteBinder = new CallSiteBinder();
        ClassDefinition classDefinition = new ClassDefinition(Access.a((Access[])new Access[]{Access.PUBLIC, Access.FINAL}), CompilerUtils.makeClassName("PagesHashStrategy"), ParameterizedType.type(Object.class), new ParameterizedType[]{ParameterizedType.type(PagesHashStrategy.class)});
        FieldDefinition instanceSizeField = JoinCompiler.generateInstanceSize(classDefinition);
        FieldDefinition sizeField = classDefinition.declareField(Access.a((Access[])new Access[]{Access.PRIVATE, Access.FINAL}), "size", ParameterizedType.type(Long.TYPE));
        ArrayList<FieldDefinition> channelFields = new ArrayList<FieldDefinition>();
        for (int i = 0; i < types.size(); ++i) {
            FieldDefinition channelField = classDefinition.declareField(Access.a((Access[])new Access[]{Access.PRIVATE, Access.FINAL}), "channel_" + i, ParameterizedType.type(List.class, (Class[])new Class[]{Block.class}));
            channelFields.add(channelField);
        }
        ArrayList<Type> joinChannelTypes = new ArrayList<Type>();
        ArrayList<FieldDefinition> joinChannelFields = new ArrayList<FieldDefinition>();
        for (int i = 0; i < joinChannels.size(); ++i) {
            joinChannelTypes.add(types.get(joinChannels.get(i)));
            FieldDefinition channelField = classDefinition.declareField(Access.a((Access[])new Access[]{Access.PRIVATE, Access.FINAL}), "joinChannel_" + i, ParameterizedType.type(List.class, (Class[])new Class[]{Block.class}));
            joinChannelFields.add(channelField);
        }
        FieldDefinition hashChannelField = classDefinition.declareField(Access.a((Access[])new Access[]{Access.PRIVATE, Access.FINAL}), "hashChannel", ParameterizedType.type(List.class, (Class[])new Class[]{Block.class}));
        JoinCompiler.generateConstructor(classDefinition, joinChannels, sizeField, instanceSizeField, channelFields, joinChannelFields, hashChannelField);
        JoinCompiler.generateGetChannelCountMethod(classDefinition, outputChannels.size());
        JoinCompiler.generateGetSizeInBytesMethod(classDefinition, sizeField);
        JoinCompiler.generateAppendToMethod(classDefinition, callSiteBinder, types, outputChannels, channelFields);
        JoinCompiler.generateHashPositionMethod(classDefinition, callSiteBinder, joinChannelTypes, joinChannelFields, hashChannelField);
        JoinCompiler.generateHashRowMethod(classDefinition, callSiteBinder, joinChannelTypes);
        JoinCompiler.generateRowEqualsRowMethod(classDefinition, callSiteBinder, joinChannelTypes);
        JoinCompiler.generatePositionEqualsRowMethod(classDefinition, callSiteBinder, joinChannelTypes, joinChannelFields, true);
        JoinCompiler.generatePositionEqualsRowMethod(classDefinition, callSiteBinder, joinChannelTypes, joinChannelFields, false);
        this.generatePositionNotDistinctFromRowWithPageMethod(classDefinition, callSiteBinder, joinChannelTypes, joinChannelFields);
        JoinCompiler.generatePositionEqualsRowWithPageMethod(classDefinition, callSiteBinder, joinChannelTypes, joinChannelFields);
        JoinCompiler.generatePositionEqualsPositionMethod(classDefinition, callSiteBinder, joinChannelTypes, joinChannelFields, true);
        JoinCompiler.generatePositionEqualsPositionMethod(classDefinition, callSiteBinder, joinChannelTypes, joinChannelFields, false);
        JoinCompiler.generateIsPositionNull(classDefinition, joinChannelFields);
        JoinCompiler.generateCompareSortChannelPositionsMethod(classDefinition, callSiteBinder, types, channelFields, sortChannel);
        JoinCompiler.generateIsSortChannelPositionNull(classDefinition, channelFields, sortChannel);
        return CompilerUtils.defineClass(classDefinition, PagesHashStrategy.class, callSiteBinder.getBindings(), this.getClass().getClassLoader());
    }

    private static void generateConstructor(ClassDefinition classDefinition, List<Integer> joinChannels, FieldDefinition sizeField, FieldDefinition instanceSizeField, List<FieldDefinition> channelFields, List<FieldDefinition> joinChannelFields, FieldDefinition hashChannelField) {
        int index;
        Parameter channels = Parameter.arg((String)"channels", (ParameterizedType)ParameterizedType.type(List.class, (ParameterizedType[])new ParameterizedType[]{ParameterizedType.type(List.class, (Class[])new Class[]{Block.class})}));
        Parameter hashChannel = Parameter.arg((String)"hashChannel", (ParameterizedType)ParameterizedType.type(OptionalInt.class));
        MethodDefinition constructorDefinition = classDefinition.declareConstructor(Access.a((Access[])new Access[]{Access.PUBLIC}), new Parameter[]{channels, hashChannel});
        Variable thisVariable = constructorDefinition.getThis();
        Variable blockIndex = constructorDefinition.getScope().declareVariable(Integer.TYPE, "blockIndex");
        BytecodeBlock constructor = constructorDefinition.getBody().comment("super();").append((BytecodeNode)thisVariable).invokeConstructor(Object.class, new Class[0]);
        constructor.comment("this.size = INSTANCE_SIZE").append((BytecodeNode)thisVariable.setField(sizeField, BytecodeExpressions.getStatic((FieldDefinition)instanceSizeField)));
        constructor.comment("Set channel fields");
        for (index = 0; index < channelFields.size(); ++index) {
            BytecodeExpression channel = channels.invoke("get", Object.class, new BytecodeExpression[]{BytecodeExpressions.constantInt((int)index)}).cast(ParameterizedType.type(List.class, (Class[])new Class[]{Block.class}));
            constructor.append((BytecodeNode)thisVariable.setField(channelFields.get(index), channel));
            BytecodeBlock loopBody = new BytecodeBlock();
            constructor.comment("for(blockIndex = 0; blockIndex < channel.size(); blockIndex++) { size += channel.get(i).getRetainedSizeInBytes() }").append((BytecodeNode)new ForLoop().initialize((BytecodeNode)blockIndex.set(BytecodeExpressions.constantInt((int)0))).condition((BytecodeNode)new BytecodeBlock().append((BytecodeNode)blockIndex).append((BytecodeNode)channel.invoke("size", Integer.TYPE, new BytecodeExpression[0])).invokeStatic(CompilerOperations.class, "lessThan", Boolean.TYPE, new Class[]{Integer.TYPE, Integer.TYPE})).update((BytecodeNode)new BytecodeBlock().incrementVariable(blockIndex, (byte)1)).body((BytecodeNode)loopBody));
            loopBody.append((BytecodeNode)thisVariable).append((BytecodeNode)thisVariable).getField(sizeField).append((BytecodeNode)channel.invoke("get", Object.class, new BytecodeExpression[]{blockIndex}).cast(ParameterizedType.type(Block.class)).invoke("getRetainedSizeInBytes", Long.TYPE, new BytecodeExpression[0])).longAdd().putField(sizeField);
        }
        constructor.comment("Set join channel fields");
        for (index = 0; index < joinChannelFields.size(); ++index) {
            BytecodeExpression joinChannel = channels.invoke("get", Object.class, new BytecodeExpression[]{BytecodeExpressions.constantInt((int)joinChannels.get(index))}).cast(ParameterizedType.type(List.class, (Class[])new Class[]{Block.class}));
            constructor.append((BytecodeNode)thisVariable.setField(joinChannelFields.get(index), joinChannel));
        }
        constructor.comment("Set hashChannel");
        constructor.append((BytecodeNode)new IfStatement().condition((BytecodeNode)hashChannel.invoke("isPresent", Boolean.TYPE, new BytecodeExpression[0])).ifTrue((BytecodeNode)thisVariable.setField(hashChannelField, channels.invoke("get", Object.class, new BytecodeExpression[]{hashChannel.invoke("getAsInt", Integer.TYPE, new BytecodeExpression[0])}))).ifFalse((BytecodeNode)thisVariable.setField(hashChannelField, BytecodeExpressions.constantNull((ParameterizedType)hashChannelField.getType()))));
        constructor.ret();
    }

    private static void generateGetChannelCountMethod(ClassDefinition classDefinition, int outputChannelCount) {
        classDefinition.declareMethod(Access.a((Access[])new Access[]{Access.PUBLIC}), "getChannelCount", ParameterizedType.type(Integer.TYPE), new Parameter[0]).getBody().push(outputChannelCount).retInt();
    }

    private static void generateGetSizeInBytesMethod(ClassDefinition classDefinition, FieldDefinition sizeField) {
        MethodDefinition getSizeInBytesMethod = classDefinition.declareMethod(Access.a((Access[])new Access[]{Access.PUBLIC}), "getSizeInBytes", ParameterizedType.type(Long.TYPE), new Parameter[0]);
        Variable thisVariable = getSizeInBytesMethod.getThis();
        getSizeInBytesMethod.getBody().append((BytecodeNode)thisVariable.getField(sizeField)).retLong();
    }

    private static void generateAppendToMethod(ClassDefinition classDefinition, CallSiteBinder callSiteBinder, List<Type> types, List<Integer> outputChannels, List<FieldDefinition> channelFields) {
        Parameter blockIndex = Parameter.arg((String)"blockIndex", Integer.TYPE);
        Parameter blockPosition = Parameter.arg((String)"blockPosition", Integer.TYPE);
        Parameter pageBuilder = Parameter.arg((String)"pageBuilder", PageBuilder.class);
        Parameter outputChannelOffset = Parameter.arg((String)"outputChannelOffset", Integer.TYPE);
        MethodDefinition appendToMethod = classDefinition.declareMethod(Access.a((Access[])new Access[]{Access.PUBLIC}), "appendTo", ParameterizedType.type(Void.TYPE), new Parameter[]{blockIndex, blockPosition, pageBuilder, outputChannelOffset});
        Variable thisVariable = appendToMethod.getThis();
        BytecodeBlock appendToBody = appendToMethod.getBody();
        int pageBuilderOutputChannel = 0;
        for (int outputChannel : outputChannels) {
            Type type = types.get(outputChannel);
            SqlTypeBytecodeExpression typeExpression = SqlTypeBytecodeExpression.constantType(callSiteBinder, type);
            BytecodeExpression block = thisVariable.getField(channelFields.get(outputChannel)).invoke("get", Object.class, new BytecodeExpression[]{blockIndex}).cast(Block.class);
            appendToBody.comment("%s.appendTo(channel_%s.get(outputChannel), blockPosition, pageBuilder.getBlockBuilder(outputChannelOffset + %s));", new Object[]{type.getClass(), outputChannel, pageBuilderOutputChannel}).append((BytecodeNode)typeExpression).append((BytecodeNode)block).append((BytecodeNode)blockPosition).append((BytecodeNode)pageBuilder).append((BytecodeNode)outputChannelOffset).push(pageBuilderOutputChannel++).append((BytecodeNode)OpCode.IADD).invokeVirtual(PageBuilder.class, "getBlockBuilder", BlockBuilder.class, new Class[]{Integer.TYPE}).invokeInterface(Type.class, "appendTo", Void.TYPE, new Class[]{Block.class, Integer.TYPE, BlockBuilder.class});
        }
        appendToBody.ret();
    }

    private static void generateIsPositionNull(ClassDefinition classDefinition, List<FieldDefinition> joinChannelFields) {
        Parameter blockIndex = Parameter.arg((String)"blockIndex", Integer.TYPE);
        Parameter blockPosition = Parameter.arg((String)"blockPosition", Integer.TYPE);
        MethodDefinition isPositionNullMethod = classDefinition.declareMethod(Access.a((Access[])new Access[]{Access.PUBLIC}), "isPositionNull", ParameterizedType.type(Boolean.TYPE), new Parameter[]{blockIndex, blockPosition});
        for (FieldDefinition joinChannelField : joinChannelFields) {
            BytecodeExpression block = isPositionNullMethod.getThis().getField(joinChannelField).invoke("get", Object.class, new BytecodeExpression[]{blockIndex}).cast(Block.class);
            IfStatement ifStatement = new IfStatement();
            ifStatement.condition((BytecodeNode)block.invoke("isNull", Boolean.TYPE, new BytecodeExpression[]{blockPosition}));
            ifStatement.ifTrue((BytecodeNode)BytecodeExpressions.constantTrue().ret());
            isPositionNullMethod.getBody().append((BytecodeNode)ifStatement);
        }
        isPositionNullMethod.getBody().append((BytecodeNode)BytecodeExpressions.constantFalse().ret());
    }

    private static void generateHashPositionMethod(ClassDefinition classDefinition, CallSiteBinder callSiteBinder, List<Type> joinChannelTypes, List<FieldDefinition> joinChannelFields, FieldDefinition hashChannelField) {
        Parameter blockIndex = Parameter.arg((String)"blockIndex", Integer.TYPE);
        Parameter blockPosition = Parameter.arg((String)"blockPosition", Integer.TYPE);
        MethodDefinition hashPositionMethod = classDefinition.declareMethod(Access.a((Access[])new Access[]{Access.PUBLIC}), "hashPosition", ParameterizedType.type(Long.TYPE), new Parameter[]{blockIndex, blockPosition});
        Variable thisVariable = hashPositionMethod.getThis();
        BytecodeExpression hashChannel = thisVariable.getField(hashChannelField);
        SqlTypeBytecodeExpression bigintType = SqlTypeBytecodeExpression.constantType(callSiteBinder, (Type)BigintType.BIGINT);
        IfStatement ifStatement = new IfStatement();
        ifStatement.condition((BytecodeNode)BytecodeExpressions.notEqual((BytecodeExpression)hashChannel, (BytecodeExpression)BytecodeExpressions.constantNull((ParameterizedType)hashChannelField.getType())));
        ifStatement.ifTrue((BytecodeNode)bigintType.invoke("getLong", Long.TYPE, new BytecodeExpression[]{hashChannel.invoke("get", Object.class, new BytecodeExpression[]{blockIndex}).cast(Block.class), blockPosition}).ret());
        hashPositionMethod.getBody().append((BytecodeNode)ifStatement);
        Variable resultVariable = hashPositionMethod.getScope().declareVariable(Long.TYPE, "result");
        hashPositionMethod.getBody().push((Number)0L).putVariable(resultVariable);
        for (int index = 0; index < joinChannelTypes.size(); ++index) {
            SqlTypeBytecodeExpression type = SqlTypeBytecodeExpression.constantType(callSiteBinder, joinChannelTypes.get(index));
            BytecodeExpression block = hashPositionMethod.getThis().getField(joinChannelFields.get(index)).invoke("get", Object.class, new BytecodeExpression[]{blockIndex}).cast(Block.class);
            hashPositionMethod.getBody().getVariable(resultVariable).push((Number)31L).append((BytecodeNode)OpCode.LMUL).append(JoinCompiler.typeHashCode(type, block, (BytecodeExpression)blockPosition)).append((BytecodeNode)OpCode.LADD).putVariable(resultVariable);
        }
        hashPositionMethod.getBody().getVariable(resultVariable).retLong();
    }

    private static void generateHashRowMethod(ClassDefinition classDefinition, CallSiteBinder callSiteBinder, List<Type> joinChannelTypes) {
        Parameter position = Parameter.arg((String)"position", Integer.TYPE);
        Parameter page = Parameter.arg((String)"blocks", Page.class);
        MethodDefinition hashRowMethod = classDefinition.declareMethod(Access.a((Access[])new Access[]{Access.PUBLIC}), "hashRow", ParameterizedType.type(Long.TYPE), new Parameter[]{position, page});
        Variable resultVariable = hashRowMethod.getScope().declareVariable(Long.TYPE, "result");
        hashRowMethod.getBody().push((Number)0L).putVariable(resultVariable);
        for (int index = 0; index < joinChannelTypes.size(); ++index) {
            SqlTypeBytecodeExpression type = SqlTypeBytecodeExpression.constantType(callSiteBinder, joinChannelTypes.get(index));
            BytecodeExpression block = page.invoke("getBlock", Block.class, new BytecodeExpression[]{BytecodeExpressions.constantInt((int)index)});
            hashRowMethod.getBody().getVariable(resultVariable).push((Number)31L).append((BytecodeNode)OpCode.LMUL).append(JoinCompiler.typeHashCode(type, block, (BytecodeExpression)position)).append((BytecodeNode)OpCode.LADD).putVariable(resultVariable);
        }
        hashRowMethod.getBody().getVariable(resultVariable).retLong();
    }

    private static BytecodeNode typeHashCode(BytecodeExpression type, BytecodeExpression blockRef, BytecodeExpression blockPosition) {
        return new IfStatement().condition((BytecodeNode)blockRef.invoke("isNull", Boolean.TYPE, new BytecodeExpression[]{blockPosition})).ifTrue((BytecodeNode)BytecodeExpressions.constantLong((long)0L)).ifFalse((BytecodeNode)type.invoke("hash", Long.TYPE, new BytecodeExpression[]{blockRef, blockPosition}));
    }

    private static void generateRowEqualsRowMethod(ClassDefinition classDefinition, CallSiteBinder callSiteBinder, List<Type> joinChannelTypes) {
        Parameter leftPosition = Parameter.arg((String)"leftPosition", Integer.TYPE);
        Parameter leftPage = Parameter.arg((String)"leftPage", Page.class);
        Parameter rightPosition = Parameter.arg((String)"rightPosition", Integer.TYPE);
        Parameter rightPage = Parameter.arg((String)"rightPage", Page.class);
        MethodDefinition rowEqualsRowMethod = classDefinition.declareMethod(Access.a((Access[])new Access[]{Access.PUBLIC}), "rowEqualsRow", ParameterizedType.type(Boolean.TYPE), new Parameter[]{leftPosition, leftPage, rightPosition, rightPage});
        for (int index = 0; index < joinChannelTypes.size(); ++index) {
            SqlTypeBytecodeExpression type = SqlTypeBytecodeExpression.constantType(callSiteBinder, joinChannelTypes.get(index));
            BytecodeExpression leftBlock = leftPage.invoke("getBlock", Block.class, new BytecodeExpression[]{BytecodeExpressions.constantInt((int)index)});
            BytecodeExpression rightBlock = rightPage.invoke("getBlock", Block.class, new BytecodeExpression[]{BytecodeExpressions.constantInt((int)index)});
            LabelNode checkNextField = new LabelNode("checkNextField");
            rowEqualsRowMethod.getBody().append(JoinCompiler.typeEquals(type, leftBlock, (BytecodeExpression)leftPosition, rightBlock, (BytecodeExpression)rightPosition)).ifTrueGoto(checkNextField).push(false).retBoolean().visitLabel(checkNextField);
        }
        rowEqualsRowMethod.getBody().push(true).retInt();
    }

    private static void generatePositionEqualsRowMethod(ClassDefinition classDefinition, CallSiteBinder callSiteBinder, List<Type> joinChannelTypes, List<FieldDefinition> joinChannelFields, boolean ignoreNulls) {
        Parameter leftBlockIndex = Parameter.arg((String)"leftBlockIndex", Integer.TYPE);
        Parameter leftBlockPosition = Parameter.arg((String)"leftBlockPosition", Integer.TYPE);
        Parameter rightPosition = Parameter.arg((String)"rightPosition", Integer.TYPE);
        Parameter rightPage = Parameter.arg((String)"rightPage", Page.class);
        MethodDefinition positionEqualsRowMethod = classDefinition.declareMethod(Access.a((Access[])new Access[]{Access.PUBLIC}), ignoreNulls ? "positionEqualsRowIgnoreNulls" : "positionEqualsRow", ParameterizedType.type(Boolean.TYPE), new Parameter[]{leftBlockIndex, leftBlockPosition, rightPosition, rightPage});
        Variable thisVariable = positionEqualsRowMethod.getThis();
        for (int index = 0; index < joinChannelTypes.size(); ++index) {
            SqlTypeBytecodeExpression type = SqlTypeBytecodeExpression.constantType(callSiteBinder, joinChannelTypes.get(index));
            BytecodeExpression leftBlock = thisVariable.getField(joinChannelFields.get(index)).invoke("get", Object.class, new BytecodeExpression[]{leftBlockIndex}).cast(Block.class);
            BytecodeExpression rightBlock = rightPage.invoke("getBlock", Block.class, new BytecodeExpression[]{BytecodeExpressions.constantInt((int)index)});
            BytecodeNode equalityCondition = ignoreNulls ? JoinCompiler.typeEqualsIgnoreNulls(type, leftBlock, (BytecodeExpression)leftBlockPosition, rightBlock, (BytecodeExpression)rightPosition) : JoinCompiler.typeEquals(type, leftBlock, (BytecodeExpression)leftBlockPosition, rightBlock, (BytecodeExpression)rightPosition);
            LabelNode checkNextField = new LabelNode("checkNextField");
            positionEqualsRowMethod.getBody().append(equalityCondition).ifTrueGoto(checkNextField).push(false).retBoolean().visitLabel(checkNextField);
        }
        positionEqualsRowMethod.getBody().push(true).retInt();
    }

    private static void generatePositionEqualsRowWithPageMethod(ClassDefinition classDefinition, CallSiteBinder callSiteBinder, List<Type> joinChannelTypes, List<FieldDefinition> joinChannelFields) {
        Parameter leftBlockIndex = Parameter.arg((String)"leftBlockIndex", Integer.TYPE);
        Parameter leftBlockPosition = Parameter.arg((String)"leftBlockPosition", Integer.TYPE);
        Parameter rightPosition = Parameter.arg((String)"rightPosition", Integer.TYPE);
        Parameter page = Parameter.arg((String)"page", Page.class);
        Parameter rightChannels = Parameter.arg((String)"rightChannels", int[].class);
        MethodDefinition positionEqualsRowMethod = classDefinition.declareMethod(Access.a((Access[])new Access[]{Access.PUBLIC}), "positionEqualsRow", ParameterizedType.type(Boolean.TYPE), new Parameter[]{leftBlockIndex, leftBlockPosition, rightPosition, page, rightChannels});
        Variable thisVariable = positionEqualsRowMethod.getThis();
        BytecodeBlock body = positionEqualsRowMethod.getBody();
        for (int index = 0; index < joinChannelTypes.size(); ++index) {
            SqlTypeBytecodeExpression type = SqlTypeBytecodeExpression.constantType(callSiteBinder, joinChannelTypes.get(index));
            BytecodeExpression leftBlock = thisVariable.getField(joinChannelFields.get(index)).invoke("get", Object.class, new BytecodeExpression[]{leftBlockIndex}).cast(Block.class);
            BytecodeExpression rightBlock = page.invoke("getBlock", Block.class, new BytecodeExpression[]{rightChannels.getElement(index)});
            body.append((BytecodeNode)new IfStatement().condition(JoinCompiler.typeEquals(type, leftBlock, (BytecodeExpression)leftBlockPosition, rightBlock, (BytecodeExpression)rightPosition)).ifFalse((BytecodeNode)BytecodeExpressions.constantFalse().ret()));
        }
        body.append((BytecodeNode)BytecodeExpressions.constantTrue().ret());
    }

    /*
     * Unable to fully structure code
     */
    private void generatePositionNotDistinctFromRowWithPageMethod(ClassDefinition classDefinition, CallSiteBinder callSiteBinder, List<Type> joinChannelTypes, List<FieldDefinition> joinChannelFields) {
        leftBlockIndex = Parameter.arg((String)"leftBlockIndex", Integer.TYPE);
        leftBlockPosition = Parameter.arg((String)"leftBlockPosition", Integer.TYPE);
        rightPosition = Parameter.arg((String)"rightPosition", Integer.TYPE);
        page = Parameter.arg((String)"page", Page.class);
        rightChannels = Parameter.arg((String)"rightChannels", int[].class);
        positionNotDistinctFromRowMethod = classDefinition.declareMethod(Access.a((Access[])new Access[]{Access.PUBLIC}), "positionNotDistinctFromRow", ParameterizedType.type(Boolean.TYPE), new Parameter[]{leftBlockIndex, leftBlockPosition, rightPosition, page, rightChannels});
        thisVariable = positionNotDistinctFromRowMethod.getThis();
        scope = positionNotDistinctFromRowMethod.getScope();
        body = positionNotDistinctFromRowMethod.getBody();
        if (this.groupByUsesEqualTo) {
            body.append((BytecodeNode)thisVariable.invoke("positionEqualsRow", Boolean.TYPE, new BytecodeExpression[]{leftBlockIndex, leftBlockPosition, rightPosition, page, rightChannels}).ret());
            return;
        }
        scope.declareVariable("wasNull", body, BytecodeExpressions.constantFalse());
        block11: for (index = 0; index < joinChannelTypes.size(); ++index) {
            leftBlock = thisVariable.getField(joinChannelFields.get(index)).invoke("get", Object.class, new BytecodeExpression[]{leftBlockIndex}).cast(Block.class);
            rightBlock = page.invoke("getBlock", Block.class, new BytecodeExpression[]{rightChannels.getElement(index)});
            type = joinChannelTypes.get(index);
            if (!type.getJavaType().equals(Slice.class)) ** GOTO lbl-1000
            var18_18 = type.getTypeSignature().getBase();
            var19_19 = -1;
            switch (var18_18.hashCode()) {
                case 3052374: {
                    if (!var18_18.equals("char")) break;
                    var19_19 = 0;
                    break;
                }
                case -30620435: {
                    if (!var18_18.equals("ipaddress")) break;
                    var19_19 = 1;
                    break;
                }
                case 3271912: {
                    if (!var18_18.equals("json")) break;
                    var19_19 = 2;
                    break;
                }
                case 1542263633: {
                    if (!var18_18.equals("decimal")) break;
                    var19_19 = 3;
                    break;
                }
                case -275146264: {
                    if (!var18_18.equals("varbinary")) break;
                    var19_19 = 4;
                    break;
                }
                case 236613373: {
                    if (!var18_18.equals("varchar")) break;
                    var19_19 = 5;
                }
            }
            switch (var19_19) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    body.append((BytecodeNode)new IfStatement().condition(JoinCompiler.typeEquals(SqlTypeBytecodeExpression.constantType(callSiteBinder, type), leftBlock, (BytecodeExpression)leftBlockPosition, rightBlock, (BytecodeExpression)rightPosition)).ifFalse((BytecodeNode)BytecodeExpressions.constantFalse().ret()));
                    continue block11;
                }
                default: lbl-1000:
                // 2 sources

                {
                    operator = this.registry.getScalarFunctionImplementation(this.registry.resolveOperator(OperatorType.IS_DISTINCT_FROM, (List<? extends Type>)ImmutableList.of((Object)type, (Object)type)));
                    binding = callSiteBinder.bind(operator.getMethodHandle());
                    argumentsBytecode = new ArrayList<BytecodeNode>();
                    argumentsBytecode.add(InputReferenceCompiler.generateInputReference(callSiteBinder, scope, type, leftBlock, (BytecodeExpression)leftBlockPosition));
                    argumentsBytecode.add(InputReferenceCompiler.generateInputReference(callSiteBinder, scope, type, rightBlock, (BytecodeExpression)rightPosition));
                    body.append((BytecodeNode)new IfStatement().condition(BytecodeUtils.generateInvocation(scope, "isDistinctFrom", operator, Optional.empty(), argumentsBytecode, binding)).ifTrue((BytecodeNode)BytecodeExpressions.constantFalse().ret()));
                }
            }
        }
        body.append((BytecodeNode)BytecodeExpressions.constantTrue().ret());
    }

    private static void generatePositionEqualsPositionMethod(ClassDefinition classDefinition, CallSiteBinder callSiteBinder, List<Type> joinChannelTypes, List<FieldDefinition> joinChannelFields, boolean ignoreNulls) {
        Parameter leftBlockIndex = Parameter.arg((String)"leftBlockIndex", Integer.TYPE);
        Parameter leftBlockPosition = Parameter.arg((String)"leftBlockPosition", Integer.TYPE);
        Parameter rightBlockIndex = Parameter.arg((String)"rightBlockIndex", Integer.TYPE);
        Parameter rightBlockPosition = Parameter.arg((String)"rightBlockPosition", Integer.TYPE);
        MethodDefinition positionEqualsPositionMethod = classDefinition.declareMethod(Access.a((Access[])new Access[]{Access.PUBLIC}), ignoreNulls ? "positionEqualsPositionIgnoreNulls" : "positionEqualsPosition", ParameterizedType.type(Boolean.TYPE), new Parameter[]{leftBlockIndex, leftBlockPosition, rightBlockIndex, rightBlockPosition});
        Variable thisVariable = positionEqualsPositionMethod.getThis();
        for (int index = 0; index < joinChannelTypes.size(); ++index) {
            SqlTypeBytecodeExpression type = SqlTypeBytecodeExpression.constantType(callSiteBinder, joinChannelTypes.get(index));
            BytecodeExpression leftBlock = thisVariable.getField(joinChannelFields.get(index)).invoke("get", Object.class, new BytecodeExpression[]{leftBlockIndex}).cast(Block.class);
            BytecodeExpression rightBlock = thisVariable.getField(joinChannelFields.get(index)).invoke("get", Object.class, new BytecodeExpression[]{rightBlockIndex}).cast(Block.class);
            BytecodeNode equalityCondition = ignoreNulls ? JoinCompiler.typeEqualsIgnoreNulls(type, leftBlock, (BytecodeExpression)leftBlockPosition, rightBlock, (BytecodeExpression)rightBlockPosition) : JoinCompiler.typeEquals(type, leftBlock, (BytecodeExpression)leftBlockPosition, rightBlock, (BytecodeExpression)rightBlockPosition);
            LabelNode checkNextField = new LabelNode("checkNextField");
            positionEqualsPositionMethod.getBody().append(equalityCondition).ifTrueGoto(checkNextField).push(false).retBoolean().visitLabel(checkNextField);
        }
        positionEqualsPositionMethod.getBody().push(true).retInt();
    }

    private static void generateCompareSortChannelPositionsMethod(ClassDefinition classDefinition, CallSiteBinder callSiteBinder, List<Type> types, List<FieldDefinition> channelFields, Optional<Integer> sortChannel) {
        Parameter leftBlockIndex = Parameter.arg((String)"leftBlockIndex", Integer.TYPE);
        Parameter leftBlockPosition = Parameter.arg((String)"leftBlockPosition", Integer.TYPE);
        Parameter rightBlockIndex = Parameter.arg((String)"rightBlockIndex", Integer.TYPE);
        Parameter rightBlockPosition = Parameter.arg((String)"rightBlockPosition", Integer.TYPE);
        MethodDefinition compareMethod = classDefinition.declareMethod(Access.a((Access[])new Access[]{Access.PUBLIC}), "compareSortChannelPositions", ParameterizedType.type(Integer.TYPE), new Parameter[]{leftBlockIndex, leftBlockPosition, rightBlockIndex, rightBlockPosition});
        if (!sortChannel.isPresent()) {
            compareMethod.getBody().append((BytecodeNode)BytecodeExpressions.newInstance(UnsupportedOperationException.class, (BytecodeExpression[])new BytecodeExpression[0])).throwObject();
            return;
        }
        Variable thisVariable = compareMethod.getThis();
        int index = sortChannel.get();
        SqlTypeBytecodeExpression type = SqlTypeBytecodeExpression.constantType(callSiteBinder, types.get(index));
        BytecodeExpression leftBlock = thisVariable.getField(channelFields.get(index)).invoke("get", Object.class, new BytecodeExpression[]{leftBlockIndex}).cast(Block.class);
        BytecodeExpression rightBlock = thisVariable.getField(channelFields.get(index)).invoke("get", Object.class, new BytecodeExpression[]{rightBlockIndex}).cast(Block.class);
        BytecodeExpression comparison = type.invoke("compareTo", Integer.TYPE, new BytecodeExpression[]{leftBlock, leftBlockPosition, rightBlock, rightBlockPosition}).ret();
        compareMethod.getBody().append((BytecodeNode)comparison);
    }

    private static void generateIsSortChannelPositionNull(ClassDefinition classDefinition, List<FieldDefinition> channelFields, Optional<Integer> sortChannel) {
        Parameter blockIndex = Parameter.arg((String)"blockIndex", Integer.TYPE);
        Parameter blockPosition = Parameter.arg((String)"blockPosition", Integer.TYPE);
        MethodDefinition isSortChannelPositionNullMethod = classDefinition.declareMethod(Access.a((Access[])new Access[]{Access.PUBLIC}), "isSortChannelPositionNull", ParameterizedType.type(Boolean.TYPE), new Parameter[]{blockIndex, blockPosition});
        if (!sortChannel.isPresent()) {
            isSortChannelPositionNullMethod.getBody().append((BytecodeNode)BytecodeExpressions.newInstance(UnsupportedOperationException.class, (BytecodeExpression[])new BytecodeExpression[0])).throwObject();
            return;
        }
        Variable thisVariable = isSortChannelPositionNullMethod.getThis();
        int index = sortChannel.get();
        BytecodeExpression block = thisVariable.getField(channelFields.get(index)).invoke("get", Object.class, new BytecodeExpression[]{blockIndex}).cast(Block.class);
        BytecodeExpression isNull = block.invoke("isNull", Boolean.TYPE, new BytecodeExpression[]{blockPosition}).ret();
        isSortChannelPositionNullMethod.getBody().append((BytecodeNode)isNull);
    }

    private static BytecodeNode typeEquals(BytecodeExpression type, BytecodeExpression leftBlock, BytecodeExpression leftBlockPosition, BytecodeExpression rightBlock, BytecodeExpression rightBlockPosition) {
        IfStatement ifStatement = new IfStatement();
        ifStatement.condition().append((BytecodeNode)leftBlock.invoke("isNull", Boolean.TYPE, new BytecodeExpression[]{leftBlockPosition})).append((BytecodeNode)rightBlock.invoke("isNull", Boolean.TYPE, new BytecodeExpression[]{rightBlockPosition})).append((BytecodeNode)OpCode.IOR);
        ifStatement.ifTrue().append((BytecodeNode)leftBlock.invoke("isNull", Boolean.TYPE, new BytecodeExpression[]{leftBlockPosition})).append((BytecodeNode)rightBlock.invoke("isNull", Boolean.TYPE, new BytecodeExpression[]{rightBlockPosition})).append((BytecodeNode)OpCode.IAND);
        ifStatement.ifFalse().append(JoinCompiler.typeEqualsIgnoreNulls(type, leftBlock, leftBlockPosition, rightBlock, rightBlockPosition));
        return ifStatement;
    }

    private static BytecodeNode typeEqualsIgnoreNulls(BytecodeExpression type, BytecodeExpression leftBlock, BytecodeExpression leftBlockPosition, BytecodeExpression rightBlock, BytecodeExpression rightBlockPosition) {
        return type.invoke("equalTo", Boolean.TYPE, new BytecodeExpression[]{leftBlock, leftBlockPosition, rightBlock, rightBlockPosition});
    }

    private static final class CacheKey {
        private final List<Type> types;
        private final List<Integer> outputChannels;
        private final List<Integer> joinChannels;
        private final Optional<Integer> sortChannel;

        private CacheKey(List<? extends Type> types, List<Integer> outputChannels, List<Integer> joinChannels, Optional<Integer> sortChannel) {
            this.types = ImmutableList.copyOf((Collection)Objects.requireNonNull(types, "types is null"));
            this.outputChannels = ImmutableList.copyOf((Collection)Objects.requireNonNull(outputChannels, "outputChannels is null"));
            this.joinChannels = ImmutableList.copyOf((Collection)Objects.requireNonNull(joinChannels, "joinChannels is null"));
            this.sortChannel = Objects.requireNonNull(sortChannel, "sortChannel is null");
        }

        private List<Type> getTypes() {
            return this.types;
        }

        private List<Integer> getOutputChannels() {
            return this.outputChannels;
        }

        private List<Integer> getJoinChannels() {
            return this.joinChannels;
        }

        private Optional<Integer> getSortChannel() {
            return this.sortChannel;
        }

        public int hashCode() {
            return Objects.hash(this.types, this.outputChannels, this.joinChannels, this.sortChannel);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof CacheKey)) {
                return false;
            }
            CacheKey other = (CacheKey)obj;
            return Objects.equals(this.types, other.types) && Objects.equals(this.outputChannels, other.outputChannels) && Objects.equals(this.joinChannels, other.joinChannels) && Objects.equals(this.sortChannel, other.sortChannel);
        }
    }

    public static class PagesHashStrategyFactory {
        private final Constructor<? extends PagesHashStrategy> constructor;

        public PagesHashStrategyFactory(Class<? extends PagesHashStrategy> pagesHashStrategyClass) {
            try {
                this.constructor = pagesHashStrategyClass.getConstructor(List.class, OptionalInt.class);
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException(e);
            }
        }

        public PagesHashStrategy createPagesHashStrategy(List<? extends List<Block>> channels, OptionalInt hashChannel) {
            try {
                return this.constructor.newInstance(channels, hashChannel);
            }
            catch (ReflectiveOperationException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static class LookupSourceSupplierFactory {
        private final Constructor<? extends LookupSourceSupplier> constructor;
        private final PagesHashStrategyFactory pagesHashStrategyFactory;

        public LookupSourceSupplierFactory(Class<? extends LookupSourceSupplier> joinHashSupplierClass, PagesHashStrategyFactory pagesHashStrategyFactory) {
            this.pagesHashStrategyFactory = pagesHashStrategyFactory;
            try {
                this.constructor = joinHashSupplierClass.getConstructor(Session.class, PagesHashStrategy.class, LongArrayList.class, List.class, Optional.class, Optional.class, List.class);
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException(e);
            }
        }

        public LookupSourceSupplier createLookupSourceSupplier(Session session, LongArrayList addresses, List<List<Block>> channels, OptionalInt hashChannel, Optional<JoinFilterFunctionCompiler.JoinFilterFunctionFactory> filterFunctionFactory, Optional<Integer> sortChannel, List<JoinFilterFunctionCompiler.JoinFilterFunctionFactory> searchFunctionFactories) {
            PagesHashStrategy pagesHashStrategy = this.pagesHashStrategyFactory.createPagesHashStrategy(channels, hashChannel);
            try {
                return this.constructor.newInstance(session, pagesHashStrategy, addresses, channels, filterFunctionFactory, sortChannel, searchFunctionFactories);
            }
            catch (ReflectiveOperationException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

