/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.analyzer;

import com.facebook.presto.metadata.FunctionKind;
import com.facebook.presto.metadata.Signature;
import com.facebook.presto.sql.analyzer.Analysis;
import com.facebook.presto.sql.analyzer.SemanticErrorCode;
import com.facebook.presto.sql.analyzer.SemanticException;
import com.facebook.presto.sql.tree.DefaultExpressionTraversalVisitor;
import com.facebook.presto.sql.tree.FunctionCall;
import com.facebook.presto.sql.tree.Node;
import java.util.Objects;

class WindowFunctionValidator
extends DefaultExpressionTraversalVisitor<Void, Analysis> {
    WindowFunctionValidator() {
    }

    protected Void visitFunctionCall(FunctionCall functionCall, Analysis analysis) {
        Objects.requireNonNull(analysis, "analysis is null");
        Signature signature = analysis.getFunctionSignature(functionCall);
        if (signature != null && signature.getKind() == FunctionKind.WINDOW && !functionCall.getWindow().isPresent()) {
            throw new SemanticException(SemanticErrorCode.WINDOW_REQUIRES_OVER, (Node)functionCall, "Window function %s requires an OVER clause", signature.getName());
        }
        return (Void)super.visitFunctionCall(functionCall, (Object)analysis);
    }
}

