/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.server.testing;

import com.facebook.presto.connector.ConnectorId;
import com.facebook.presto.connector.ConnectorManager;
import com.facebook.presto.cost.StatsCalculator;
import com.facebook.presto.eventlistener.EventListenerManager;
import com.facebook.presto.execution.QueryManager;
import com.facebook.presto.execution.TaskManager;
import com.facebook.presto.execution.resourceGroups.InternalResourceGroupManager;
import com.facebook.presto.execution.resourceGroups.ResourceGroupManager;
import com.facebook.presto.memory.ClusterMemoryManager;
import com.facebook.presto.memory.LocalMemoryManager;
import com.facebook.presto.metadata.AllNodes;
import com.facebook.presto.metadata.CatalogManager;
import com.facebook.presto.metadata.InternalNodeManager;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.security.AccessControl;
import com.facebook.presto.security.AccessControlManager;
import com.facebook.presto.server.GracefulShutdownHandler;
import com.facebook.presto.server.PluginManager;
import com.facebook.presto.server.ServerMainModule;
import com.facebook.presto.server.ShutdownAction;
import com.facebook.presto.server.security.ServerSecurityModule;
import com.facebook.presto.spi.Node;
import com.facebook.presto.spi.Plugin;
import com.facebook.presto.split.SplitManager;
import com.facebook.presto.sql.parser.SqlParserOptions;
import com.facebook.presto.sql.planner.NodePartitioningManager;
import com.facebook.presto.testing.ProcedureTester;
import com.facebook.presto.testing.TestingAccessControlManager;
import com.facebook.presto.testing.TestingEventListenerManager;
import com.facebook.presto.transaction.TransactionManager;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.io.MoreFiles;
import com.google.common.io.RecursiveDeleteOption;
import com.google.common.net.HostAndPort;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.Scopes;
import io.airlift.bootstrap.Bootstrap;
import io.airlift.bootstrap.LifeCycleManager;
import io.airlift.discovery.client.Announcer;
import io.airlift.discovery.client.DiscoveryModule;
import io.airlift.discovery.client.ServiceAnnouncement;
import io.airlift.discovery.client.ServiceSelectorManager;
import io.airlift.discovery.client.testing.TestingDiscoveryModule;
import io.airlift.event.client.EventModule;
import io.airlift.http.server.testing.TestingHttpServer;
import io.airlift.http.server.testing.TestingHttpServerModule;
import io.airlift.jaxrs.JaxrsModule;
import io.airlift.jmx.testing.TestingJmxModule;
import io.airlift.json.JsonModule;
import io.airlift.node.testing.TestingNodeModule;
import io.airlift.tracetoken.TraceTokenModule;
import java.io.Closeable;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import javax.annotation.concurrent.GuardedBy;
import org.weakref.jmx.guice.MBeanModule;

public class TestingPrestoServer
implements Closeable {
    private final Injector injector;
    private final Path baseDataDir;
    private final LifeCycleManager lifeCycleManager;
    private final PluginManager pluginManager;
    private final ConnectorManager connectorManager;
    private final TestingHttpServer server;
    private final CatalogManager catalogManager;
    private final TransactionManager transactionManager;
    private final Metadata metadata;
    private final StatsCalculator statsCalculator;
    private final TestingAccessControlManager accessControl;
    private final ProcedureTester procedureTester;
    private final Optional<InternalResourceGroupManager> resourceGroupManager;
    private final SplitManager splitManager;
    private final NodePartitioningManager nodePartitioningManager;
    private final ClusterMemoryManager clusterMemoryManager;
    private final LocalMemoryManager localMemoryManager;
    private final InternalNodeManager nodeManager;
    private final ServiceSelectorManager serviceSelectorManager;
    private final Announcer announcer;
    private final QueryManager queryManager;
    private final TaskManager taskManager;
    private final GracefulShutdownHandler gracefulShutdownHandler;
    private final ShutdownAction shutdownAction;
    private final boolean coordinator;

    public TestingPrestoServer() throws Exception {
        this((List<Module>)ImmutableList.of());
    }

    public TestingPrestoServer(List<Module> additionalModules) throws Exception {
        this(true, (Map<String, String>)ImmutableMap.of(), null, null, new SqlParserOptions(), additionalModules);
    }

    public TestingPrestoServer(boolean coordinator, Map<String, String> properties, String environment, URI discoveryUri, SqlParserOptions parserOptions, List<Module> additionalModules) throws Exception {
        this.coordinator = coordinator;
        this.baseDataDir = Files.createTempDirectory("PrestoTest", new FileAttribute[0]);
        properties = new HashMap<String, String>(properties);
        String coordinatorPort = properties.remove("http-server.http.port");
        if (coordinatorPort == null) {
            coordinatorPort = "0";
        }
        ImmutableMap.Builder serverProperties = ImmutableMap.builder().putAll(properties).put((Object)"coordinator", (Object)String.valueOf(coordinator)).put((Object)"presto.version", (Object)"testversion").put((Object)"task.concurrency", (Object)"4").put((Object)"task.max-worker-threads", (Object)"4").put((Object)"exchange.client-threads", (Object)"4");
        if (coordinator) {
            serverProperties.put((Object)"failure-detector.enabled", (Object)"false");
        }
        ImmutableList.Builder modules = ImmutableList.builder().add((Object)new TestingNodeModule(Optional.ofNullable(environment))).add((Object)new TestingHttpServerModule(Integer.parseInt(coordinator ? coordinatorPort : "0"))).add((Object)new JsonModule()).add((Object)new JaxrsModule(true)).add((Object)new MBeanModule()).add((Object)new TestingJmxModule()).add((Object)new EventModule()).add((Object)new TraceTokenModule()).add((Object)new ServerSecurityModule()).add((Object)new ServerMainModule(parserOptions)).add(binder -> {
            binder.bind(TestingAccessControlManager.class).in(Scopes.SINGLETON);
            binder.bind(TestingEventListenerManager.class).in(Scopes.SINGLETON);
            binder.bind(AccessControlManager.class).to(TestingAccessControlManager.class).in(Scopes.SINGLETON);
            binder.bind(EventListenerManager.class).to(TestingEventListenerManager.class).in(Scopes.SINGLETON);
            binder.bind(AccessControl.class).to(AccessControlManager.class).in(Scopes.SINGLETON);
            binder.bind(ShutdownAction.class).to(TestShutdownAction.class).in(Scopes.SINGLETON);
            binder.bind(GracefulShutdownHandler.class).in(Scopes.SINGLETON);
            binder.bind(ProcedureTester.class).in(Scopes.SINGLETON);
        });
        if (discoveryUri != null) {
            Objects.requireNonNull(environment, "environment required when discoveryUri is present");
            serverProperties.put((Object)"discovery.uri", (Object)discoveryUri.toString());
            modules.add((Object)new DiscoveryModule());
        } else {
            modules.add((Object)new TestingDiscoveryModule());
        }
        modules.addAll(additionalModules);
        Bootstrap app = new Bootstrap((Iterable)modules.build());
        HashMap<String, String> optionalProperties = new HashMap<String, String>();
        if (environment != null) {
            optionalProperties.put("node.environment", environment);
        }
        this.injector = app.strictConfig().doNotInitializeLogging().setRequiredConfigurationProperties((Map)serverProperties.build()).setOptionalConfigurationProperties(optionalProperties).quiet().initialize();
        ((Announcer)this.injector.getInstance(Announcer.class)).start();
        this.lifeCycleManager = (LifeCycleManager)this.injector.getInstance(LifeCycleManager.class);
        this.queryManager = (QueryManager)this.injector.getInstance(QueryManager.class);
        this.pluginManager = (PluginManager)this.injector.getInstance(PluginManager.class);
        this.connectorManager = (ConnectorManager)this.injector.getInstance(ConnectorManager.class);
        this.server = (TestingHttpServer)this.injector.getInstance(TestingHttpServer.class);
        this.catalogManager = (CatalogManager)this.injector.getInstance(CatalogManager.class);
        this.transactionManager = (TransactionManager)this.injector.getInstance(TransactionManager.class);
        this.metadata = (Metadata)this.injector.getInstance(Metadata.class);
        this.statsCalculator = (StatsCalculator)this.injector.getInstance(StatsCalculator.class);
        this.accessControl = (TestingAccessControlManager)this.injector.getInstance(TestingAccessControlManager.class);
        this.procedureTester = (ProcedureTester)this.injector.getInstance(ProcedureTester.class);
        this.splitManager = (SplitManager)this.injector.getInstance(SplitManager.class);
        if (coordinator) {
            this.resourceGroupManager = Optional.of((InternalResourceGroupManager)this.injector.getInstance(ResourceGroupManager.class));
            this.nodePartitioningManager = (NodePartitioningManager)this.injector.getInstance(NodePartitioningManager.class);
            this.clusterMemoryManager = (ClusterMemoryManager)this.injector.getInstance(ClusterMemoryManager.class);
        } else {
            this.resourceGroupManager = Optional.empty();
            this.nodePartitioningManager = null;
            this.clusterMemoryManager = null;
        }
        this.localMemoryManager = (LocalMemoryManager)this.injector.getInstance(LocalMemoryManager.class);
        this.nodeManager = (InternalNodeManager)this.injector.getInstance(InternalNodeManager.class);
        this.serviceSelectorManager = (ServiceSelectorManager)this.injector.getInstance(ServiceSelectorManager.class);
        this.gracefulShutdownHandler = (GracefulShutdownHandler)this.injector.getInstance(GracefulShutdownHandler.class);
        this.taskManager = (TaskManager)this.injector.getInstance(TaskManager.class);
        this.shutdownAction = (ShutdownAction)this.injector.getInstance(ShutdownAction.class);
        this.announcer = (Announcer)this.injector.getInstance(Announcer.class);
        this.announcer.forceAnnounce();
        this.refreshNodes();
    }

    @Override
    public void close() throws IOException {
        block6: {
            try {
                if (this.lifeCycleManager == null) break block6;
                this.lifeCycleManager.stop();
            }
            catch (Exception e) {
                try {
                    Throwables.throwIfUnchecked((Throwable)e);
                    throw new RuntimeException(e);
                }
                catch (Throwable throwable) {
                    if (Files.isDirectory(this.baseDataDir, new LinkOption[0])) {
                        MoreFiles.deleteRecursively((Path)this.baseDataDir, (RecursiveDeleteOption[])new RecursiveDeleteOption[]{RecursiveDeleteOption.ALLOW_INSECURE});
                    }
                    throw throwable;
                }
            }
        }
        if (Files.isDirectory(this.baseDataDir, new LinkOption[0])) {
            MoreFiles.deleteRecursively((Path)this.baseDataDir, (RecursiveDeleteOption[])new RecursiveDeleteOption[]{RecursiveDeleteOption.ALLOW_INSECURE});
        }
    }

    public void installPlugin(Plugin plugin) {
        this.pluginManager.installPlugin(plugin);
    }

    public QueryManager getQueryManager() {
        return this.queryManager;
    }

    public ConnectorId createCatalog(String catalogName, String connectorName) {
        return this.createCatalog(catalogName, connectorName, (Map<String, String>)ImmutableMap.of());
    }

    public ConnectorId createCatalog(String catalogName, String connectorName, Map<String, String> properties) {
        ConnectorId connectorId = this.connectorManager.createConnection(catalogName, connectorName, properties);
        TestingPrestoServer.updateConnectorIdAnnouncement(this.announcer, connectorId);
        return connectorId;
    }

    public Path getBaseDataDir() {
        return this.baseDataDir;
    }

    public URI getBaseUrl() {
        return this.server.getBaseUrl();
    }

    public URI resolve(String path) {
        return this.server.getBaseUrl().resolve(path);
    }

    public HostAndPort getAddress() {
        return HostAndPort.fromParts((String)this.getBaseUrl().getHost(), (int)this.getBaseUrl().getPort());
    }

    public HostAndPort getHttpsAddress() {
        URI httpsUri = this.server.getHttpServerInfo().getHttpsUri();
        return HostAndPort.fromParts((String)httpsUri.getHost(), (int)httpsUri.getPort());
    }

    public CatalogManager getCatalogManager() {
        return this.catalogManager;
    }

    public TransactionManager getTransactionManager() {
        return this.transactionManager;
    }

    public Metadata getMetadata() {
        return this.metadata;
    }

    public StatsCalculator getStatsCalculator() {
        return this.statsCalculator;
    }

    public TestingAccessControlManager getAccessControl() {
        return this.accessControl;
    }

    public ProcedureTester getProcedureTester() {
        return this.procedureTester;
    }

    public SplitManager getSplitManager() {
        return this.splitManager;
    }

    public Optional<InternalResourceGroupManager> getResourceGroupManager() {
        return this.resourceGroupManager;
    }

    public NodePartitioningManager getNodePartitioningManager() {
        return this.nodePartitioningManager;
    }

    public LocalMemoryManager getLocalMemoryManager() {
        return this.localMemoryManager;
    }

    public ClusterMemoryManager getClusterMemoryManager() {
        Preconditions.checkState((boolean)this.coordinator, (Object)"not a coordinator");
        return this.clusterMemoryManager;
    }

    public GracefulShutdownHandler getGracefulShutdownHandler() {
        return this.gracefulShutdownHandler;
    }

    public TaskManager getTaskManager() {
        return this.taskManager;
    }

    public ShutdownAction getShutdownAction() {
        return this.shutdownAction;
    }

    public boolean isCoordinator() {
        return this.coordinator;
    }

    public final AllNodes refreshNodes() {
        this.serviceSelectorManager.forceRefresh();
        this.nodeManager.refreshNodes();
        return this.nodeManager.getAllNodes();
    }

    public Set<Node> getActiveNodesWithConnector(ConnectorId connectorId) {
        return this.nodeManager.getActiveConnectorNodes(connectorId);
    }

    public <T> T getInstance(Key<T> key) {
        return (T)this.injector.getInstance(key);
    }

    private static void updateConnectorIdAnnouncement(Announcer announcer, ConnectorId connectorId) {
        ServiceAnnouncement announcement = TestingPrestoServer.getPrestoAnnouncement(announcer.getServiceAnnouncements());
        LinkedHashMap<String, String> properties = new LinkedHashMap<String, String>(announcement.getProperties());
        String property = Strings.nullToEmpty((String)((String)properties.get("connectorIds")));
        LinkedHashSet<String> connectorIds = new LinkedHashSet<String>(Splitter.on((char)',').trimResults().omitEmptyStrings().splitToList((CharSequence)property));
        connectorIds.add(connectorId.toString());
        properties.put("connectorIds", Joiner.on((char)',').join(connectorIds));
        announcer.removeServiceAnnouncement(announcement.getId());
        announcer.addServiceAnnouncement(ServiceAnnouncement.serviceAnnouncement((String)announcement.getType()).addProperties(properties).build());
        announcer.forceAnnounce();
    }

    private static ServiceAnnouncement getPrestoAnnouncement(Set<ServiceAnnouncement> announcements) {
        for (ServiceAnnouncement announcement : announcements) {
            if (!announcement.getType().equals("presto")) continue;
            return announcement;
        }
        throw new RuntimeException("Presto announcement not found: " + announcements);
    }

    public static class TestShutdownAction
    implements ShutdownAction {
        private final CountDownLatch shutdownCalled = new CountDownLatch(1);
        @GuardedBy(value="this")
        private boolean isWorkerShutdown;

        @Override
        public synchronized void onShutdown() {
            this.isWorkerShutdown = true;
            this.shutdownCalled.countDown();
        }

        public void waitForShutdownComplete(long millis) throws InterruptedException {
            this.shutdownCalled.await(millis, TimeUnit.MILLISECONDS);
        }

        public synchronized boolean isWorkerShutdown() {
            return this.isWorkerShutdown;
        }
    }
}

