/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.server.remotetask;

import com.facebook.presto.server.remotetask.RemoteTaskStats;
import com.facebook.presto.server.remotetask.SimpleHttpResponseCallback;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.google.common.util.concurrent.FutureCallback;
import io.airlift.http.client.FullJsonResponseHandler;
import io.airlift.http.client.HttpStatus;
import java.net.URI;
import java.util.Objects;

public class SimpleHttpResponseHandler<T>
implements FutureCallback<FullJsonResponseHandler.JsonResponse<T>> {
    private final SimpleHttpResponseCallback<T> callback;
    private final URI uri;
    private final RemoteTaskStats stats;

    public SimpleHttpResponseHandler(SimpleHttpResponseCallback<T> callback, URI uri, RemoteTaskStats stats) {
        this.callback = callback;
        this.uri = uri;
        this.stats = Objects.requireNonNull(stats, "stats is null");
    }

    public void onSuccess(FullJsonResponseHandler.JsonResponse<T> response) {
        this.stats.updateSuccess();
        this.stats.responseSize(response.getResponseSize());
        try {
            if (response.getStatusCode() == HttpStatus.OK.code() && response.hasValue()) {
                this.callback.success(response.getValue());
            } else if (response.getStatusCode() == HttpStatus.SERVICE_UNAVAILABLE.code()) {
                this.callback.failed(new ServiceUnavailableException(this.uri));
            } else {
                Throwable cause = response.getException();
                cause = cause == null ? (response.getStatusCode() == HttpStatus.OK.code() ? new PrestoException((ErrorCodeSupplier)StandardErrorCode.REMOTE_TASK_ERROR, String.format("Expected response from %s is empty", this.uri)) : new PrestoException((ErrorCodeSupplier)StandardErrorCode.REMOTE_TASK_ERROR, String.format("Expected response code from %s to be %s, but was %s: %s%n%s", this.uri, HttpStatus.OK.code(), response.getStatusCode(), response.getStatusMessage(), response.getResponseBody()))) : new PrestoException((ErrorCodeSupplier)StandardErrorCode.REMOTE_TASK_ERROR, String.format("Unexpected response from %s", this.uri), cause);
                this.callback.fatal(cause);
            }
        }
        catch (Throwable t) {
            this.callback.fatal(t);
        }
    }

    public void onFailure(Throwable t) {
        this.stats.updateFailure();
        this.callback.failed(t);
    }

    private static class ServiceUnavailableException
    extends RuntimeException {
        public ServiceUnavailableException(URI uri) {
            super("Server returned SERVICE_UNAVAILABLE: " + uri);
        }
    }
}

