/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.server;

import com.facebook.presto.Session;
import com.facebook.presto.metadata.SessionPropertyManager;
import com.facebook.presto.security.AccessControl;
import com.facebook.presto.server.SessionContext;
import com.facebook.presto.server.SessionSupplier;
import com.facebook.presto.spi.QueryId;
import com.facebook.presto.spi.resourceGroups.ResourceGroupId;
import com.facebook.presto.spi.security.Identity;
import com.facebook.presto.spi.session.SessionConfigurationContext;
import com.facebook.presto.spi.session.SessionPropertyConfigurationManager;
import com.facebook.presto.spi.session.SessionPropertyConfigurationManagerFactory;
import com.facebook.presto.spi.type.TimeZoneKey;
import com.facebook.presto.transaction.TransactionManager;
import com.facebook.presto.util.PropertiesUtil;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import io.airlift.log.Logger;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.concurrent.ThreadSafe;
import javax.inject.Inject;

@ThreadSafe
public class QuerySessionSupplier
implements SessionSupplier {
    private static final Logger log = Logger.get(QuerySessionSupplier.class);
    private static final File SESSION_PROPERTY_CONFIGURATION = new File("etc/session-property-config.properties");
    private static final String SESSION_PROPERTY_MANAGER_NAME = "session-property-config.configuration-manager";
    private final TransactionManager transactionManager;
    private final AccessControl accessControl;
    private final SessionPropertyManager sessionPropertyManager;
    private final Map<String, SessionPropertyConfigurationManagerFactory> sessionPropertyConfigurationManagerFactories = new ConcurrentHashMap<String, SessionPropertyConfigurationManagerFactory>();
    private final AtomicReference<SessionPropertyConfigurationManager> sessionPropertyConfigurationManager = new AtomicReference();

    @Inject
    public QuerySessionSupplier(TransactionManager transactionManager, AccessControl accessControl, SessionPropertyManager sessionPropertyManager) {
        this.transactionManager = Objects.requireNonNull(transactionManager, "transactionManager is null");
        this.accessControl = Objects.requireNonNull(accessControl, "accessControl is null");
        this.sessionPropertyManager = Objects.requireNonNull(sessionPropertyManager, "sessionPropertyManager is null");
    }

    @Override
    public void addConfigurationManager(SessionPropertyConfigurationManagerFactory sessionConfigFactory) {
        if (this.sessionPropertyConfigurationManagerFactories.putIfAbsent(sessionConfigFactory.getName(), sessionConfigFactory) != null) {
            throw new IllegalArgumentException(String.format("Session property configuration manager '%s' is already registered", sessionConfigFactory.getName()));
        }
    }

    @Override
    public void loadConfigurationManager() throws IOException {
        if (!SESSION_PROPERTY_CONFIGURATION.exists()) {
            return;
        }
        HashMap<String, String> propertyMap = new HashMap<String, String>(PropertiesUtil.loadProperties(SESSION_PROPERTY_CONFIGURATION));
        log.info("-- Loading session property configuration manager --");
        String configManagerName = (String)propertyMap.remove(SESSION_PROPERTY_MANAGER_NAME);
        Preconditions.checkArgument((configManagerName != null ? 1 : 0) != 0, (String)"Session property configuration %s does not contain %s", (Object)SESSION_PROPERTY_CONFIGURATION, (Object)SESSION_PROPERTY_MANAGER_NAME);
        this.setConfigurationManager(configManagerName, propertyMap);
        log.info("-- Loaded session property configuration manager %s --", new Object[]{configManagerName});
    }

    @VisibleForTesting
    public void setConfigurationManager(String name, Map<String, String> properties) {
        SessionPropertyConfigurationManagerFactory factory = this.sessionPropertyConfigurationManagerFactories.get(name);
        Preconditions.checkState((factory != null ? 1 : 0) != 0, (Object)"Session property configuration manager %s is not registered");
        SessionPropertyConfigurationManager manager = factory.create(properties);
        Preconditions.checkState((boolean)this.sessionPropertyConfigurationManager.compareAndSet(null, manager), (Object)"sessionPropertyConfigurationManager is already set");
    }

    @Override
    public Session createSession(QueryId queryId, SessionContext context, Optional<String> queryType, ResourceGroupId resourceGroupId) {
        Identity identity = context.getIdentity();
        this.accessControl.checkCanSetUser(identity.getPrincipal().orElse(null), identity.getUser());
        Session.SessionBuilder sessionBuilder = Session.builder(this.sessionPropertyManager).setQueryId(queryId).setIdentity(identity).setSource(context.getSource()).setCatalog(context.getCatalog()).setSchema(context.getSchema()).setRemoteUserAddress(context.getRemoteUserAddress()).setUserAgent(context.getUserAgent()).setClientInfo(context.getClientInfo()).setClientTags(context.getClientTags()).setTraceToken(context.getTraceToken()).setResourceEstimates(context.getResourceEstimates());
        if (context.getTimeZoneId() != null) {
            sessionBuilder.setTimeZoneKey(TimeZoneKey.getTimeZoneKey((String)context.getTimeZoneId()));
        }
        if (context.getLanguage() != null) {
            sessionBuilder.setLocale(Locale.forLanguageTag(context.getLanguage()));
        }
        if (this.sessionPropertyConfigurationManager.get() != null) {
            SessionConfigurationContext configContext = new SessionConfigurationContext(context.getIdentity().getUser(), Optional.ofNullable(context.getSource()), context.getClientTags(), queryType, resourceGroupId);
            for (Map.Entry entry : this.sessionPropertyConfigurationManager.get().getSystemSessionProperties(configContext).entrySet()) {
                sessionBuilder.setSystemProperty((String)entry.getKey(), (String)entry.getValue());
            }
            for (Map.Entry catalogProperties : this.sessionPropertyConfigurationManager.get().getCatalogSessionProperties(configContext).entrySet()) {
                String catalog = (String)catalogProperties.getKey();
                for (Map.Entry entry : ((Map)catalogProperties.getValue()).entrySet()) {
                    sessionBuilder.setCatalogSessionProperty(catalog, (String)entry.getKey(), (String)entry.getValue());
                }
            }
        }
        for (Map.Entry<String, String> entry : context.getSystemProperties().entrySet()) {
            sessionBuilder.setSystemProperty(entry.getKey(), entry.getValue());
        }
        for (Map.Entry entry : context.getCatalogSessionProperties().entrySet()) {
            String catalog = (String)entry.getKey();
            for (Map.Entry entry2 : ((Map)entry.getValue()).entrySet()) {
                sessionBuilder.setCatalogSessionProperty(catalog, (String)entry2.getKey(), (String)entry2.getValue());
            }
        }
        for (Map.Entry entry : context.getPreparedStatements().entrySet()) {
            sessionBuilder.addPreparedStatement((String)entry.getKey(), (String)entry.getValue());
        }
        if (context.supportClientTransaction()) {
            sessionBuilder.setClientTransactionSupport();
        }
        Session session = sessionBuilder.build();
        if (context.getTransactionId().isPresent()) {
            session = session.beginTransactionId(context.getTransactionId().get(), this.transactionManager, this.accessControl);
        }
        return session;
    }
}

