/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.server;

import com.facebook.presto.connector.system.KillQueryProcedure;
import com.facebook.presto.execution.QueryInfo;
import com.facebook.presto.execution.QueryManager;
import com.facebook.presto.execution.QueryState;
import com.facebook.presto.execution.StageId;
import com.facebook.presto.server.BasicQueryInfo;
import com.facebook.presto.spi.QueryId;
import com.facebook.presto.spi.StandardErrorCode;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Locale;
import java.util.NoSuchElementException;
import java.util.Objects;
import javax.inject.Inject;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;

@Path(value="/v1/query")
public class QueryResource {
    private final QueryManager queryManager;

    @Inject
    public QueryResource(QueryManager queryManager) {
        this.queryManager = Objects.requireNonNull(queryManager, "queryManager is null");
    }

    @GET
    public List<BasicQueryInfo> getAllQueryInfo(@QueryParam(value="state") String queryState) {
        ImmutableList.Builder builder = new ImmutableList.Builder();
        for (QueryInfo queryInfo : this.queryManager.getAllQueryInfo()) {
            if (queryState != null && !queryInfo.getState().equals((Object)QueryState.valueOf(queryState.toUpperCase(Locale.ENGLISH)))) continue;
            builder.add((Object)new BasicQueryInfo(queryInfo));
        }
        return builder.build();
    }

    @GET
    @Path(value="{queryId}")
    public Response getQueryInfo(@PathParam(value="queryId") QueryId queryId) {
        Objects.requireNonNull(queryId, "queryId is null");
        try {
            QueryInfo queryInfo = this.queryManager.getQueryInfo(queryId);
            return Response.ok((Object)queryInfo).build();
        }
        catch (NoSuchElementException e) {
            return Response.status((Response.Status)Response.Status.GONE).build();
        }
    }

    @DELETE
    @Path(value="{queryId}")
    public void cancelQuery(@PathParam(value="queryId") QueryId queryId) {
        Objects.requireNonNull(queryId, "queryId is null");
        this.queryManager.cancelQuery(queryId);
    }

    @PUT
    @Path(value="{queryId}/killed")
    public Response killQuery(@PathParam(value="queryId") QueryId queryId, String message) {
        Objects.requireNonNull(queryId, "queryId is null");
        try {
            QueryInfo queryInfo = this.queryManager.getQueryInfo(queryId);
            if (queryInfo.getState().isDone()) {
                return Response.status((Response.Status)Response.Status.CONFLICT).build();
            }
            this.queryManager.failQuery(queryId, KillQueryProcedure.createKillQueryException(message));
            queryInfo = this.queryManager.getQueryInfo(queryId);
            if (queryInfo.getState() != QueryState.FAILED || !StandardErrorCode.ADMINISTRATIVELY_KILLED.toErrorCode().equals((Object)queryInfo.getErrorCode())) {
                return Response.status((Response.Status)Response.Status.CONFLICT).build();
            }
            return Response.status((Response.Status)Response.Status.OK).build();
        }
        catch (NoSuchElementException e) {
            return Response.status((Response.Status)Response.Status.GONE).build();
        }
    }

    @DELETE
    @Path(value="stage/{stageId}")
    public void cancelStage(@PathParam(value="stageId") StageId stageId) {
        Objects.requireNonNull(stageId, "stageId is null");
        this.queryManager.cancelStage(stageId);
    }
}

