/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.server;

import com.facebook.presto.execution.QueryStats;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalDouble;
import org.joda.time.DateTime;

public class QueryProgressStats {
    private final Optional<DateTime> executionStartTime;
    private final long elapsedTimeMillis;
    private final long queuedTimeMillis;
    private final long cpuTimeMillis;
    private final long scheduledTimeMillis;
    private final long blockedTimeMillis;
    private final long currentMemoryBytes;
    private final long peakMemoryBytes;
    private final long inputRows;
    private final long inputBytes;
    private final OptionalDouble progressPercentage;
    private final boolean blocked;

    @JsonCreator
    public QueryProgressStats(@JsonProperty(value="executionStartTime") Optional<DateTime> executionStartTime, @JsonProperty(value="elapsedTimeMillis") long elapsedTimeMillis, @JsonProperty(value="queuedTimeMillis") long queuedTimeMillis, @JsonProperty(value="cpuTimeMillis") long cpuTimeMillis, @JsonProperty(value="scheduledTimeMillis") long scheduledTimeMillis, @JsonProperty(value="blockedTimeMillis") long blockedTimeMillis, @JsonProperty(value="currentMemoryBytes") long currentMemoryBytes, @JsonProperty(value="peakMemoryBytes") long peakMemoryBytes, @JsonProperty(value="inputRows") long inputRows, @JsonProperty(value="inputBytes") long inputBytes, @JsonProperty(value="blocked") boolean blocked, @JsonProperty(value="progressPercentage") OptionalDouble progressPercentage) {
        this.executionStartTime = Objects.requireNonNull(executionStartTime, "executionStartTime is null");
        this.elapsedTimeMillis = elapsedTimeMillis;
        this.queuedTimeMillis = queuedTimeMillis;
        this.cpuTimeMillis = cpuTimeMillis;
        this.scheduledTimeMillis = scheduledTimeMillis;
        this.blockedTimeMillis = blockedTimeMillis;
        this.currentMemoryBytes = currentMemoryBytes;
        this.peakMemoryBytes = peakMemoryBytes;
        this.inputRows = inputRows;
        this.inputBytes = inputBytes;
        this.blocked = blocked;
        this.progressPercentage = Objects.requireNonNull(progressPercentage, "progressPercentage is null");
    }

    public static QueryProgressStats createQueryProgressStats(QueryStats queryStats) {
        return new QueryProgressStats(Optional.ofNullable(queryStats.getExecutionStartTime()), queryStats.getElapsedTime().toMillis(), queryStats.getQueuedTime().toMillis(), queryStats.getTotalCpuTime().toMillis(), queryStats.getTotalScheduledTime().toMillis(), queryStats.getTotalBlockedTime().toMillis(), queryStats.getUserMemoryReservation().toBytes(), queryStats.getPeakUserMemoryReservation().toBytes(), queryStats.getRawInputPositions(), queryStats.getRawInputDataSize().toBytes(), queryStats.isFullyBlocked(), queryStats.getProgressPercentage());
    }

    @JsonProperty
    public Optional<DateTime> getExecutionStartTime() {
        return this.executionStartTime;
    }

    @JsonProperty
    public long getElapsedTimeMillis() {
        return this.elapsedTimeMillis;
    }

    @JsonProperty
    public long getQueuedTimeMillis() {
        return this.queuedTimeMillis;
    }

    @JsonProperty
    public long getCpuTimeMillis() {
        return this.cpuTimeMillis;
    }

    @JsonProperty
    public long getScheduledTimeMillis() {
        return this.scheduledTimeMillis;
    }

    @JsonProperty
    public long getBlockedTimeMillis() {
        return this.blockedTimeMillis;
    }

    @JsonProperty
    public long getCurrentMemoryBytes() {
        return this.currentMemoryBytes;
    }

    @JsonProperty
    public long getPeakMemoryBytes() {
        return this.peakMemoryBytes;
    }

    @JsonProperty
    public long getInputRows() {
        return this.inputRows;
    }

    @JsonProperty
    public long getInputBytes() {
        return this.inputBytes;
    }

    @JsonProperty
    public boolean isBlocked() {
        return this.blocked;
    }

    @JsonProperty
    public OptionalDouble getProgressPercentage() {
        return this.progressPercentage;
    }
}

