/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar;

import com.facebook.presto.metadata.BoundVariables;
import com.facebook.presto.metadata.FunctionRegistry;
import com.facebook.presto.metadata.Signature;
import com.facebook.presto.metadata.SignatureBinder;
import com.facebook.presto.metadata.SqlScalarFunction;
import com.facebook.presto.operator.ParametricImplementationsGroup;
import com.facebook.presto.operator.scalar.ScalarFunctionImplementation;
import com.facebook.presto.operator.scalar.ScalarHeader;
import com.facebook.presto.operator.scalar.annotations.ScalarImplementation;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.type.TypeManager;
import com.facebook.presto.util.Failures;
import com.google.common.annotations.VisibleForTesting;
import java.util.Objects;
import java.util.Optional;

public class ParametricScalar
extends SqlScalarFunction {
    private final ScalarHeader details;
    private final ParametricImplementationsGroup<ScalarImplementation> implementations;

    public ParametricScalar(Signature signature, ScalarHeader details, ParametricImplementationsGroup<ScalarImplementation> implementations) {
        super(signature);
        this.details = Objects.requireNonNull(details);
        this.implementations = Objects.requireNonNull(implementations);
    }

    @Override
    public boolean isHidden() {
        return this.details.isHidden();
    }

    @Override
    public boolean isDeterministic() {
        return this.details.isDeterministic();
    }

    @Override
    public String getDescription() {
        return this.details.getDescription().isPresent() ? this.details.getDescription().get() : "";
    }

    @VisibleForTesting
    public ParametricImplementationsGroup<ScalarImplementation> getImplementations() {
        return this.implementations;
    }

    @Override
    public ScalarFunctionImplementation specialize(BoundVariables boundVariables, int arity, TypeManager typeManager, FunctionRegistry functionRegistry) {
        Optional<ScalarImplementation.MethodHandleAndConstructor> methodHandle;
        Signature boundSignature = SignatureBinder.applyBoundVariables(this.getSignature(), boundVariables, arity);
        if (this.implementations.getExactImplementations().containsKey(boundSignature)) {
            ScalarImplementation implementation = this.implementations.getExactImplementations().get(boundSignature);
            Optional<ScalarImplementation.MethodHandleAndConstructor> methodHandleAndConstructor = implementation.specialize(boundSignature, boundVariables, typeManager, functionRegistry);
            Failures.checkCondition(methodHandleAndConstructor.isPresent(), (ErrorCodeSupplier)StandardErrorCode.FUNCTION_IMPLEMENTATION_ERROR, String.format("Exact implementation of %s do not match expected java types.", boundSignature.getName()), new Object[0]);
            return new ScalarFunctionImplementation(implementation.isNullable(), implementation.getArgumentProperties(), methodHandleAndConstructor.get().getMethodHandle(), methodHandleAndConstructor.get().getConstructor(), this.isDeterministic());
        }
        ScalarFunctionImplementation selectedImplementation = null;
        for (ScalarImplementation implementation : this.implementations.getSpecializedImplementations()) {
            methodHandle = implementation.specialize(boundSignature, boundVariables, typeManager, functionRegistry);
            if (!methodHandle.isPresent()) continue;
            Failures.checkCondition(selectedImplementation == null, (ErrorCodeSupplier)StandardErrorCode.AMBIGUOUS_FUNCTION_IMPLEMENTATION, "Ambiguous implementation for %s with bindings %s", this.getSignature(), boundVariables.getTypeVariables());
            selectedImplementation = new ScalarFunctionImplementation(implementation.isNullable(), implementation.getArgumentProperties(), methodHandle.get().getMethodHandle(), methodHandle.get().getConstructor(), this.isDeterministic());
        }
        if (selectedImplementation != null) {
            return selectedImplementation;
        }
        for (ScalarImplementation implementation : this.implementations.getGenericImplementations()) {
            methodHandle = implementation.specialize(boundSignature, boundVariables, typeManager, functionRegistry);
            if (!methodHandle.isPresent()) continue;
            Failures.checkCondition(selectedImplementation == null, (ErrorCodeSupplier)StandardErrorCode.AMBIGUOUS_FUNCTION_IMPLEMENTATION, "Ambiguous implementation for %s with bindings %s", this.getSignature(), boundVariables.getTypeVariables());
            selectedImplementation = new ScalarFunctionImplementation(implementation.isNullable(), implementation.getArgumentProperties(), methodHandle.get().getMethodHandle(), methodHandle.get().getConstructor(), this.isDeterministic());
        }
        if (selectedImplementation != null) {
            return selectedImplementation;
        }
        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.FUNCTION_IMPLEMENTATION_MISSING, String.format("Unsupported type parameters (%s) for %s", boundVariables, this.getSignature()));
    }
}

