/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar;

import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.SingleMapBlock;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeUtils;
import com.facebook.presto.util.Failures;

public final class MapGenericEquality {
    private MapGenericEquality() {
    }

    public static Boolean genericEqual(Type keyType, Block leftBlock, Block rightBlock, EqualityPredicate predicate) {
        if (leftBlock.getPositionCount() != rightBlock.getPositionCount()) {
            return false;
        }
        SingleMapBlock leftSingleMapLeftBlock = (SingleMapBlock)leftBlock;
        SingleMapBlock rightSingleMapBlock = (SingleMapBlock)rightBlock;
        for (int position = 0; position < leftSingleMapLeftBlock.getPositionCount(); position += 2) {
            Object key = TypeUtils.readNativeValue((Type)keyType, (Block)leftBlock, (int)position);
            int leftPosition = position + 1;
            int rightPosition = rightSingleMapBlock.seekKey(key);
            if (rightPosition == -1) {
                return false;
            }
            try {
                Boolean result = predicate.equals(leftPosition, rightPosition);
                if (result == null) {
                    return null;
                }
                if (result.booleanValue()) continue;
                return false;
            }
            catch (Throwable t) {
                throw Failures.internalError(t);
            }
        }
        return true;
    }

    public static interface EqualityPredicate {
        public Boolean equals(int var1, int var2) throws Throwable;
    }
}

