/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar;

import com.facebook.presto.client.FailureInfo;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.function.Description;
import com.facebook.presto.spi.function.ScalarFunction;
import com.facebook.presto.spi.function.SqlType;
import io.airlift.json.JsonCodec;
import io.airlift.slice.Slice;

public final class FailureFunction {
    private static final JsonCodec<FailureInfo> JSON_CODEC = JsonCodec.jsonCodec(FailureInfo.class);

    private FailureFunction() {
    }

    @Description(value="Decodes json to an exception and throws it")
    @ScalarFunction(value="fail", hidden=true)
    @SqlType(value="unknown")
    public static void failWithException(@SqlType(value="json") Slice failureInfoSlice) {
        FailureInfo failureInfo = (FailureInfo)JSON_CODEC.fromJson(failureInfoSlice.getBytes());
        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_USER_ERROR, (Throwable)failureInfo.toException());
    }

    @Description(value="Throws an exception with a given message")
    @ScalarFunction(value="fail", hidden=true)
    @SqlType(value="unknown")
    public static void fail(@SqlType(value="varchar") Slice message) {
        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_USER_ERROR, message.toStringUtf8());
    }

    @Description(value="Throws an exception with a given error code and message")
    @ScalarFunction(value="fail", hidden=true)
    @SqlType(value="unknown")
    public static void fail(@SqlType(value="integer") long errorCode, @SqlType(value="varchar") Slice message) {
        for (StandardErrorCode standardErrorCode : StandardErrorCode.values()) {
            if ((long)standardErrorCode.toErrorCode().getCode() != errorCode) continue;
            throw new PrestoException((ErrorCodeSupplier)standardErrorCode, message.toStringUtf8());
        }
        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, "Unable to find error for code: " + errorCode);
    }
}

