/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar;

import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PageBuilder;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.function.Description;
import com.facebook.presto.spi.function.ScalarFunction;
import com.facebook.presto.spi.function.SqlType;
import com.facebook.presto.spi.function.TypeParameter;
import com.facebook.presto.spi.function.TypeParameterSpecialization;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.sql.gen.lambda.LambdaFunctionInterface;
import com.facebook.presto.util.Failures;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Ints;
import io.airlift.slice.Slice;
import java.util.List;

@ScalarFunction(value="array_sort")
@Description(value="Sorts the given array with a lambda comparator.")
public final class ArraySortComparatorFunction {
    private final PageBuilder pageBuilder;
    private static final int INITIAL_LENGTH = 128;
    private static final String COMPARATOR_RETURN_ERROR = "Lambda comparator must return either -1, 0, or 1";
    private List<Integer> positions = Ints.asList((int[])new int[128]);

    @TypeParameter(value="T")
    public ArraySortComparatorFunction(@TypeParameter(value="T") Type elementType) {
        this.pageBuilder = new PageBuilder((List)ImmutableList.of((Object)elementType));
    }

    @TypeParameter(value="T")
    @TypeParameterSpecialization(name="T", nativeContainerType=long.class)
    @SqlType(value="array(T)")
    public Block sortLong(@TypeParameter(value="T") Type type, @SqlType(value="array(T)") Block block, @SqlType(value="function(T, T, int)") ComparatorLongLambda function) {
        int arrayLength = block.getPositionCount();
        this.initPositionsList(arrayLength);
        this.positions.subList(0, arrayLength).sort((p1, p2) -> {
            Long lambdaResult = function.apply(block.isNull(p1.intValue()) ? null : Long.valueOf(type.getLong(block, p1.intValue())), block.isNull(p2.intValue()) ? null : Long.valueOf(type.getLong(block, p2.intValue())));
            Failures.checkCondition(lambdaResult != null && (lambdaResult == -1L || lambdaResult == 0L || lambdaResult == 1L), (ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, COMPARATOR_RETURN_ERROR, new Object[0]);
            return lambdaResult.intValue();
        });
        return this.computeResultBlock(type, block, arrayLength);
    }

    @TypeParameter(value="T")
    @TypeParameterSpecialization(name="T", nativeContainerType=double.class)
    @SqlType(value="array(T)")
    public Block sortDouble(@TypeParameter(value="T") Type type, @SqlType(value="array(T)") Block block, @SqlType(value="function(T, T, int)") ComparatorDoubleLambda function) {
        int arrayLength = block.getPositionCount();
        this.initPositionsList(arrayLength);
        this.positions.subList(0, arrayLength).sort((p1, p2) -> {
            Long lambdaResult = function.apply(block.isNull(p1.intValue()) ? null : Double.valueOf(type.getDouble(block, p1.intValue())), block.isNull(p2.intValue()) ? null : Double.valueOf(type.getDouble(block, p2.intValue())));
            Failures.checkCondition(lambdaResult != null && (lambdaResult == -1L || lambdaResult == 0L || lambdaResult == 1L), (ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, COMPARATOR_RETURN_ERROR, new Object[0]);
            return lambdaResult.intValue();
        });
        return this.computeResultBlock(type, block, arrayLength);
    }

    @TypeParameter(value="T")
    @TypeParameterSpecialization(name="T", nativeContainerType=boolean.class)
    @SqlType(value="array(T)")
    public Block sortBoolean(@TypeParameter(value="T") Type type, @SqlType(value="array(T)") Block block, @SqlType(value="function(T, T, int)") ComparatorBooleanLambda function) {
        int arrayLength = block.getPositionCount();
        this.initPositionsList(arrayLength);
        this.positions.subList(0, arrayLength).sort((p1, p2) -> {
            Long lambdaResult = function.apply(block.isNull(p1.intValue()) ? null : Boolean.valueOf(type.getBoolean(block, p1.intValue())), block.isNull(p2.intValue()) ? null : Boolean.valueOf(type.getBoolean(block, p2.intValue())));
            Failures.checkCondition(lambdaResult != null && (lambdaResult == -1L || lambdaResult == 0L || lambdaResult == 1L), (ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, COMPARATOR_RETURN_ERROR, new Object[0]);
            return lambdaResult.intValue();
        });
        return this.computeResultBlock(type, block, arrayLength);
    }

    @TypeParameter(value="T")
    @TypeParameterSpecialization(name="T", nativeContainerType=Slice.class)
    @SqlType(value="array(T)")
    public Block sortSlice(@TypeParameter(value="T") Type type, @SqlType(value="array(T)") Block block, @SqlType(value="function(T, T, int)") ComparatorSliceLambda function) {
        int arrayLength = block.getPositionCount();
        this.initPositionsList(arrayLength);
        this.positions.subList(0, arrayLength).sort((p1, p2) -> {
            Long lambdaResult = function.apply(block.isNull(p1.intValue()) ? null : type.getSlice(block, p1.intValue()), block.isNull(p2.intValue()) ? null : type.getSlice(block, p2.intValue()));
            Failures.checkCondition(lambdaResult != null && (lambdaResult == -1L || lambdaResult == 0L || lambdaResult == 1L), (ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, COMPARATOR_RETURN_ERROR, new Object[0]);
            return lambdaResult.intValue();
        });
        return this.computeResultBlock(type, block, arrayLength);
    }

    @TypeParameter(value="T")
    @TypeParameterSpecialization(name="T", nativeContainerType=Block.class)
    @SqlType(value="array(T)")
    public Block sortObject(@TypeParameter(value="T") Type type, @SqlType(value="array(T)") Block block, @SqlType(value="function(T, T, int)") ComparatorBlockLambda function) {
        int arrayLength = block.getPositionCount();
        this.initPositionsList(arrayLength);
        this.positions.subList(0, arrayLength).sort((p1, p2) -> {
            Long lambdaResult = function.apply(block.isNull(p1.intValue()) ? null : (Block)type.getObject(block, p1.intValue()), block.isNull(p2.intValue()) ? null : (Block)type.getObject(block, p2.intValue()));
            Failures.checkCondition(lambdaResult != null && (lambdaResult == -1L || lambdaResult == 0L || lambdaResult == 1L), (ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, COMPARATOR_RETURN_ERROR, new Object[0]);
            return lambdaResult.intValue();
        });
        return this.computeResultBlock(type, block, arrayLength);
    }

    private void initPositionsList(int arrayLength) {
        if (this.positions.size() < arrayLength) {
            this.positions = Ints.asList((int[])new int[arrayLength]);
        }
        for (int i = 0; i < arrayLength; ++i) {
            this.positions.set(i, i);
        }
    }

    private Block computeResultBlock(Type type, Block block, int arrayLength) {
        if (this.pageBuilder.isFull()) {
            this.pageBuilder.reset();
        }
        BlockBuilder blockBuilder = this.pageBuilder.getBlockBuilder(0);
        for (int i = 0; i < arrayLength; ++i) {
            type.appendTo(block, this.positions.get(i).intValue(), blockBuilder);
        }
        this.pageBuilder.declarePositions(arrayLength);
        return blockBuilder.getRegion(blockBuilder.getPositionCount() - arrayLength, arrayLength);
    }

    @FunctionalInterface
    public static interface ComparatorBlockLambda
    extends LambdaFunctionInterface {
        public Long apply(Block var1, Block var2);
    }

    @FunctionalInterface
    public static interface ComparatorSliceLambda
    extends LambdaFunctionInterface {
        public Long apply(Slice var1, Slice var2);
    }

    @FunctionalInterface
    public static interface ComparatorBooleanLambda
    extends LambdaFunctionInterface {
        public Long apply(Boolean var1, Boolean var2);
    }

    @FunctionalInterface
    public static interface ComparatorDoubleLambda
    extends LambdaFunctionInterface {
        public Long apply(Double var1, Double var2);
    }

    @FunctionalInterface
    public static interface ComparatorLongLambda
    extends LambdaFunctionInterface {
        public Long apply(Long var1, Long var2);
    }
}

