/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar;

import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.function.Description;
import com.facebook.presto.spi.function.OperatorDependency;
import com.facebook.presto.spi.function.OperatorType;
import com.facebook.presto.spi.function.ScalarFunction;
import com.facebook.presto.spi.function.SqlNullable;
import com.facebook.presto.spi.function.SqlType;
import com.facebook.presto.spi.function.TypeParameter;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.util.Failures;
import io.airlift.slice.Slice;
import java.lang.invoke.MethodHandle;

@Description(value="Returns the position of the first occurrence of the given value in array (or 0 if not found)")
@ScalarFunction(value="array_position")
public final class ArrayPositionFunction {
    private ArrayPositionFunction() {
    }

    @TypeParameter(value="T")
    @SqlType(value="bigint")
    public static long arrayPosition(@TypeParameter(value="T") Type type, @OperatorDependency(operator=OperatorType.EQUAL, returnType="boolean", argumentTypes={"T", "T"}) MethodHandle equalMethodHandle, @SqlType(value="array(T)") Block array, @SqlType(value="T") boolean element) {
        int size = array.getPositionCount();
        for (int i = 0; i < size; ++i) {
            if (array.isNull(i)) continue;
            boolean arrayValue = type.getBoolean(array, i);
            try {
                if (!equalMethodHandle.invokeExact(arrayValue, element)) continue;
                return i + 1;
            }
            catch (Throwable t) {
                throw Failures.internalError(t);
            }
        }
        return 0L;
    }

    @TypeParameter(value="T")
    @SqlType(value="bigint")
    public static long arrayPosition(@TypeParameter(value="T") Type type, @OperatorDependency(operator=OperatorType.EQUAL, returnType="boolean", argumentTypes={"T", "T"}) MethodHandle equalMethodHandle, @SqlType(value="array(T)") Block array, @SqlType(value="T") long element) {
        int size = array.getPositionCount();
        for (int i = 0; i < size; ++i) {
            if (array.isNull(i)) continue;
            long arrayValue = type.getLong(array, i);
            try {
                if (!equalMethodHandle.invokeExact(arrayValue, element)) continue;
                return i + 1;
            }
            catch (Throwable t) {
                throw Failures.internalError(t);
            }
        }
        return 0L;
    }

    @TypeParameter(value="T")
    @SqlType(value="bigint")
    public static long arrayPosition(@TypeParameter(value="T") Type type, @OperatorDependency(operator=OperatorType.EQUAL, returnType="boolean", argumentTypes={"T", "T"}) MethodHandle equalMethodHandle, @SqlType(value="array(T)") Block array, @SqlType(value="T") double element) {
        int size = array.getPositionCount();
        for (int i = 0; i < size; ++i) {
            if (array.isNull(i)) continue;
            double arrayValue = type.getDouble(array, i);
            try {
                if (!equalMethodHandle.invokeExact(arrayValue, element)) continue;
                return i + 1;
            }
            catch (Throwable t) {
                throw Failures.internalError(t);
            }
        }
        return 0L;
    }

    @TypeParameter(value="T")
    @SqlType(value="bigint")
    public static long arrayPosition(@TypeParameter(value="T") Type type, @OperatorDependency(operator=OperatorType.EQUAL, returnType="boolean", argumentTypes={"T", "T"}) MethodHandle equalMethodHandle, @SqlType(value="array(T)") Block array, @SqlType(value="T") Slice element) {
        int size = array.getPositionCount();
        for (int i = 0; i < size; ++i) {
            if (array.isNull(i)) continue;
            Slice arrayValue = type.getSlice(array, i);
            try {
                if (!equalMethodHandle.invokeExact(arrayValue, element)) continue;
                return i + 1;
            }
            catch (Throwable t) {
                throw Failures.internalError(t);
            }
        }
        return 0L;
    }

    @TypeParameter(value="T")
    @SqlType(value="bigint")
    public static long arrayPosition(@TypeParameter(value="T") Type type, @OperatorDependency(operator=OperatorType.EQUAL, returnType="boolean", argumentTypes={"T", "T"}) MethodHandle equalMethodHandle, @SqlType(value="array(T)") Block array, @SqlType(value="T") Block element) {
        int size = array.getPositionCount();
        for (int i = 0; i < size; ++i) {
            if (array.isNull(i)) continue;
            Object arrayValue = type.getObject(array, i);
            try {
                if (!equalMethodHandle.invoke(arrayValue, element)) continue;
                return i + 1;
            }
            catch (Throwable t) {
                throw Failures.internalError(t);
            }
        }
        return 0L;
    }

    @SqlType(value="bigint")
    @SqlNullable
    public static Long arrayPosition(@SqlType(value="array(unknown)") Block array, @SqlNullable @SqlType(value="unknown") Void element) {
        return null;
    }
}

