/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar;

import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.function.OperatorDependency;
import com.facebook.presto.spi.function.OperatorType;
import com.facebook.presto.spi.function.ScalarOperator;
import com.facebook.presto.spi.function.SqlType;
import com.facebook.presto.spi.function.TypeParameter;
import com.facebook.presto.spi.function.TypeParameterSpecialization;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeUtils;
import com.facebook.presto.util.Failures;
import java.lang.invoke.MethodHandle;

@ScalarOperator(value=OperatorType.EQUAL)
public final class ArrayEqualOperator {
    private ArrayEqualOperator() {
    }

    @TypeParameter(value="E")
    @SqlType(value="boolean")
    public static boolean equals(@OperatorDependency(operator=OperatorType.EQUAL, returnType="boolean", argumentTypes={"E", "E"}) MethodHandle equalsFunction, @TypeParameter(value="E") Type type, @SqlType(value="array(E)") Block leftArray, @SqlType(value="array(E)") Block rightArray) {
        if (leftArray.getPositionCount() != rightArray.getPositionCount()) {
            return false;
        }
        for (int i = 0; i < leftArray.getPositionCount(); ++i) {
            com.facebook.presto.type.TypeUtils.checkElementNotNull(leftArray.isNull(i), "ARRAY comparison not supported for arrays with null elements");
            com.facebook.presto.type.TypeUtils.checkElementNotNull(rightArray.isNull(i), "ARRAY comparison not supported for arrays with null elements");
            Object leftElement = TypeUtils.readNativeValue((Type)type, (Block)leftArray, (int)i);
            Object rightElement = TypeUtils.readNativeValue((Type)type, (Block)rightArray, (int)i);
            try {
                if (equalsFunction.invoke(leftElement, rightElement)) continue;
                return false;
            }
            catch (Throwable t) {
                throw Failures.internalError(t);
            }
        }
        return true;
    }

    @TypeParameter(value="E")
    @TypeParameterSpecialization(name="E", nativeContainerType=long.class)
    @SqlType(value="boolean")
    public static boolean equalsLong(@OperatorDependency(operator=OperatorType.EQUAL, returnType="boolean", argumentTypes={"E", "E"}) MethodHandle equalsFunction, @TypeParameter(value="E") Type type, @SqlType(value="array(E)") Block leftArray, @SqlType(value="array(E)") Block rightArray) {
        if (leftArray.getPositionCount() != rightArray.getPositionCount()) {
            return false;
        }
        for (int i = 0; i < leftArray.getPositionCount(); ++i) {
            com.facebook.presto.type.TypeUtils.checkElementNotNull(leftArray.isNull(i), "ARRAY comparison not supported for arrays with null elements");
            com.facebook.presto.type.TypeUtils.checkElementNotNull(rightArray.isNull(i), "ARRAY comparison not supported for arrays with null elements");
            long leftElement = type.getLong(leftArray, i);
            long rightElement = type.getLong(rightArray, i);
            try {
                if (equalsFunction.invokeExact(leftElement, rightElement)) continue;
                return false;
            }
            catch (Throwable t) {
                throw Failures.internalError(t);
            }
        }
        return true;
    }

    @TypeParameter(value="E")
    @TypeParameterSpecialization(name="E", nativeContainerType=double.class)
    @SqlType(value="boolean")
    public static boolean equalsDouble(@OperatorDependency(operator=OperatorType.EQUAL, returnType="boolean", argumentTypes={"E", "E"}) MethodHandle equalsFunction, @TypeParameter(value="E") Type type, @SqlType(value="array(E)") Block leftArray, @SqlType(value="array(E)") Block rightArray) {
        if (leftArray.getPositionCount() != rightArray.getPositionCount()) {
            return false;
        }
        for (int i = 0; i < leftArray.getPositionCount(); ++i) {
            com.facebook.presto.type.TypeUtils.checkElementNotNull(leftArray.isNull(i), "ARRAY comparison not supported for arrays with null elements");
            com.facebook.presto.type.TypeUtils.checkElementNotNull(rightArray.isNull(i), "ARRAY comparison not supported for arrays with null elements");
            double leftElement = type.getDouble(leftArray, i);
            double rightElement = type.getDouble(rightArray, i);
            try {
                if (equalsFunction.invokeExact(leftElement, rightElement)) continue;
                return false;
            }
            catch (Throwable t) {
                throw Failures.internalError(t);
            }
        }
        return true;
    }
}

