/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.project;

import com.facebook.presto.spi.Page;
import java.util.Collections;
import java.util.Iterator;
import java.util.Objects;
import java.util.Optional;
import java.util.function.LongSupplier;

public class PageProcessorOutput
implements Iterator<Optional<Page>> {
    public static final PageProcessorOutput EMPTY_PAGE_PROCESSOR_OUTPUT = new PageProcessorOutput(() -> 0L, Collections.emptyIterator());
    private final LongSupplier retainedSizeInBytesSupplier;
    private final Iterator<Optional<Page>> pages;
    private long retainedSizeInBytes;

    public PageProcessorOutput(LongSupplier retainedSizeInBytesSupplier, Iterator<Optional<Page>> pages) {
        this.retainedSizeInBytesSupplier = Objects.requireNonNull(retainedSizeInBytesSupplier, "retainedSizeInBytesSupplier is null");
        this.pages = Objects.requireNonNull(pages, "pages is null");
        this.retainedSizeInBytes = retainedSizeInBytesSupplier.getAsLong();
    }

    public long getRetainedSizeInBytes() {
        return this.retainedSizeInBytes;
    }

    @Override
    public boolean hasNext() {
        boolean result = this.pages.hasNext();
        this.retainedSizeInBytes = this.retainedSizeInBytesSupplier.getAsLong();
        return result;
    }

    @Override
    public Optional<Page> next() {
        return this.pages.next();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

