/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.project;

import com.facebook.presto.Session;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.operator.DriverYieldSignal;
import com.facebook.presto.operator.Work;
import com.facebook.presto.operator.project.InputChannels;
import com.facebook.presto.operator.project.PageProjection;
import com.facebook.presto.operator.project.SelectedPositions;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeUtils;
import com.facebook.presto.sql.analyzer.ExpressionAnalyzer;
import com.facebook.presto.sql.parser.SqlParser;
import com.facebook.presto.sql.planner.DeterminismEvaluator;
import com.facebook.presto.sql.planner.ExpressionInterpreter;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.SymbolToInputParameterRewriter;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.NodeRef;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class InterpretedPageProjection
implements PageProjection {
    private final ExpressionInterpreter evaluator;
    private final InputChannels inputChannels;
    private final boolean deterministic;
    private BlockBuilder blockBuilder;

    public InterpretedPageProjection(Expression expression, Map<Symbol, Type> symbolTypes, Map<Symbol, Integer> symbolToInputMappings, Metadata metadata, SqlParser sqlParser, Session session) {
        SymbolToInputParameterRewriter rewriter = new SymbolToInputParameterRewriter(symbolTypes, symbolToInputMappings);
        Expression rewritten = rewriter.rewrite(expression);
        this.inputChannels = new InputChannels(rewriter.getInputChannels());
        this.deterministic = DeterminismEvaluator.isDeterministic(expression);
        List<Type> inputTypes = rewriter.getInputTypes();
        ImmutableMap.Builder parameterTypes = ImmutableMap.builder();
        for (int parameter = 0; parameter < inputTypes.size(); ++parameter) {
            Type type = inputTypes.get(parameter);
            parameterTypes.put((Object)parameter, (Object)type);
        }
        Map<NodeRef<Expression>, Type> expressionTypes = ExpressionAnalyzer.getExpressionTypesFromInput(session, metadata, sqlParser, (Map<Integer, Type>)parameterTypes.build(), rewritten, Collections.emptyList());
        this.evaluator = ExpressionInterpreter.expressionInterpreter(rewritten, metadata, session, expressionTypes);
        this.blockBuilder = this.evaluator.getType().createBlockBuilder(null, 1);
    }

    @Override
    public Type getType() {
        return this.evaluator.getType();
    }

    @Override
    public boolean isDeterministic() {
        return this.deterministic;
    }

    @Override
    public InputChannels getInputChannels() {
        return this.inputChannels;
    }

    @Override
    public Work<Block> project(ConnectorSession session, DriverYieldSignal yieldSignal, Page page, SelectedPositions selectedPositions) {
        return new InterpretedPageProjectionWork(yieldSignal, page, selectedPositions);
    }

    private class InterpretedPageProjectionWork
    implements Work<Block> {
        private final DriverYieldSignal yieldSignal;
        private final Page page;
        private final SelectedPositions selectedPositions;
        private int nextIndexOrPosition;
        private Block result;

        public InterpretedPageProjectionWork(DriverYieldSignal yieldSignal, Page page, SelectedPositions selectedPositions) {
            this.yieldSignal = Objects.requireNonNull(yieldSignal, "yieldSignal is null");
            this.page = Objects.requireNonNull(page, "page is null");
            this.selectedPositions = Objects.requireNonNull(selectedPositions, "selectedPositions is null");
            this.nextIndexOrPosition = selectedPositions.getOffset();
        }

        @Override
        public boolean process() {
            Preconditions.checkState((this.result == null ? 1 : 0) != 0, (Object)"result has been generated");
            int length = this.selectedPositions.getOffset() + this.selectedPositions.size();
            if (this.selectedPositions.isList()) {
                int[] positions = this.selectedPositions.getPositions();
                while (this.nextIndexOrPosition < length) {
                    TypeUtils.writeNativeValue((Type)InterpretedPageProjection.this.evaluator.getType(), (BlockBuilder)InterpretedPageProjection.this.blockBuilder, (Object)InterpretedPageProjection.this.evaluator.evaluate(positions[this.nextIndexOrPosition], this.page));
                    ++this.nextIndexOrPosition;
                    if (!this.yieldSignal.isSet()) continue;
                    return false;
                }
            } else {
                while (this.nextIndexOrPosition < length) {
                    TypeUtils.writeNativeValue((Type)InterpretedPageProjection.this.evaluator.getType(), (BlockBuilder)InterpretedPageProjection.this.blockBuilder, (Object)InterpretedPageProjection.this.evaluator.evaluate(this.nextIndexOrPosition, this.page));
                    ++this.nextIndexOrPosition;
                    if (!this.yieldSignal.isSet()) continue;
                    return false;
                }
            }
            this.result = InterpretedPageProjection.this.blockBuilder.build();
            InterpretedPageProjection.this.blockBuilder = InterpretedPageProjection.this.blockBuilder.newBlockBuilderLike(null);
            return true;
        }

        @Override
        public Block getResult() {
            Preconditions.checkState((this.result != null ? 1 : 0) != 0, (Object)"result has not been generated");
            return this.result;
        }
    }
}

