/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.exchange;

import com.facebook.presto.operator.Operator;
import com.facebook.presto.operator.exchange.LocalExchanger;
import com.facebook.presto.spi.Page;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;

public class LocalExchangeSink {
    private final LocalExchanger exchanger;
    private final Consumer<LocalExchangeSink> onFinish;
    private final AtomicBoolean finished = new AtomicBoolean();

    public static LocalExchangeSink finishedLocalExchangeSink() {
        LocalExchangeSink finishedSink = new LocalExchangeSink(LocalExchanger.FINISHED, sink -> {});
        finishedSink.finish();
        return finishedSink;
    }

    public LocalExchangeSink(LocalExchanger exchanger, Consumer<LocalExchangeSink> onFinish) {
        this.exchanger = Objects.requireNonNull(exchanger, "exchanger is null");
        this.onFinish = Objects.requireNonNull(onFinish, "onFinish is null");
    }

    public void finish() {
        if (this.finished.compareAndSet(false, true)) {
            this.onFinish.accept(this);
        }
    }

    public boolean isFinished() {
        return this.finished.get();
    }

    public void addPage(Page page) {
        Objects.requireNonNull(page, "page is null");
        if (this.isFinished()) {
            return;
        }
        this.exchanger.accept(page);
    }

    public ListenableFuture<?> waitForWriting() {
        if (this.isFinished()) {
            return Operator.NOT_BLOCKED;
        }
        return this.exchanger.waitForWriting();
    }
}

