/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation.state;

import com.facebook.presto.operator.aggregation.state.LongDecimalWithOverflowAndLongState;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.function.AccumulatorStateSerializer;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.VarbinaryType;
import io.airlift.slice.BasicSliceInput;
import io.airlift.slice.Slice;
import io.airlift.slice.SliceOutput;
import io.airlift.slice.Slices;

public class LongDecimalWithOverflowAndLongStateSerializer
implements AccumulatorStateSerializer<LongDecimalWithOverflowAndLongState> {
    public Type getSerializedType() {
        return VarbinaryType.VARBINARY;
    }

    public void serialize(LongDecimalWithOverflowAndLongState state, BlockBuilder out) {
        if (state.getLongDecimal() == null) {
            out.appendNull();
        } else {
            Slice slice = Slices.allocate((int)32);
            SliceOutput output = slice.getOutput();
            output.writeLong(state.getLong());
            output.writeLong(state.getOverflow());
            output.writeBytes(state.getLongDecimal());
            VarbinaryType.VARBINARY.writeSlice(out, slice);
        }
    }

    public void deserialize(Block block, int index, LongDecimalWithOverflowAndLongState state) {
        if (!block.isNull(index)) {
            BasicSliceInput slice = VarbinaryType.VARBINARY.getSlice(block, index).getInput();
            state.setLong(slice.readLong());
            state.setOverflow(slice.readLong());
            state.setLongDecimal(Slices.copyOf((Slice)slice.readSlice(slice.available())));
        }
    }
}

