/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.operator.WorkProcessor;
import com.google.common.base.Preconditions;
import com.google.common.collect.AbstractIterator;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Objects;
import java.util.Optional;
import java.util.PriorityQueue;
import java.util.function.Function;

public final class WorkProcessorUtils {
    private WorkProcessorUtils() {
    }

    static <T> Iterator<T> iteratorFrom(final WorkProcessor<T> processor) {
        Objects.requireNonNull(processor, "processor is null");
        return new AbstractIterator<T>(){
            final Iterator<Optional<T>> yieldingIterator;
            {
                this.yieldingIterator = WorkProcessorUtils.yieldingIteratorFrom(processor);
            }

            protected T computeNext() {
                if (!this.yieldingIterator.hasNext()) {
                    return this.endOfData();
                }
                return this.yieldingIterator.next().orElseThrow(() -> new IllegalStateException("Cannot iterate over yielding WorkProcessor"));
            }
        };
    }

    static <T> Iterator<Optional<T>> yieldingIteratorFrom(final WorkProcessor<T> processor) {
        Objects.requireNonNull(processor, "processor is null");
        return new AbstractIterator<Optional<T>>(){

            protected Optional<T> computeNext() {
                if (processor.process()) {
                    if (processor.isFinished()) {
                        return (Optional)this.endOfData();
                    }
                    return Optional.of(processor.getResult());
                }
                if (processor.isBlocked()) {
                    throw new IllegalStateException("Cannot iterate over blocking WorkProcessor");
                }
                return Optional.empty();
            }
        };
    }

    static <T> WorkProcessor<T> fromIterator(Iterator<T> iterator) {
        Objects.requireNonNull(iterator, "iterator is null");
        return WorkProcessorUtils.create(() -> {
            if (!iterator.hasNext()) {
                return WorkProcessor.ProcessorState.finished();
            }
            return WorkProcessor.ProcessorState.ofResult(iterator.next());
        });
    }

    static <T> WorkProcessor<T> mergeSorted(Iterable<WorkProcessor<T>> processorIterable, Comparator<T> comparator) {
        Objects.requireNonNull(comparator, "comparator is null");
        final Iterator<WorkProcessor<T>> processorIterator = Objects.requireNonNull(processorIterable, "processorIterable is null").iterator();
        Preconditions.checkArgument((boolean)processorIterator.hasNext(), (Object)"There must be at least one base processor");
        final PriorityQueue<ElementAndProcessor> queue = new PriorityQueue<ElementAndProcessor>(2, Comparator.comparing(ElementAndProcessor::getElement, comparator));
        return WorkProcessorUtils.create(new WorkProcessor.Process<T>(){
            WorkProcessor<T> processor;
            {
                this.processor = (WorkProcessor)Objects.requireNonNull(processorIterator.next());
            }

            @Override
            public WorkProcessor.ProcessorState<T> process() {
                while (true) {
                    if (this.processor.process()) {
                        if (!this.processor.isFinished()) {
                            queue.add(new ElementAndProcessor(this.processor.getResult(), this.processor));
                        }
                    } else {
                        if (this.processor.isBlocked()) {
                            return WorkProcessor.ProcessorState.blocked(this.processor.getBlockedFuture());
                        }
                        return WorkProcessor.ProcessorState.yield();
                    }
                    if (!processorIterator.hasNext()) break;
                    this.processor = (WorkProcessor)processorIterator.next();
                }
                if (queue.isEmpty()) {
                    return WorkProcessor.ProcessorState.finished();
                }
                ElementAndProcessor elementAndProcessor = (ElementAndProcessor)queue.poll();
                this.processor = elementAndProcessor.getProcessor();
                return WorkProcessor.ProcessorState.ofResult(elementAndProcessor.getElement());
            }
        });
    }

    static <T, R> WorkProcessor<R> flatMap(WorkProcessor<T> processor, Function<T, WorkProcessor<R>> mapper) {
        Objects.requireNonNull(processor, "processor is null");
        Objects.requireNonNull(mapper, "mapper is null");
        return processor.flatTransform(elementOptional -> elementOptional.map(element -> WorkProcessor.ProcessorState.ofResult(mapper.apply(element))).orElse(WorkProcessor.ProcessorState.finished()));
    }

    static <T, R> WorkProcessor<R> map(WorkProcessor<T> processor, Function<T, R> mapper) {
        Objects.requireNonNull(processor, "processor is null");
        Objects.requireNonNull(mapper, "mapper is null");
        return processor.transform(elementOptional -> elementOptional.map(element -> WorkProcessor.ProcessorState.ofResult(mapper.apply(element))).orElse(WorkProcessor.ProcessorState.finished()));
    }

    static <T, R> WorkProcessor<R> flatTransform(WorkProcessor<T> processor, final WorkProcessor.Transformation<T, WorkProcessor<R>> transformation) {
        Objects.requireNonNull(processor, "processor is null");
        Objects.requireNonNull(transformation, "transformation is null");
        return processor.transform(new WorkProcessor.Transformation<T, R>(){
            WorkProcessor<R> processor;
            boolean needsMoreData;

            @Override
            public WorkProcessor.ProcessorState<R> process(Optional<T> elementOptional) {
                block5: {
                    do {
                        if (this.processor == null) {
                            WorkProcessor.ProcessorState state = transformation.process(elementOptional);
                            if (state.getType() != WorkProcessor.ProcessorState.Type.RESULT) {
                                return new WorkProcessor.ProcessorState(state.getType(), state.isNeedsMoreData(), Optional.empty(), state.getBlocked());
                            }
                            this.processor = (WorkProcessor)state.getResult().get();
                            this.needsMoreData = state.isNeedsMoreData();
                        }
                        if (!this.processor.process()) break block5;
                        if (!this.processor.isFinished()) {
                            return WorkProcessor.ProcessorState.ofResult(this.processor.getResult(), false);
                        }
                        this.processor = null;
                    } while (!this.needsMoreData);
                    return WorkProcessor.ProcessorState.needsMoreData();
                }
                if (this.processor.isBlocked()) {
                    return WorkProcessor.ProcessorState.blocked(this.processor.getBlockedFuture());
                }
                return WorkProcessor.ProcessorState.yield();
            }
        });
    }

    static <T, R> WorkProcessor<R> transform(final WorkProcessor<T> processor, final WorkProcessor.Transformation<T, R> transformation) {
        Objects.requireNonNull(processor, "processor is null");
        Objects.requireNonNull(transformation, "transformation is null");
        return WorkProcessorUtils.create(new WorkProcessor.Process<R>(){
            Optional<T> element = Optional.empty();

            @Override
            public WorkProcessor.ProcessorState<R> process() {
                WorkProcessor.ProcessorState state;
                do {
                    if (!this.element.isPresent() && !processor.isFinished()) {
                        if (processor.process()) {
                            if (!processor.isFinished()) {
                                this.element = Optional.of(processor.getResult());
                            }
                        } else {
                            if (processor.isBlocked()) {
                                return WorkProcessor.ProcessorState.blocked(processor.getBlockedFuture());
                            }
                            return WorkProcessor.ProcessorState.yield();
                        }
                    }
                    if (!(state = Objects.requireNonNull(transformation.process(this.element), "state is null")).isNeedsMoreData()) continue;
                    Preconditions.checkState((!processor.isFinished() ? 1 : 0) != 0, (Object)"Cannot request more data when base processor is finished");
                    this.element = Optional.empty();
                } while (state.getType() == WorkProcessor.ProcessorState.Type.NEEDS_MORE_DATA);
                return state;
            }
        });
    }

    static <T> WorkProcessor<T> create(final WorkProcessor.Process<T> process) {
        Objects.requireNonNull(process, "process is null");
        return new WorkProcessor<T>(){
            WorkProcessor.ProcessorState<T> state;

            @Override
            public boolean process() {
                if (this.isBlocked()) {
                    return false;
                }
                if (this.isFinished()) {
                    return true;
                }
                this.state = Objects.requireNonNull(process.process());
                Preconditions.checkState((this.state.getType() != WorkProcessor.ProcessorState.Type.NEEDS_MORE_DATA ? 1 : 0) != 0, (Object)"Unexpected state: NEEDS_MORE_DATA");
                return this.state.getType() == WorkProcessor.ProcessorState.Type.RESULT || this.state.getType() == WorkProcessor.ProcessorState.Type.FINISHED;
            }

            @Override
            public boolean isBlocked() {
                return this.state != null && this.state.getType() == WorkProcessor.ProcessorState.Type.BLOCKED && !this.state.getBlocked().get().isDone();
            }

            @Override
            public ListenableFuture<?> getBlockedFuture() {
                Preconditions.checkState((this.state != null && this.state.getType() == WorkProcessor.ProcessorState.Type.BLOCKED ? 1 : 0) != 0, (Object)"Must be blocked to get blocked future");
                return this.state.getBlocked().get();
            }

            @Override
            public boolean isFinished() {
                return this.state != null && this.state.getType() == WorkProcessor.ProcessorState.Type.FINISHED;
            }

            @Override
            public T getResult() {
                Preconditions.checkState((this.state != null && this.state.getType() == WorkProcessor.ProcessorState.Type.RESULT ? 1 : 0) != 0, (Object)"process() must return true and must not be finished");
                return this.state.getResult().get();
            }
        };
    }

    private static class ElementAndProcessor<T> {
        final T element;
        final WorkProcessor<T> processor;

        ElementAndProcessor(T element, WorkProcessor<T> processor) {
            this.element = element;
            this.processor = processor;
        }

        T getElement() {
            return this.element;
        }

        WorkProcessor<T> getProcessor() {
            return this.processor;
        }
    }
}

