/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.memory.context.LocalMemoryContext;
import com.facebook.presto.operator.DriverContext;
import com.facebook.presto.operator.GroupedTopNBuilder;
import com.facebook.presto.operator.NoChannelGroupByHash;
import com.facebook.presto.operator.Operator;
import com.facebook.presto.operator.OperatorContext;
import com.facebook.presto.operator.OperatorFactory;
import com.facebook.presto.operator.SimplePageWithPositionComparator;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.block.SortOrder;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.sql.planner.plan.PlanNodeId;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;

public class TopNOperator
implements Operator {
    private final OperatorContext operatorContext;
    private final LocalMemoryContext localUserMemoryContext;
    private final List<Type> types;
    private GroupedTopNBuilder topNBuilder;
    private boolean finishing;
    private Iterator<Page> outputIterator;

    public TopNOperator(OperatorContext operatorContext, List<Type> types, int n, List<Integer> sortChannels, List<SortOrder> sortOrders) {
        this.operatorContext = Objects.requireNonNull(operatorContext, "operatorContext is null");
        this.localUserMemoryContext = operatorContext.localUserMemoryContext();
        this.types = Objects.requireNonNull(types, "types is null");
        Preconditions.checkArgument((n >= 0 ? 1 : 0) != 0, (Object)"n must be positive");
        if (n == 0) {
            this.finishing = true;
            this.outputIterator = Collections.emptyIterator();
        } else {
            this.topNBuilder = new GroupedTopNBuilder(types, new SimplePageWithPositionComparator(types, sortChannels, sortOrders), n, false, new NoChannelGroupByHash());
        }
    }

    @Override
    public OperatorContext getOperatorContext() {
        return this.operatorContext;
    }

    @Override
    public void finish() {
        this.finishing = true;
    }

    @Override
    public boolean isFinished() {
        return this.finishing && this.noMoreOutput();
    }

    @Override
    public boolean needsInput() {
        return !this.finishing && !this.noMoreOutput();
    }

    @Override
    public void addInput(Page page) {
        Preconditions.checkState((!this.finishing ? 1 : 0) != 0, (Object)"Operator is already finishing");
        boolean done = this.topNBuilder.processPage(Objects.requireNonNull(page, "page is null")).process();
        Verify.verify((boolean)done);
        this.updateMemoryReservation();
    }

    @Override
    public Page getOutput() {
        if (!this.finishing || this.noMoreOutput()) {
            return null;
        }
        if (this.outputIterator == null) {
            this.outputIterator = this.topNBuilder.buildResult();
        }
        Page output = null;
        if (this.outputIterator.hasNext()) {
            output = this.outputIterator.next();
        } else {
            this.outputIterator = Collections.emptyIterator();
        }
        this.updateMemoryReservation();
        return output;
    }

    private void updateMemoryReservation() {
        this.localUserMemoryContext.setBytes(this.topNBuilder.getEstimatedSizeInBytes());
    }

    private boolean noMoreOutput() {
        return this.outputIterator != null && !this.outputIterator.hasNext();
    }

    public static class TopNOperatorFactory
    implements OperatorFactory {
        private final int operatorId;
        private final PlanNodeId planNodeId;
        private final List<Type> sourceTypes;
        private final int n;
        private final List<Integer> sortChannels;
        private final List<SortOrder> sortOrders;
        private boolean closed;

        public TopNOperatorFactory(int operatorId, PlanNodeId planNodeId, List<? extends Type> types, int n, List<Integer> sortChannels, List<SortOrder> sortOrders) {
            this.operatorId = operatorId;
            this.planNodeId = Objects.requireNonNull(planNodeId, "planNodeId is null");
            this.sourceTypes = ImmutableList.copyOf((Collection)Objects.requireNonNull(types, "types is null"));
            this.n = n;
            this.sortChannels = ImmutableList.copyOf((Collection)Objects.requireNonNull(sortChannels, "sortChannels is null"));
            this.sortOrders = ImmutableList.copyOf((Collection)Objects.requireNonNull(sortOrders, "sortOrders is null"));
        }

        @Override
        public Operator createOperator(DriverContext driverContext) {
            Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"Factory is already closed");
            OperatorContext operatorContext = driverContext.addOperatorContext(this.operatorId, this.planNodeId, TopNOperator.class.getSimpleName());
            return new TopNOperator(operatorContext, this.sourceTypes, this.n, this.sortChannels, this.sortOrders);
        }

        @Override
        public void noMoreOperators() {
            this.closed = true;
        }

        @Override
        public OperatorFactory duplicate() {
            return new TopNOperatorFactory(this.operatorId, this.planNodeId, this.sourceTypes, this.n, this.sortChannels, this.sortOrders);
        }
    }
}

