/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.operator.OperatorInfo;
import com.facebook.presto.spi.connector.ConnectorOutputMetadata;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonRawValue;
import com.fasterxml.jackson.databind.JsonNode;
import io.airlift.json.JsonCodec;
import io.airlift.units.DataSize;
import java.util.Optional;

public class TableFinishInfo
implements OperatorInfo {
    private static final int JSON_LENGTH_LIMIT = Math.toIntExact(new DataSize(10.0, DataSize.Unit.MEGABYTE).toBytes());
    private static final JsonCodec<Object> INFO_CODEC = JsonCodec.jsonCodec(Object.class);
    private static final JsonCodec<JsonNode> JSON_NODE_CODEC = JsonCodec.jsonCodec(JsonNode.class);
    private String connectorOutputMetadata;
    private boolean jsonLengthLimitExceeded;

    public TableFinishInfo(Optional<ConnectorOutputMetadata> metadata) {
        if (metadata.isPresent()) {
            Optional serializedMetadata = INFO_CODEC.toJsonWithLengthLimit(metadata.get().getInfo(), JSON_LENGTH_LIMIT);
            if (!serializedMetadata.isPresent()) {
                this.jsonLengthLimitExceeded = true;
            } else {
                this.connectorOutputMetadata = (String)serializedMetadata.get();
            }
        }
    }

    @JsonCreator
    public TableFinishInfo(@JsonProperty(value="connectorOutputMetadata") JsonNode connectorOutputMetadata) {
        this.connectorOutputMetadata = JSON_NODE_CODEC.toJson((Object)connectorOutputMetadata);
    }

    @Override
    public boolean isFinal() {
        return true;
    }

    @JsonProperty
    @JsonRawValue
    public String getConnectorOutputMetadata() {
        return this.connectorOutputMetadata;
    }

    @JsonProperty
    public boolean isJsonLengthLimitExceeded() {
        return this.jsonLengthLimitExceeded;
    }
}

