/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.operator.InternalJoinFilterFunction;
import com.facebook.presto.operator.JoinFilterFunction;
import com.facebook.presto.operator.SyntheticAddress;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.block.Block;
import com.google.common.collect.ImmutableList;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import java.util.List;
import java.util.Objects;

public class StandardJoinFilterFunction
implements JoinFilterFunction {
    private static final Page EMPTY_PAGE = new Page(0, new Block[0]);
    private final InternalJoinFilterFunction filterFunction;
    private final LongArrayList addresses;
    private final List<Page> pages;

    public StandardJoinFilterFunction(InternalJoinFilterFunction filterFunction, LongArrayList addresses, List<List<Block>> channels) {
        this.filterFunction = Objects.requireNonNull(filterFunction, "filterFunction can not be null");
        this.addresses = Objects.requireNonNull(addresses, "addresses is null");
        Objects.requireNonNull(channels, "channels can not be null");
        ImmutableList.Builder pagesBuilder = ImmutableList.builder();
        if (!channels.isEmpty()) {
            int pagesCount = channels.get(0).size();
            for (int pageIndex = 0; pageIndex < pagesCount; ++pageIndex) {
                Block[] blocks = new Block[channels.size()];
                for (int channelIndex = 0; channelIndex < channels.size(); ++channelIndex) {
                    blocks[channelIndex] = channels.get(channelIndex).get(pageIndex);
                }
                pagesBuilder.add((Object)new Page(blocks));
            }
        }
        this.pages = pagesBuilder.build();
    }

    @Override
    public boolean filter(int leftPosition, int rightPosition, Page rightPage) {
        long pageAddress = this.addresses.getLong(leftPosition);
        int blockIndex = SyntheticAddress.decodeSliceIndex(pageAddress);
        int blockPosition = SyntheticAddress.decodePosition(pageAddress);
        return this.filterFunction.filter(blockPosition, this.pages.isEmpty() ? EMPTY_PAGE : this.pages.get(blockIndex), rightPosition, rightPage);
    }
}

