/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.Session;
import com.facebook.presto.memory.QueryContextVisitor;
import com.facebook.presto.memory.context.AggregatedMemoryContext;
import com.facebook.presto.memory.context.LocalMemoryContext;
import com.facebook.presto.memory.context.MemoryTrackingContext;
import com.facebook.presto.operator.BlockedReason;
import com.facebook.presto.operator.DriverContext;
import com.facebook.presto.operator.OperatorInfo;
import com.facebook.presto.operator.OperatorStats;
import com.facebook.presto.operator.SpillContext;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.sql.planner.plan.PlanNodeId;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.SettableFuture;
import io.airlift.stats.CounterStat;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;

public class OperatorContext {
    private static final ThreadMXBean THREAD_MX_BEAN = ManagementFactory.getThreadMXBean();
    private final int operatorId;
    private final PlanNodeId planNodeId;
    private final String operatorType;
    private final DriverContext driverContext;
    private final Executor executor;
    private final AtomicLong intervalWallStart = new AtomicLong();
    private final AtomicLong intervalCpuStart = new AtomicLong();
    private final AtomicLong intervalUserStart = new AtomicLong();
    private final AtomicLong addInputCalls = new AtomicLong();
    private final AtomicLong addInputWallNanos = new AtomicLong();
    private final AtomicLong addInputCpuNanos = new AtomicLong();
    private final AtomicLong addInputUserNanos = new AtomicLong();
    private final CounterStat inputDataSize = new CounterStat();
    private final CounterStat inputPositions = new CounterStat();
    private final AtomicLong getOutputCalls = new AtomicLong();
    private final AtomicLong getOutputWallNanos = new AtomicLong();
    private final AtomicLong getOutputCpuNanos = new AtomicLong();
    private final AtomicLong getOutputUserNanos = new AtomicLong();
    private final CounterStat outputDataSize = new CounterStat();
    private final CounterStat outputPositions = new CounterStat();
    private final AtomicLong physicalWrittenDataSize = new AtomicLong();
    private final AtomicReference<SettableFuture<?>> memoryFuture;
    private final AtomicReference<SettableFuture<?>> revocableMemoryFuture;
    private final AtomicReference<BlockedMonitor> blockedMonitor = new AtomicReference();
    private final AtomicLong blockedWallNanos = new AtomicLong();
    private final AtomicLong finishCalls = new AtomicLong();
    private final AtomicLong finishWallNanos = new AtomicLong();
    private final AtomicLong finishCpuNanos = new AtomicLong();
    private final AtomicLong finishUserNanos = new AtomicLong();
    private final SpillContext spillContext;
    private final AtomicReference<Supplier<OperatorInfo>> infoSupplier = new AtomicReference();
    private final boolean collectTimings;
    @GuardedBy(value="this")
    private boolean memoryRevokingRequested;
    @Nullable
    @GuardedBy(value="this")
    private Runnable memoryRevocationRequestListener;
    private final MemoryTrackingContext operatorMemoryContext;

    public OperatorContext(int operatorId, PlanNodeId planNodeId, String operatorType, DriverContext driverContext, Executor executor, MemoryTrackingContext operatorMemoryContext) {
        Preconditions.checkArgument((operatorId >= 0 ? 1 : 0) != 0, (Object)"operatorId is negative");
        this.operatorId = operatorId;
        this.planNodeId = Objects.requireNonNull(planNodeId, "planNodeId is null");
        this.operatorType = Objects.requireNonNull(operatorType, "operatorType is null");
        this.driverContext = Objects.requireNonNull(driverContext, "driverContext is null");
        this.spillContext = new OperatorSpillContext(this.driverContext);
        this.executor = Objects.requireNonNull(executor, "executor is null");
        this.memoryFuture = new AtomicReference<SettableFuture>(SettableFuture.create());
        this.memoryFuture.get().set(null);
        this.revocableMemoryFuture = new AtomicReference<SettableFuture>(SettableFuture.create());
        this.revocableMemoryFuture.get().set(null);
        this.operatorMemoryContext = Objects.requireNonNull(operatorMemoryContext, "operatorMemoryContext is null");
        this.collectTimings = driverContext.isVerboseStats() && driverContext.isCpuTimerEnabled();
    }

    public int getOperatorId() {
        return this.operatorId;
    }

    public String getOperatorType() {
        return this.operatorType;
    }

    public DriverContext getDriverContext() {
        return this.driverContext;
    }

    public Session getSession() {
        return this.driverContext.getSession();
    }

    public boolean isDone() {
        return this.driverContext.isDone();
    }

    public void startIntervalTimer() {
        this.intervalWallStart.set(System.nanoTime());
        this.intervalCpuStart.set(this.currentThreadCpuTime());
        this.intervalUserStart.set(this.currentThreadUserTime());
    }

    public void recordAddInput(Page page) {
        this.addInputCalls.incrementAndGet();
        this.recordInputWallNanos(OperatorContext.nanosBetween(this.intervalWallStart.get(), System.nanoTime()));
        this.addInputCpuNanos.getAndAdd(OperatorContext.nanosBetween(this.intervalCpuStart.get(), this.currentThreadCpuTime()));
        this.addInputUserNanos.getAndAdd(OperatorContext.nanosBetween(this.intervalUserStart.get(), this.currentThreadUserTime()));
        if (page != null) {
            this.inputDataSize.update(page.getSizeInBytes());
            this.inputPositions.update((long)page.getPositionCount());
        }
    }

    public void recordGeneratedInput(long sizeInBytes, long positions) {
        this.recordGeneratedInput(sizeInBytes, positions, 0L);
    }

    public void recordGeneratedInput(long sizeInBytes, long positions, long readNanos) {
        this.inputDataSize.update(sizeInBytes);
        this.inputPositions.update(positions);
        this.recordInputWallNanos(readNanos);
    }

    public long recordInputWallNanos(long readNanos) {
        return this.addInputWallNanos.getAndAdd(readNanos);
    }

    public void recordGetOutput(Page page) {
        this.getOutputCalls.incrementAndGet();
        this.getOutputWallNanos.getAndAdd(OperatorContext.nanosBetween(this.intervalWallStart.get(), System.nanoTime()));
        this.getOutputCpuNanos.getAndAdd(OperatorContext.nanosBetween(this.intervalCpuStart.get(), this.currentThreadCpuTime()));
        this.getOutputUserNanos.getAndAdd(OperatorContext.nanosBetween(this.intervalUserStart.get(), this.currentThreadUserTime()));
        if (page != null) {
            this.outputDataSize.update(page.getSizeInBytes());
            this.outputPositions.update((long)page.getPositionCount());
        }
    }

    public void recordGeneratedOutput(long sizeInBytes, long positions) {
        this.outputDataSize.update(sizeInBytes);
        this.outputPositions.update(positions);
    }

    public void recordPhysicalWrittenData(long sizeInBytes) {
        this.physicalWrittenDataSize.getAndAdd(sizeInBytes);
    }

    public void recordBlocked(ListenableFuture<?> blocked) {
        Objects.requireNonNull(blocked, "blocked is null");
        BlockedMonitor monitor = new BlockedMonitor();
        BlockedMonitor oldMonitor = this.blockedMonitor.getAndSet(monitor);
        if (oldMonitor != null) {
            oldMonitor.run();
        }
        blocked.addListener((Runnable)monitor, this.executor);
    }

    public void recordFinish() {
        this.finishCalls.incrementAndGet();
        this.finishWallNanos.getAndAdd(OperatorContext.nanosBetween(this.intervalWallStart.get(), System.nanoTime()));
        this.finishCpuNanos.getAndAdd(OperatorContext.nanosBetween(this.intervalCpuStart.get(), this.currentThreadCpuTime()));
        this.finishUserNanos.getAndAdd(OperatorContext.nanosBetween(this.intervalUserStart.get(), this.currentThreadUserTime()));
    }

    public ListenableFuture<?> isWaitingForMemory() {
        return (ListenableFuture)this.memoryFuture.get();
    }

    public ListenableFuture<?> isWaitingForRevocableMemory() {
        return (ListenableFuture)this.revocableMemoryFuture.get();
    }

    public LocalMemoryContext newLocalSystemMemoryContext() {
        return new InternalLocalMemoryContext(this.operatorMemoryContext.newSystemMemoryContext(), this.memoryFuture);
    }

    public LocalMemoryContext localUserMemoryContext() {
        return new InternalLocalMemoryContext(this.operatorMemoryContext.localUserMemoryContext(), this.memoryFuture);
    }

    public LocalMemoryContext localRevocableMemoryContext() {
        return new InternalLocalMemoryContext(this.operatorMemoryContext.localRevocableMemoryContext(), this.revocableMemoryFuture);
    }

    public AggregatedMemoryContext newAggregateSystemMemoryContext() {
        return new InternalAggregatedMemoryContext(this.operatorMemoryContext.newAggregateSystemMemoryContext(), this.memoryFuture);
    }

    public long getReservedRevocableBytes() {
        return this.operatorMemoryContext.getRevocableMemory();
    }

    private static void updateMemoryFuture(ListenableFuture<?> memoryPoolFuture, AtomicReference<SettableFuture<?>> targetFutureReference) {
        if (!memoryPoolFuture.isDone()) {
            SettableFuture<?> currentMemoryFuture = targetFutureReference.get();
            while (currentMemoryFuture.isDone()) {
                SettableFuture<?> settableFuture = SettableFuture.create();
                if (targetFutureReference.compareAndSet(currentMemoryFuture, settableFuture)) {
                    currentMemoryFuture = settableFuture;
                    continue;
                }
                currentMemoryFuture = targetFutureReference.get();
            }
            SettableFuture<?> finalMemoryFuture = currentMemoryFuture;
            memoryPoolFuture.addListener(() -> finalMemoryFuture.set(null), MoreExecutors.directExecutor());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        OperatorContext operatorContext = this;
        synchronized (operatorContext) {
            this.memoryRevocationRequestListener = null;
        }
        this.operatorMemoryContext.close();
        if (this.operatorMemoryContext.getSystemMemory() != 0L) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, String.format("Operator %s has non-zero system memory (%d bytes) after destroy()", this, this.operatorMemoryContext.getSystemMemory()));
        }
        if (this.operatorMemoryContext.getUserMemory() != 0L) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, String.format("Operator %s has non-zero user memory (%d bytes) after destroy()", this, this.operatorMemoryContext.getUserMemory()));
        }
        if (this.operatorMemoryContext.getRevocableMemory() != 0L) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, String.format("Operator %s has non-zero revocable memory (%d bytes) after destroy()", this, this.operatorMemoryContext.getRevocableMemory()));
        }
    }

    public SpillContext getSpillContext() {
        return this.spillContext;
    }

    public void moreMemoryAvailable() {
        this.memoryFuture.get().set(null);
    }

    public synchronized boolean isMemoryRevokingRequested() {
        return this.memoryRevokingRequested;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long requestMemoryRevoking() {
        long revokedMemory = 0L;
        Runnable listener = null;
        OperatorContext operatorContext = this;
        synchronized (operatorContext) {
            if (!this.isMemoryRevokingRequested() && this.operatorMemoryContext.getRevocableMemory() > 0L) {
                this.memoryRevokingRequested = true;
                revokedMemory = this.operatorMemoryContext.getRevocableMemory();
                listener = this.memoryRevocationRequestListener;
            }
        }
        if (listener != null) {
            OperatorContext.runListener(listener);
        }
        return revokedMemory;
    }

    public synchronized void resetMemoryRevokingRequested() {
        this.memoryRevokingRequested = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMemoryRevocationRequestListener(Runnable listener) {
        boolean shouldNotify;
        Objects.requireNonNull(listener, "listener is null");
        OperatorContext operatorContext = this;
        synchronized (operatorContext) {
            Preconditions.checkState((this.memoryRevocationRequestListener == null ? 1 : 0) != 0, (Object)"listener already set");
            this.memoryRevocationRequestListener = listener;
            shouldNotify = this.memoryRevokingRequested;
        }
        if (shouldNotify) {
            OperatorContext.runListener(listener);
        }
    }

    private static void runListener(Runnable listener) {
        Objects.requireNonNull(listener, "listener is null");
        try {
            listener.run();
        }
        catch (RuntimeException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, "Exception while running the listener", (Throwable)e);
        }
    }

    public void setInfoSupplier(Supplier<OperatorInfo> infoSupplier) {
        Objects.requireNonNull(infoSupplier, "infoProvider is null");
        this.infoSupplier.set(infoSupplier);
    }

    public CounterStat getInputDataSize() {
        return this.inputDataSize;
    }

    public CounterStat getInputPositions() {
        return this.inputPositions;
    }

    public CounterStat getOutputDataSize() {
        return this.outputDataSize;
    }

    public CounterStat getOutputPositions() {
        return this.outputPositions;
    }

    public long getPhysicalWrittenDataSize() {
        return this.physicalWrittenDataSize.get();
    }

    public String toString() {
        return String.format("%s-%s", this.operatorType, this.planNodeId);
    }

    public OperatorStats getOperatorStats() {
        Supplier<OperatorInfo> infoSupplier = this.infoSupplier.get();
        OperatorInfo info = Optional.ofNullable(infoSupplier).map(Supplier::get).orElse(null);
        long inputPositionsCount = this.inputPositions.getTotalCount();
        return new OperatorStats(this.driverContext.getPipelineContext().getPipelineId(), this.operatorId, this.planNodeId, this.operatorType, 1L, this.addInputCalls.get(), new Duration((double)this.addInputWallNanos.get(), TimeUnit.NANOSECONDS).convertToMostSuccinctTimeUnit(), new Duration((double)this.addInputCpuNanos.get(), TimeUnit.NANOSECONDS).convertToMostSuccinctTimeUnit(), new Duration((double)this.addInputUserNanos.get(), TimeUnit.NANOSECONDS).convertToMostSuccinctTimeUnit(), DataSize.succinctBytes((long)this.inputDataSize.getTotalCount()), inputPositionsCount, (double)inputPositionsCount * (double)inputPositionsCount, this.getOutputCalls.get(), new Duration((double)this.getOutputWallNanos.get(), TimeUnit.NANOSECONDS).convertToMostSuccinctTimeUnit(), new Duration((double)this.getOutputCpuNanos.get(), TimeUnit.NANOSECONDS).convertToMostSuccinctTimeUnit(), new Duration((double)this.getOutputUserNanos.get(), TimeUnit.NANOSECONDS).convertToMostSuccinctTimeUnit(), DataSize.succinctBytes((long)this.outputDataSize.getTotalCount()), this.outputPositions.getTotalCount(), DataSize.succinctBytes((long)this.physicalWrittenDataSize.get()), new Duration((double)this.blockedWallNanos.get(), TimeUnit.NANOSECONDS).convertToMostSuccinctTimeUnit(), this.finishCalls.get(), new Duration((double)this.finishWallNanos.get(), TimeUnit.NANOSECONDS).convertToMostSuccinctTimeUnit(), new Duration((double)this.finishCpuNanos.get(), TimeUnit.NANOSECONDS).convertToMostSuccinctTimeUnit(), new Duration((double)this.finishUserNanos.get(), TimeUnit.NANOSECONDS).convertToMostSuccinctTimeUnit(), DataSize.succinctBytes((long)this.operatorMemoryContext.getUserMemory()), DataSize.succinctBytes((long)this.getReservedRevocableBytes()), DataSize.succinctBytes((long)this.operatorMemoryContext.getSystemMemory()), this.memoryFuture.get().isDone() ? Optional.empty() : Optional.of(BlockedReason.WAITING_FOR_MEMORY), info);
    }

    public <C, R> R accept(QueryContextVisitor<C, R> visitor, C context) {
        return visitor.visitOperatorContext(this, context);
    }

    private long currentThreadUserTime() {
        if (!this.collectTimings) {
            return 0L;
        }
        return THREAD_MX_BEAN.getCurrentThreadUserTime();
    }

    private long currentThreadCpuTime() {
        if (!this.collectTimings) {
            return 0L;
        }
        return THREAD_MX_BEAN.getCurrentThreadCpuTime();
    }

    private static long nanosBetween(long start, long end) {
        return Math.abs(end - start);
    }

    @VisibleForTesting
    public MemoryTrackingContext getOperatorMemoryContext() {
        return this.operatorMemoryContext;
    }

    private static class InternalAggregatedMemoryContext
    implements AggregatedMemoryContext {
        private final AggregatedMemoryContext delegate;
        private final AtomicReference<SettableFuture<?>> memoryFuture;

        InternalAggregatedMemoryContext(AggregatedMemoryContext delegate, AtomicReference<SettableFuture<?>> memoryFuture) {
            this.delegate = Objects.requireNonNull(delegate, "delegate is null");
            this.memoryFuture = Objects.requireNonNull(memoryFuture, "memoryFuture is null");
        }

        public AggregatedMemoryContext newAggregatedMemoryContext() {
            return this.delegate.newAggregatedMemoryContext();
        }

        public LocalMemoryContext newLocalMemoryContext() {
            return new InternalLocalMemoryContext(this.delegate.newLocalMemoryContext(), this.memoryFuture);
        }

        public long getBytes() {
            return this.delegate.getBytes();
        }

        public void close() {
            this.delegate.close();
        }
    }

    private static class InternalLocalMemoryContext
    implements LocalMemoryContext {
        private final LocalMemoryContext delegate;
        private final AtomicReference<SettableFuture<?>> memoryFuture;

        InternalLocalMemoryContext(LocalMemoryContext delegate, AtomicReference<SettableFuture<?>> memoryFuture) {
            this.delegate = Objects.requireNonNull(delegate, "delegate is null");
            this.memoryFuture = Objects.requireNonNull(memoryFuture, "memoryFuture is null");
        }

        public long getBytes() {
            return this.delegate.getBytes();
        }

        public ListenableFuture<?> setBytes(long bytes) {
            ListenableFuture blocked = this.delegate.setBytes(bytes);
            OperatorContext.updateMemoryFuture(blocked, this.memoryFuture);
            return blocked;
        }

        public boolean trySetBytes(long bytes) {
            return this.delegate.trySetBytes(bytes);
        }

        public void close() {
            this.delegate.close();
        }
    }

    @ThreadSafe
    private static class OperatorSpillContext
    implements SpillContext {
        private final DriverContext driverContext;
        private final AtomicLong reservedBytes = new AtomicLong();

        public OperatorSpillContext(DriverContext driverContext) {
            this.driverContext = driverContext;
        }

        @Override
        public void updateBytes(long bytes) {
            if (bytes >= 0L) {
                this.reservedBytes.addAndGet(bytes);
                this.driverContext.reserveSpill(bytes);
            } else {
                this.reservedBytes.accumulateAndGet(-bytes, this::decrementSpilledReservation);
                this.driverContext.freeSpill(-bytes);
            }
        }

        private long decrementSpilledReservation(long reservedBytes, long bytesBeingFreed) {
            Preconditions.checkArgument((bytesBeingFreed >= 0L ? 1 : 0) != 0);
            Preconditions.checkArgument((bytesBeingFreed <= reservedBytes ? 1 : 0) != 0, (String)"tried to free %s spilled bytes from %s bytes reserved", (long)bytesBeingFreed, (long)reservedBytes);
            return reservedBytes - bytesBeingFreed;
        }

        @Override
        public void close() {
            throw new UnsupportedOperationException(String.format("%s should not be closed directly", this.getClass()));
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("usedBytes", this.reservedBytes.get()).toString();
        }
    }

    private class BlockedMonitor
    implements Runnable {
        private final long start = System.nanoTime();
        private boolean finished;

        private BlockedMonitor() {
        }

        @Override
        public synchronized void run() {
            if (this.finished) {
                return;
            }
            this.finished = true;
            OperatorContext.this.blockedMonitor.compareAndSet(this, null);
            OperatorContext.this.blockedWallNanos.getAndAdd(this.getBlockedTime());
        }

        public long getBlockedTime() {
            return OperatorContext.nanosBetween(this.start, System.nanoTime());
        }
    }
}

