/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.execution.Lifespan;
import com.facebook.presto.operator.JoinBridgeDataManager;
import com.facebook.presto.operator.LookupJoinOperators;
import com.facebook.presto.operator.LookupSourceFactory;
import com.facebook.presto.operator.NestedLoopJoinPagesBridge;
import com.facebook.presto.operator.OuterPositionIterator;
import com.facebook.presto.operator.ReferenceCount;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import java.util.function.Function;

public class JoinBridgeLifecycleManager<T> {
    private final LookupJoinOperators.JoinType joinType;
    private final FreezeOnReadCounter factoryCount;
    private final JoinBridgeDataManager<T> joinBridgeDataManager;
    private final Consumer<T> destroy;
    private final Function<T, ListenableFuture<OuterPositionIterator>> outerPositionIteratorFutureFunction;
    private final Map<Lifespan, PerLifespanData<T>> dataByLifespan;
    private final ReferenceCount probeFactoryReferenceCount;
    private boolean closed;

    public static JoinBridgeLifecycleManager<LookupSourceFactory> lookup(LookupJoinOperators.JoinType joinType, JoinBridgeDataManager<LookupSourceFactory> lookupSourceFactoryManager) {
        return new JoinBridgeLifecycleManager<LookupSourceFactory>(joinType, lookupSourceFactoryManager, LookupSourceFactory::destroy, lookupSourceFactory -> Futures.transform(lookupSourceFactory.createLookupSourceProvider(), lookupSourceProvider -> {
            lookupSourceProvider.close();
            return lookupSourceFactory.getOuterPositionIterator();
        }, (Executor)MoreExecutors.directExecutor()));
    }

    public static JoinBridgeLifecycleManager<NestedLoopJoinPagesBridge> nestedLoop(LookupJoinOperators.JoinType joinType, JoinBridgeDataManager<NestedLoopJoinPagesBridge> nestedLoopJoinPagesSupplierManager) {
        Preconditions.checkArgument((joinType == LookupJoinOperators.JoinType.INNER ? 1 : 0) != 0);
        return new JoinBridgeLifecycleManager<NestedLoopJoinPagesBridge>(joinType, nestedLoopJoinPagesSupplierManager, NestedLoopJoinPagesBridge::destroy, joinBridge -> {
            throw new UnsupportedOperationException();
        });
    }

    public JoinBridgeLifecycleManager(LookupJoinOperators.JoinType joinType, JoinBridgeDataManager<T> joinBridgeDataManager, Consumer<T> destroy, Function<T, ListenableFuture<OuterPositionIterator>> outerPositionIteratorFutureFunction) {
        this.joinType = joinType;
        this.joinBridgeDataManager = joinBridgeDataManager;
        this.destroy = destroy;
        this.outerPositionIteratorFutureFunction = outerPositionIteratorFutureFunction;
        this.dataByLifespan = new ConcurrentHashMap<Lifespan, PerLifespanData<T>>();
        this.factoryCount = new FreezeOnReadCounter();
        this.factoryCount.increment();
        this.probeFactoryReferenceCount = new ReferenceCount(1);
        this.probeFactoryReferenceCount.getFreeFuture().addListener(joinBridgeDataManager::noMoreJoinBridge, MoreExecutors.directExecutor());
    }

    private JoinBridgeLifecycleManager(JoinBridgeLifecycleManager<T> other) {
        this.joinType = other.joinType;
        this.factoryCount = other.factoryCount;
        this.joinBridgeDataManager = other.joinBridgeDataManager;
        this.destroy = other.destroy;
        this.outerPositionIteratorFutureFunction = other.outerPositionIteratorFutureFunction;
        this.dataByLifespan = other.dataByLifespan;
        this.probeFactoryReferenceCount = other.probeFactoryReferenceCount;
        this.closed = false;
        this.factoryCount.increment();
        this.probeFactoryReferenceCount.retain();
    }

    public JoinBridgeLifecycleManager<T> duplicate() {
        return new JoinBridgeLifecycleManager<T>(this);
    }

    public void noMoreLifespan() {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        this.closed = true;
        this.probeFactoryReferenceCount.release();
    }

    public T getJoinBridge(Lifespan lifespan) {
        return this.data(lifespan).getJoinBridge();
    }

    public ReferenceCount getProbeReferenceCount(Lifespan lifespan) {
        return this.data(lifespan).getProbeReferenceCount();
    }

    public ReferenceCount getJoinBridgeUsersCount(Lifespan lifespan) {
        return this.data(lifespan).getJoinBridgeUsersCount();
    }

    public ListenableFuture<OuterPositionIterator> getOuterPositionsFuture(Lifespan lifespan) {
        return this.data(lifespan).getOuterPositionsFuture();
    }

    private PerLifespanData<T> data(Lifespan lifespan) {
        return this.dataByLifespan.computeIfAbsent(lifespan, id -> {
            Preconditions.checkState((!this.closed ? 1 : 0) != 0);
            return new PerLifespanData<T>(this.joinType, this.factoryCount.get(), this.joinBridgeDataManager.forLifespan((Lifespan)id), this.destroy, this.outerPositionIteratorFutureFunction);
        });
    }

    public static class FreezeOnReadCounter {
        private int count;
        private boolean freezed;

        public synchronized void increment() {
            Preconditions.checkState((!this.freezed ? 1 : 0) != 0, (Object)"Counter has been read");
            ++this.count;
        }

        public synchronized int get() {
            this.freezed = true;
            return this.count;
        }
    }

    public static class PerLifespanData<T> {
        private final T joinBridge;
        private final ReferenceCount probeReferenceCount;
        private final ReferenceCount joinBridgeUsersCount;
        private final ListenableFuture<OuterPositionIterator> outerPositionsFuture;

        public PerLifespanData(LookupJoinOperators.JoinType joinType, int factoryCount, T joinBridge, Consumer<T> destroy, Function<T, ListenableFuture<OuterPositionIterator>> outerPositionIteratorFutureFunction) {
            this.joinBridge = joinBridge;
            this.joinBridgeUsersCount = new ReferenceCount(1);
            this.joinBridgeUsersCount.getFreeFuture().addListener(() -> destroy.accept(joinBridge), MoreExecutors.directExecutor());
            this.probeReferenceCount = new ReferenceCount(factoryCount);
            this.probeReferenceCount.getFreeFuture().addListener(this.joinBridgeUsersCount::release, MoreExecutors.directExecutor());
            if (joinType == LookupJoinOperators.JoinType.INNER || joinType == LookupJoinOperators.JoinType.PROBE_OUTER) {
                this.outerPositionsFuture = null;
            } else {
                this.joinBridgeUsersCount.retain();
                this.outerPositionsFuture = Futures.transformAsync(this.probeReferenceCount.getFreeFuture(), ignored -> (ListenableFuture)outerPositionIteratorFutureFunction.apply(joinBridge), (Executor)MoreExecutors.directExecutor());
            }
        }

        public T getJoinBridge() {
            return this.joinBridge;
        }

        public ReferenceCount getProbeReferenceCount() {
            return this.probeReferenceCount;
        }

        public ReferenceCount getJoinBridgeUsersCount() {
            return this.joinBridgeUsersCount;
        }

        public ListenableFuture<OuterPositionIterator> getOuterPositionsFuture() {
            return this.outerPositionsFuture;
        }
    }
}

