/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.memory;

import com.facebook.presto.memory.LocalMemoryManager;
import com.facebook.presto.memory.LowMemoryKiller;
import com.facebook.presto.memory.MemoryInfo;
import com.facebook.presto.spi.QueryId;
import java.util.List;
import java.util.Optional;

public class TotalReservationLowMemoryKiller
implements LowMemoryKiller {
    @Override
    public Optional<QueryId> chooseQueryToKill(List<LowMemoryKiller.QueryMemoryInfo> queries, List<MemoryInfo> nodes) {
        QueryId biggestQuery = null;
        long maxMemory = 0L;
        for (LowMemoryKiller.QueryMemoryInfo query : queries) {
            long bytesUsed = query.getMemoryReservation();
            if (bytesUsed <= maxMemory || !LocalMemoryManager.GENERAL_POOL.equals((Object)query.getMemoryPoolId())) continue;
            biggestQuery = query.getQueryId();
            maxMemory = bytesUsed;
        }
        return Optional.ofNullable(biggestQuery);
    }
}

